/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioGainNode.h"

#include "AudioGain.h"
#include "AudioGainNode.h"
#include "JSAudioGain.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSAudioGainNode);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSAudioGainNodeTableValues[] =
{
    { "gain", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioGainNodeGain), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioGainNodeConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSAudioGainNodeTable = { 4, 3, JSAudioGainNodeTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSAudioGainNodeConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSAudioGainNodeConstructorTable = { 1, 0, JSAudioGainNodeConstructorTableValues, 0 };
class JSAudioGainNodeConstructor : public DOMConstructorObject {
private:
    JSAudioGainNodeConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSAudioGainNodeConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSAudioGainNodeConstructor* ptr = new (JSC::allocateCell<JSAudioGainNodeConstructor>(*exec->heap())) JSAudioGainNodeConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSAudioGainNodeConstructor::s_info = { "AudioGainNodeConstructor", &DOMConstructorObject::s_info, &JSAudioGainNodeConstructorTable, 0 };

JSAudioGainNodeConstructor::JSAudioGainNodeConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSAudioGainNodeConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSAudioGainNodePrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSAudioGainNodeConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSAudioGainNodeConstructor, JSDOMWrapper>(exec, &JSAudioGainNodeConstructorTable, this, propertyName, slot);
}

bool JSAudioGainNodeConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSAudioGainNodeConstructor, JSDOMWrapper>(exec, &JSAudioGainNodeConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSAudioGainNodePrototypeTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSAudioGainNodePrototypeTable = { 1, 0, JSAudioGainNodePrototypeTableValues, 0 };
const ClassInfo JSAudioGainNodePrototype::s_info = { "AudioGainNodePrototype", &JSC::JSNonFinalObject::s_info, &JSAudioGainNodePrototypeTable, 0 };

JSObject* JSAudioGainNodePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSAudioGainNode>(exec, globalObject);
}

const ClassInfo JSAudioGainNode::s_info = { "AudioGainNode", &JSAudioNode::s_info, &JSAudioGainNodeTable, 0 };

JSAudioGainNode::JSAudioGainNode(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<AudioGainNode> impl)
    : JSAudioNode(structure, globalObject, impl)
{
}

void JSAudioGainNode::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSAudioGainNode::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSAudioGainNodePrototype::create(exec->globalData(), globalObject, JSAudioGainNodePrototype::createStructure(exec->globalData(), globalObject, JSAudioNodePrototype::self(exec, globalObject)));
}

bool JSAudioGainNode::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSAudioGainNode, Base>(exec, &JSAudioGainNodeTable, this, propertyName, slot);
}

bool JSAudioGainNode::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSAudioGainNode, Base>(exec, &JSAudioGainNodeTable, this, propertyName, descriptor);
}

JSValue jsAudioGainNodeGain(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSAudioGainNode* castedThis = static_cast<JSAudioGainNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioGainNode* imp = static_cast<AudioGainNode*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->gain()));
    return result;
}


JSValue jsAudioGainNodeConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSAudioGainNode* domObject = static_cast<JSAudioGainNode*>(asObject(slotBase));
    return JSAudioGainNode::getConstructor(exec, domObject->globalObject());
}

JSValue JSAudioGainNode::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioGainNodeConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, AudioGainNode* impl)
{
    return wrap<JSAudioGainNode>(exec, globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
