/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioContext.h"

#include "AudioBuffer.h"
#include "AudioBufferSourceNode.h"
#include "AudioChannelMerger.h"
#include "AudioChannelSplitter.h"
#include "AudioContext.h"
#include "AudioDestinationNode.h"
#include "AudioGainNode.h"
#include "AudioListener.h"
#include "AudioPannerNode.h"
#include "BiquadFilterNode.h"
#include "ConvolverNode.h"
#include "DelayNode.h"
#include "DynamicsCompressorNode.h"
#include "EventListener.h"
#include "ExceptionCode.h"
#include "HighPass2FilterNode.h"
#include "JSArrayBuffer.h"
#include "JSAudioBufferCallback.h"
#include "JSAudioBufferSourceNode.h"
#include "JSAudioChannelMerger.h"
#include "JSAudioChannelSplitter.h"
#include "JSAudioDestinationNode.h"
#include "JSAudioGainNode.h"
#include "JSAudioListener.h"
#include "JSAudioPannerNode.h"
#include "JSBiquadFilterNode.h"
#include "JSConvolverNode.h"
#include "JSDOMBinding.h"
#include "JSDelayNode.h"
#include "JSDynamicsCompressorNode.h"
#include "JSEventListener.h"
#include "JSHighPass2FilterNode.h"
#include "JSJavaScriptAudioNode.h"
#include "JSLowPass2FilterNode.h"
#include "JSRealtimeAnalyserNode.h"
#include "JSWaveShaperNode.h"
#include "JavaScriptAudioNode.h"
#include "LowPass2FilterNode.h"
#include "RealtimeAnalyserNode.h"
#include "WaveShaperNode.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSAudioContext);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSAudioContextTableValues[] =
{
    { "destination", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextDestination), (intptr_t)0 THUNK_GENERATOR(0) },
    { "currentTime", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextCurrentTime), (intptr_t)0 THUNK_GENERATOR(0) },
    { "sampleRate", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextSampleRate), (intptr_t)0 THUNK_GENERATOR(0) },
    { "listener", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextListener), (intptr_t)0 THUNK_GENERATOR(0) },
    { "oncomplete", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextOncomplete), (intptr_t)setJSAudioContextOncomplete THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSAudioContextTable = { 17, 15, JSAudioContextTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSAudioContextConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSAudioContextConstructorTable = { 1, 0, JSAudioContextConstructorTableValues, 0 };
const ClassInfo JSAudioContextConstructor::s_info = { "AudioContextConstructor", &DOMConstructorObject::s_info, &JSAudioContextConstructorTable, 0 };

JSAudioContextConstructor::JSAudioContextConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSAudioContextConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSAudioContextPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSAudioContextConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSAudioContextConstructor, JSDOMWrapper>(exec, &JSAudioContextConstructorTable, this, propertyName, slot);
}

bool JSAudioContextConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSAudioContextConstructor, JSDOMWrapper>(exec, &JSAudioContextConstructorTable, this, propertyName, descriptor);
}

ConstructType JSAudioContextConstructor::getConstructData(ConstructData& constructData)
{
    constructData.native.function = constructJSAudioContext;
    return ConstructTypeHost;
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSAudioContextPrototypeTableValues[] =
{
    { "createBuffer", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateBuffer), (intptr_t)0 THUNK_GENERATOR(0) },
    { "decodeAudioData", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionDecodeAudioData), (intptr_t)3 THUNK_GENERATOR(0) },
    { "createBufferSource", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateBufferSource), (intptr_t)0 THUNK_GENERATOR(0) },
    { "createGainNode", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateGainNode), (intptr_t)0 THUNK_GENERATOR(0) },
    { "createDelayNode", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateDelayNode), (intptr_t)0 THUNK_GENERATOR(0) },
    { "createBiquadFilter", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateBiquadFilter), (intptr_t)0 THUNK_GENERATOR(0) },
    { "createWaveShaper", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateWaveShaper), (intptr_t)0 THUNK_GENERATOR(0) },
    { "createLowPass2Filter", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateLowPass2Filter), (intptr_t)0 THUNK_GENERATOR(0) },
    { "createHighPass2Filter", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateHighPass2Filter), (intptr_t)0 THUNK_GENERATOR(0) },
    { "createPanner", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreatePanner), (intptr_t)0 THUNK_GENERATOR(0) },
    { "createConvolver", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateConvolver), (intptr_t)0 THUNK_GENERATOR(0) },
    { "createDynamicsCompressor", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateDynamicsCompressor), (intptr_t)0 THUNK_GENERATOR(0) },
    { "createAnalyser", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateAnalyser), (intptr_t)0 THUNK_GENERATOR(0) },
    { "createJavaScriptNode", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateJavaScriptNode), (intptr_t)1 THUNK_GENERATOR(0) },
    { "createChannelSplitter", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateChannelSplitter), (intptr_t)0 THUNK_GENERATOR(0) },
    { "createChannelMerger", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionCreateChannelMerger), (intptr_t)0 THUNK_GENERATOR(0) },
    { "startRendering", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsAudioContextPrototypeFunctionStartRendering), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSAudioContextPrototypeTable = { 66, 63, JSAudioContextPrototypeTableValues, 0 };
const ClassInfo JSAudioContextPrototype::s_info = { "AudioContextPrototype", &JSC::JSNonFinalObject::s_info, &JSAudioContextPrototypeTable, 0 };

JSObject* JSAudioContextPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSAudioContext>(exec, globalObject);
}

bool JSAudioContextPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSAudioContextPrototypeTable, this, propertyName, slot);
}

bool JSAudioContextPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSAudioContextPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSAudioContext::s_info = { "AudioContext", &JSDOMWrapper::s_info, &JSAudioContextTable, 0 };

JSAudioContext::JSAudioContext(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<AudioContext> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSAudioContext::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSAudioContext::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSAudioContextPrototype::create(exec->globalData(), globalObject, JSAudioContextPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSAudioContext::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSAudioContext, Base>(exec, &JSAudioContextTable, this, propertyName, slot);
}

bool JSAudioContext::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSAudioContext, Base>(exec, &JSAudioContextTable, this, propertyName, descriptor);
}

JSValue jsAudioContextDestination(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSAudioContext* castedThis = static_cast<JSAudioContext*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioContext* imp = static_cast<AudioContext*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->destination()));
    return result;
}


JSValue jsAudioContextCurrentTime(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSAudioContext* castedThis = static_cast<JSAudioContext*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioContext* imp = static_cast<AudioContext*>(castedThis->impl());
    JSValue result = jsNumber(imp->currentTime());
    return result;
}


JSValue jsAudioContextSampleRate(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSAudioContext* castedThis = static_cast<JSAudioContext*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioContext* imp = static_cast<AudioContext*>(castedThis->impl());
    JSValue result = jsNumber(imp->sampleRate());
    return result;
}


JSValue jsAudioContextListener(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSAudioContext* castedThis = static_cast<JSAudioContext*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioContext* imp = static_cast<AudioContext*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->listener()));
    return result;
}


JSValue jsAudioContextOncomplete(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSAudioContext* castedThis = static_cast<JSAudioContext*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioContext* imp = static_cast<AudioContext*>(castedThis->impl());
    if (EventListener* listener = imp->oncomplete()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsAudioContextConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSAudioContext* domObject = static_cast<JSAudioContext*>(asObject(slotBase));
    return JSAudioContext::getConstructor(exec, domObject->globalObject());
}

void JSAudioContext::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSAudioContext, Base>(exec, propertyName, value, &JSAudioContextTable, this, slot);
}

void setJSAudioContextOncomplete(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSAudioContext* castedThis = static_cast<JSAudioContext*>(thisObject);
    AudioContext* imp = static_cast<AudioContext*>(castedThis->impl());
    imp->setOncomplete(createJSAttributeEventListener(exec, value, thisObject));
}


JSValue JSAudioContext::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioContextConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateBuffer(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioContext::s_info))
        return throwVMTypeError(exec);
    JSAudioContext* castedThis = static_cast<JSAudioContext*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioContext::s_info);
    return JSValue::encode(castedThis->createBuffer(exec));
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionDecodeAudioData(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioContext::s_info))
        return throwVMTypeError(exec);
    JSAudioContext* castedThis = static_cast<JSAudioContext*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioContext::s_info);
    AudioContext* imp = static_cast<AudioContext*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    ArrayBuffer* audioData(toArrayBuffer(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (exec->argumentCount() <= 1 || !exec->argument(1).isObject()) {
        setDOMException(exec, TYPE_MISMATCH_ERR);
        return JSValue::encode(jsUndefined());
    }
    RefPtr<AudioBufferCallback> successCallback = JSAudioBufferCallback::create(asObject(exec->argument(1)), castedThis->globalObject());
    RefPtr<AudioBufferCallback> errorCallback;
    if (exec->argumentCount() > 2 && !exec->argument(2).isUndefinedOrNull()) {
        if (!exec->argument(2).isObject()) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return JSValue::encode(jsUndefined());
        }
        errorCallback = JSAudioBufferCallback::create(asObject(exec->argument(2)), castedThis->globalObject());
    }

    imp->decodeAudioData(audioData, successCallback, errorCallback, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateBufferSource(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioContext::s_info))
        return throwVMTypeError(exec);
    JSAudioContext* castedThis = static_cast<JSAudioContext*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioContext::s_info);
    AudioContext* imp = static_cast<AudioContext*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createBufferSource()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateGainNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioContext::s_info))
        return throwVMTypeError(exec);
    JSAudioContext* castedThis = static_cast<JSAudioContext*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioContext::s_info);
    AudioContext* imp = static_cast<AudioContext*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createGainNode()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateDelayNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioContext::s_info))
        return throwVMTypeError(exec);
    JSAudioContext* castedThis = static_cast<JSAudioContext*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioContext::s_info);
    AudioContext* imp = static_cast<AudioContext*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createDelayNode()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateBiquadFilter(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioContext::s_info))
        return throwVMTypeError(exec);
    JSAudioContext* castedThis = static_cast<JSAudioContext*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioContext::s_info);
    AudioContext* imp = static_cast<AudioContext*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createBiquadFilter()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateWaveShaper(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioContext::s_info))
        return throwVMTypeError(exec);
    JSAudioContext* castedThis = static_cast<JSAudioContext*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioContext::s_info);
    AudioContext* imp = static_cast<AudioContext*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createWaveShaper()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateLowPass2Filter(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioContext::s_info))
        return throwVMTypeError(exec);
    JSAudioContext* castedThis = static_cast<JSAudioContext*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioContext::s_info);
    AudioContext* imp = static_cast<AudioContext*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createLowPass2Filter()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateHighPass2Filter(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioContext::s_info))
        return throwVMTypeError(exec);
    JSAudioContext* castedThis = static_cast<JSAudioContext*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioContext::s_info);
    AudioContext* imp = static_cast<AudioContext*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createHighPass2Filter()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreatePanner(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioContext::s_info))
        return throwVMTypeError(exec);
    JSAudioContext* castedThis = static_cast<JSAudioContext*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioContext::s_info);
    AudioContext* imp = static_cast<AudioContext*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createPanner()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateConvolver(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioContext::s_info))
        return throwVMTypeError(exec);
    JSAudioContext* castedThis = static_cast<JSAudioContext*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioContext::s_info);
    AudioContext* imp = static_cast<AudioContext*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createConvolver()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateDynamicsCompressor(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioContext::s_info))
        return throwVMTypeError(exec);
    JSAudioContext* castedThis = static_cast<JSAudioContext*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioContext::s_info);
    AudioContext* imp = static_cast<AudioContext*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createDynamicsCompressor()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateAnalyser(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioContext::s_info))
        return throwVMTypeError(exec);
    JSAudioContext* castedThis = static_cast<JSAudioContext*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioContext::s_info);
    AudioContext* imp = static_cast<AudioContext*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createAnalyser()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateJavaScriptNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioContext::s_info))
        return throwVMTypeError(exec);
    JSAudioContext* castedThis = static_cast<JSAudioContext*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioContext::s_info);
    AudioContext* imp = static_cast<AudioContext*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    unsigned bufferSize(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createJavaScriptNode(bufferSize)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateChannelSplitter(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioContext::s_info))
        return throwVMTypeError(exec);
    JSAudioContext* castedThis = static_cast<JSAudioContext*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioContext::s_info);
    AudioContext* imp = static_cast<AudioContext*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createChannelSplitter()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateChannelMerger(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioContext::s_info))
        return throwVMTypeError(exec);
    JSAudioContext* castedThis = static_cast<JSAudioContext*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioContext::s_info);
    AudioContext* imp = static_cast<AudioContext*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createChannelMerger()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionStartRendering(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioContext::s_info))
        return throwVMTypeError(exec);
    JSAudioContext* castedThis = static_cast<JSAudioContext*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioContext::s_info);
    AudioContext* imp = static_cast<AudioContext*>(castedThis->impl());

    imp->startRendering();
    return JSValue::encode(jsUndefined());
}

static inline bool isObservable(JSAudioContext* jsAudioContext)
{
    if (jsAudioContext->hasCustomProperties())
        return true;
    return false;
}

bool JSAudioContextOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSAudioContext* jsAudioContext = static_cast<JSAudioContext*>(handle.get().asCell());
    if (jsAudioContext->impl()->hasPendingActivity())
        return true;
    if (!isObservable(jsAudioContext))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSAudioContextOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSAudioContext* jsAudioContext = static_cast<JSAudioContext*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsAudioContext->impl(), jsAudioContext);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, AudioContext* impl)
{
    return wrap<JSAudioContext>(exec, globalObject, impl);
}

AudioContext* toAudioContext(JSC::JSValue value)
{
    return value.inherits(&JSAudioContext::s_info) ? static_cast<JSAudioContext*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEB_AUDIO)
