/*
 * Copyright (C) 2010 Google, Inc. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */

// THIS FILE IS GENERATED BY WebCore/html/parser/create-html-entity-table
// DO NOT EDIT (unless you are a ninja)!

#include "config.h"
#include "HTMLEntityTable.h"

namespace WebCore {

namespace {
static const UChar AEligEntityName[] = {'A', 'E', 'l', 'i', 'g'};
static const UChar AEligSemicolonEntityName[] = {'A', 'E', 'l', 'i', 'g', ';'};
static const UChar AMPEntityName[] = {'A', 'M', 'P'};
static const UChar AMPSemicolonEntityName[] = {'A', 'M', 'P', ';'};
static const UChar AacuteEntityName[] = {'A', 'a', 'c', 'u', 't', 'e'};
static const UChar AacuteSemicolonEntityName[] = {'A', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar AbreveSemicolonEntityName[] = {'A', 'b', 'r', 'e', 'v', 'e', ';'};
static const UChar AcircEntityName[] = {'A', 'c', 'i', 'r', 'c'};
static const UChar AcircSemicolonEntityName[] = {'A', 'c', 'i', 'r', 'c', ';'};
static const UChar AcySemicolonEntityName[] = {'A', 'c', 'y', ';'};
static const UChar AfrSemicolonEntityName[] = {'A', 'f', 'r', ';'};
static const UChar AgraveEntityName[] = {'A', 'g', 'r', 'a', 'v', 'e'};
static const UChar AgraveSemicolonEntityName[] = {'A', 'g', 'r', 'a', 'v', 'e', ';'};
static const UChar AlphaSemicolonEntityName[] = {'A', 'l', 'p', 'h', 'a', ';'};
static const UChar AmacrSemicolonEntityName[] = {'A', 'm', 'a', 'c', 'r', ';'};
static const UChar AndSemicolonEntityName[] = {'A', 'n', 'd', ';'};
static const UChar AogonSemicolonEntityName[] = {'A', 'o', 'g', 'o', 'n', ';'};
static const UChar AopfSemicolonEntityName[] = {'A', 'o', 'p', 'f', ';'};
static const UChar ApplyFunctionSemicolonEntityName[] = {'A', 'p', 'p', 'l', 'y', 'F', 'u', 'n', 'c', 't', 'i', 'o', 'n', ';'};
static const UChar AringEntityName[] = {'A', 'r', 'i', 'n', 'g'};
static const UChar AringSemicolonEntityName[] = {'A', 'r', 'i', 'n', 'g', ';'};
static const UChar AscrSemicolonEntityName[] = {'A', 's', 'c', 'r', ';'};
static const UChar AssignSemicolonEntityName[] = {'A', 's', 's', 'i', 'g', 'n', ';'};
static const UChar AtildeEntityName[] = {'A', 't', 'i', 'l', 'd', 'e'};
static const UChar AtildeSemicolonEntityName[] = {'A', 't', 'i', 'l', 'd', 'e', ';'};
static const UChar AumlEntityName[] = {'A', 'u', 'm', 'l'};
static const UChar AumlSemicolonEntityName[] = {'A', 'u', 'm', 'l', ';'};
static const UChar BackslashSemicolonEntityName[] = {'B', 'a', 'c', 'k', 's', 'l', 'a', 's', 'h', ';'};
static const UChar BarvSemicolonEntityName[] = {'B', 'a', 'r', 'v', ';'};
static const UChar BarwedSemicolonEntityName[] = {'B', 'a', 'r', 'w', 'e', 'd', ';'};
static const UChar BcySemicolonEntityName[] = {'B', 'c', 'y', ';'};
static const UChar BecauseSemicolonEntityName[] = {'B', 'e', 'c', 'a', 'u', 's', 'e', ';'};
static const UChar BernoullisSemicolonEntityName[] = {'B', 'e', 'r', 'n', 'o', 'u', 'l', 'l', 'i', 's', ';'};
static const UChar BetaSemicolonEntityName[] = {'B', 'e', 't', 'a', ';'};
static const UChar BfrSemicolonEntityName[] = {'B', 'f', 'r', ';'};
static const UChar BopfSemicolonEntityName[] = {'B', 'o', 'p', 'f', ';'};
static const UChar BreveSemicolonEntityName[] = {'B', 'r', 'e', 'v', 'e', ';'};
static const UChar BscrSemicolonEntityName[] = {'B', 's', 'c', 'r', ';'};
static const UChar BumpeqSemicolonEntityName[] = {'B', 'u', 'm', 'p', 'e', 'q', ';'};
static const UChar CHcySemicolonEntityName[] = {'C', 'H', 'c', 'y', ';'};
static const UChar COPYEntityName[] = {'C', 'O', 'P', 'Y'};
static const UChar COPYSemicolonEntityName[] = {'C', 'O', 'P', 'Y', ';'};
static const UChar CacuteSemicolonEntityName[] = {'C', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar CapSemicolonEntityName[] = {'C', 'a', 'p', ';'};
static const UChar CapitalDifferentialDSemicolonEntityName[] = {'C', 'a', 'p', 'i', 't', 'a', 'l', 'D', 'i', 'f', 'f', 'e', 'r', 'e', 'n', 't', 'i', 'a', 'l', 'D', ';'};
static const UChar CayleysSemicolonEntityName[] = {'C', 'a', 'y', 'l', 'e', 'y', 's', ';'};
static const UChar CcaronSemicolonEntityName[] = {'C', 'c', 'a', 'r', 'o', 'n', ';'};
static const UChar CcedilEntityName[] = {'C', 'c', 'e', 'd', 'i', 'l'};
static const UChar CcedilSemicolonEntityName[] = {'C', 'c', 'e', 'd', 'i', 'l', ';'};
static const UChar CcircSemicolonEntityName[] = {'C', 'c', 'i', 'r', 'c', ';'};
static const UChar CconintSemicolonEntityName[] = {'C', 'c', 'o', 'n', 'i', 'n', 't', ';'};
static const UChar CdotSemicolonEntityName[] = {'C', 'd', 'o', 't', ';'};
static const UChar CedillaSemicolonEntityName[] = {'C', 'e', 'd', 'i', 'l', 'l', 'a', ';'};
static const UChar CenterDotSemicolonEntityName[] = {'C', 'e', 'n', 't', 'e', 'r', 'D', 'o', 't', ';'};
static const UChar CfrSemicolonEntityName[] = {'C', 'f', 'r', ';'};
static const UChar ChiSemicolonEntityName[] = {'C', 'h', 'i', ';'};
static const UChar CircleDotSemicolonEntityName[] = {'C', 'i', 'r', 'c', 'l', 'e', 'D', 'o', 't', ';'};
static const UChar CircleMinusSemicolonEntityName[] = {'C', 'i', 'r', 'c', 'l', 'e', 'M', 'i', 'n', 'u', 's', ';'};
static const UChar CirclePlusSemicolonEntityName[] = {'C', 'i', 'r', 'c', 'l', 'e', 'P', 'l', 'u', 's', ';'};
static const UChar CircleTimesSemicolonEntityName[] = {'C', 'i', 'r', 'c', 'l', 'e', 'T', 'i', 'm', 'e', 's', ';'};
static const UChar ClockwiseContourIntegralSemicolonEntityName[] = {'C', 'l', 'o', 'c', 'k', 'w', 'i', 's', 'e', 'C', 'o', 'n', 't', 'o', 'u', 'r', 'I', 'n', 't', 'e', 'g', 'r', 'a', 'l', ';'};
static const UChar CloseCurlyDoubleQuoteSemicolonEntityName[] = {'C', 'l', 'o', 's', 'e', 'C', 'u', 'r', 'l', 'y', 'D', 'o', 'u', 'b', 'l', 'e', 'Q', 'u', 'o', 't', 'e', ';'};
static const UChar CloseCurlyQuoteSemicolonEntityName[] = {'C', 'l', 'o', 's', 'e', 'C', 'u', 'r', 'l', 'y', 'Q', 'u', 'o', 't', 'e', ';'};
static const UChar ColonSemicolonEntityName[] = {'C', 'o', 'l', 'o', 'n', ';'};
static const UChar ColoneSemicolonEntityName[] = {'C', 'o', 'l', 'o', 'n', 'e', ';'};
static const UChar CongruentSemicolonEntityName[] = {'C', 'o', 'n', 'g', 'r', 'u', 'e', 'n', 't', ';'};
static const UChar ConintSemicolonEntityName[] = {'C', 'o', 'n', 'i', 'n', 't', ';'};
static const UChar ContourIntegralSemicolonEntityName[] = {'C', 'o', 'n', 't', 'o', 'u', 'r', 'I', 'n', 't', 'e', 'g', 'r', 'a', 'l', ';'};
static const UChar CopfSemicolonEntityName[] = {'C', 'o', 'p', 'f', ';'};
static const UChar CoproductSemicolonEntityName[] = {'C', 'o', 'p', 'r', 'o', 'd', 'u', 'c', 't', ';'};
static const UChar CounterClockwiseContourIntegralSemicolonEntityName[] = {'C', 'o', 'u', 'n', 't', 'e', 'r', 'C', 'l', 'o', 'c', 'k', 'w', 'i', 's', 'e', 'C', 'o', 'n', 't', 'o', 'u', 'r', 'I', 'n', 't', 'e', 'g', 'r', 'a', 'l', ';'};
static const UChar CrossSemicolonEntityName[] = {'C', 'r', 'o', 's', 's', ';'};
static const UChar CscrSemicolonEntityName[] = {'C', 's', 'c', 'r', ';'};
static const UChar CupSemicolonEntityName[] = {'C', 'u', 'p', ';'};
static const UChar CupCapSemicolonEntityName[] = {'C', 'u', 'p', 'C', 'a', 'p', ';'};
static const UChar DDSemicolonEntityName[] = {'D', 'D', ';'};
static const UChar DDotrahdSemicolonEntityName[] = {'D', 'D', 'o', 't', 'r', 'a', 'h', 'd', ';'};
static const UChar DJcySemicolonEntityName[] = {'D', 'J', 'c', 'y', ';'};
static const UChar DScySemicolonEntityName[] = {'D', 'S', 'c', 'y', ';'};
static const UChar DZcySemicolonEntityName[] = {'D', 'Z', 'c', 'y', ';'};
static const UChar DaggerSemicolonEntityName[] = {'D', 'a', 'g', 'g', 'e', 'r', ';'};
static const UChar DarrSemicolonEntityName[] = {'D', 'a', 'r', 'r', ';'};
static const UChar DashvSemicolonEntityName[] = {'D', 'a', 's', 'h', 'v', ';'};
static const UChar DcaronSemicolonEntityName[] = {'D', 'c', 'a', 'r', 'o', 'n', ';'};
static const UChar DcySemicolonEntityName[] = {'D', 'c', 'y', ';'};
static const UChar DelSemicolonEntityName[] = {'D', 'e', 'l', ';'};
static const UChar DeltaSemicolonEntityName[] = {'D', 'e', 'l', 't', 'a', ';'};
static const UChar DfrSemicolonEntityName[] = {'D', 'f', 'r', ';'};
static const UChar DiacriticalAcuteSemicolonEntityName[] = {'D', 'i', 'a', 'c', 'r', 'i', 't', 'i', 'c', 'a', 'l', 'A', 'c', 'u', 't', 'e', ';'};
static const UChar DiacriticalDotSemicolonEntityName[] = {'D', 'i', 'a', 'c', 'r', 'i', 't', 'i', 'c', 'a', 'l', 'D', 'o', 't', ';'};
static const UChar DiacriticalDoubleAcuteSemicolonEntityName[] = {'D', 'i', 'a', 'c', 'r', 'i', 't', 'i', 'c', 'a', 'l', 'D', 'o', 'u', 'b', 'l', 'e', 'A', 'c', 'u', 't', 'e', ';'};
static const UChar DiacriticalGraveSemicolonEntityName[] = {'D', 'i', 'a', 'c', 'r', 'i', 't', 'i', 'c', 'a', 'l', 'G', 'r', 'a', 'v', 'e', ';'};
static const UChar DiacriticalTildeSemicolonEntityName[] = {'D', 'i', 'a', 'c', 'r', 'i', 't', 'i', 'c', 'a', 'l', 'T', 'i', 'l', 'd', 'e', ';'};
static const UChar DiamondSemicolonEntityName[] = {'D', 'i', 'a', 'm', 'o', 'n', 'd', ';'};
static const UChar DifferentialDSemicolonEntityName[] = {'D', 'i', 'f', 'f', 'e', 'r', 'e', 'n', 't', 'i', 'a', 'l', 'D', ';'};
static const UChar DopfSemicolonEntityName[] = {'D', 'o', 'p', 'f', ';'};
static const UChar DotSemicolonEntityName[] = {'D', 'o', 't', ';'};
static const UChar DotDotSemicolonEntityName[] = {'D', 'o', 't', 'D', 'o', 't', ';'};
static const UChar DotEqualSemicolonEntityName[] = {'D', 'o', 't', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar DoubleContourIntegralSemicolonEntityName[] = {'D', 'o', 'u', 'b', 'l', 'e', 'C', 'o', 'n', 't', 'o', 'u', 'r', 'I', 'n', 't', 'e', 'g', 'r', 'a', 'l', ';'};
static const UChar DoubleDotSemicolonEntityName[] = {'D', 'o', 'u', 'b', 'l', 'e', 'D', 'o', 't', ';'};
static const UChar DoubleDownArrowSemicolonEntityName[] = {'D', 'o', 'u', 'b', 'l', 'e', 'D', 'o', 'w', 'n', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar DoubleLeftArrowSemicolonEntityName[] = {'D', 'o', 'u', 'b', 'l', 'e', 'L', 'e', 'f', 't', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar DoubleLeftRightArrowSemicolonEntityName[] = {'D', 'o', 'u', 'b', 'l', 'e', 'L', 'e', 'f', 't', 'R', 'i', 'g', 'h', 't', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar DoubleLeftTeeSemicolonEntityName[] = {'D', 'o', 'u', 'b', 'l', 'e', 'L', 'e', 'f', 't', 'T', 'e', 'e', ';'};
static const UChar DoubleLongLeftArrowSemicolonEntityName[] = {'D', 'o', 'u', 'b', 'l', 'e', 'L', 'o', 'n', 'g', 'L', 'e', 'f', 't', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar DoubleLongLeftRightArrowSemicolonEntityName[] = {'D', 'o', 'u', 'b', 'l', 'e', 'L', 'o', 'n', 'g', 'L', 'e', 'f', 't', 'R', 'i', 'g', 'h', 't', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar DoubleLongRightArrowSemicolonEntityName[] = {'D', 'o', 'u', 'b', 'l', 'e', 'L', 'o', 'n', 'g', 'R', 'i', 'g', 'h', 't', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar DoubleRightArrowSemicolonEntityName[] = {'D', 'o', 'u', 'b', 'l', 'e', 'R', 'i', 'g', 'h', 't', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar DoubleRightTeeSemicolonEntityName[] = {'D', 'o', 'u', 'b', 'l', 'e', 'R', 'i', 'g', 'h', 't', 'T', 'e', 'e', ';'};
static const UChar DoubleUpArrowSemicolonEntityName[] = {'D', 'o', 'u', 'b', 'l', 'e', 'U', 'p', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar DoubleUpDownArrowSemicolonEntityName[] = {'D', 'o', 'u', 'b', 'l', 'e', 'U', 'p', 'D', 'o', 'w', 'n', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar DoubleVerticalBarSemicolonEntityName[] = {'D', 'o', 'u', 'b', 'l', 'e', 'V', 'e', 'r', 't', 'i', 'c', 'a', 'l', 'B', 'a', 'r', ';'};
static const UChar DownArrowSemicolonEntityName[] = {'D', 'o', 'w', 'n', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar DownArrowBarSemicolonEntityName[] = {'D', 'o', 'w', 'n', 'A', 'r', 'r', 'o', 'w', 'B', 'a', 'r', ';'};
static const UChar DownArrowUpArrowSemicolonEntityName[] = {'D', 'o', 'w', 'n', 'A', 'r', 'r', 'o', 'w', 'U', 'p', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar DownBreveSemicolonEntityName[] = {'D', 'o', 'w', 'n', 'B', 'r', 'e', 'v', 'e', ';'};
static const UChar DownLeftRightVectorSemicolonEntityName[] = {'D', 'o', 'w', 'n', 'L', 'e', 'f', 't', 'R', 'i', 'g', 'h', 't', 'V', 'e', 'c', 't', 'o', 'r', ';'};
static const UChar DownLeftTeeVectorSemicolonEntityName[] = {'D', 'o', 'w', 'n', 'L', 'e', 'f', 't', 'T', 'e', 'e', 'V', 'e', 'c', 't', 'o', 'r', ';'};
static const UChar DownLeftVectorSemicolonEntityName[] = {'D', 'o', 'w', 'n', 'L', 'e', 'f', 't', 'V', 'e', 'c', 't', 'o', 'r', ';'};
static const UChar DownLeftVectorBarSemicolonEntityName[] = {'D', 'o', 'w', 'n', 'L', 'e', 'f', 't', 'V', 'e', 'c', 't', 'o', 'r', 'B', 'a', 'r', ';'};
static const UChar DownRightTeeVectorSemicolonEntityName[] = {'D', 'o', 'w', 'n', 'R', 'i', 'g', 'h', 't', 'T', 'e', 'e', 'V', 'e', 'c', 't', 'o', 'r', ';'};
static const UChar DownRightVectorSemicolonEntityName[] = {'D', 'o', 'w', 'n', 'R', 'i', 'g', 'h', 't', 'V', 'e', 'c', 't', 'o', 'r', ';'};
static const UChar DownRightVectorBarSemicolonEntityName[] = {'D', 'o', 'w', 'n', 'R', 'i', 'g', 'h', 't', 'V', 'e', 'c', 't', 'o', 'r', 'B', 'a', 'r', ';'};
static const UChar DownTeeSemicolonEntityName[] = {'D', 'o', 'w', 'n', 'T', 'e', 'e', ';'};
static const UChar DownTeeArrowSemicolonEntityName[] = {'D', 'o', 'w', 'n', 'T', 'e', 'e', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar DownarrowSemicolonEntityName[] = {'D', 'o', 'w', 'n', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar DscrSemicolonEntityName[] = {'D', 's', 'c', 'r', ';'};
static const UChar DstrokSemicolonEntityName[] = {'D', 's', 't', 'r', 'o', 'k', ';'};
static const UChar ENGSemicolonEntityName[] = {'E', 'N', 'G', ';'};
static const UChar ETHEntityName[] = {'E', 'T', 'H'};
static const UChar ETHSemicolonEntityName[] = {'E', 'T', 'H', ';'};
static const UChar EacuteEntityName[] = {'E', 'a', 'c', 'u', 't', 'e'};
static const UChar EacuteSemicolonEntityName[] = {'E', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar EcaronSemicolonEntityName[] = {'E', 'c', 'a', 'r', 'o', 'n', ';'};
static const UChar EcircEntityName[] = {'E', 'c', 'i', 'r', 'c'};
static const UChar EcircSemicolonEntityName[] = {'E', 'c', 'i', 'r', 'c', ';'};
static const UChar EcySemicolonEntityName[] = {'E', 'c', 'y', ';'};
static const UChar EdotSemicolonEntityName[] = {'E', 'd', 'o', 't', ';'};
static const UChar EfrSemicolonEntityName[] = {'E', 'f', 'r', ';'};
static const UChar EgraveEntityName[] = {'E', 'g', 'r', 'a', 'v', 'e'};
static const UChar EgraveSemicolonEntityName[] = {'E', 'g', 'r', 'a', 'v', 'e', ';'};
static const UChar ElementSemicolonEntityName[] = {'E', 'l', 'e', 'm', 'e', 'n', 't', ';'};
static const UChar EmacrSemicolonEntityName[] = {'E', 'm', 'a', 'c', 'r', ';'};
static const UChar EmptySmallSquareSemicolonEntityName[] = {'E', 'm', 'p', 't', 'y', 'S', 'm', 'a', 'l', 'l', 'S', 'q', 'u', 'a', 'r', 'e', ';'};
static const UChar EmptyVerySmallSquareSemicolonEntityName[] = {'E', 'm', 'p', 't', 'y', 'V', 'e', 'r', 'y', 'S', 'm', 'a', 'l', 'l', 'S', 'q', 'u', 'a', 'r', 'e', ';'};
static const UChar EogonSemicolonEntityName[] = {'E', 'o', 'g', 'o', 'n', ';'};
static const UChar EopfSemicolonEntityName[] = {'E', 'o', 'p', 'f', ';'};
static const UChar EpsilonSemicolonEntityName[] = {'E', 'p', 's', 'i', 'l', 'o', 'n', ';'};
static const UChar EqualSemicolonEntityName[] = {'E', 'q', 'u', 'a', 'l', ';'};
static const UChar EqualTildeSemicolonEntityName[] = {'E', 'q', 'u', 'a', 'l', 'T', 'i', 'l', 'd', 'e', ';'};
static const UChar EquilibriumSemicolonEntityName[] = {'E', 'q', 'u', 'i', 'l', 'i', 'b', 'r', 'i', 'u', 'm', ';'};
static const UChar EscrSemicolonEntityName[] = {'E', 's', 'c', 'r', ';'};
static const UChar EsimSemicolonEntityName[] = {'E', 's', 'i', 'm', ';'};
static const UChar EtaSemicolonEntityName[] = {'E', 't', 'a', ';'};
static const UChar EumlEntityName[] = {'E', 'u', 'm', 'l'};
static const UChar EumlSemicolonEntityName[] = {'E', 'u', 'm', 'l', ';'};
static const UChar ExistsSemicolonEntityName[] = {'E', 'x', 'i', 's', 't', 's', ';'};
static const UChar ExponentialESemicolonEntityName[] = {'E', 'x', 'p', 'o', 'n', 'e', 'n', 't', 'i', 'a', 'l', 'E', ';'};
static const UChar FcySemicolonEntityName[] = {'F', 'c', 'y', ';'};
static const UChar FfrSemicolonEntityName[] = {'F', 'f', 'r', ';'};
static const UChar FilledSmallSquareSemicolonEntityName[] = {'F', 'i', 'l', 'l', 'e', 'd', 'S', 'm', 'a', 'l', 'l', 'S', 'q', 'u', 'a', 'r', 'e', ';'};
static const UChar FilledVerySmallSquareSemicolonEntityName[] = {'F', 'i', 'l', 'l', 'e', 'd', 'V', 'e', 'r', 'y', 'S', 'm', 'a', 'l', 'l', 'S', 'q', 'u', 'a', 'r', 'e', ';'};
static const UChar FopfSemicolonEntityName[] = {'F', 'o', 'p', 'f', ';'};
static const UChar ForAllSemicolonEntityName[] = {'F', 'o', 'r', 'A', 'l', 'l', ';'};
static const UChar FouriertrfSemicolonEntityName[] = {'F', 'o', 'u', 'r', 'i', 'e', 'r', 't', 'r', 'f', ';'};
static const UChar FscrSemicolonEntityName[] = {'F', 's', 'c', 'r', ';'};
static const UChar GJcySemicolonEntityName[] = {'G', 'J', 'c', 'y', ';'};
static const UChar GTEntityName[] = {'G', 'T'};
static const UChar GTSemicolonEntityName[] = {'G', 'T', ';'};
static const UChar GammaSemicolonEntityName[] = {'G', 'a', 'm', 'm', 'a', ';'};
static const UChar GammadSemicolonEntityName[] = {'G', 'a', 'm', 'm', 'a', 'd', ';'};
static const UChar GbreveSemicolonEntityName[] = {'G', 'b', 'r', 'e', 'v', 'e', ';'};
static const UChar GcedilSemicolonEntityName[] = {'G', 'c', 'e', 'd', 'i', 'l', ';'};
static const UChar GcircSemicolonEntityName[] = {'G', 'c', 'i', 'r', 'c', ';'};
static const UChar GcySemicolonEntityName[] = {'G', 'c', 'y', ';'};
static const UChar GdotSemicolonEntityName[] = {'G', 'd', 'o', 't', ';'};
static const UChar GfrSemicolonEntityName[] = {'G', 'f', 'r', ';'};
static const UChar GgSemicolonEntityName[] = {'G', 'g', ';'};
static const UChar GopfSemicolonEntityName[] = {'G', 'o', 'p', 'f', ';'};
static const UChar GreaterEqualSemicolonEntityName[] = {'G', 'r', 'e', 'a', 't', 'e', 'r', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar GreaterEqualLessSemicolonEntityName[] = {'G', 'r', 'e', 'a', 't', 'e', 'r', 'E', 'q', 'u', 'a', 'l', 'L', 'e', 's', 's', ';'};
static const UChar GreaterFullEqualSemicolonEntityName[] = {'G', 'r', 'e', 'a', 't', 'e', 'r', 'F', 'u', 'l', 'l', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar GreaterGreaterSemicolonEntityName[] = {'G', 'r', 'e', 'a', 't', 'e', 'r', 'G', 'r', 'e', 'a', 't', 'e', 'r', ';'};
static const UChar GreaterLessSemicolonEntityName[] = {'G', 'r', 'e', 'a', 't', 'e', 'r', 'L', 'e', 's', 's', ';'};
static const UChar GreaterSlantEqualSemicolonEntityName[] = {'G', 'r', 'e', 'a', 't', 'e', 'r', 'S', 'l', 'a', 'n', 't', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar GreaterTildeSemicolonEntityName[] = {'G', 'r', 'e', 'a', 't', 'e', 'r', 'T', 'i', 'l', 'd', 'e', ';'};
static const UChar GscrSemicolonEntityName[] = {'G', 's', 'c', 'r', ';'};
static const UChar GtSemicolonEntityName[] = {'G', 't', ';'};
static const UChar HARDcySemicolonEntityName[] = {'H', 'A', 'R', 'D', 'c', 'y', ';'};
static const UChar HacekSemicolonEntityName[] = {'H', 'a', 'c', 'e', 'k', ';'};
static const UChar HatSemicolonEntityName[] = {'H', 'a', 't', ';'};
static const UChar HcircSemicolonEntityName[] = {'H', 'c', 'i', 'r', 'c', ';'};
static const UChar HfrSemicolonEntityName[] = {'H', 'f', 'r', ';'};
static const UChar HilbertSpaceSemicolonEntityName[] = {'H', 'i', 'l', 'b', 'e', 'r', 't', 'S', 'p', 'a', 'c', 'e', ';'};
static const UChar HopfSemicolonEntityName[] = {'H', 'o', 'p', 'f', ';'};
static const UChar HorizontalLineSemicolonEntityName[] = {'H', 'o', 'r', 'i', 'z', 'o', 'n', 't', 'a', 'l', 'L', 'i', 'n', 'e', ';'};
static const UChar HscrSemicolonEntityName[] = {'H', 's', 'c', 'r', ';'};
static const UChar HstrokSemicolonEntityName[] = {'H', 's', 't', 'r', 'o', 'k', ';'};
static const UChar HumpDownHumpSemicolonEntityName[] = {'H', 'u', 'm', 'p', 'D', 'o', 'w', 'n', 'H', 'u', 'm', 'p', ';'};
static const UChar HumpEqualSemicolonEntityName[] = {'H', 'u', 'm', 'p', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar IEcySemicolonEntityName[] = {'I', 'E', 'c', 'y', ';'};
static const UChar IJligSemicolonEntityName[] = {'I', 'J', 'l', 'i', 'g', ';'};
static const UChar IOcySemicolonEntityName[] = {'I', 'O', 'c', 'y', ';'};
static const UChar IacuteEntityName[] = {'I', 'a', 'c', 'u', 't', 'e'};
static const UChar IacuteSemicolonEntityName[] = {'I', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar IcircEntityName[] = {'I', 'c', 'i', 'r', 'c'};
static const UChar IcircSemicolonEntityName[] = {'I', 'c', 'i', 'r', 'c', ';'};
static const UChar IcySemicolonEntityName[] = {'I', 'c', 'y', ';'};
static const UChar IdotSemicolonEntityName[] = {'I', 'd', 'o', 't', ';'};
static const UChar IfrSemicolonEntityName[] = {'I', 'f', 'r', ';'};
static const UChar IgraveEntityName[] = {'I', 'g', 'r', 'a', 'v', 'e'};
static const UChar IgraveSemicolonEntityName[] = {'I', 'g', 'r', 'a', 'v', 'e', ';'};
static const UChar ImSemicolonEntityName[] = {'I', 'm', ';'};
static const UChar ImacrSemicolonEntityName[] = {'I', 'm', 'a', 'c', 'r', ';'};
static const UChar ImaginaryISemicolonEntityName[] = {'I', 'm', 'a', 'g', 'i', 'n', 'a', 'r', 'y', 'I', ';'};
static const UChar ImpliesSemicolonEntityName[] = {'I', 'm', 'p', 'l', 'i', 'e', 's', ';'};
static const UChar IntSemicolonEntityName[] = {'I', 'n', 't', ';'};
static const UChar IntegralSemicolonEntityName[] = {'I', 'n', 't', 'e', 'g', 'r', 'a', 'l', ';'};
static const UChar IntersectionSemicolonEntityName[] = {'I', 'n', 't', 'e', 'r', 's', 'e', 'c', 't', 'i', 'o', 'n', ';'};
static const UChar InvisibleCommaSemicolonEntityName[] = {'I', 'n', 'v', 'i', 's', 'i', 'b', 'l', 'e', 'C', 'o', 'm', 'm', 'a', ';'};
static const UChar InvisibleTimesSemicolonEntityName[] = {'I', 'n', 'v', 'i', 's', 'i', 'b', 'l', 'e', 'T', 'i', 'm', 'e', 's', ';'};
static const UChar IogonSemicolonEntityName[] = {'I', 'o', 'g', 'o', 'n', ';'};
static const UChar IopfSemicolonEntityName[] = {'I', 'o', 'p', 'f', ';'};
static const UChar IotaSemicolonEntityName[] = {'I', 'o', 't', 'a', ';'};
static const UChar IscrSemicolonEntityName[] = {'I', 's', 'c', 'r', ';'};
static const UChar ItildeSemicolonEntityName[] = {'I', 't', 'i', 'l', 'd', 'e', ';'};
static const UChar IukcySemicolonEntityName[] = {'I', 'u', 'k', 'c', 'y', ';'};
static const UChar IumlEntityName[] = {'I', 'u', 'm', 'l'};
static const UChar IumlSemicolonEntityName[] = {'I', 'u', 'm', 'l', ';'};
static const UChar JcircSemicolonEntityName[] = {'J', 'c', 'i', 'r', 'c', ';'};
static const UChar JcySemicolonEntityName[] = {'J', 'c', 'y', ';'};
static const UChar JfrSemicolonEntityName[] = {'J', 'f', 'r', ';'};
static const UChar JopfSemicolonEntityName[] = {'J', 'o', 'p', 'f', ';'};
static const UChar JscrSemicolonEntityName[] = {'J', 's', 'c', 'r', ';'};
static const UChar JsercySemicolonEntityName[] = {'J', 's', 'e', 'r', 'c', 'y', ';'};
static const UChar JukcySemicolonEntityName[] = {'J', 'u', 'k', 'c', 'y', ';'};
static const UChar KHcySemicolonEntityName[] = {'K', 'H', 'c', 'y', ';'};
static const UChar KJcySemicolonEntityName[] = {'K', 'J', 'c', 'y', ';'};
static const UChar KappaSemicolonEntityName[] = {'K', 'a', 'p', 'p', 'a', ';'};
static const UChar KcedilSemicolonEntityName[] = {'K', 'c', 'e', 'd', 'i', 'l', ';'};
static const UChar KcySemicolonEntityName[] = {'K', 'c', 'y', ';'};
static const UChar KfrSemicolonEntityName[] = {'K', 'f', 'r', ';'};
static const UChar KopfSemicolonEntityName[] = {'K', 'o', 'p', 'f', ';'};
static const UChar KscrSemicolonEntityName[] = {'K', 's', 'c', 'r', ';'};
static const UChar LJcySemicolonEntityName[] = {'L', 'J', 'c', 'y', ';'};
static const UChar LTEntityName[] = {'L', 'T'};
static const UChar LTSemicolonEntityName[] = {'L', 'T', ';'};
static const UChar LacuteSemicolonEntityName[] = {'L', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar LambdaSemicolonEntityName[] = {'L', 'a', 'm', 'b', 'd', 'a', ';'};
static const UChar LangSemicolonEntityName[] = {'L', 'a', 'n', 'g', ';'};
static const UChar LaplacetrfSemicolonEntityName[] = {'L', 'a', 'p', 'l', 'a', 'c', 'e', 't', 'r', 'f', ';'};
static const UChar LarrSemicolonEntityName[] = {'L', 'a', 'r', 'r', ';'};
static const UChar LcaronSemicolonEntityName[] = {'L', 'c', 'a', 'r', 'o', 'n', ';'};
static const UChar LcedilSemicolonEntityName[] = {'L', 'c', 'e', 'd', 'i', 'l', ';'};
static const UChar LcySemicolonEntityName[] = {'L', 'c', 'y', ';'};
static const UChar LeftAngleBracketSemicolonEntityName[] = {'L', 'e', 'f', 't', 'A', 'n', 'g', 'l', 'e', 'B', 'r', 'a', 'c', 'k', 'e', 't', ';'};
static const UChar LeftArrowSemicolonEntityName[] = {'L', 'e', 'f', 't', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar LeftArrowBarSemicolonEntityName[] = {'L', 'e', 'f', 't', 'A', 'r', 'r', 'o', 'w', 'B', 'a', 'r', ';'};
static const UChar LeftArrowRightArrowSemicolonEntityName[] = {'L', 'e', 'f', 't', 'A', 'r', 'r', 'o', 'w', 'R', 'i', 'g', 'h', 't', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar LeftCeilingSemicolonEntityName[] = {'L', 'e', 'f', 't', 'C', 'e', 'i', 'l', 'i', 'n', 'g', ';'};
static const UChar LeftDoubleBracketSemicolonEntityName[] = {'L', 'e', 'f', 't', 'D', 'o', 'u', 'b', 'l', 'e', 'B', 'r', 'a', 'c', 'k', 'e', 't', ';'};
static const UChar LeftDownTeeVectorSemicolonEntityName[] = {'L', 'e', 'f', 't', 'D', 'o', 'w', 'n', 'T', 'e', 'e', 'V', 'e', 'c', 't', 'o', 'r', ';'};
static const UChar LeftDownVectorSemicolonEntityName[] = {'L', 'e', 'f', 't', 'D', 'o', 'w', 'n', 'V', 'e', 'c', 't', 'o', 'r', ';'};
static const UChar LeftDownVectorBarSemicolonEntityName[] = {'L', 'e', 'f', 't', 'D', 'o', 'w', 'n', 'V', 'e', 'c', 't', 'o', 'r', 'B', 'a', 'r', ';'};
static const UChar LeftFloorSemicolonEntityName[] = {'L', 'e', 'f', 't', 'F', 'l', 'o', 'o', 'r', ';'};
static const UChar LeftRightArrowSemicolonEntityName[] = {'L', 'e', 'f', 't', 'R', 'i', 'g', 'h', 't', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar LeftRightVectorSemicolonEntityName[] = {'L', 'e', 'f', 't', 'R', 'i', 'g', 'h', 't', 'V', 'e', 'c', 't', 'o', 'r', ';'};
static const UChar LeftTeeSemicolonEntityName[] = {'L', 'e', 'f', 't', 'T', 'e', 'e', ';'};
static const UChar LeftTeeArrowSemicolonEntityName[] = {'L', 'e', 'f', 't', 'T', 'e', 'e', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar LeftTeeVectorSemicolonEntityName[] = {'L', 'e', 'f', 't', 'T', 'e', 'e', 'V', 'e', 'c', 't', 'o', 'r', ';'};
static const UChar LeftTriangleSemicolonEntityName[] = {'L', 'e', 'f', 't', 'T', 'r', 'i', 'a', 'n', 'g', 'l', 'e', ';'};
static const UChar LeftTriangleBarSemicolonEntityName[] = {'L', 'e', 'f', 't', 'T', 'r', 'i', 'a', 'n', 'g', 'l', 'e', 'B', 'a', 'r', ';'};
static const UChar LeftTriangleEqualSemicolonEntityName[] = {'L', 'e', 'f', 't', 'T', 'r', 'i', 'a', 'n', 'g', 'l', 'e', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar LeftUpDownVectorSemicolonEntityName[] = {'L', 'e', 'f', 't', 'U', 'p', 'D', 'o', 'w', 'n', 'V', 'e', 'c', 't', 'o', 'r', ';'};
static const UChar LeftUpTeeVectorSemicolonEntityName[] = {'L', 'e', 'f', 't', 'U', 'p', 'T', 'e', 'e', 'V', 'e', 'c', 't', 'o', 'r', ';'};
static const UChar LeftUpVectorSemicolonEntityName[] = {'L', 'e', 'f', 't', 'U', 'p', 'V', 'e', 'c', 't', 'o', 'r', ';'};
static const UChar LeftUpVectorBarSemicolonEntityName[] = {'L', 'e', 'f', 't', 'U', 'p', 'V', 'e', 'c', 't', 'o', 'r', 'B', 'a', 'r', ';'};
static const UChar LeftVectorSemicolonEntityName[] = {'L', 'e', 'f', 't', 'V', 'e', 'c', 't', 'o', 'r', ';'};
static const UChar LeftVectorBarSemicolonEntityName[] = {'L', 'e', 'f', 't', 'V', 'e', 'c', 't', 'o', 'r', 'B', 'a', 'r', ';'};
static const UChar LeftarrowSemicolonEntityName[] = {'L', 'e', 'f', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar LeftrightarrowSemicolonEntityName[] = {'L', 'e', 'f', 't', 'r', 'i', 'g', 'h', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar LessEqualGreaterSemicolonEntityName[] = {'L', 'e', 's', 's', 'E', 'q', 'u', 'a', 'l', 'G', 'r', 'e', 'a', 't', 'e', 'r', ';'};
static const UChar LessFullEqualSemicolonEntityName[] = {'L', 'e', 's', 's', 'F', 'u', 'l', 'l', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar LessGreaterSemicolonEntityName[] = {'L', 'e', 's', 's', 'G', 'r', 'e', 'a', 't', 'e', 'r', ';'};
static const UChar LessLessSemicolonEntityName[] = {'L', 'e', 's', 's', 'L', 'e', 's', 's', ';'};
static const UChar LessSlantEqualSemicolonEntityName[] = {'L', 'e', 's', 's', 'S', 'l', 'a', 'n', 't', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar LessTildeSemicolonEntityName[] = {'L', 'e', 's', 's', 'T', 'i', 'l', 'd', 'e', ';'};
static const UChar LfrSemicolonEntityName[] = {'L', 'f', 'r', ';'};
static const UChar LlSemicolonEntityName[] = {'L', 'l', ';'};
static const UChar LleftarrowSemicolonEntityName[] = {'L', 'l', 'e', 'f', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar LmidotSemicolonEntityName[] = {'L', 'm', 'i', 'd', 'o', 't', ';'};
static const UChar LongLeftArrowSemicolonEntityName[] = {'L', 'o', 'n', 'g', 'L', 'e', 'f', 't', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar LongLeftRightArrowSemicolonEntityName[] = {'L', 'o', 'n', 'g', 'L', 'e', 'f', 't', 'R', 'i', 'g', 'h', 't', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar LongRightArrowSemicolonEntityName[] = {'L', 'o', 'n', 'g', 'R', 'i', 'g', 'h', 't', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar LongleftarrowSemicolonEntityName[] = {'L', 'o', 'n', 'g', 'l', 'e', 'f', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar LongleftrightarrowSemicolonEntityName[] = {'L', 'o', 'n', 'g', 'l', 'e', 'f', 't', 'r', 'i', 'g', 'h', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar LongrightarrowSemicolonEntityName[] = {'L', 'o', 'n', 'g', 'r', 'i', 'g', 'h', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar LopfSemicolonEntityName[] = {'L', 'o', 'p', 'f', ';'};
static const UChar LowerLeftArrowSemicolonEntityName[] = {'L', 'o', 'w', 'e', 'r', 'L', 'e', 'f', 't', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar LowerRightArrowSemicolonEntityName[] = {'L', 'o', 'w', 'e', 'r', 'R', 'i', 'g', 'h', 't', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar LscrSemicolonEntityName[] = {'L', 's', 'c', 'r', ';'};
static const UChar LshSemicolonEntityName[] = {'L', 's', 'h', ';'};
static const UChar LstrokSemicolonEntityName[] = {'L', 's', 't', 'r', 'o', 'k', ';'};
static const UChar LtSemicolonEntityName[] = {'L', 't', ';'};
static const UChar MapSemicolonEntityName[] = {'M', 'a', 'p', ';'};
static const UChar McySemicolonEntityName[] = {'M', 'c', 'y', ';'};
static const UChar MediumSpaceSemicolonEntityName[] = {'M', 'e', 'd', 'i', 'u', 'm', 'S', 'p', 'a', 'c', 'e', ';'};
static const UChar MellintrfSemicolonEntityName[] = {'M', 'e', 'l', 'l', 'i', 'n', 't', 'r', 'f', ';'};
static const UChar MfrSemicolonEntityName[] = {'M', 'f', 'r', ';'};
static const UChar MinusPlusSemicolonEntityName[] = {'M', 'i', 'n', 'u', 's', 'P', 'l', 'u', 's', ';'};
static const UChar MopfSemicolonEntityName[] = {'M', 'o', 'p', 'f', ';'};
static const UChar MscrSemicolonEntityName[] = {'M', 's', 'c', 'r', ';'};
static const UChar MuSemicolonEntityName[] = {'M', 'u', ';'};
static const UChar NJcySemicolonEntityName[] = {'N', 'J', 'c', 'y', ';'};
static const UChar NacuteSemicolonEntityName[] = {'N', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar NcaronSemicolonEntityName[] = {'N', 'c', 'a', 'r', 'o', 'n', ';'};
static const UChar NcedilSemicolonEntityName[] = {'N', 'c', 'e', 'd', 'i', 'l', ';'};
static const UChar NcySemicolonEntityName[] = {'N', 'c', 'y', ';'};
static const UChar NegativeMediumSpaceSemicolonEntityName[] = {'N', 'e', 'g', 'a', 't', 'i', 'v', 'e', 'M', 'e', 'd', 'i', 'u', 'm', 'S', 'p', 'a', 'c', 'e', ';'};
static const UChar NegativeThickSpaceSemicolonEntityName[] = {'N', 'e', 'g', 'a', 't', 'i', 'v', 'e', 'T', 'h', 'i', 'c', 'k', 'S', 'p', 'a', 'c', 'e', ';'};
static const UChar NegativeThinSpaceSemicolonEntityName[] = {'N', 'e', 'g', 'a', 't', 'i', 'v', 'e', 'T', 'h', 'i', 'n', 'S', 'p', 'a', 'c', 'e', ';'};
static const UChar NegativeVeryThinSpaceSemicolonEntityName[] = {'N', 'e', 'g', 'a', 't', 'i', 'v', 'e', 'V', 'e', 'r', 'y', 'T', 'h', 'i', 'n', 'S', 'p', 'a', 'c', 'e', ';'};
static const UChar NestedGreaterGreaterSemicolonEntityName[] = {'N', 'e', 's', 't', 'e', 'd', 'G', 'r', 'e', 'a', 't', 'e', 'r', 'G', 'r', 'e', 'a', 't', 'e', 'r', ';'};
static const UChar NestedLessLessSemicolonEntityName[] = {'N', 'e', 's', 't', 'e', 'd', 'L', 'e', 's', 's', 'L', 'e', 's', 's', ';'};
static const UChar NewLineSemicolonEntityName[] = {'N', 'e', 'w', 'L', 'i', 'n', 'e', ';'};
static const UChar NfrSemicolonEntityName[] = {'N', 'f', 'r', ';'};
static const UChar NoBreakSemicolonEntityName[] = {'N', 'o', 'B', 'r', 'e', 'a', 'k', ';'};
static const UChar NonBreakingSpaceSemicolonEntityName[] = {'N', 'o', 'n', 'B', 'r', 'e', 'a', 'k', 'i', 'n', 'g', 'S', 'p', 'a', 'c', 'e', ';'};
static const UChar NopfSemicolonEntityName[] = {'N', 'o', 'p', 'f', ';'};
static const UChar NotSemicolonEntityName[] = {'N', 'o', 't', ';'};
static const UChar NotCongruentSemicolonEntityName[] = {'N', 'o', 't', 'C', 'o', 'n', 'g', 'r', 'u', 'e', 'n', 't', ';'};
static const UChar NotCupCapSemicolonEntityName[] = {'N', 'o', 't', 'C', 'u', 'p', 'C', 'a', 'p', ';'};
static const UChar NotDoubleVerticalBarSemicolonEntityName[] = {'N', 'o', 't', 'D', 'o', 'u', 'b', 'l', 'e', 'V', 'e', 'r', 't', 'i', 'c', 'a', 'l', 'B', 'a', 'r', ';'};
static const UChar NotElementSemicolonEntityName[] = {'N', 'o', 't', 'E', 'l', 'e', 'm', 'e', 'n', 't', ';'};
static const UChar NotEqualSemicolonEntityName[] = {'N', 'o', 't', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar NotExistsSemicolonEntityName[] = {'N', 'o', 't', 'E', 'x', 'i', 's', 't', 's', ';'};
static const UChar NotGreaterSemicolonEntityName[] = {'N', 'o', 't', 'G', 'r', 'e', 'a', 't', 'e', 'r', ';'};
static const UChar NotGreaterEqualSemicolonEntityName[] = {'N', 'o', 't', 'G', 'r', 'e', 'a', 't', 'e', 'r', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar NotGreaterLessSemicolonEntityName[] = {'N', 'o', 't', 'G', 'r', 'e', 'a', 't', 'e', 'r', 'L', 'e', 's', 's', ';'};
static const UChar NotGreaterTildeSemicolonEntityName[] = {'N', 'o', 't', 'G', 'r', 'e', 'a', 't', 'e', 'r', 'T', 'i', 'l', 'd', 'e', ';'};
static const UChar NotLeftTriangleSemicolonEntityName[] = {'N', 'o', 't', 'L', 'e', 'f', 't', 'T', 'r', 'i', 'a', 'n', 'g', 'l', 'e', ';'};
static const UChar NotLeftTriangleEqualSemicolonEntityName[] = {'N', 'o', 't', 'L', 'e', 'f', 't', 'T', 'r', 'i', 'a', 'n', 'g', 'l', 'e', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar NotLessSemicolonEntityName[] = {'N', 'o', 't', 'L', 'e', 's', 's', ';'};
static const UChar NotLessEqualSemicolonEntityName[] = {'N', 'o', 't', 'L', 'e', 's', 's', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar NotLessGreaterSemicolonEntityName[] = {'N', 'o', 't', 'L', 'e', 's', 's', 'G', 'r', 'e', 'a', 't', 'e', 'r', ';'};
static const UChar NotLessTildeSemicolonEntityName[] = {'N', 'o', 't', 'L', 'e', 's', 's', 'T', 'i', 'l', 'd', 'e', ';'};
static const UChar NotPrecedesSemicolonEntityName[] = {'N', 'o', 't', 'P', 'r', 'e', 'c', 'e', 'd', 'e', 's', ';'};
static const UChar NotPrecedesSlantEqualSemicolonEntityName[] = {'N', 'o', 't', 'P', 'r', 'e', 'c', 'e', 'd', 'e', 's', 'S', 'l', 'a', 'n', 't', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar NotReverseElementSemicolonEntityName[] = {'N', 'o', 't', 'R', 'e', 'v', 'e', 'r', 's', 'e', 'E', 'l', 'e', 'm', 'e', 'n', 't', ';'};
static const UChar NotRightTriangleSemicolonEntityName[] = {'N', 'o', 't', 'R', 'i', 'g', 'h', 't', 'T', 'r', 'i', 'a', 'n', 'g', 'l', 'e', ';'};
static const UChar NotRightTriangleEqualSemicolonEntityName[] = {'N', 'o', 't', 'R', 'i', 'g', 'h', 't', 'T', 'r', 'i', 'a', 'n', 'g', 'l', 'e', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar NotSquareSubsetEqualSemicolonEntityName[] = {'N', 'o', 't', 'S', 'q', 'u', 'a', 'r', 'e', 'S', 'u', 'b', 's', 'e', 't', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar NotSquareSupersetEqualSemicolonEntityName[] = {'N', 'o', 't', 'S', 'q', 'u', 'a', 'r', 'e', 'S', 'u', 'p', 'e', 'r', 's', 'e', 't', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar NotSubsetEqualSemicolonEntityName[] = {'N', 'o', 't', 'S', 'u', 'b', 's', 'e', 't', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar NotSucceedsSemicolonEntityName[] = {'N', 'o', 't', 'S', 'u', 'c', 'c', 'e', 'e', 'd', 's', ';'};
static const UChar NotSucceedsSlantEqualSemicolonEntityName[] = {'N', 'o', 't', 'S', 'u', 'c', 'c', 'e', 'e', 'd', 's', 'S', 'l', 'a', 'n', 't', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar NotSupersetEqualSemicolonEntityName[] = {'N', 'o', 't', 'S', 'u', 'p', 'e', 'r', 's', 'e', 't', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar NotTildeSemicolonEntityName[] = {'N', 'o', 't', 'T', 'i', 'l', 'd', 'e', ';'};
static const UChar NotTildeEqualSemicolonEntityName[] = {'N', 'o', 't', 'T', 'i', 'l', 'd', 'e', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar NotTildeFullEqualSemicolonEntityName[] = {'N', 'o', 't', 'T', 'i', 'l', 'd', 'e', 'F', 'u', 'l', 'l', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar NotTildeTildeSemicolonEntityName[] = {'N', 'o', 't', 'T', 'i', 'l', 'd', 'e', 'T', 'i', 'l', 'd', 'e', ';'};
static const UChar NotVerticalBarSemicolonEntityName[] = {'N', 'o', 't', 'V', 'e', 'r', 't', 'i', 'c', 'a', 'l', 'B', 'a', 'r', ';'};
static const UChar NscrSemicolonEntityName[] = {'N', 's', 'c', 'r', ';'};
static const UChar NtildeEntityName[] = {'N', 't', 'i', 'l', 'd', 'e'};
static const UChar NtildeSemicolonEntityName[] = {'N', 't', 'i', 'l', 'd', 'e', ';'};
static const UChar NuSemicolonEntityName[] = {'N', 'u', ';'};
static const UChar OEligSemicolonEntityName[] = {'O', 'E', 'l', 'i', 'g', ';'};
static const UChar OacuteEntityName[] = {'O', 'a', 'c', 'u', 't', 'e'};
static const UChar OacuteSemicolonEntityName[] = {'O', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar OcircEntityName[] = {'O', 'c', 'i', 'r', 'c'};
static const UChar OcircSemicolonEntityName[] = {'O', 'c', 'i', 'r', 'c', ';'};
static const UChar OcySemicolonEntityName[] = {'O', 'c', 'y', ';'};
static const UChar OdblacSemicolonEntityName[] = {'O', 'd', 'b', 'l', 'a', 'c', ';'};
static const UChar OfrSemicolonEntityName[] = {'O', 'f', 'r', ';'};
static const UChar OgraveEntityName[] = {'O', 'g', 'r', 'a', 'v', 'e'};
static const UChar OgraveSemicolonEntityName[] = {'O', 'g', 'r', 'a', 'v', 'e', ';'};
static const UChar OmacrSemicolonEntityName[] = {'O', 'm', 'a', 'c', 'r', ';'};
static const UChar OmegaSemicolonEntityName[] = {'O', 'm', 'e', 'g', 'a', ';'};
static const UChar OmicronSemicolonEntityName[] = {'O', 'm', 'i', 'c', 'r', 'o', 'n', ';'};
static const UChar OopfSemicolonEntityName[] = {'O', 'o', 'p', 'f', ';'};
static const UChar OpenCurlyDoubleQuoteSemicolonEntityName[] = {'O', 'p', 'e', 'n', 'C', 'u', 'r', 'l', 'y', 'D', 'o', 'u', 'b', 'l', 'e', 'Q', 'u', 'o', 't', 'e', ';'};
static const UChar OpenCurlyQuoteSemicolonEntityName[] = {'O', 'p', 'e', 'n', 'C', 'u', 'r', 'l', 'y', 'Q', 'u', 'o', 't', 'e', ';'};
static const UChar OrSemicolonEntityName[] = {'O', 'r', ';'};
static const UChar OscrSemicolonEntityName[] = {'O', 's', 'c', 'r', ';'};
static const UChar OslashEntityName[] = {'O', 's', 'l', 'a', 's', 'h'};
static const UChar OslashSemicolonEntityName[] = {'O', 's', 'l', 'a', 's', 'h', ';'};
static const UChar OtildeEntityName[] = {'O', 't', 'i', 'l', 'd', 'e'};
static const UChar OtildeSemicolonEntityName[] = {'O', 't', 'i', 'l', 'd', 'e', ';'};
static const UChar OtimesSemicolonEntityName[] = {'O', 't', 'i', 'm', 'e', 's', ';'};
static const UChar OumlEntityName[] = {'O', 'u', 'm', 'l'};
static const UChar OumlSemicolonEntityName[] = {'O', 'u', 'm', 'l', ';'};
static const UChar OverBarSemicolonEntityName[] = {'O', 'v', 'e', 'r', 'B', 'a', 'r', ';'};
static const UChar OverBraceSemicolonEntityName[] = {'O', 'v', 'e', 'r', 'B', 'r', 'a', 'c', 'e', ';'};
static const UChar OverBracketSemicolonEntityName[] = {'O', 'v', 'e', 'r', 'B', 'r', 'a', 'c', 'k', 'e', 't', ';'};
static const UChar OverParenthesisSemicolonEntityName[] = {'O', 'v', 'e', 'r', 'P', 'a', 'r', 'e', 'n', 't', 'h', 'e', 's', 'i', 's', ';'};
static const UChar PartialDSemicolonEntityName[] = {'P', 'a', 'r', 't', 'i', 'a', 'l', 'D', ';'};
static const UChar PcySemicolonEntityName[] = {'P', 'c', 'y', ';'};
static const UChar PfrSemicolonEntityName[] = {'P', 'f', 'r', ';'};
static const UChar PhiSemicolonEntityName[] = {'P', 'h', 'i', ';'};
static const UChar PiSemicolonEntityName[] = {'P', 'i', ';'};
static const UChar PlusMinusSemicolonEntityName[] = {'P', 'l', 'u', 's', 'M', 'i', 'n', 'u', 's', ';'};
static const UChar PoincareplaneSemicolonEntityName[] = {'P', 'o', 'i', 'n', 'c', 'a', 'r', 'e', 'p', 'l', 'a', 'n', 'e', ';'};
static const UChar PopfSemicolonEntityName[] = {'P', 'o', 'p', 'f', ';'};
static const UChar PrSemicolonEntityName[] = {'P', 'r', ';'};
static const UChar PrecedesSemicolonEntityName[] = {'P', 'r', 'e', 'c', 'e', 'd', 'e', 's', ';'};
static const UChar PrecedesEqualSemicolonEntityName[] = {'P', 'r', 'e', 'c', 'e', 'd', 'e', 's', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar PrecedesSlantEqualSemicolonEntityName[] = {'P', 'r', 'e', 'c', 'e', 'd', 'e', 's', 'S', 'l', 'a', 'n', 't', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar PrecedesTildeSemicolonEntityName[] = {'P', 'r', 'e', 'c', 'e', 'd', 'e', 's', 'T', 'i', 'l', 'd', 'e', ';'};
static const UChar PrimeSemicolonEntityName[] = {'P', 'r', 'i', 'm', 'e', ';'};
static const UChar ProductSemicolonEntityName[] = {'P', 'r', 'o', 'd', 'u', 'c', 't', ';'};
static const UChar ProportionSemicolonEntityName[] = {'P', 'r', 'o', 'p', 'o', 'r', 't', 'i', 'o', 'n', ';'};
static const UChar ProportionalSemicolonEntityName[] = {'P', 'r', 'o', 'p', 'o', 'r', 't', 'i', 'o', 'n', 'a', 'l', ';'};
static const UChar PscrSemicolonEntityName[] = {'P', 's', 'c', 'r', ';'};
static const UChar PsiSemicolonEntityName[] = {'P', 's', 'i', ';'};
static const UChar QUOTEntityName[] = {'Q', 'U', 'O', 'T'};
static const UChar QUOTSemicolonEntityName[] = {'Q', 'U', 'O', 'T', ';'};
static const UChar QfrSemicolonEntityName[] = {'Q', 'f', 'r', ';'};
static const UChar QopfSemicolonEntityName[] = {'Q', 'o', 'p', 'f', ';'};
static const UChar QscrSemicolonEntityName[] = {'Q', 's', 'c', 'r', ';'};
static const UChar RBarrSemicolonEntityName[] = {'R', 'B', 'a', 'r', 'r', ';'};
static const UChar REGEntityName[] = {'R', 'E', 'G'};
static const UChar REGSemicolonEntityName[] = {'R', 'E', 'G', ';'};
static const UChar RacuteSemicolonEntityName[] = {'R', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar RangSemicolonEntityName[] = {'R', 'a', 'n', 'g', ';'};
static const UChar RarrSemicolonEntityName[] = {'R', 'a', 'r', 'r', ';'};
static const UChar RarrtlSemicolonEntityName[] = {'R', 'a', 'r', 'r', 't', 'l', ';'};
static const UChar RcaronSemicolonEntityName[] = {'R', 'c', 'a', 'r', 'o', 'n', ';'};
static const UChar RcedilSemicolonEntityName[] = {'R', 'c', 'e', 'd', 'i', 'l', ';'};
static const UChar RcySemicolonEntityName[] = {'R', 'c', 'y', ';'};
static const UChar ReSemicolonEntityName[] = {'R', 'e', ';'};
static const UChar ReverseElementSemicolonEntityName[] = {'R', 'e', 'v', 'e', 'r', 's', 'e', 'E', 'l', 'e', 'm', 'e', 'n', 't', ';'};
static const UChar ReverseEquilibriumSemicolonEntityName[] = {'R', 'e', 'v', 'e', 'r', 's', 'e', 'E', 'q', 'u', 'i', 'l', 'i', 'b', 'r', 'i', 'u', 'm', ';'};
static const UChar ReverseUpEquilibriumSemicolonEntityName[] = {'R', 'e', 'v', 'e', 'r', 's', 'e', 'U', 'p', 'E', 'q', 'u', 'i', 'l', 'i', 'b', 'r', 'i', 'u', 'm', ';'};
static const UChar RfrSemicolonEntityName[] = {'R', 'f', 'r', ';'};
static const UChar RhoSemicolonEntityName[] = {'R', 'h', 'o', ';'};
static const UChar RightAngleBracketSemicolonEntityName[] = {'R', 'i', 'g', 'h', 't', 'A', 'n', 'g', 'l', 'e', 'B', 'r', 'a', 'c', 'k', 'e', 't', ';'};
static const UChar RightArrowSemicolonEntityName[] = {'R', 'i', 'g', 'h', 't', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar RightArrowBarSemicolonEntityName[] = {'R', 'i', 'g', 'h', 't', 'A', 'r', 'r', 'o', 'w', 'B', 'a', 'r', ';'};
static const UChar RightArrowLeftArrowSemicolonEntityName[] = {'R', 'i', 'g', 'h', 't', 'A', 'r', 'r', 'o', 'w', 'L', 'e', 'f', 't', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar RightCeilingSemicolonEntityName[] = {'R', 'i', 'g', 'h', 't', 'C', 'e', 'i', 'l', 'i', 'n', 'g', ';'};
static const UChar RightDoubleBracketSemicolonEntityName[] = {'R', 'i', 'g', 'h', 't', 'D', 'o', 'u', 'b', 'l', 'e', 'B', 'r', 'a', 'c', 'k', 'e', 't', ';'};
static const UChar RightDownTeeVectorSemicolonEntityName[] = {'R', 'i', 'g', 'h', 't', 'D', 'o', 'w', 'n', 'T', 'e', 'e', 'V', 'e', 'c', 't', 'o', 'r', ';'};
static const UChar RightDownVectorSemicolonEntityName[] = {'R', 'i', 'g', 'h', 't', 'D', 'o', 'w', 'n', 'V', 'e', 'c', 't', 'o', 'r', ';'};
static const UChar RightDownVectorBarSemicolonEntityName[] = {'R', 'i', 'g', 'h', 't', 'D', 'o', 'w', 'n', 'V', 'e', 'c', 't', 'o', 'r', 'B', 'a', 'r', ';'};
static const UChar RightFloorSemicolonEntityName[] = {'R', 'i', 'g', 'h', 't', 'F', 'l', 'o', 'o', 'r', ';'};
static const UChar RightTeeSemicolonEntityName[] = {'R', 'i', 'g', 'h', 't', 'T', 'e', 'e', ';'};
static const UChar RightTeeArrowSemicolonEntityName[] = {'R', 'i', 'g', 'h', 't', 'T', 'e', 'e', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar RightTeeVectorSemicolonEntityName[] = {'R', 'i', 'g', 'h', 't', 'T', 'e', 'e', 'V', 'e', 'c', 't', 'o', 'r', ';'};
static const UChar RightTriangleSemicolonEntityName[] = {'R', 'i', 'g', 'h', 't', 'T', 'r', 'i', 'a', 'n', 'g', 'l', 'e', ';'};
static const UChar RightTriangleBarSemicolonEntityName[] = {'R', 'i', 'g', 'h', 't', 'T', 'r', 'i', 'a', 'n', 'g', 'l', 'e', 'B', 'a', 'r', ';'};
static const UChar RightTriangleEqualSemicolonEntityName[] = {'R', 'i', 'g', 'h', 't', 'T', 'r', 'i', 'a', 'n', 'g', 'l', 'e', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar RightUpDownVectorSemicolonEntityName[] = {'R', 'i', 'g', 'h', 't', 'U', 'p', 'D', 'o', 'w', 'n', 'V', 'e', 'c', 't', 'o', 'r', ';'};
static const UChar RightUpTeeVectorSemicolonEntityName[] = {'R', 'i', 'g', 'h', 't', 'U', 'p', 'T', 'e', 'e', 'V', 'e', 'c', 't', 'o', 'r', ';'};
static const UChar RightUpVectorSemicolonEntityName[] = {'R', 'i', 'g', 'h', 't', 'U', 'p', 'V', 'e', 'c', 't', 'o', 'r', ';'};
static const UChar RightUpVectorBarSemicolonEntityName[] = {'R', 'i', 'g', 'h', 't', 'U', 'p', 'V', 'e', 'c', 't', 'o', 'r', 'B', 'a', 'r', ';'};
static const UChar RightVectorSemicolonEntityName[] = {'R', 'i', 'g', 'h', 't', 'V', 'e', 'c', 't', 'o', 'r', ';'};
static const UChar RightVectorBarSemicolonEntityName[] = {'R', 'i', 'g', 'h', 't', 'V', 'e', 'c', 't', 'o', 'r', 'B', 'a', 'r', ';'};
static const UChar RightarrowSemicolonEntityName[] = {'R', 'i', 'g', 'h', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar RopfSemicolonEntityName[] = {'R', 'o', 'p', 'f', ';'};
static const UChar RoundImpliesSemicolonEntityName[] = {'R', 'o', 'u', 'n', 'd', 'I', 'm', 'p', 'l', 'i', 'e', 's', ';'};
static const UChar RrightarrowSemicolonEntityName[] = {'R', 'r', 'i', 'g', 'h', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar RscrSemicolonEntityName[] = {'R', 's', 'c', 'r', ';'};
static const UChar RshSemicolonEntityName[] = {'R', 's', 'h', ';'};
static const UChar RuleDelayedSemicolonEntityName[] = {'R', 'u', 'l', 'e', 'D', 'e', 'l', 'a', 'y', 'e', 'd', ';'};
static const UChar SHCHcySemicolonEntityName[] = {'S', 'H', 'C', 'H', 'c', 'y', ';'};
static const UChar SHcySemicolonEntityName[] = {'S', 'H', 'c', 'y', ';'};
static const UChar SOFTcySemicolonEntityName[] = {'S', 'O', 'F', 'T', 'c', 'y', ';'};
static const UChar SacuteSemicolonEntityName[] = {'S', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar ScSemicolonEntityName[] = {'S', 'c', ';'};
static const UChar ScaronSemicolonEntityName[] = {'S', 'c', 'a', 'r', 'o', 'n', ';'};
static const UChar ScedilSemicolonEntityName[] = {'S', 'c', 'e', 'd', 'i', 'l', ';'};
static const UChar ScircSemicolonEntityName[] = {'S', 'c', 'i', 'r', 'c', ';'};
static const UChar ScySemicolonEntityName[] = {'S', 'c', 'y', ';'};
static const UChar SfrSemicolonEntityName[] = {'S', 'f', 'r', ';'};
static const UChar ShortDownArrowSemicolonEntityName[] = {'S', 'h', 'o', 'r', 't', 'D', 'o', 'w', 'n', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar ShortLeftArrowSemicolonEntityName[] = {'S', 'h', 'o', 'r', 't', 'L', 'e', 'f', 't', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar ShortRightArrowSemicolonEntityName[] = {'S', 'h', 'o', 'r', 't', 'R', 'i', 'g', 'h', 't', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar ShortUpArrowSemicolonEntityName[] = {'S', 'h', 'o', 'r', 't', 'U', 'p', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar SigmaSemicolonEntityName[] = {'S', 'i', 'g', 'm', 'a', ';'};
static const UChar SmallCircleSemicolonEntityName[] = {'S', 'm', 'a', 'l', 'l', 'C', 'i', 'r', 'c', 'l', 'e', ';'};
static const UChar SopfSemicolonEntityName[] = {'S', 'o', 'p', 'f', ';'};
static const UChar SqrtSemicolonEntityName[] = {'S', 'q', 'r', 't', ';'};
static const UChar SquareSemicolonEntityName[] = {'S', 'q', 'u', 'a', 'r', 'e', ';'};
static const UChar SquareIntersectionSemicolonEntityName[] = {'S', 'q', 'u', 'a', 'r', 'e', 'I', 'n', 't', 'e', 'r', 's', 'e', 'c', 't', 'i', 'o', 'n', ';'};
static const UChar SquareSubsetSemicolonEntityName[] = {'S', 'q', 'u', 'a', 'r', 'e', 'S', 'u', 'b', 's', 'e', 't', ';'};
static const UChar SquareSubsetEqualSemicolonEntityName[] = {'S', 'q', 'u', 'a', 'r', 'e', 'S', 'u', 'b', 's', 'e', 't', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar SquareSupersetSemicolonEntityName[] = {'S', 'q', 'u', 'a', 'r', 'e', 'S', 'u', 'p', 'e', 'r', 's', 'e', 't', ';'};
static const UChar SquareSupersetEqualSemicolonEntityName[] = {'S', 'q', 'u', 'a', 'r', 'e', 'S', 'u', 'p', 'e', 'r', 's', 'e', 't', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar SquareUnionSemicolonEntityName[] = {'S', 'q', 'u', 'a', 'r', 'e', 'U', 'n', 'i', 'o', 'n', ';'};
static const UChar SscrSemicolonEntityName[] = {'S', 's', 'c', 'r', ';'};
static const UChar StarSemicolonEntityName[] = {'S', 't', 'a', 'r', ';'};
static const UChar SubSemicolonEntityName[] = {'S', 'u', 'b', ';'};
static const UChar SubsetSemicolonEntityName[] = {'S', 'u', 'b', 's', 'e', 't', ';'};
static const UChar SubsetEqualSemicolonEntityName[] = {'S', 'u', 'b', 's', 'e', 't', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar SucceedsSemicolonEntityName[] = {'S', 'u', 'c', 'c', 'e', 'e', 'd', 's', ';'};
static const UChar SucceedsEqualSemicolonEntityName[] = {'S', 'u', 'c', 'c', 'e', 'e', 'd', 's', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar SucceedsSlantEqualSemicolonEntityName[] = {'S', 'u', 'c', 'c', 'e', 'e', 'd', 's', 'S', 'l', 'a', 'n', 't', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar SucceedsTildeSemicolonEntityName[] = {'S', 'u', 'c', 'c', 'e', 'e', 'd', 's', 'T', 'i', 'l', 'd', 'e', ';'};
static const UChar SuchThatSemicolonEntityName[] = {'S', 'u', 'c', 'h', 'T', 'h', 'a', 't', ';'};
static const UChar SumSemicolonEntityName[] = {'S', 'u', 'm', ';'};
static const UChar SupSemicolonEntityName[] = {'S', 'u', 'p', ';'};
static const UChar SupersetSemicolonEntityName[] = {'S', 'u', 'p', 'e', 'r', 's', 'e', 't', ';'};
static const UChar SupersetEqualSemicolonEntityName[] = {'S', 'u', 'p', 'e', 'r', 's', 'e', 't', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar SupsetSemicolonEntityName[] = {'S', 'u', 'p', 's', 'e', 't', ';'};
static const UChar THORNEntityName[] = {'T', 'H', 'O', 'R', 'N'};
static const UChar THORNSemicolonEntityName[] = {'T', 'H', 'O', 'R', 'N', ';'};
static const UChar TRADESemicolonEntityName[] = {'T', 'R', 'A', 'D', 'E', ';'};
static const UChar TSHcySemicolonEntityName[] = {'T', 'S', 'H', 'c', 'y', ';'};
static const UChar TScySemicolonEntityName[] = {'T', 'S', 'c', 'y', ';'};
static const UChar TabSemicolonEntityName[] = {'T', 'a', 'b', ';'};
static const UChar TauSemicolonEntityName[] = {'T', 'a', 'u', ';'};
static const UChar TcaronSemicolonEntityName[] = {'T', 'c', 'a', 'r', 'o', 'n', ';'};
static const UChar TcedilSemicolonEntityName[] = {'T', 'c', 'e', 'd', 'i', 'l', ';'};
static const UChar TcySemicolonEntityName[] = {'T', 'c', 'y', ';'};
static const UChar TfrSemicolonEntityName[] = {'T', 'f', 'r', ';'};
static const UChar ThereforeSemicolonEntityName[] = {'T', 'h', 'e', 'r', 'e', 'f', 'o', 'r', 'e', ';'};
static const UChar ThetaSemicolonEntityName[] = {'T', 'h', 'e', 't', 'a', ';'};
static const UChar ThinSpaceSemicolonEntityName[] = {'T', 'h', 'i', 'n', 'S', 'p', 'a', 'c', 'e', ';'};
static const UChar TildeSemicolonEntityName[] = {'T', 'i', 'l', 'd', 'e', ';'};
static const UChar TildeEqualSemicolonEntityName[] = {'T', 'i', 'l', 'd', 'e', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar TildeFullEqualSemicolonEntityName[] = {'T', 'i', 'l', 'd', 'e', 'F', 'u', 'l', 'l', 'E', 'q', 'u', 'a', 'l', ';'};
static const UChar TildeTildeSemicolonEntityName[] = {'T', 'i', 'l', 'd', 'e', 'T', 'i', 'l', 'd', 'e', ';'};
static const UChar TopfSemicolonEntityName[] = {'T', 'o', 'p', 'f', ';'};
static const UChar TripleDotSemicolonEntityName[] = {'T', 'r', 'i', 'p', 'l', 'e', 'D', 'o', 't', ';'};
static const UChar TscrSemicolonEntityName[] = {'T', 's', 'c', 'r', ';'};
static const UChar TstrokSemicolonEntityName[] = {'T', 's', 't', 'r', 'o', 'k', ';'};
static const UChar UacuteEntityName[] = {'U', 'a', 'c', 'u', 't', 'e'};
static const UChar UacuteSemicolonEntityName[] = {'U', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar UarrSemicolonEntityName[] = {'U', 'a', 'r', 'r', ';'};
static const UChar UarrocirSemicolonEntityName[] = {'U', 'a', 'r', 'r', 'o', 'c', 'i', 'r', ';'};
static const UChar UbrcySemicolonEntityName[] = {'U', 'b', 'r', 'c', 'y', ';'};
static const UChar UbreveSemicolonEntityName[] = {'U', 'b', 'r', 'e', 'v', 'e', ';'};
static const UChar UcircEntityName[] = {'U', 'c', 'i', 'r', 'c'};
static const UChar UcircSemicolonEntityName[] = {'U', 'c', 'i', 'r', 'c', ';'};
static const UChar UcySemicolonEntityName[] = {'U', 'c', 'y', ';'};
static const UChar UdblacSemicolonEntityName[] = {'U', 'd', 'b', 'l', 'a', 'c', ';'};
static const UChar UfrSemicolonEntityName[] = {'U', 'f', 'r', ';'};
static const UChar UgraveEntityName[] = {'U', 'g', 'r', 'a', 'v', 'e'};
static const UChar UgraveSemicolonEntityName[] = {'U', 'g', 'r', 'a', 'v', 'e', ';'};
static const UChar UmacrSemicolonEntityName[] = {'U', 'm', 'a', 'c', 'r', ';'};
static const UChar UnderBarSemicolonEntityName[] = {'U', 'n', 'd', 'e', 'r', 'B', 'a', 'r', ';'};
static const UChar UnderBraceSemicolonEntityName[] = {'U', 'n', 'd', 'e', 'r', 'B', 'r', 'a', 'c', 'e', ';'};
static const UChar UnderBracketSemicolonEntityName[] = {'U', 'n', 'd', 'e', 'r', 'B', 'r', 'a', 'c', 'k', 'e', 't', ';'};
static const UChar UnderParenthesisSemicolonEntityName[] = {'U', 'n', 'd', 'e', 'r', 'P', 'a', 'r', 'e', 'n', 't', 'h', 'e', 's', 'i', 's', ';'};
static const UChar UnionSemicolonEntityName[] = {'U', 'n', 'i', 'o', 'n', ';'};
static const UChar UnionPlusSemicolonEntityName[] = {'U', 'n', 'i', 'o', 'n', 'P', 'l', 'u', 's', ';'};
static const UChar UogonSemicolonEntityName[] = {'U', 'o', 'g', 'o', 'n', ';'};
static const UChar UopfSemicolonEntityName[] = {'U', 'o', 'p', 'f', ';'};
static const UChar UpArrowSemicolonEntityName[] = {'U', 'p', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar UpArrowBarSemicolonEntityName[] = {'U', 'p', 'A', 'r', 'r', 'o', 'w', 'B', 'a', 'r', ';'};
static const UChar UpArrowDownArrowSemicolonEntityName[] = {'U', 'p', 'A', 'r', 'r', 'o', 'w', 'D', 'o', 'w', 'n', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar UpDownArrowSemicolonEntityName[] = {'U', 'p', 'D', 'o', 'w', 'n', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar UpEquilibriumSemicolonEntityName[] = {'U', 'p', 'E', 'q', 'u', 'i', 'l', 'i', 'b', 'r', 'i', 'u', 'm', ';'};
static const UChar UpTeeSemicolonEntityName[] = {'U', 'p', 'T', 'e', 'e', ';'};
static const UChar UpTeeArrowSemicolonEntityName[] = {'U', 'p', 'T', 'e', 'e', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar UparrowSemicolonEntityName[] = {'U', 'p', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar UpdownarrowSemicolonEntityName[] = {'U', 'p', 'd', 'o', 'w', 'n', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar UpperLeftArrowSemicolonEntityName[] = {'U', 'p', 'p', 'e', 'r', 'L', 'e', 'f', 't', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar UpperRightArrowSemicolonEntityName[] = {'U', 'p', 'p', 'e', 'r', 'R', 'i', 'g', 'h', 't', 'A', 'r', 'r', 'o', 'w', ';'};
static const UChar UpsiSemicolonEntityName[] = {'U', 'p', 's', 'i', ';'};
static const UChar UpsilonSemicolonEntityName[] = {'U', 'p', 's', 'i', 'l', 'o', 'n', ';'};
static const UChar UringSemicolonEntityName[] = {'U', 'r', 'i', 'n', 'g', ';'};
static const UChar UscrSemicolonEntityName[] = {'U', 's', 'c', 'r', ';'};
static const UChar UtildeSemicolonEntityName[] = {'U', 't', 'i', 'l', 'd', 'e', ';'};
static const UChar UumlEntityName[] = {'U', 'u', 'm', 'l'};
static const UChar UumlSemicolonEntityName[] = {'U', 'u', 'm', 'l', ';'};
static const UChar VDashSemicolonEntityName[] = {'V', 'D', 'a', 's', 'h', ';'};
static const UChar VbarSemicolonEntityName[] = {'V', 'b', 'a', 'r', ';'};
static const UChar VcySemicolonEntityName[] = {'V', 'c', 'y', ';'};
static const UChar VdashSemicolonEntityName[] = {'V', 'd', 'a', 's', 'h', ';'};
static const UChar VdashlSemicolonEntityName[] = {'V', 'd', 'a', 's', 'h', 'l', ';'};
static const UChar VeeSemicolonEntityName[] = {'V', 'e', 'e', ';'};
static const UChar VerbarSemicolonEntityName[] = {'V', 'e', 'r', 'b', 'a', 'r', ';'};
static const UChar VertSemicolonEntityName[] = {'V', 'e', 'r', 't', ';'};
static const UChar VerticalBarSemicolonEntityName[] = {'V', 'e', 'r', 't', 'i', 'c', 'a', 'l', 'B', 'a', 'r', ';'};
static const UChar VerticalLineSemicolonEntityName[] = {'V', 'e', 'r', 't', 'i', 'c', 'a', 'l', 'L', 'i', 'n', 'e', ';'};
static const UChar VerticalSeparatorSemicolonEntityName[] = {'V', 'e', 'r', 't', 'i', 'c', 'a', 'l', 'S', 'e', 'p', 'a', 'r', 'a', 't', 'o', 'r', ';'};
static const UChar VerticalTildeSemicolonEntityName[] = {'V', 'e', 'r', 't', 'i', 'c', 'a', 'l', 'T', 'i', 'l', 'd', 'e', ';'};
static const UChar VeryThinSpaceSemicolonEntityName[] = {'V', 'e', 'r', 'y', 'T', 'h', 'i', 'n', 'S', 'p', 'a', 'c', 'e', ';'};
static const UChar VfrSemicolonEntityName[] = {'V', 'f', 'r', ';'};
static const UChar VopfSemicolonEntityName[] = {'V', 'o', 'p', 'f', ';'};
static const UChar VscrSemicolonEntityName[] = {'V', 's', 'c', 'r', ';'};
static const UChar VvdashSemicolonEntityName[] = {'V', 'v', 'd', 'a', 's', 'h', ';'};
static const UChar WcircSemicolonEntityName[] = {'W', 'c', 'i', 'r', 'c', ';'};
static const UChar WedgeSemicolonEntityName[] = {'W', 'e', 'd', 'g', 'e', ';'};
static const UChar WfrSemicolonEntityName[] = {'W', 'f', 'r', ';'};
static const UChar WopfSemicolonEntityName[] = {'W', 'o', 'p', 'f', ';'};
static const UChar WscrSemicolonEntityName[] = {'W', 's', 'c', 'r', ';'};
static const UChar XfrSemicolonEntityName[] = {'X', 'f', 'r', ';'};
static const UChar XiSemicolonEntityName[] = {'X', 'i', ';'};
static const UChar XopfSemicolonEntityName[] = {'X', 'o', 'p', 'f', ';'};
static const UChar XscrSemicolonEntityName[] = {'X', 's', 'c', 'r', ';'};
static const UChar YAcySemicolonEntityName[] = {'Y', 'A', 'c', 'y', ';'};
static const UChar YIcySemicolonEntityName[] = {'Y', 'I', 'c', 'y', ';'};
static const UChar YUcySemicolonEntityName[] = {'Y', 'U', 'c', 'y', ';'};
static const UChar YacuteEntityName[] = {'Y', 'a', 'c', 'u', 't', 'e'};
static const UChar YacuteSemicolonEntityName[] = {'Y', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar YcircSemicolonEntityName[] = {'Y', 'c', 'i', 'r', 'c', ';'};
static const UChar YcySemicolonEntityName[] = {'Y', 'c', 'y', ';'};
static const UChar YfrSemicolonEntityName[] = {'Y', 'f', 'r', ';'};
static const UChar YopfSemicolonEntityName[] = {'Y', 'o', 'p', 'f', ';'};
static const UChar YscrSemicolonEntityName[] = {'Y', 's', 'c', 'r', ';'};
static const UChar YumlSemicolonEntityName[] = {'Y', 'u', 'm', 'l', ';'};
static const UChar ZHcySemicolonEntityName[] = {'Z', 'H', 'c', 'y', ';'};
static const UChar ZacuteSemicolonEntityName[] = {'Z', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar ZcaronSemicolonEntityName[] = {'Z', 'c', 'a', 'r', 'o', 'n', ';'};
static const UChar ZcySemicolonEntityName[] = {'Z', 'c', 'y', ';'};
static const UChar ZdotSemicolonEntityName[] = {'Z', 'd', 'o', 't', ';'};
static const UChar ZeroWidthSpaceSemicolonEntityName[] = {'Z', 'e', 'r', 'o', 'W', 'i', 'd', 't', 'h', 'S', 'p', 'a', 'c', 'e', ';'};
static const UChar ZetaSemicolonEntityName[] = {'Z', 'e', 't', 'a', ';'};
static const UChar ZfrSemicolonEntityName[] = {'Z', 'f', 'r', ';'};
static const UChar ZopfSemicolonEntityName[] = {'Z', 'o', 'p', 'f', ';'};
static const UChar ZscrSemicolonEntityName[] = {'Z', 's', 'c', 'r', ';'};
static const UChar aacuteEntityName[] = {'a', 'a', 'c', 'u', 't', 'e'};
static const UChar aacuteSemicolonEntityName[] = {'a', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar abreveSemicolonEntityName[] = {'a', 'b', 'r', 'e', 'v', 'e', ';'};
static const UChar acSemicolonEntityName[] = {'a', 'c', ';'};
static const UChar acdSemicolonEntityName[] = {'a', 'c', 'd', ';'};
static const UChar acircEntityName[] = {'a', 'c', 'i', 'r', 'c'};
static const UChar acircSemicolonEntityName[] = {'a', 'c', 'i', 'r', 'c', ';'};
static const UChar acuteEntityName[] = {'a', 'c', 'u', 't', 'e'};
static const UChar acuteSemicolonEntityName[] = {'a', 'c', 'u', 't', 'e', ';'};
static const UChar acySemicolonEntityName[] = {'a', 'c', 'y', ';'};
static const UChar aeligEntityName[] = {'a', 'e', 'l', 'i', 'g'};
static const UChar aeligSemicolonEntityName[] = {'a', 'e', 'l', 'i', 'g', ';'};
static const UChar afSemicolonEntityName[] = {'a', 'f', ';'};
static const UChar afrSemicolonEntityName[] = {'a', 'f', 'r', ';'};
static const UChar agraveEntityName[] = {'a', 'g', 'r', 'a', 'v', 'e'};
static const UChar agraveSemicolonEntityName[] = {'a', 'g', 'r', 'a', 'v', 'e', ';'};
static const UChar alefsymSemicolonEntityName[] = {'a', 'l', 'e', 'f', 's', 'y', 'm', ';'};
static const UChar alephSemicolonEntityName[] = {'a', 'l', 'e', 'p', 'h', ';'};
static const UChar alphaSemicolonEntityName[] = {'a', 'l', 'p', 'h', 'a', ';'};
static const UChar amacrSemicolonEntityName[] = {'a', 'm', 'a', 'c', 'r', ';'};
static const UChar amalgSemicolonEntityName[] = {'a', 'm', 'a', 'l', 'g', ';'};
static const UChar ampEntityName[] = {'a', 'm', 'p'};
static const UChar ampSemicolonEntityName[] = {'a', 'm', 'p', ';'};
static const UChar andSemicolonEntityName[] = {'a', 'n', 'd', ';'};
static const UChar andandSemicolonEntityName[] = {'a', 'n', 'd', 'a', 'n', 'd', ';'};
static const UChar anddSemicolonEntityName[] = {'a', 'n', 'd', 'd', ';'};
static const UChar andslopeSemicolonEntityName[] = {'a', 'n', 'd', 's', 'l', 'o', 'p', 'e', ';'};
static const UChar andvSemicolonEntityName[] = {'a', 'n', 'd', 'v', ';'};
static const UChar angSemicolonEntityName[] = {'a', 'n', 'g', ';'};
static const UChar angeSemicolonEntityName[] = {'a', 'n', 'g', 'e', ';'};
static const UChar angleSemicolonEntityName[] = {'a', 'n', 'g', 'l', 'e', ';'};
static const UChar angmsdSemicolonEntityName[] = {'a', 'n', 'g', 'm', 's', 'd', ';'};
static const UChar angmsdaaSemicolonEntityName[] = {'a', 'n', 'g', 'm', 's', 'd', 'a', 'a', ';'};
static const UChar angmsdabSemicolonEntityName[] = {'a', 'n', 'g', 'm', 's', 'd', 'a', 'b', ';'};
static const UChar angmsdacSemicolonEntityName[] = {'a', 'n', 'g', 'm', 's', 'd', 'a', 'c', ';'};
static const UChar angmsdadSemicolonEntityName[] = {'a', 'n', 'g', 'm', 's', 'd', 'a', 'd', ';'};
static const UChar angmsdaeSemicolonEntityName[] = {'a', 'n', 'g', 'm', 's', 'd', 'a', 'e', ';'};
static const UChar angmsdafSemicolonEntityName[] = {'a', 'n', 'g', 'm', 's', 'd', 'a', 'f', ';'};
static const UChar angmsdagSemicolonEntityName[] = {'a', 'n', 'g', 'm', 's', 'd', 'a', 'g', ';'};
static const UChar angmsdahSemicolonEntityName[] = {'a', 'n', 'g', 'm', 's', 'd', 'a', 'h', ';'};
static const UChar angrtSemicolonEntityName[] = {'a', 'n', 'g', 'r', 't', ';'};
static const UChar angrtvbSemicolonEntityName[] = {'a', 'n', 'g', 'r', 't', 'v', 'b', ';'};
static const UChar angrtvbdSemicolonEntityName[] = {'a', 'n', 'g', 'r', 't', 'v', 'b', 'd', ';'};
static const UChar angsphSemicolonEntityName[] = {'a', 'n', 'g', 's', 'p', 'h', ';'};
static const UChar angstSemicolonEntityName[] = {'a', 'n', 'g', 's', 't', ';'};
static const UChar angzarrSemicolonEntityName[] = {'a', 'n', 'g', 'z', 'a', 'r', 'r', ';'};
static const UChar aogonSemicolonEntityName[] = {'a', 'o', 'g', 'o', 'n', ';'};
static const UChar aopfSemicolonEntityName[] = {'a', 'o', 'p', 'f', ';'};
static const UChar apSemicolonEntityName[] = {'a', 'p', ';'};
static const UChar apESemicolonEntityName[] = {'a', 'p', 'E', ';'};
static const UChar apacirSemicolonEntityName[] = {'a', 'p', 'a', 'c', 'i', 'r', ';'};
static const UChar apeSemicolonEntityName[] = {'a', 'p', 'e', ';'};
static const UChar apidSemicolonEntityName[] = {'a', 'p', 'i', 'd', ';'};
static const UChar aposSemicolonEntityName[] = {'a', 'p', 'o', 's', ';'};
static const UChar approxSemicolonEntityName[] = {'a', 'p', 'p', 'r', 'o', 'x', ';'};
static const UChar approxeqSemicolonEntityName[] = {'a', 'p', 'p', 'r', 'o', 'x', 'e', 'q', ';'};
static const UChar aringEntityName[] = {'a', 'r', 'i', 'n', 'g'};
static const UChar aringSemicolonEntityName[] = {'a', 'r', 'i', 'n', 'g', ';'};
static const UChar ascrSemicolonEntityName[] = {'a', 's', 'c', 'r', ';'};
static const UChar astSemicolonEntityName[] = {'a', 's', 't', ';'};
static const UChar asympSemicolonEntityName[] = {'a', 's', 'y', 'm', 'p', ';'};
static const UChar asympeqSemicolonEntityName[] = {'a', 's', 'y', 'm', 'p', 'e', 'q', ';'};
static const UChar atildeEntityName[] = {'a', 't', 'i', 'l', 'd', 'e'};
static const UChar atildeSemicolonEntityName[] = {'a', 't', 'i', 'l', 'd', 'e', ';'};
static const UChar aumlEntityName[] = {'a', 'u', 'm', 'l'};
static const UChar aumlSemicolonEntityName[] = {'a', 'u', 'm', 'l', ';'};
static const UChar awconintSemicolonEntityName[] = {'a', 'w', 'c', 'o', 'n', 'i', 'n', 't', ';'};
static const UChar awintSemicolonEntityName[] = {'a', 'w', 'i', 'n', 't', ';'};
static const UChar bNotSemicolonEntityName[] = {'b', 'N', 'o', 't', ';'};
static const UChar backcongSemicolonEntityName[] = {'b', 'a', 'c', 'k', 'c', 'o', 'n', 'g', ';'};
static const UChar backepsilonSemicolonEntityName[] = {'b', 'a', 'c', 'k', 'e', 'p', 's', 'i', 'l', 'o', 'n', ';'};
static const UChar backprimeSemicolonEntityName[] = {'b', 'a', 'c', 'k', 'p', 'r', 'i', 'm', 'e', ';'};
static const UChar backsimSemicolonEntityName[] = {'b', 'a', 'c', 'k', 's', 'i', 'm', ';'};
static const UChar backsimeqSemicolonEntityName[] = {'b', 'a', 'c', 'k', 's', 'i', 'm', 'e', 'q', ';'};
static const UChar barveeSemicolonEntityName[] = {'b', 'a', 'r', 'v', 'e', 'e', ';'};
static const UChar barwedSemicolonEntityName[] = {'b', 'a', 'r', 'w', 'e', 'd', ';'};
static const UChar barwedgeSemicolonEntityName[] = {'b', 'a', 'r', 'w', 'e', 'd', 'g', 'e', ';'};
static const UChar bbrkSemicolonEntityName[] = {'b', 'b', 'r', 'k', ';'};
static const UChar bbrktbrkSemicolonEntityName[] = {'b', 'b', 'r', 'k', 't', 'b', 'r', 'k', ';'};
static const UChar bcongSemicolonEntityName[] = {'b', 'c', 'o', 'n', 'g', ';'};
static const UChar bcySemicolonEntityName[] = {'b', 'c', 'y', ';'};
static const UChar bdquoSemicolonEntityName[] = {'b', 'd', 'q', 'u', 'o', ';'};
static const UChar becausSemicolonEntityName[] = {'b', 'e', 'c', 'a', 'u', 's', ';'};
static const UChar becauseSemicolonEntityName[] = {'b', 'e', 'c', 'a', 'u', 's', 'e', ';'};
static const UChar bemptyvSemicolonEntityName[] = {'b', 'e', 'm', 'p', 't', 'y', 'v', ';'};
static const UChar bepsiSemicolonEntityName[] = {'b', 'e', 'p', 's', 'i', ';'};
static const UChar bernouSemicolonEntityName[] = {'b', 'e', 'r', 'n', 'o', 'u', ';'};
static const UChar betaSemicolonEntityName[] = {'b', 'e', 't', 'a', ';'};
static const UChar bethSemicolonEntityName[] = {'b', 'e', 't', 'h', ';'};
static const UChar betweenSemicolonEntityName[] = {'b', 'e', 't', 'w', 'e', 'e', 'n', ';'};
static const UChar bfrSemicolonEntityName[] = {'b', 'f', 'r', ';'};
static const UChar bigcapSemicolonEntityName[] = {'b', 'i', 'g', 'c', 'a', 'p', ';'};
static const UChar bigcircSemicolonEntityName[] = {'b', 'i', 'g', 'c', 'i', 'r', 'c', ';'};
static const UChar bigcupSemicolonEntityName[] = {'b', 'i', 'g', 'c', 'u', 'p', ';'};
static const UChar bigodotSemicolonEntityName[] = {'b', 'i', 'g', 'o', 'd', 'o', 't', ';'};
static const UChar bigoplusSemicolonEntityName[] = {'b', 'i', 'g', 'o', 'p', 'l', 'u', 's', ';'};
static const UChar bigotimesSemicolonEntityName[] = {'b', 'i', 'g', 'o', 't', 'i', 'm', 'e', 's', ';'};
static const UChar bigsqcupSemicolonEntityName[] = {'b', 'i', 'g', 's', 'q', 'c', 'u', 'p', ';'};
static const UChar bigstarSemicolonEntityName[] = {'b', 'i', 'g', 's', 't', 'a', 'r', ';'};
static const UChar bigtriangledownSemicolonEntityName[] = {'b', 'i', 'g', 't', 'r', 'i', 'a', 'n', 'g', 'l', 'e', 'd', 'o', 'w', 'n', ';'};
static const UChar bigtriangleupSemicolonEntityName[] = {'b', 'i', 'g', 't', 'r', 'i', 'a', 'n', 'g', 'l', 'e', 'u', 'p', ';'};
static const UChar biguplusSemicolonEntityName[] = {'b', 'i', 'g', 'u', 'p', 'l', 'u', 's', ';'};
static const UChar bigveeSemicolonEntityName[] = {'b', 'i', 'g', 'v', 'e', 'e', ';'};
static const UChar bigwedgeSemicolonEntityName[] = {'b', 'i', 'g', 'w', 'e', 'd', 'g', 'e', ';'};
static const UChar bkarowSemicolonEntityName[] = {'b', 'k', 'a', 'r', 'o', 'w', ';'};
static const UChar blacklozengeSemicolonEntityName[] = {'b', 'l', 'a', 'c', 'k', 'l', 'o', 'z', 'e', 'n', 'g', 'e', ';'};
static const UChar blacksquareSemicolonEntityName[] = {'b', 'l', 'a', 'c', 'k', 's', 'q', 'u', 'a', 'r', 'e', ';'};
static const UChar blacktriangleSemicolonEntityName[] = {'b', 'l', 'a', 'c', 'k', 't', 'r', 'i', 'a', 'n', 'g', 'l', 'e', ';'};
static const UChar blacktriangledownSemicolonEntityName[] = {'b', 'l', 'a', 'c', 'k', 't', 'r', 'i', 'a', 'n', 'g', 'l', 'e', 'd', 'o', 'w', 'n', ';'};
static const UChar blacktriangleleftSemicolonEntityName[] = {'b', 'l', 'a', 'c', 'k', 't', 'r', 'i', 'a', 'n', 'g', 'l', 'e', 'l', 'e', 'f', 't', ';'};
static const UChar blacktrianglerightSemicolonEntityName[] = {'b', 'l', 'a', 'c', 'k', 't', 'r', 'i', 'a', 'n', 'g', 'l', 'e', 'r', 'i', 'g', 'h', 't', ';'};
static const UChar blankSemicolonEntityName[] = {'b', 'l', 'a', 'n', 'k', ';'};
static const UChar blk12SemicolonEntityName[] = {'b', 'l', 'k', '1', '2', ';'};
static const UChar blk14SemicolonEntityName[] = {'b', 'l', 'k', '1', '4', ';'};
static const UChar blk34SemicolonEntityName[] = {'b', 'l', 'k', '3', '4', ';'};
static const UChar blockSemicolonEntityName[] = {'b', 'l', 'o', 'c', 'k', ';'};
static const UChar bnotSemicolonEntityName[] = {'b', 'n', 'o', 't', ';'};
static const UChar bopfSemicolonEntityName[] = {'b', 'o', 'p', 'f', ';'};
static const UChar botSemicolonEntityName[] = {'b', 'o', 't', ';'};
static const UChar bottomSemicolonEntityName[] = {'b', 'o', 't', 't', 'o', 'm', ';'};
static const UChar bowtieSemicolonEntityName[] = {'b', 'o', 'w', 't', 'i', 'e', ';'};
static const UChar boxDLSemicolonEntityName[] = {'b', 'o', 'x', 'D', 'L', ';'};
static const UChar boxDRSemicolonEntityName[] = {'b', 'o', 'x', 'D', 'R', ';'};
static const UChar boxDlSemicolonEntityName[] = {'b', 'o', 'x', 'D', 'l', ';'};
static const UChar boxDrSemicolonEntityName[] = {'b', 'o', 'x', 'D', 'r', ';'};
static const UChar boxHSemicolonEntityName[] = {'b', 'o', 'x', 'H', ';'};
static const UChar boxHDSemicolonEntityName[] = {'b', 'o', 'x', 'H', 'D', ';'};
static const UChar boxHUSemicolonEntityName[] = {'b', 'o', 'x', 'H', 'U', ';'};
static const UChar boxHdSemicolonEntityName[] = {'b', 'o', 'x', 'H', 'd', ';'};
static const UChar boxHuSemicolonEntityName[] = {'b', 'o', 'x', 'H', 'u', ';'};
static const UChar boxULSemicolonEntityName[] = {'b', 'o', 'x', 'U', 'L', ';'};
static const UChar boxURSemicolonEntityName[] = {'b', 'o', 'x', 'U', 'R', ';'};
static const UChar boxUlSemicolonEntityName[] = {'b', 'o', 'x', 'U', 'l', ';'};
static const UChar boxUrSemicolonEntityName[] = {'b', 'o', 'x', 'U', 'r', ';'};
static const UChar boxVSemicolonEntityName[] = {'b', 'o', 'x', 'V', ';'};
static const UChar boxVHSemicolonEntityName[] = {'b', 'o', 'x', 'V', 'H', ';'};
static const UChar boxVLSemicolonEntityName[] = {'b', 'o', 'x', 'V', 'L', ';'};
static const UChar boxVRSemicolonEntityName[] = {'b', 'o', 'x', 'V', 'R', ';'};
static const UChar boxVhSemicolonEntityName[] = {'b', 'o', 'x', 'V', 'h', ';'};
static const UChar boxVlSemicolonEntityName[] = {'b', 'o', 'x', 'V', 'l', ';'};
static const UChar boxVrSemicolonEntityName[] = {'b', 'o', 'x', 'V', 'r', ';'};
static const UChar boxboxSemicolonEntityName[] = {'b', 'o', 'x', 'b', 'o', 'x', ';'};
static const UChar boxdLSemicolonEntityName[] = {'b', 'o', 'x', 'd', 'L', ';'};
static const UChar boxdRSemicolonEntityName[] = {'b', 'o', 'x', 'd', 'R', ';'};
static const UChar boxdlSemicolonEntityName[] = {'b', 'o', 'x', 'd', 'l', ';'};
static const UChar boxdrSemicolonEntityName[] = {'b', 'o', 'x', 'd', 'r', ';'};
static const UChar boxhSemicolonEntityName[] = {'b', 'o', 'x', 'h', ';'};
static const UChar boxhDSemicolonEntityName[] = {'b', 'o', 'x', 'h', 'D', ';'};
static const UChar boxhUSemicolonEntityName[] = {'b', 'o', 'x', 'h', 'U', ';'};
static const UChar boxhdSemicolonEntityName[] = {'b', 'o', 'x', 'h', 'd', ';'};
static const UChar boxhuSemicolonEntityName[] = {'b', 'o', 'x', 'h', 'u', ';'};
static const UChar boxminusSemicolonEntityName[] = {'b', 'o', 'x', 'm', 'i', 'n', 'u', 's', ';'};
static const UChar boxplusSemicolonEntityName[] = {'b', 'o', 'x', 'p', 'l', 'u', 's', ';'};
static const UChar boxtimesSemicolonEntityName[] = {'b', 'o', 'x', 't', 'i', 'm', 'e', 's', ';'};
static const UChar boxuLSemicolonEntityName[] = {'b', 'o', 'x', 'u', 'L', ';'};
static const UChar boxuRSemicolonEntityName[] = {'b', 'o', 'x', 'u', 'R', ';'};
static const UChar boxulSemicolonEntityName[] = {'b', 'o', 'x', 'u', 'l', ';'};
static const UChar boxurSemicolonEntityName[] = {'b', 'o', 'x', 'u', 'r', ';'};
static const UChar boxvSemicolonEntityName[] = {'b', 'o', 'x', 'v', ';'};
static const UChar boxvHSemicolonEntityName[] = {'b', 'o', 'x', 'v', 'H', ';'};
static const UChar boxvLSemicolonEntityName[] = {'b', 'o', 'x', 'v', 'L', ';'};
static const UChar boxvRSemicolonEntityName[] = {'b', 'o', 'x', 'v', 'R', ';'};
static const UChar boxvhSemicolonEntityName[] = {'b', 'o', 'x', 'v', 'h', ';'};
static const UChar boxvlSemicolonEntityName[] = {'b', 'o', 'x', 'v', 'l', ';'};
static const UChar boxvrSemicolonEntityName[] = {'b', 'o', 'x', 'v', 'r', ';'};
static const UChar bprimeSemicolonEntityName[] = {'b', 'p', 'r', 'i', 'm', 'e', ';'};
static const UChar breveSemicolonEntityName[] = {'b', 'r', 'e', 'v', 'e', ';'};
static const UChar brvbarEntityName[] = {'b', 'r', 'v', 'b', 'a', 'r'};
static const UChar brvbarSemicolonEntityName[] = {'b', 'r', 'v', 'b', 'a', 'r', ';'};
static const UChar bscrSemicolonEntityName[] = {'b', 's', 'c', 'r', ';'};
static const UChar bsemiSemicolonEntityName[] = {'b', 's', 'e', 'm', 'i', ';'};
static const UChar bsimSemicolonEntityName[] = {'b', 's', 'i', 'm', ';'};
static const UChar bsimeSemicolonEntityName[] = {'b', 's', 'i', 'm', 'e', ';'};
static const UChar bsolSemicolonEntityName[] = {'b', 's', 'o', 'l', ';'};
static const UChar bsolbSemicolonEntityName[] = {'b', 's', 'o', 'l', 'b', ';'};
static const UChar bsolhsubSemicolonEntityName[] = {'b', 's', 'o', 'l', 'h', 's', 'u', 'b', ';'};
static const UChar bullSemicolonEntityName[] = {'b', 'u', 'l', 'l', ';'};
static const UChar bulletSemicolonEntityName[] = {'b', 'u', 'l', 'l', 'e', 't', ';'};
static const UChar bumpSemicolonEntityName[] = {'b', 'u', 'm', 'p', ';'};
static const UChar bumpESemicolonEntityName[] = {'b', 'u', 'm', 'p', 'E', ';'};
static const UChar bumpeSemicolonEntityName[] = {'b', 'u', 'm', 'p', 'e', ';'};
static const UChar bumpeqSemicolonEntityName[] = {'b', 'u', 'm', 'p', 'e', 'q', ';'};
static const UChar cacuteSemicolonEntityName[] = {'c', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar capSemicolonEntityName[] = {'c', 'a', 'p', ';'};
static const UChar capandSemicolonEntityName[] = {'c', 'a', 'p', 'a', 'n', 'd', ';'};
static const UChar capbrcupSemicolonEntityName[] = {'c', 'a', 'p', 'b', 'r', 'c', 'u', 'p', ';'};
static const UChar capcapSemicolonEntityName[] = {'c', 'a', 'p', 'c', 'a', 'p', ';'};
static const UChar capcupSemicolonEntityName[] = {'c', 'a', 'p', 'c', 'u', 'p', ';'};
static const UChar capdotSemicolonEntityName[] = {'c', 'a', 'p', 'd', 'o', 't', ';'};
static const UChar caretSemicolonEntityName[] = {'c', 'a', 'r', 'e', 't', ';'};
static const UChar caronSemicolonEntityName[] = {'c', 'a', 'r', 'o', 'n', ';'};
static const UChar ccapsSemicolonEntityName[] = {'c', 'c', 'a', 'p', 's', ';'};
static const UChar ccaronSemicolonEntityName[] = {'c', 'c', 'a', 'r', 'o', 'n', ';'};
static const UChar ccedilEntityName[] = {'c', 'c', 'e', 'd', 'i', 'l'};
static const UChar ccedilSemicolonEntityName[] = {'c', 'c', 'e', 'd', 'i', 'l', ';'};
static const UChar ccircSemicolonEntityName[] = {'c', 'c', 'i', 'r', 'c', ';'};
static const UChar ccupsSemicolonEntityName[] = {'c', 'c', 'u', 'p', 's', ';'};
static const UChar ccupssmSemicolonEntityName[] = {'c', 'c', 'u', 'p', 's', 's', 'm', ';'};
static const UChar cdotSemicolonEntityName[] = {'c', 'd', 'o', 't', ';'};
static const UChar cedilEntityName[] = {'c', 'e', 'd', 'i', 'l'};
static const UChar cedilSemicolonEntityName[] = {'c', 'e', 'd', 'i', 'l', ';'};
static const UChar cemptyvSemicolonEntityName[] = {'c', 'e', 'm', 'p', 't', 'y', 'v', ';'};
static const UChar centEntityName[] = {'c', 'e', 'n', 't'};
static const UChar centSemicolonEntityName[] = {'c', 'e', 'n', 't', ';'};
static const UChar centerdotSemicolonEntityName[] = {'c', 'e', 'n', 't', 'e', 'r', 'd', 'o', 't', ';'};
static const UChar cfrSemicolonEntityName[] = {'c', 'f', 'r', ';'};
static const UChar chcySemicolonEntityName[] = {'c', 'h', 'c', 'y', ';'};
static const UChar checkSemicolonEntityName[] = {'c', 'h', 'e', 'c', 'k', ';'};
static const UChar checkmarkSemicolonEntityName[] = {'c', 'h', 'e', 'c', 'k', 'm', 'a', 'r', 'k', ';'};
static const UChar chiSemicolonEntityName[] = {'c', 'h', 'i', ';'};
static const UChar cirSemicolonEntityName[] = {'c', 'i', 'r', ';'};
static const UChar cirESemicolonEntityName[] = {'c', 'i', 'r', 'E', ';'};
static const UChar circSemicolonEntityName[] = {'c', 'i', 'r', 'c', ';'};
static const UChar circeqSemicolonEntityName[] = {'c', 'i', 'r', 'c', 'e', 'q', ';'};
static const UChar circlearrowleftSemicolonEntityName[] = {'c', 'i', 'r', 'c', 'l', 'e', 'a', 'r', 'r', 'o', 'w', 'l', 'e', 'f', 't', ';'};
static const UChar circlearrowrightSemicolonEntityName[] = {'c', 'i', 'r', 'c', 'l', 'e', 'a', 'r', 'r', 'o', 'w', 'r', 'i', 'g', 'h', 't', ';'};
static const UChar circledRSemicolonEntityName[] = {'c', 'i', 'r', 'c', 'l', 'e', 'd', 'R', ';'};
static const UChar circledSSemicolonEntityName[] = {'c', 'i', 'r', 'c', 'l', 'e', 'd', 'S', ';'};
static const UChar circledastSemicolonEntityName[] = {'c', 'i', 'r', 'c', 'l', 'e', 'd', 'a', 's', 't', ';'};
static const UChar circledcircSemicolonEntityName[] = {'c', 'i', 'r', 'c', 'l', 'e', 'd', 'c', 'i', 'r', 'c', ';'};
static const UChar circleddashSemicolonEntityName[] = {'c', 'i', 'r', 'c', 'l', 'e', 'd', 'd', 'a', 's', 'h', ';'};
static const UChar cireSemicolonEntityName[] = {'c', 'i', 'r', 'e', ';'};
static const UChar cirfnintSemicolonEntityName[] = {'c', 'i', 'r', 'f', 'n', 'i', 'n', 't', ';'};
static const UChar cirmidSemicolonEntityName[] = {'c', 'i', 'r', 'm', 'i', 'd', ';'};
static const UChar cirscirSemicolonEntityName[] = {'c', 'i', 'r', 's', 'c', 'i', 'r', ';'};
static const UChar clubsSemicolonEntityName[] = {'c', 'l', 'u', 'b', 's', ';'};
static const UChar clubsuitSemicolonEntityName[] = {'c', 'l', 'u', 'b', 's', 'u', 'i', 't', ';'};
static const UChar colonSemicolonEntityName[] = {'c', 'o', 'l', 'o', 'n', ';'};
static const UChar coloneSemicolonEntityName[] = {'c', 'o', 'l', 'o', 'n', 'e', ';'};
static const UChar coloneqSemicolonEntityName[] = {'c', 'o', 'l', 'o', 'n', 'e', 'q', ';'};
static const UChar commaSemicolonEntityName[] = {'c', 'o', 'm', 'm', 'a', ';'};
static const UChar commatSemicolonEntityName[] = {'c', 'o', 'm', 'm', 'a', 't', ';'};
static const UChar compSemicolonEntityName[] = {'c', 'o', 'm', 'p', ';'};
static const UChar compfnSemicolonEntityName[] = {'c', 'o', 'm', 'p', 'f', 'n', ';'};
static const UChar complementSemicolonEntityName[] = {'c', 'o', 'm', 'p', 'l', 'e', 'm', 'e', 'n', 't', ';'};
static const UChar complexesSemicolonEntityName[] = {'c', 'o', 'm', 'p', 'l', 'e', 'x', 'e', 's', ';'};
static const UChar congSemicolonEntityName[] = {'c', 'o', 'n', 'g', ';'};
static const UChar congdotSemicolonEntityName[] = {'c', 'o', 'n', 'g', 'd', 'o', 't', ';'};
static const UChar conintSemicolonEntityName[] = {'c', 'o', 'n', 'i', 'n', 't', ';'};
static const UChar copfSemicolonEntityName[] = {'c', 'o', 'p', 'f', ';'};
static const UChar coprodSemicolonEntityName[] = {'c', 'o', 'p', 'r', 'o', 'd', ';'};
static const UChar copyEntityName[] = {'c', 'o', 'p', 'y'};
static const UChar copySemicolonEntityName[] = {'c', 'o', 'p', 'y', ';'};
static const UChar copysrSemicolonEntityName[] = {'c', 'o', 'p', 'y', 's', 'r', ';'};
static const UChar crarrSemicolonEntityName[] = {'c', 'r', 'a', 'r', 'r', ';'};
static const UChar crossSemicolonEntityName[] = {'c', 'r', 'o', 's', 's', ';'};
static const UChar cscrSemicolonEntityName[] = {'c', 's', 'c', 'r', ';'};
static const UChar csubSemicolonEntityName[] = {'c', 's', 'u', 'b', ';'};
static const UChar csubeSemicolonEntityName[] = {'c', 's', 'u', 'b', 'e', ';'};
static const UChar csupSemicolonEntityName[] = {'c', 's', 'u', 'p', ';'};
static const UChar csupeSemicolonEntityName[] = {'c', 's', 'u', 'p', 'e', ';'};
static const UChar ctdotSemicolonEntityName[] = {'c', 't', 'd', 'o', 't', ';'};
static const UChar cudarrlSemicolonEntityName[] = {'c', 'u', 'd', 'a', 'r', 'r', 'l', ';'};
static const UChar cudarrrSemicolonEntityName[] = {'c', 'u', 'd', 'a', 'r', 'r', 'r', ';'};
static const UChar cueprSemicolonEntityName[] = {'c', 'u', 'e', 'p', 'r', ';'};
static const UChar cuescSemicolonEntityName[] = {'c', 'u', 'e', 's', 'c', ';'};
static const UChar cularrSemicolonEntityName[] = {'c', 'u', 'l', 'a', 'r', 'r', ';'};
static const UChar cularrpSemicolonEntityName[] = {'c', 'u', 'l', 'a', 'r', 'r', 'p', ';'};
static const UChar cupSemicolonEntityName[] = {'c', 'u', 'p', ';'};
static const UChar cupbrcapSemicolonEntityName[] = {'c', 'u', 'p', 'b', 'r', 'c', 'a', 'p', ';'};
static const UChar cupcapSemicolonEntityName[] = {'c', 'u', 'p', 'c', 'a', 'p', ';'};
static const UChar cupcupSemicolonEntityName[] = {'c', 'u', 'p', 'c', 'u', 'p', ';'};
static const UChar cupdotSemicolonEntityName[] = {'c', 'u', 'p', 'd', 'o', 't', ';'};
static const UChar cuporSemicolonEntityName[] = {'c', 'u', 'p', 'o', 'r', ';'};
static const UChar curarrSemicolonEntityName[] = {'c', 'u', 'r', 'a', 'r', 'r', ';'};
static const UChar curarrmSemicolonEntityName[] = {'c', 'u', 'r', 'a', 'r', 'r', 'm', ';'};
static const UChar curlyeqprecSemicolonEntityName[] = {'c', 'u', 'r', 'l', 'y', 'e', 'q', 'p', 'r', 'e', 'c', ';'};
static const UChar curlyeqsuccSemicolonEntityName[] = {'c', 'u', 'r', 'l', 'y', 'e', 'q', 's', 'u', 'c', 'c', ';'};
static const UChar curlyveeSemicolonEntityName[] = {'c', 'u', 'r', 'l', 'y', 'v', 'e', 'e', ';'};
static const UChar curlywedgeSemicolonEntityName[] = {'c', 'u', 'r', 'l', 'y', 'w', 'e', 'd', 'g', 'e', ';'};
static const UChar currenEntityName[] = {'c', 'u', 'r', 'r', 'e', 'n'};
static const UChar currenSemicolonEntityName[] = {'c', 'u', 'r', 'r', 'e', 'n', ';'};
static const UChar curvearrowleftSemicolonEntityName[] = {'c', 'u', 'r', 'v', 'e', 'a', 'r', 'r', 'o', 'w', 'l', 'e', 'f', 't', ';'};
static const UChar curvearrowrightSemicolonEntityName[] = {'c', 'u', 'r', 'v', 'e', 'a', 'r', 'r', 'o', 'w', 'r', 'i', 'g', 'h', 't', ';'};
static const UChar cuveeSemicolonEntityName[] = {'c', 'u', 'v', 'e', 'e', ';'};
static const UChar cuwedSemicolonEntityName[] = {'c', 'u', 'w', 'e', 'd', ';'};
static const UChar cwconintSemicolonEntityName[] = {'c', 'w', 'c', 'o', 'n', 'i', 'n', 't', ';'};
static const UChar cwintSemicolonEntityName[] = {'c', 'w', 'i', 'n', 't', ';'};
static const UChar cylctySemicolonEntityName[] = {'c', 'y', 'l', 'c', 't', 'y', ';'};
static const UChar dArrSemicolonEntityName[] = {'d', 'A', 'r', 'r', ';'};
static const UChar dHarSemicolonEntityName[] = {'d', 'H', 'a', 'r', ';'};
static const UChar daggerSemicolonEntityName[] = {'d', 'a', 'g', 'g', 'e', 'r', ';'};
static const UChar dalethSemicolonEntityName[] = {'d', 'a', 'l', 'e', 't', 'h', ';'};
static const UChar darrSemicolonEntityName[] = {'d', 'a', 'r', 'r', ';'};
static const UChar dashSemicolonEntityName[] = {'d', 'a', 's', 'h', ';'};
static const UChar dashvSemicolonEntityName[] = {'d', 'a', 's', 'h', 'v', ';'};
static const UChar dbkarowSemicolonEntityName[] = {'d', 'b', 'k', 'a', 'r', 'o', 'w', ';'};
static const UChar dblacSemicolonEntityName[] = {'d', 'b', 'l', 'a', 'c', ';'};
static const UChar dcaronSemicolonEntityName[] = {'d', 'c', 'a', 'r', 'o', 'n', ';'};
static const UChar dcySemicolonEntityName[] = {'d', 'c', 'y', ';'};
static const UChar ddSemicolonEntityName[] = {'d', 'd', ';'};
static const UChar ddaggerSemicolonEntityName[] = {'d', 'd', 'a', 'g', 'g', 'e', 'r', ';'};
static const UChar ddarrSemicolonEntityName[] = {'d', 'd', 'a', 'r', 'r', ';'};
static const UChar ddotseqSemicolonEntityName[] = {'d', 'd', 'o', 't', 's', 'e', 'q', ';'};
static const UChar degEntityName[] = {'d', 'e', 'g'};
static const UChar degSemicolonEntityName[] = {'d', 'e', 'g', ';'};
static const UChar deltaSemicolonEntityName[] = {'d', 'e', 'l', 't', 'a', ';'};
static const UChar demptyvSemicolonEntityName[] = {'d', 'e', 'm', 'p', 't', 'y', 'v', ';'};
static const UChar dfishtSemicolonEntityName[] = {'d', 'f', 'i', 's', 'h', 't', ';'};
static const UChar dfrSemicolonEntityName[] = {'d', 'f', 'r', ';'};
static const UChar dharlSemicolonEntityName[] = {'d', 'h', 'a', 'r', 'l', ';'};
static const UChar dharrSemicolonEntityName[] = {'d', 'h', 'a', 'r', 'r', ';'};
static const UChar diamSemicolonEntityName[] = {'d', 'i', 'a', 'm', ';'};
static const UChar diamondSemicolonEntityName[] = {'d', 'i', 'a', 'm', 'o', 'n', 'd', ';'};
static const UChar diamondsuitSemicolonEntityName[] = {'d', 'i', 'a', 'm', 'o', 'n', 'd', 's', 'u', 'i', 't', ';'};
static const UChar diamsSemicolonEntityName[] = {'d', 'i', 'a', 'm', 's', ';'};
static const UChar dieSemicolonEntityName[] = {'d', 'i', 'e', ';'};
static const UChar digammaSemicolonEntityName[] = {'d', 'i', 'g', 'a', 'm', 'm', 'a', ';'};
static const UChar disinSemicolonEntityName[] = {'d', 'i', 's', 'i', 'n', ';'};
static const UChar divSemicolonEntityName[] = {'d', 'i', 'v', ';'};
static const UChar divideEntityName[] = {'d', 'i', 'v', 'i', 'd', 'e'};
static const UChar divideSemicolonEntityName[] = {'d', 'i', 'v', 'i', 'd', 'e', ';'};
static const UChar divideontimesSemicolonEntityName[] = {'d', 'i', 'v', 'i', 'd', 'e', 'o', 'n', 't', 'i', 'm', 'e', 's', ';'};
static const UChar divonxSemicolonEntityName[] = {'d', 'i', 'v', 'o', 'n', 'x', ';'};
static const UChar djcySemicolonEntityName[] = {'d', 'j', 'c', 'y', ';'};
static const UChar dlcornSemicolonEntityName[] = {'d', 'l', 'c', 'o', 'r', 'n', ';'};
static const UChar dlcropSemicolonEntityName[] = {'d', 'l', 'c', 'r', 'o', 'p', ';'};
static const UChar dollarSemicolonEntityName[] = {'d', 'o', 'l', 'l', 'a', 'r', ';'};
static const UChar dopfSemicolonEntityName[] = {'d', 'o', 'p', 'f', ';'};
static const UChar dotSemicolonEntityName[] = {'d', 'o', 't', ';'};
static const UChar doteqSemicolonEntityName[] = {'d', 'o', 't', 'e', 'q', ';'};
static const UChar doteqdotSemicolonEntityName[] = {'d', 'o', 't', 'e', 'q', 'd', 'o', 't', ';'};
static const UChar dotminusSemicolonEntityName[] = {'d', 'o', 't', 'm', 'i', 'n', 'u', 's', ';'};
static const UChar dotplusSemicolonEntityName[] = {'d', 'o', 't', 'p', 'l', 'u', 's', ';'};
static const UChar dotsquareSemicolonEntityName[] = {'d', 'o', 't', 's', 'q', 'u', 'a', 'r', 'e', ';'};
static const UChar doublebarwedgeSemicolonEntityName[] = {'d', 'o', 'u', 'b', 'l', 'e', 'b', 'a', 'r', 'w', 'e', 'd', 'g', 'e', ';'};
static const UChar downarrowSemicolonEntityName[] = {'d', 'o', 'w', 'n', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar downdownarrowsSemicolonEntityName[] = {'d', 'o', 'w', 'n', 'd', 'o', 'w', 'n', 'a', 'r', 'r', 'o', 'w', 's', ';'};
static const UChar downharpoonleftSemicolonEntityName[] = {'d', 'o', 'w', 'n', 'h', 'a', 'r', 'p', 'o', 'o', 'n', 'l', 'e', 'f', 't', ';'};
static const UChar downharpoonrightSemicolonEntityName[] = {'d', 'o', 'w', 'n', 'h', 'a', 'r', 'p', 'o', 'o', 'n', 'r', 'i', 'g', 'h', 't', ';'};
static const UChar drbkarowSemicolonEntityName[] = {'d', 'r', 'b', 'k', 'a', 'r', 'o', 'w', ';'};
static const UChar drcornSemicolonEntityName[] = {'d', 'r', 'c', 'o', 'r', 'n', ';'};
static const UChar drcropSemicolonEntityName[] = {'d', 'r', 'c', 'r', 'o', 'p', ';'};
static const UChar dscrSemicolonEntityName[] = {'d', 's', 'c', 'r', ';'};
static const UChar dscySemicolonEntityName[] = {'d', 's', 'c', 'y', ';'};
static const UChar dsolSemicolonEntityName[] = {'d', 's', 'o', 'l', ';'};
static const UChar dstrokSemicolonEntityName[] = {'d', 's', 't', 'r', 'o', 'k', ';'};
static const UChar dtdotSemicolonEntityName[] = {'d', 't', 'd', 'o', 't', ';'};
static const UChar dtriSemicolonEntityName[] = {'d', 't', 'r', 'i', ';'};
static const UChar dtrifSemicolonEntityName[] = {'d', 't', 'r', 'i', 'f', ';'};
static const UChar duarrSemicolonEntityName[] = {'d', 'u', 'a', 'r', 'r', ';'};
static const UChar duharSemicolonEntityName[] = {'d', 'u', 'h', 'a', 'r', ';'};
static const UChar dwangleSemicolonEntityName[] = {'d', 'w', 'a', 'n', 'g', 'l', 'e', ';'};
static const UChar dzcySemicolonEntityName[] = {'d', 'z', 'c', 'y', ';'};
static const UChar dzigrarrSemicolonEntityName[] = {'d', 'z', 'i', 'g', 'r', 'a', 'r', 'r', ';'};
static const UChar eDDotSemicolonEntityName[] = {'e', 'D', 'D', 'o', 't', ';'};
static const UChar eDotSemicolonEntityName[] = {'e', 'D', 'o', 't', ';'};
static const UChar eacuteEntityName[] = {'e', 'a', 'c', 'u', 't', 'e'};
static const UChar eacuteSemicolonEntityName[] = {'e', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar easterSemicolonEntityName[] = {'e', 'a', 's', 't', 'e', 'r', ';'};
static const UChar ecaronSemicolonEntityName[] = {'e', 'c', 'a', 'r', 'o', 'n', ';'};
static const UChar ecirSemicolonEntityName[] = {'e', 'c', 'i', 'r', ';'};
static const UChar ecircEntityName[] = {'e', 'c', 'i', 'r', 'c'};
static const UChar ecircSemicolonEntityName[] = {'e', 'c', 'i', 'r', 'c', ';'};
static const UChar ecolonSemicolonEntityName[] = {'e', 'c', 'o', 'l', 'o', 'n', ';'};
static const UChar ecySemicolonEntityName[] = {'e', 'c', 'y', ';'};
static const UChar edotSemicolonEntityName[] = {'e', 'd', 'o', 't', ';'};
static const UChar eeSemicolonEntityName[] = {'e', 'e', ';'};
static const UChar efDotSemicolonEntityName[] = {'e', 'f', 'D', 'o', 't', ';'};
static const UChar efrSemicolonEntityName[] = {'e', 'f', 'r', ';'};
static const UChar egSemicolonEntityName[] = {'e', 'g', ';'};
static const UChar egraveEntityName[] = {'e', 'g', 'r', 'a', 'v', 'e'};
static const UChar egraveSemicolonEntityName[] = {'e', 'g', 'r', 'a', 'v', 'e', ';'};
static const UChar egsSemicolonEntityName[] = {'e', 'g', 's', ';'};
static const UChar egsdotSemicolonEntityName[] = {'e', 'g', 's', 'd', 'o', 't', ';'};
static const UChar elSemicolonEntityName[] = {'e', 'l', ';'};
static const UChar elintersSemicolonEntityName[] = {'e', 'l', 'i', 'n', 't', 'e', 'r', 's', ';'};
static const UChar ellSemicolonEntityName[] = {'e', 'l', 'l', ';'};
static const UChar elsSemicolonEntityName[] = {'e', 'l', 's', ';'};
static const UChar elsdotSemicolonEntityName[] = {'e', 'l', 's', 'd', 'o', 't', ';'};
static const UChar emacrSemicolonEntityName[] = {'e', 'm', 'a', 'c', 'r', ';'};
static const UChar emptySemicolonEntityName[] = {'e', 'm', 'p', 't', 'y', ';'};
static const UChar emptysetSemicolonEntityName[] = {'e', 'm', 'p', 't', 'y', 's', 'e', 't', ';'};
static const UChar emptyvSemicolonEntityName[] = {'e', 'm', 'p', 't', 'y', 'v', ';'};
static const UChar emsp13SemicolonEntityName[] = {'e', 'm', 's', 'p', '1', '3', ';'};
static const UChar emsp14SemicolonEntityName[] = {'e', 'm', 's', 'p', '1', '4', ';'};
static const UChar emspSemicolonEntityName[] = {'e', 'm', 's', 'p', ';'};
static const UChar engSemicolonEntityName[] = {'e', 'n', 'g', ';'};
static const UChar enspSemicolonEntityName[] = {'e', 'n', 's', 'p', ';'};
static const UChar eogonSemicolonEntityName[] = {'e', 'o', 'g', 'o', 'n', ';'};
static const UChar eopfSemicolonEntityName[] = {'e', 'o', 'p', 'f', ';'};
static const UChar eparSemicolonEntityName[] = {'e', 'p', 'a', 'r', ';'};
static const UChar eparslSemicolonEntityName[] = {'e', 'p', 'a', 'r', 's', 'l', ';'};
static const UChar eplusSemicolonEntityName[] = {'e', 'p', 'l', 'u', 's', ';'};
static const UChar epsiSemicolonEntityName[] = {'e', 'p', 's', 'i', ';'};
static const UChar epsilonSemicolonEntityName[] = {'e', 'p', 's', 'i', 'l', 'o', 'n', ';'};
static const UChar epsivSemicolonEntityName[] = {'e', 'p', 's', 'i', 'v', ';'};
static const UChar eqcircSemicolonEntityName[] = {'e', 'q', 'c', 'i', 'r', 'c', ';'};
static const UChar eqcolonSemicolonEntityName[] = {'e', 'q', 'c', 'o', 'l', 'o', 'n', ';'};
static const UChar eqsimSemicolonEntityName[] = {'e', 'q', 's', 'i', 'm', ';'};
static const UChar eqslantgtrSemicolonEntityName[] = {'e', 'q', 's', 'l', 'a', 'n', 't', 'g', 't', 'r', ';'};
static const UChar eqslantlessSemicolonEntityName[] = {'e', 'q', 's', 'l', 'a', 'n', 't', 'l', 'e', 's', 's', ';'};
static const UChar equalsSemicolonEntityName[] = {'e', 'q', 'u', 'a', 'l', 's', ';'};
static const UChar equestSemicolonEntityName[] = {'e', 'q', 'u', 'e', 's', 't', ';'};
static const UChar equivSemicolonEntityName[] = {'e', 'q', 'u', 'i', 'v', ';'};
static const UChar equivDDSemicolonEntityName[] = {'e', 'q', 'u', 'i', 'v', 'D', 'D', ';'};
static const UChar eqvparslSemicolonEntityName[] = {'e', 'q', 'v', 'p', 'a', 'r', 's', 'l', ';'};
static const UChar erDotSemicolonEntityName[] = {'e', 'r', 'D', 'o', 't', ';'};
static const UChar erarrSemicolonEntityName[] = {'e', 'r', 'a', 'r', 'r', ';'};
static const UChar escrSemicolonEntityName[] = {'e', 's', 'c', 'r', ';'};
static const UChar esdotSemicolonEntityName[] = {'e', 's', 'd', 'o', 't', ';'};
static const UChar esimSemicolonEntityName[] = {'e', 's', 'i', 'm', ';'};
static const UChar etaSemicolonEntityName[] = {'e', 't', 'a', ';'};
static const UChar ethEntityName[] = {'e', 't', 'h'};
static const UChar ethSemicolonEntityName[] = {'e', 't', 'h', ';'};
static const UChar eumlEntityName[] = {'e', 'u', 'm', 'l'};
static const UChar eumlSemicolonEntityName[] = {'e', 'u', 'm', 'l', ';'};
static const UChar euroSemicolonEntityName[] = {'e', 'u', 'r', 'o', ';'};
static const UChar exclSemicolonEntityName[] = {'e', 'x', 'c', 'l', ';'};
static const UChar existSemicolonEntityName[] = {'e', 'x', 'i', 's', 't', ';'};
static const UChar expectationSemicolonEntityName[] = {'e', 'x', 'p', 'e', 'c', 't', 'a', 't', 'i', 'o', 'n', ';'};
static const UChar exponentialeSemicolonEntityName[] = {'e', 'x', 'p', 'o', 'n', 'e', 'n', 't', 'i', 'a', 'l', 'e', ';'};
static const UChar fallingdotseqSemicolonEntityName[] = {'f', 'a', 'l', 'l', 'i', 'n', 'g', 'd', 'o', 't', 's', 'e', 'q', ';'};
static const UChar fcySemicolonEntityName[] = {'f', 'c', 'y', ';'};
static const UChar femaleSemicolonEntityName[] = {'f', 'e', 'm', 'a', 'l', 'e', ';'};
static const UChar ffiligSemicolonEntityName[] = {'f', 'f', 'i', 'l', 'i', 'g', ';'};
static const UChar ffligSemicolonEntityName[] = {'f', 'f', 'l', 'i', 'g', ';'};
static const UChar fflligSemicolonEntityName[] = {'f', 'f', 'l', 'l', 'i', 'g', ';'};
static const UChar ffrSemicolonEntityName[] = {'f', 'f', 'r', ';'};
static const UChar filigSemicolonEntityName[] = {'f', 'i', 'l', 'i', 'g', ';'};
static const UChar flatSemicolonEntityName[] = {'f', 'l', 'a', 't', ';'};
static const UChar flligSemicolonEntityName[] = {'f', 'l', 'l', 'i', 'g', ';'};
static const UChar fltnsSemicolonEntityName[] = {'f', 'l', 't', 'n', 's', ';'};
static const UChar fnofSemicolonEntityName[] = {'f', 'n', 'o', 'f', ';'};
static const UChar fopfSemicolonEntityName[] = {'f', 'o', 'p', 'f', ';'};
static const UChar forallSemicolonEntityName[] = {'f', 'o', 'r', 'a', 'l', 'l', ';'};
static const UChar forkSemicolonEntityName[] = {'f', 'o', 'r', 'k', ';'};
static const UChar forkvSemicolonEntityName[] = {'f', 'o', 'r', 'k', 'v', ';'};
static const UChar fpartintSemicolonEntityName[] = {'f', 'p', 'a', 'r', 't', 'i', 'n', 't', ';'};
static const UChar frac12EntityName[] = {'f', 'r', 'a', 'c', '1', '2'};
static const UChar frac12SemicolonEntityName[] = {'f', 'r', 'a', 'c', '1', '2', ';'};
static const UChar frac13SemicolonEntityName[] = {'f', 'r', 'a', 'c', '1', '3', ';'};
static const UChar frac14EntityName[] = {'f', 'r', 'a', 'c', '1', '4'};
static const UChar frac14SemicolonEntityName[] = {'f', 'r', 'a', 'c', '1', '4', ';'};
static const UChar frac15SemicolonEntityName[] = {'f', 'r', 'a', 'c', '1', '5', ';'};
static const UChar frac16SemicolonEntityName[] = {'f', 'r', 'a', 'c', '1', '6', ';'};
static const UChar frac18SemicolonEntityName[] = {'f', 'r', 'a', 'c', '1', '8', ';'};
static const UChar frac23SemicolonEntityName[] = {'f', 'r', 'a', 'c', '2', '3', ';'};
static const UChar frac25SemicolonEntityName[] = {'f', 'r', 'a', 'c', '2', '5', ';'};
static const UChar frac34EntityName[] = {'f', 'r', 'a', 'c', '3', '4'};
static const UChar frac34SemicolonEntityName[] = {'f', 'r', 'a', 'c', '3', '4', ';'};
static const UChar frac35SemicolonEntityName[] = {'f', 'r', 'a', 'c', '3', '5', ';'};
static const UChar frac38SemicolonEntityName[] = {'f', 'r', 'a', 'c', '3', '8', ';'};
static const UChar frac45SemicolonEntityName[] = {'f', 'r', 'a', 'c', '4', '5', ';'};
static const UChar frac56SemicolonEntityName[] = {'f', 'r', 'a', 'c', '5', '6', ';'};
static const UChar frac58SemicolonEntityName[] = {'f', 'r', 'a', 'c', '5', '8', ';'};
static const UChar frac78SemicolonEntityName[] = {'f', 'r', 'a', 'c', '7', '8', ';'};
static const UChar fraslSemicolonEntityName[] = {'f', 'r', 'a', 's', 'l', ';'};
static const UChar frownSemicolonEntityName[] = {'f', 'r', 'o', 'w', 'n', ';'};
static const UChar fscrSemicolonEntityName[] = {'f', 's', 'c', 'r', ';'};
static const UChar gESemicolonEntityName[] = {'g', 'E', ';'};
static const UChar gElSemicolonEntityName[] = {'g', 'E', 'l', ';'};
static const UChar gacuteSemicolonEntityName[] = {'g', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar gammaSemicolonEntityName[] = {'g', 'a', 'm', 'm', 'a', ';'};
static const UChar gammadSemicolonEntityName[] = {'g', 'a', 'm', 'm', 'a', 'd', ';'};
static const UChar gapSemicolonEntityName[] = {'g', 'a', 'p', ';'};
static const UChar gbreveSemicolonEntityName[] = {'g', 'b', 'r', 'e', 'v', 'e', ';'};
static const UChar gcircSemicolonEntityName[] = {'g', 'c', 'i', 'r', 'c', ';'};
static const UChar gcySemicolonEntityName[] = {'g', 'c', 'y', ';'};
static const UChar gdotSemicolonEntityName[] = {'g', 'd', 'o', 't', ';'};
static const UChar geSemicolonEntityName[] = {'g', 'e', ';'};
static const UChar gelSemicolonEntityName[] = {'g', 'e', 'l', ';'};
static const UChar geqSemicolonEntityName[] = {'g', 'e', 'q', ';'};
static const UChar geqqSemicolonEntityName[] = {'g', 'e', 'q', 'q', ';'};
static const UChar geqslantSemicolonEntityName[] = {'g', 'e', 'q', 's', 'l', 'a', 'n', 't', ';'};
static const UChar gesSemicolonEntityName[] = {'g', 'e', 's', ';'};
static const UChar gesccSemicolonEntityName[] = {'g', 'e', 's', 'c', 'c', ';'};
static const UChar gesdotSemicolonEntityName[] = {'g', 'e', 's', 'd', 'o', 't', ';'};
static const UChar gesdotoSemicolonEntityName[] = {'g', 'e', 's', 'd', 'o', 't', 'o', ';'};
static const UChar gesdotolSemicolonEntityName[] = {'g', 'e', 's', 'd', 'o', 't', 'o', 'l', ';'};
static const UChar geslesSemicolonEntityName[] = {'g', 'e', 's', 'l', 'e', 's', ';'};
static const UChar gfrSemicolonEntityName[] = {'g', 'f', 'r', ';'};
static const UChar ggSemicolonEntityName[] = {'g', 'g', ';'};
static const UChar gggSemicolonEntityName[] = {'g', 'g', 'g', ';'};
static const UChar gimelSemicolonEntityName[] = {'g', 'i', 'm', 'e', 'l', ';'};
static const UChar gjcySemicolonEntityName[] = {'g', 'j', 'c', 'y', ';'};
static const UChar glSemicolonEntityName[] = {'g', 'l', ';'};
static const UChar glESemicolonEntityName[] = {'g', 'l', 'E', ';'};
static const UChar glaSemicolonEntityName[] = {'g', 'l', 'a', ';'};
static const UChar gljSemicolonEntityName[] = {'g', 'l', 'j', ';'};
static const UChar gnESemicolonEntityName[] = {'g', 'n', 'E', ';'};
static const UChar gnapSemicolonEntityName[] = {'g', 'n', 'a', 'p', ';'};
static const UChar gnapproxSemicolonEntityName[] = {'g', 'n', 'a', 'p', 'p', 'r', 'o', 'x', ';'};
static const UChar gneSemicolonEntityName[] = {'g', 'n', 'e', ';'};
static const UChar gneqSemicolonEntityName[] = {'g', 'n', 'e', 'q', ';'};
static const UChar gneqqSemicolonEntityName[] = {'g', 'n', 'e', 'q', 'q', ';'};
static const UChar gnsimSemicolonEntityName[] = {'g', 'n', 's', 'i', 'm', ';'};
static const UChar gopfSemicolonEntityName[] = {'g', 'o', 'p', 'f', ';'};
static const UChar graveSemicolonEntityName[] = {'g', 'r', 'a', 'v', 'e', ';'};
static const UChar gscrSemicolonEntityName[] = {'g', 's', 'c', 'r', ';'};
static const UChar gsimSemicolonEntityName[] = {'g', 's', 'i', 'm', ';'};
static const UChar gsimeSemicolonEntityName[] = {'g', 's', 'i', 'm', 'e', ';'};
static const UChar gsimlSemicolonEntityName[] = {'g', 's', 'i', 'm', 'l', ';'};
static const UChar gtEntityName[] = {'g', 't'};
static const UChar gtSemicolonEntityName[] = {'g', 't', ';'};
static const UChar gtccSemicolonEntityName[] = {'g', 't', 'c', 'c', ';'};
static const UChar gtcirSemicolonEntityName[] = {'g', 't', 'c', 'i', 'r', ';'};
static const UChar gtdotSemicolonEntityName[] = {'g', 't', 'd', 'o', 't', ';'};
static const UChar gtlParSemicolonEntityName[] = {'g', 't', 'l', 'P', 'a', 'r', ';'};
static const UChar gtquestSemicolonEntityName[] = {'g', 't', 'q', 'u', 'e', 's', 't', ';'};
static const UChar gtrapproxSemicolonEntityName[] = {'g', 't', 'r', 'a', 'p', 'p', 'r', 'o', 'x', ';'};
static const UChar gtrarrSemicolonEntityName[] = {'g', 't', 'r', 'a', 'r', 'r', ';'};
static const UChar gtrdotSemicolonEntityName[] = {'g', 't', 'r', 'd', 'o', 't', ';'};
static const UChar gtreqlessSemicolonEntityName[] = {'g', 't', 'r', 'e', 'q', 'l', 'e', 's', 's', ';'};
static const UChar gtreqqlessSemicolonEntityName[] = {'g', 't', 'r', 'e', 'q', 'q', 'l', 'e', 's', 's', ';'};
static const UChar gtrlessSemicolonEntityName[] = {'g', 't', 'r', 'l', 'e', 's', 's', ';'};
static const UChar gtrsimSemicolonEntityName[] = {'g', 't', 'r', 's', 'i', 'm', ';'};
static const UChar hArrSemicolonEntityName[] = {'h', 'A', 'r', 'r', ';'};
static const UChar hairspSemicolonEntityName[] = {'h', 'a', 'i', 'r', 's', 'p', ';'};
static const UChar halfSemicolonEntityName[] = {'h', 'a', 'l', 'f', ';'};
static const UChar hamiltSemicolonEntityName[] = {'h', 'a', 'm', 'i', 'l', 't', ';'};
static const UChar hardcySemicolonEntityName[] = {'h', 'a', 'r', 'd', 'c', 'y', ';'};
static const UChar harrSemicolonEntityName[] = {'h', 'a', 'r', 'r', ';'};
static const UChar harrcirSemicolonEntityName[] = {'h', 'a', 'r', 'r', 'c', 'i', 'r', ';'};
static const UChar harrwSemicolonEntityName[] = {'h', 'a', 'r', 'r', 'w', ';'};
static const UChar hbarSemicolonEntityName[] = {'h', 'b', 'a', 'r', ';'};
static const UChar hcircSemicolonEntityName[] = {'h', 'c', 'i', 'r', 'c', ';'};
static const UChar heartsSemicolonEntityName[] = {'h', 'e', 'a', 'r', 't', 's', ';'};
static const UChar heartsuitSemicolonEntityName[] = {'h', 'e', 'a', 'r', 't', 's', 'u', 'i', 't', ';'};
static const UChar hellipSemicolonEntityName[] = {'h', 'e', 'l', 'l', 'i', 'p', ';'};
static const UChar herconSemicolonEntityName[] = {'h', 'e', 'r', 'c', 'o', 'n', ';'};
static const UChar hfrSemicolonEntityName[] = {'h', 'f', 'r', ';'};
static const UChar hksearowSemicolonEntityName[] = {'h', 'k', 's', 'e', 'a', 'r', 'o', 'w', ';'};
static const UChar hkswarowSemicolonEntityName[] = {'h', 'k', 's', 'w', 'a', 'r', 'o', 'w', ';'};
static const UChar hoarrSemicolonEntityName[] = {'h', 'o', 'a', 'r', 'r', ';'};
static const UChar homthtSemicolonEntityName[] = {'h', 'o', 'm', 't', 'h', 't', ';'};
static const UChar hookleftarrowSemicolonEntityName[] = {'h', 'o', 'o', 'k', 'l', 'e', 'f', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar hookrightarrowSemicolonEntityName[] = {'h', 'o', 'o', 'k', 'r', 'i', 'g', 'h', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar hopfSemicolonEntityName[] = {'h', 'o', 'p', 'f', ';'};
static const UChar horbarSemicolonEntityName[] = {'h', 'o', 'r', 'b', 'a', 'r', ';'};
static const UChar hscrSemicolonEntityName[] = {'h', 's', 'c', 'r', ';'};
static const UChar hslashSemicolonEntityName[] = {'h', 's', 'l', 'a', 's', 'h', ';'};
static const UChar hstrokSemicolonEntityName[] = {'h', 's', 't', 'r', 'o', 'k', ';'};
static const UChar hybullSemicolonEntityName[] = {'h', 'y', 'b', 'u', 'l', 'l', ';'};
static const UChar hyphenSemicolonEntityName[] = {'h', 'y', 'p', 'h', 'e', 'n', ';'};
static const UChar iacuteEntityName[] = {'i', 'a', 'c', 'u', 't', 'e'};
static const UChar iacuteSemicolonEntityName[] = {'i', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar icSemicolonEntityName[] = {'i', 'c', ';'};
static const UChar icircEntityName[] = {'i', 'c', 'i', 'r', 'c'};
static const UChar icircSemicolonEntityName[] = {'i', 'c', 'i', 'r', 'c', ';'};
static const UChar icySemicolonEntityName[] = {'i', 'c', 'y', ';'};
static const UChar iecySemicolonEntityName[] = {'i', 'e', 'c', 'y', ';'};
static const UChar iexclEntityName[] = {'i', 'e', 'x', 'c', 'l'};
static const UChar iexclSemicolonEntityName[] = {'i', 'e', 'x', 'c', 'l', ';'};
static const UChar iffSemicolonEntityName[] = {'i', 'f', 'f', ';'};
static const UChar ifrSemicolonEntityName[] = {'i', 'f', 'r', ';'};
static const UChar igraveEntityName[] = {'i', 'g', 'r', 'a', 'v', 'e'};
static const UChar igraveSemicolonEntityName[] = {'i', 'g', 'r', 'a', 'v', 'e', ';'};
static const UChar iiSemicolonEntityName[] = {'i', 'i', ';'};
static const UChar iiiintSemicolonEntityName[] = {'i', 'i', 'i', 'i', 'n', 't', ';'};
static const UChar iiintSemicolonEntityName[] = {'i', 'i', 'i', 'n', 't', ';'};
static const UChar iinfinSemicolonEntityName[] = {'i', 'i', 'n', 'f', 'i', 'n', ';'};
static const UChar iiotaSemicolonEntityName[] = {'i', 'i', 'o', 't', 'a', ';'};
static const UChar ijligSemicolonEntityName[] = {'i', 'j', 'l', 'i', 'g', ';'};
static const UChar imacrSemicolonEntityName[] = {'i', 'm', 'a', 'c', 'r', ';'};
static const UChar imageSemicolonEntityName[] = {'i', 'm', 'a', 'g', 'e', ';'};
static const UChar imaglineSemicolonEntityName[] = {'i', 'm', 'a', 'g', 'l', 'i', 'n', 'e', ';'};
static const UChar imagpartSemicolonEntityName[] = {'i', 'm', 'a', 'g', 'p', 'a', 'r', 't', ';'};
static const UChar imathSemicolonEntityName[] = {'i', 'm', 'a', 't', 'h', ';'};
static const UChar imofSemicolonEntityName[] = {'i', 'm', 'o', 'f', ';'};
static const UChar impedSemicolonEntityName[] = {'i', 'm', 'p', 'e', 'd', ';'};
static const UChar inSemicolonEntityName[] = {'i', 'n', ';'};
static const UChar incareSemicolonEntityName[] = {'i', 'n', 'c', 'a', 'r', 'e', ';'};
static const UChar infinSemicolonEntityName[] = {'i', 'n', 'f', 'i', 'n', ';'};
static const UChar infintieSemicolonEntityName[] = {'i', 'n', 'f', 'i', 'n', 't', 'i', 'e', ';'};
static const UChar inodotSemicolonEntityName[] = {'i', 'n', 'o', 'd', 'o', 't', ';'};
static const UChar intSemicolonEntityName[] = {'i', 'n', 't', ';'};
static const UChar intcalSemicolonEntityName[] = {'i', 'n', 't', 'c', 'a', 'l', ';'};
static const UChar integersSemicolonEntityName[] = {'i', 'n', 't', 'e', 'g', 'e', 'r', 's', ';'};
static const UChar intercalSemicolonEntityName[] = {'i', 'n', 't', 'e', 'r', 'c', 'a', 'l', ';'};
static const UChar intlarhkSemicolonEntityName[] = {'i', 'n', 't', 'l', 'a', 'r', 'h', 'k', ';'};
static const UChar intprodSemicolonEntityName[] = {'i', 'n', 't', 'p', 'r', 'o', 'd', ';'};
static const UChar iocySemicolonEntityName[] = {'i', 'o', 'c', 'y', ';'};
static const UChar iogonSemicolonEntityName[] = {'i', 'o', 'g', 'o', 'n', ';'};
static const UChar iopfSemicolonEntityName[] = {'i', 'o', 'p', 'f', ';'};
static const UChar iotaSemicolonEntityName[] = {'i', 'o', 't', 'a', ';'};
static const UChar iprodSemicolonEntityName[] = {'i', 'p', 'r', 'o', 'd', ';'};
static const UChar iquestEntityName[] = {'i', 'q', 'u', 'e', 's', 't'};
static const UChar iquestSemicolonEntityName[] = {'i', 'q', 'u', 'e', 's', 't', ';'};
static const UChar iscrSemicolonEntityName[] = {'i', 's', 'c', 'r', ';'};
static const UChar isinSemicolonEntityName[] = {'i', 's', 'i', 'n', ';'};
static const UChar isinESemicolonEntityName[] = {'i', 's', 'i', 'n', 'E', ';'};
static const UChar isindotSemicolonEntityName[] = {'i', 's', 'i', 'n', 'd', 'o', 't', ';'};
static const UChar isinsSemicolonEntityName[] = {'i', 's', 'i', 'n', 's', ';'};
static const UChar isinsvSemicolonEntityName[] = {'i', 's', 'i', 'n', 's', 'v', ';'};
static const UChar isinvSemicolonEntityName[] = {'i', 's', 'i', 'n', 'v', ';'};
static const UChar itSemicolonEntityName[] = {'i', 't', ';'};
static const UChar itildeSemicolonEntityName[] = {'i', 't', 'i', 'l', 'd', 'e', ';'};
static const UChar iukcySemicolonEntityName[] = {'i', 'u', 'k', 'c', 'y', ';'};
static const UChar iumlEntityName[] = {'i', 'u', 'm', 'l'};
static const UChar iumlSemicolonEntityName[] = {'i', 'u', 'm', 'l', ';'};
static const UChar jcircSemicolonEntityName[] = {'j', 'c', 'i', 'r', 'c', ';'};
static const UChar jcySemicolonEntityName[] = {'j', 'c', 'y', ';'};
static const UChar jfrSemicolonEntityName[] = {'j', 'f', 'r', ';'};
static const UChar jmathSemicolonEntityName[] = {'j', 'm', 'a', 't', 'h', ';'};
static const UChar jopfSemicolonEntityName[] = {'j', 'o', 'p', 'f', ';'};
static const UChar jscrSemicolonEntityName[] = {'j', 's', 'c', 'r', ';'};
static const UChar jsercySemicolonEntityName[] = {'j', 's', 'e', 'r', 'c', 'y', ';'};
static const UChar jukcySemicolonEntityName[] = {'j', 'u', 'k', 'c', 'y', ';'};
static const UChar kappaSemicolonEntityName[] = {'k', 'a', 'p', 'p', 'a', ';'};
static const UChar kappavSemicolonEntityName[] = {'k', 'a', 'p', 'p', 'a', 'v', ';'};
static const UChar kcedilSemicolonEntityName[] = {'k', 'c', 'e', 'd', 'i', 'l', ';'};
static const UChar kcySemicolonEntityName[] = {'k', 'c', 'y', ';'};
static const UChar kfrSemicolonEntityName[] = {'k', 'f', 'r', ';'};
static const UChar kgreenSemicolonEntityName[] = {'k', 'g', 'r', 'e', 'e', 'n', ';'};
static const UChar khcySemicolonEntityName[] = {'k', 'h', 'c', 'y', ';'};
static const UChar kjcySemicolonEntityName[] = {'k', 'j', 'c', 'y', ';'};
static const UChar kopfSemicolonEntityName[] = {'k', 'o', 'p', 'f', ';'};
static const UChar kscrSemicolonEntityName[] = {'k', 's', 'c', 'r', ';'};
static const UChar lAarrSemicolonEntityName[] = {'l', 'A', 'a', 'r', 'r', ';'};
static const UChar lArrSemicolonEntityName[] = {'l', 'A', 'r', 'r', ';'};
static const UChar lAtailSemicolonEntityName[] = {'l', 'A', 't', 'a', 'i', 'l', ';'};
static const UChar lBarrSemicolonEntityName[] = {'l', 'B', 'a', 'r', 'r', ';'};
static const UChar lESemicolonEntityName[] = {'l', 'E', ';'};
static const UChar lEgSemicolonEntityName[] = {'l', 'E', 'g', ';'};
static const UChar lHarSemicolonEntityName[] = {'l', 'H', 'a', 'r', ';'};
static const UChar lacuteSemicolonEntityName[] = {'l', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar laemptyvSemicolonEntityName[] = {'l', 'a', 'e', 'm', 'p', 't', 'y', 'v', ';'};
static const UChar lagranSemicolonEntityName[] = {'l', 'a', 'g', 'r', 'a', 'n', ';'};
static const UChar lambdaSemicolonEntityName[] = {'l', 'a', 'm', 'b', 'd', 'a', ';'};
static const UChar langSemicolonEntityName[] = {'l', 'a', 'n', 'g', ';'};
static const UChar langdSemicolonEntityName[] = {'l', 'a', 'n', 'g', 'd', ';'};
static const UChar langleSemicolonEntityName[] = {'l', 'a', 'n', 'g', 'l', 'e', ';'};
static const UChar lapSemicolonEntityName[] = {'l', 'a', 'p', ';'};
static const UChar laquoEntityName[] = {'l', 'a', 'q', 'u', 'o'};
static const UChar laquoSemicolonEntityName[] = {'l', 'a', 'q', 'u', 'o', ';'};
static const UChar larrSemicolonEntityName[] = {'l', 'a', 'r', 'r', ';'};
static const UChar larrbSemicolonEntityName[] = {'l', 'a', 'r', 'r', 'b', ';'};
static const UChar larrbfsSemicolonEntityName[] = {'l', 'a', 'r', 'r', 'b', 'f', 's', ';'};
static const UChar larrfsSemicolonEntityName[] = {'l', 'a', 'r', 'r', 'f', 's', ';'};
static const UChar larrhkSemicolonEntityName[] = {'l', 'a', 'r', 'r', 'h', 'k', ';'};
static const UChar larrlpSemicolonEntityName[] = {'l', 'a', 'r', 'r', 'l', 'p', ';'};
static const UChar larrplSemicolonEntityName[] = {'l', 'a', 'r', 'r', 'p', 'l', ';'};
static const UChar larrsimSemicolonEntityName[] = {'l', 'a', 'r', 'r', 's', 'i', 'm', ';'};
static const UChar larrtlSemicolonEntityName[] = {'l', 'a', 'r', 'r', 't', 'l', ';'};
static const UChar latSemicolonEntityName[] = {'l', 'a', 't', ';'};
static const UChar latailSemicolonEntityName[] = {'l', 'a', 't', 'a', 'i', 'l', ';'};
static const UChar lateSemicolonEntityName[] = {'l', 'a', 't', 'e', ';'};
static const UChar lbarrSemicolonEntityName[] = {'l', 'b', 'a', 'r', 'r', ';'};
static const UChar lbbrkSemicolonEntityName[] = {'l', 'b', 'b', 'r', 'k', ';'};
static const UChar lbraceSemicolonEntityName[] = {'l', 'b', 'r', 'a', 'c', 'e', ';'};
static const UChar lbrackSemicolonEntityName[] = {'l', 'b', 'r', 'a', 'c', 'k', ';'};
static const UChar lbrkeSemicolonEntityName[] = {'l', 'b', 'r', 'k', 'e', ';'};
static const UChar lbrksldSemicolonEntityName[] = {'l', 'b', 'r', 'k', 's', 'l', 'd', ';'};
static const UChar lbrksluSemicolonEntityName[] = {'l', 'b', 'r', 'k', 's', 'l', 'u', ';'};
static const UChar lcaronSemicolonEntityName[] = {'l', 'c', 'a', 'r', 'o', 'n', ';'};
static const UChar lcedilSemicolonEntityName[] = {'l', 'c', 'e', 'd', 'i', 'l', ';'};
static const UChar lceilSemicolonEntityName[] = {'l', 'c', 'e', 'i', 'l', ';'};
static const UChar lcubSemicolonEntityName[] = {'l', 'c', 'u', 'b', ';'};
static const UChar lcySemicolonEntityName[] = {'l', 'c', 'y', ';'};
static const UChar ldcaSemicolonEntityName[] = {'l', 'd', 'c', 'a', ';'};
static const UChar ldquoSemicolonEntityName[] = {'l', 'd', 'q', 'u', 'o', ';'};
static const UChar ldquorSemicolonEntityName[] = {'l', 'd', 'q', 'u', 'o', 'r', ';'};
static const UChar ldrdharSemicolonEntityName[] = {'l', 'd', 'r', 'd', 'h', 'a', 'r', ';'};
static const UChar ldrusharSemicolonEntityName[] = {'l', 'd', 'r', 'u', 's', 'h', 'a', 'r', ';'};
static const UChar ldshSemicolonEntityName[] = {'l', 'd', 's', 'h', ';'};
static const UChar leSemicolonEntityName[] = {'l', 'e', ';'};
static const UChar leftarrowSemicolonEntityName[] = {'l', 'e', 'f', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar leftarrowtailSemicolonEntityName[] = {'l', 'e', 'f', 't', 'a', 'r', 'r', 'o', 'w', 't', 'a', 'i', 'l', ';'};
static const UChar leftharpoondownSemicolonEntityName[] = {'l', 'e', 'f', 't', 'h', 'a', 'r', 'p', 'o', 'o', 'n', 'd', 'o', 'w', 'n', ';'};
static const UChar leftharpoonupSemicolonEntityName[] = {'l', 'e', 'f', 't', 'h', 'a', 'r', 'p', 'o', 'o', 'n', 'u', 'p', ';'};
static const UChar leftleftarrowsSemicolonEntityName[] = {'l', 'e', 'f', 't', 'l', 'e', 'f', 't', 'a', 'r', 'r', 'o', 'w', 's', ';'};
static const UChar leftrightarrowSemicolonEntityName[] = {'l', 'e', 'f', 't', 'r', 'i', 'g', 'h', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar leftrightarrowsSemicolonEntityName[] = {'l', 'e', 'f', 't', 'r', 'i', 'g', 'h', 't', 'a', 'r', 'r', 'o', 'w', 's', ';'};
static const UChar leftrightharpoonsSemicolonEntityName[] = {'l', 'e', 'f', 't', 'r', 'i', 'g', 'h', 't', 'h', 'a', 'r', 'p', 'o', 'o', 'n', 's', ';'};
static const UChar leftrightsquigarrowSemicolonEntityName[] = {'l', 'e', 'f', 't', 'r', 'i', 'g', 'h', 't', 's', 'q', 'u', 'i', 'g', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar leftthreetimesSemicolonEntityName[] = {'l', 'e', 'f', 't', 't', 'h', 'r', 'e', 'e', 't', 'i', 'm', 'e', 's', ';'};
static const UChar legSemicolonEntityName[] = {'l', 'e', 'g', ';'};
static const UChar leqSemicolonEntityName[] = {'l', 'e', 'q', ';'};
static const UChar leqqSemicolonEntityName[] = {'l', 'e', 'q', 'q', ';'};
static const UChar leqslantSemicolonEntityName[] = {'l', 'e', 'q', 's', 'l', 'a', 'n', 't', ';'};
static const UChar lesSemicolonEntityName[] = {'l', 'e', 's', ';'};
static const UChar lesccSemicolonEntityName[] = {'l', 'e', 's', 'c', 'c', ';'};
static const UChar lesdotSemicolonEntityName[] = {'l', 'e', 's', 'd', 'o', 't', ';'};
static const UChar lesdotoSemicolonEntityName[] = {'l', 'e', 's', 'd', 'o', 't', 'o', ';'};
static const UChar lesdotorSemicolonEntityName[] = {'l', 'e', 's', 'd', 'o', 't', 'o', 'r', ';'};
static const UChar lesgesSemicolonEntityName[] = {'l', 'e', 's', 'g', 'e', 's', ';'};
static const UChar lessapproxSemicolonEntityName[] = {'l', 'e', 's', 's', 'a', 'p', 'p', 'r', 'o', 'x', ';'};
static const UChar lessdotSemicolonEntityName[] = {'l', 'e', 's', 's', 'd', 'o', 't', ';'};
static const UChar lesseqgtrSemicolonEntityName[] = {'l', 'e', 's', 's', 'e', 'q', 'g', 't', 'r', ';'};
static const UChar lesseqqgtrSemicolonEntityName[] = {'l', 'e', 's', 's', 'e', 'q', 'q', 'g', 't', 'r', ';'};
static const UChar lessgtrSemicolonEntityName[] = {'l', 'e', 's', 's', 'g', 't', 'r', ';'};
static const UChar lesssimSemicolonEntityName[] = {'l', 'e', 's', 's', 's', 'i', 'm', ';'};
static const UChar lfishtSemicolonEntityName[] = {'l', 'f', 'i', 's', 'h', 't', ';'};
static const UChar lfloorSemicolonEntityName[] = {'l', 'f', 'l', 'o', 'o', 'r', ';'};
static const UChar lfrSemicolonEntityName[] = {'l', 'f', 'r', ';'};
static const UChar lgSemicolonEntityName[] = {'l', 'g', ';'};
static const UChar lgESemicolonEntityName[] = {'l', 'g', 'E', ';'};
static const UChar lhardSemicolonEntityName[] = {'l', 'h', 'a', 'r', 'd', ';'};
static const UChar lharuSemicolonEntityName[] = {'l', 'h', 'a', 'r', 'u', ';'};
static const UChar lharulSemicolonEntityName[] = {'l', 'h', 'a', 'r', 'u', 'l', ';'};
static const UChar lhblkSemicolonEntityName[] = {'l', 'h', 'b', 'l', 'k', ';'};
static const UChar ljcySemicolonEntityName[] = {'l', 'j', 'c', 'y', ';'};
static const UChar llSemicolonEntityName[] = {'l', 'l', ';'};
static const UChar llarrSemicolonEntityName[] = {'l', 'l', 'a', 'r', 'r', ';'};
static const UChar llcornerSemicolonEntityName[] = {'l', 'l', 'c', 'o', 'r', 'n', 'e', 'r', ';'};
static const UChar llhardSemicolonEntityName[] = {'l', 'l', 'h', 'a', 'r', 'd', ';'};
static const UChar lltriSemicolonEntityName[] = {'l', 'l', 't', 'r', 'i', ';'};
static const UChar lmidotSemicolonEntityName[] = {'l', 'm', 'i', 'd', 'o', 't', ';'};
static const UChar lmoustSemicolonEntityName[] = {'l', 'm', 'o', 'u', 's', 't', ';'};
static const UChar lmoustacheSemicolonEntityName[] = {'l', 'm', 'o', 'u', 's', 't', 'a', 'c', 'h', 'e', ';'};
static const UChar lnESemicolonEntityName[] = {'l', 'n', 'E', ';'};
static const UChar lnapSemicolonEntityName[] = {'l', 'n', 'a', 'p', ';'};
static const UChar lnapproxSemicolonEntityName[] = {'l', 'n', 'a', 'p', 'p', 'r', 'o', 'x', ';'};
static const UChar lneSemicolonEntityName[] = {'l', 'n', 'e', ';'};
static const UChar lneqSemicolonEntityName[] = {'l', 'n', 'e', 'q', ';'};
static const UChar lneqqSemicolonEntityName[] = {'l', 'n', 'e', 'q', 'q', ';'};
static const UChar lnsimSemicolonEntityName[] = {'l', 'n', 's', 'i', 'm', ';'};
static const UChar loangSemicolonEntityName[] = {'l', 'o', 'a', 'n', 'g', ';'};
static const UChar loarrSemicolonEntityName[] = {'l', 'o', 'a', 'r', 'r', ';'};
static const UChar lobrkSemicolonEntityName[] = {'l', 'o', 'b', 'r', 'k', ';'};
static const UChar longleftarrowSemicolonEntityName[] = {'l', 'o', 'n', 'g', 'l', 'e', 'f', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar longleftrightarrowSemicolonEntityName[] = {'l', 'o', 'n', 'g', 'l', 'e', 'f', 't', 'r', 'i', 'g', 'h', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar longmapstoSemicolonEntityName[] = {'l', 'o', 'n', 'g', 'm', 'a', 'p', 's', 't', 'o', ';'};
static const UChar longrightarrowSemicolonEntityName[] = {'l', 'o', 'n', 'g', 'r', 'i', 'g', 'h', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar looparrowleftSemicolonEntityName[] = {'l', 'o', 'o', 'p', 'a', 'r', 'r', 'o', 'w', 'l', 'e', 'f', 't', ';'};
static const UChar looparrowrightSemicolonEntityName[] = {'l', 'o', 'o', 'p', 'a', 'r', 'r', 'o', 'w', 'r', 'i', 'g', 'h', 't', ';'};
static const UChar loparSemicolonEntityName[] = {'l', 'o', 'p', 'a', 'r', ';'};
static const UChar lopfSemicolonEntityName[] = {'l', 'o', 'p', 'f', ';'};
static const UChar loplusSemicolonEntityName[] = {'l', 'o', 'p', 'l', 'u', 's', ';'};
static const UChar lotimesSemicolonEntityName[] = {'l', 'o', 't', 'i', 'm', 'e', 's', ';'};
static const UChar lowastSemicolonEntityName[] = {'l', 'o', 'w', 'a', 's', 't', ';'};
static const UChar lowbarSemicolonEntityName[] = {'l', 'o', 'w', 'b', 'a', 'r', ';'};
static const UChar lozSemicolonEntityName[] = {'l', 'o', 'z', ';'};
static const UChar lozengeSemicolonEntityName[] = {'l', 'o', 'z', 'e', 'n', 'g', 'e', ';'};
static const UChar lozfSemicolonEntityName[] = {'l', 'o', 'z', 'f', ';'};
static const UChar lparSemicolonEntityName[] = {'l', 'p', 'a', 'r', ';'};
static const UChar lparltSemicolonEntityName[] = {'l', 'p', 'a', 'r', 'l', 't', ';'};
static const UChar lrarrSemicolonEntityName[] = {'l', 'r', 'a', 'r', 'r', ';'};
static const UChar lrcornerSemicolonEntityName[] = {'l', 'r', 'c', 'o', 'r', 'n', 'e', 'r', ';'};
static const UChar lrharSemicolonEntityName[] = {'l', 'r', 'h', 'a', 'r', ';'};
static const UChar lrhardSemicolonEntityName[] = {'l', 'r', 'h', 'a', 'r', 'd', ';'};
static const UChar lrmSemicolonEntityName[] = {'l', 'r', 'm', ';'};
static const UChar lrtriSemicolonEntityName[] = {'l', 'r', 't', 'r', 'i', ';'};
static const UChar lsaquoSemicolonEntityName[] = {'l', 's', 'a', 'q', 'u', 'o', ';'};
static const UChar lscrSemicolonEntityName[] = {'l', 's', 'c', 'r', ';'};
static const UChar lshSemicolonEntityName[] = {'l', 's', 'h', ';'};
static const UChar lsimSemicolonEntityName[] = {'l', 's', 'i', 'm', ';'};
static const UChar lsimeSemicolonEntityName[] = {'l', 's', 'i', 'm', 'e', ';'};
static const UChar lsimgSemicolonEntityName[] = {'l', 's', 'i', 'm', 'g', ';'};
static const UChar lsqbSemicolonEntityName[] = {'l', 's', 'q', 'b', ';'};
static const UChar lsquoSemicolonEntityName[] = {'l', 's', 'q', 'u', 'o', ';'};
static const UChar lsquorSemicolonEntityName[] = {'l', 's', 'q', 'u', 'o', 'r', ';'};
static const UChar lstrokSemicolonEntityName[] = {'l', 's', 't', 'r', 'o', 'k', ';'};
static const UChar ltEntityName[] = {'l', 't'};
static const UChar ltSemicolonEntityName[] = {'l', 't', ';'};
static const UChar ltccSemicolonEntityName[] = {'l', 't', 'c', 'c', ';'};
static const UChar ltcirSemicolonEntityName[] = {'l', 't', 'c', 'i', 'r', ';'};
static const UChar ltdotSemicolonEntityName[] = {'l', 't', 'd', 'o', 't', ';'};
static const UChar lthreeSemicolonEntityName[] = {'l', 't', 'h', 'r', 'e', 'e', ';'};
static const UChar ltimesSemicolonEntityName[] = {'l', 't', 'i', 'm', 'e', 's', ';'};
static const UChar ltlarrSemicolonEntityName[] = {'l', 't', 'l', 'a', 'r', 'r', ';'};
static const UChar ltquestSemicolonEntityName[] = {'l', 't', 'q', 'u', 'e', 's', 't', ';'};
static const UChar ltrParSemicolonEntityName[] = {'l', 't', 'r', 'P', 'a', 'r', ';'};
static const UChar ltriSemicolonEntityName[] = {'l', 't', 'r', 'i', ';'};
static const UChar ltrieSemicolonEntityName[] = {'l', 't', 'r', 'i', 'e', ';'};
static const UChar ltrifSemicolonEntityName[] = {'l', 't', 'r', 'i', 'f', ';'};
static const UChar lurdsharSemicolonEntityName[] = {'l', 'u', 'r', 'd', 's', 'h', 'a', 'r', ';'};
static const UChar luruharSemicolonEntityName[] = {'l', 'u', 'r', 'u', 'h', 'a', 'r', ';'};
static const UChar mDDotSemicolonEntityName[] = {'m', 'D', 'D', 'o', 't', ';'};
static const UChar macrEntityName[] = {'m', 'a', 'c', 'r'};
static const UChar macrSemicolonEntityName[] = {'m', 'a', 'c', 'r', ';'};
static const UChar maleSemicolonEntityName[] = {'m', 'a', 'l', 'e', ';'};
static const UChar maltSemicolonEntityName[] = {'m', 'a', 'l', 't', ';'};
static const UChar malteseSemicolonEntityName[] = {'m', 'a', 'l', 't', 'e', 's', 'e', ';'};
static const UChar mapSemicolonEntityName[] = {'m', 'a', 'p', ';'};
static const UChar mapstoSemicolonEntityName[] = {'m', 'a', 'p', 's', 't', 'o', ';'};
static const UChar mapstodownSemicolonEntityName[] = {'m', 'a', 'p', 's', 't', 'o', 'd', 'o', 'w', 'n', ';'};
static const UChar mapstoleftSemicolonEntityName[] = {'m', 'a', 'p', 's', 't', 'o', 'l', 'e', 'f', 't', ';'};
static const UChar mapstoupSemicolonEntityName[] = {'m', 'a', 'p', 's', 't', 'o', 'u', 'p', ';'};
static const UChar markerSemicolonEntityName[] = {'m', 'a', 'r', 'k', 'e', 'r', ';'};
static const UChar mcommaSemicolonEntityName[] = {'m', 'c', 'o', 'm', 'm', 'a', ';'};
static const UChar mcySemicolonEntityName[] = {'m', 'c', 'y', ';'};
static const UChar mdashSemicolonEntityName[] = {'m', 'd', 'a', 's', 'h', ';'};
static const UChar measuredangleSemicolonEntityName[] = {'m', 'e', 'a', 's', 'u', 'r', 'e', 'd', 'a', 'n', 'g', 'l', 'e', ';'};
static const UChar mfrSemicolonEntityName[] = {'m', 'f', 'r', ';'};
static const UChar mhoSemicolonEntityName[] = {'m', 'h', 'o', ';'};
static const UChar microEntityName[] = {'m', 'i', 'c', 'r', 'o'};
static const UChar microSemicolonEntityName[] = {'m', 'i', 'c', 'r', 'o', ';'};
static const UChar midSemicolonEntityName[] = {'m', 'i', 'd', ';'};
static const UChar midastSemicolonEntityName[] = {'m', 'i', 'd', 'a', 's', 't', ';'};
static const UChar midcirSemicolonEntityName[] = {'m', 'i', 'd', 'c', 'i', 'r', ';'};
static const UChar middotEntityName[] = {'m', 'i', 'd', 'd', 'o', 't'};
static const UChar middotSemicolonEntityName[] = {'m', 'i', 'd', 'd', 'o', 't', ';'};
static const UChar minusSemicolonEntityName[] = {'m', 'i', 'n', 'u', 's', ';'};
static const UChar minusbSemicolonEntityName[] = {'m', 'i', 'n', 'u', 's', 'b', ';'};
static const UChar minusdSemicolonEntityName[] = {'m', 'i', 'n', 'u', 's', 'd', ';'};
static const UChar minusduSemicolonEntityName[] = {'m', 'i', 'n', 'u', 's', 'd', 'u', ';'};
static const UChar mlcpSemicolonEntityName[] = {'m', 'l', 'c', 'p', ';'};
static const UChar mldrSemicolonEntityName[] = {'m', 'l', 'd', 'r', ';'};
static const UChar mnplusSemicolonEntityName[] = {'m', 'n', 'p', 'l', 'u', 's', ';'};
static const UChar modelsSemicolonEntityName[] = {'m', 'o', 'd', 'e', 'l', 's', ';'};
static const UChar mopfSemicolonEntityName[] = {'m', 'o', 'p', 'f', ';'};
static const UChar mpSemicolonEntityName[] = {'m', 'p', ';'};
static const UChar mscrSemicolonEntityName[] = {'m', 's', 'c', 'r', ';'};
static const UChar mstposSemicolonEntityName[] = {'m', 's', 't', 'p', 'o', 's', ';'};
static const UChar muSemicolonEntityName[] = {'m', 'u', ';'};
static const UChar multimapSemicolonEntityName[] = {'m', 'u', 'l', 't', 'i', 'm', 'a', 'p', ';'};
static const UChar mumapSemicolonEntityName[] = {'m', 'u', 'm', 'a', 'p', ';'};
static const UChar nLeftarrowSemicolonEntityName[] = {'n', 'L', 'e', 'f', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar nLeftrightarrowSemicolonEntityName[] = {'n', 'L', 'e', 'f', 't', 'r', 'i', 'g', 'h', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar nRightarrowSemicolonEntityName[] = {'n', 'R', 'i', 'g', 'h', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar nVDashSemicolonEntityName[] = {'n', 'V', 'D', 'a', 's', 'h', ';'};
static const UChar nVdashSemicolonEntityName[] = {'n', 'V', 'd', 'a', 's', 'h', ';'};
static const UChar nablaSemicolonEntityName[] = {'n', 'a', 'b', 'l', 'a', ';'};
static const UChar nacuteSemicolonEntityName[] = {'n', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar napSemicolonEntityName[] = {'n', 'a', 'p', ';'};
static const UChar naposSemicolonEntityName[] = {'n', 'a', 'p', 'o', 's', ';'};
static const UChar napproxSemicolonEntityName[] = {'n', 'a', 'p', 'p', 'r', 'o', 'x', ';'};
static const UChar naturSemicolonEntityName[] = {'n', 'a', 't', 'u', 'r', ';'};
static const UChar naturalSemicolonEntityName[] = {'n', 'a', 't', 'u', 'r', 'a', 'l', ';'};
static const UChar naturalsSemicolonEntityName[] = {'n', 'a', 't', 'u', 'r', 'a', 'l', 's', ';'};
static const UChar nbspEntityName[] = {'n', 'b', 's', 'p'};
static const UChar nbspSemicolonEntityName[] = {'n', 'b', 's', 'p', ';'};
static const UChar ncapSemicolonEntityName[] = {'n', 'c', 'a', 'p', ';'};
static const UChar ncaronSemicolonEntityName[] = {'n', 'c', 'a', 'r', 'o', 'n', ';'};
static const UChar ncedilSemicolonEntityName[] = {'n', 'c', 'e', 'd', 'i', 'l', ';'};
static const UChar ncongSemicolonEntityName[] = {'n', 'c', 'o', 'n', 'g', ';'};
static const UChar ncupSemicolonEntityName[] = {'n', 'c', 'u', 'p', ';'};
static const UChar ncySemicolonEntityName[] = {'n', 'c', 'y', ';'};
static const UChar ndashSemicolonEntityName[] = {'n', 'd', 'a', 's', 'h', ';'};
static const UChar neSemicolonEntityName[] = {'n', 'e', ';'};
static const UChar neArrSemicolonEntityName[] = {'n', 'e', 'A', 'r', 'r', ';'};
static const UChar nearhkSemicolonEntityName[] = {'n', 'e', 'a', 'r', 'h', 'k', ';'};
static const UChar nearrSemicolonEntityName[] = {'n', 'e', 'a', 'r', 'r', ';'};
static const UChar nearrowSemicolonEntityName[] = {'n', 'e', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar nequivSemicolonEntityName[] = {'n', 'e', 'q', 'u', 'i', 'v', ';'};
static const UChar nesearSemicolonEntityName[] = {'n', 'e', 's', 'e', 'a', 'r', ';'};
static const UChar nexistSemicolonEntityName[] = {'n', 'e', 'x', 'i', 's', 't', ';'};
static const UChar nexistsSemicolonEntityName[] = {'n', 'e', 'x', 'i', 's', 't', 's', ';'};
static const UChar nfrSemicolonEntityName[] = {'n', 'f', 'r', ';'};
static const UChar ngeSemicolonEntityName[] = {'n', 'g', 'e', ';'};
static const UChar ngeqSemicolonEntityName[] = {'n', 'g', 'e', 'q', ';'};
static const UChar ngsimSemicolonEntityName[] = {'n', 'g', 's', 'i', 'm', ';'};
static const UChar ngtSemicolonEntityName[] = {'n', 'g', 't', ';'};
static const UChar ngtrSemicolonEntityName[] = {'n', 'g', 't', 'r', ';'};
static const UChar nhArrSemicolonEntityName[] = {'n', 'h', 'A', 'r', 'r', ';'};
static const UChar nharrSemicolonEntityName[] = {'n', 'h', 'a', 'r', 'r', ';'};
static const UChar nhparSemicolonEntityName[] = {'n', 'h', 'p', 'a', 'r', ';'};
static const UChar niSemicolonEntityName[] = {'n', 'i', ';'};
static const UChar nisSemicolonEntityName[] = {'n', 'i', 's', ';'};
static const UChar nisdSemicolonEntityName[] = {'n', 'i', 's', 'd', ';'};
static const UChar nivSemicolonEntityName[] = {'n', 'i', 'v', ';'};
static const UChar njcySemicolonEntityName[] = {'n', 'j', 'c', 'y', ';'};
static const UChar nlArrSemicolonEntityName[] = {'n', 'l', 'A', 'r', 'r', ';'};
static const UChar nlarrSemicolonEntityName[] = {'n', 'l', 'a', 'r', 'r', ';'};
static const UChar nldrSemicolonEntityName[] = {'n', 'l', 'd', 'r', ';'};
static const UChar nleSemicolonEntityName[] = {'n', 'l', 'e', ';'};
static const UChar nleftarrowSemicolonEntityName[] = {'n', 'l', 'e', 'f', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar nleftrightarrowSemicolonEntityName[] = {'n', 'l', 'e', 'f', 't', 'r', 'i', 'g', 'h', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar nleqSemicolonEntityName[] = {'n', 'l', 'e', 'q', ';'};
static const UChar nlessSemicolonEntityName[] = {'n', 'l', 'e', 's', 's', ';'};
static const UChar nlsimSemicolonEntityName[] = {'n', 'l', 's', 'i', 'm', ';'};
static const UChar nltSemicolonEntityName[] = {'n', 'l', 't', ';'};
static const UChar nltriSemicolonEntityName[] = {'n', 'l', 't', 'r', 'i', ';'};
static const UChar nltrieSemicolonEntityName[] = {'n', 'l', 't', 'r', 'i', 'e', ';'};
static const UChar nmidSemicolonEntityName[] = {'n', 'm', 'i', 'd', ';'};
static const UChar nopfSemicolonEntityName[] = {'n', 'o', 'p', 'f', ';'};
static const UChar notEntityName[] = {'n', 'o', 't'};
static const UChar notSemicolonEntityName[] = {'n', 'o', 't', ';'};
static const UChar notinSemicolonEntityName[] = {'n', 'o', 't', 'i', 'n', ';'};
static const UChar notinvaSemicolonEntityName[] = {'n', 'o', 't', 'i', 'n', 'v', 'a', ';'};
static const UChar notinvbSemicolonEntityName[] = {'n', 'o', 't', 'i', 'n', 'v', 'b', ';'};
static const UChar notinvcSemicolonEntityName[] = {'n', 'o', 't', 'i', 'n', 'v', 'c', ';'};
static const UChar notniSemicolonEntityName[] = {'n', 'o', 't', 'n', 'i', ';'};
static const UChar notnivaSemicolonEntityName[] = {'n', 'o', 't', 'n', 'i', 'v', 'a', ';'};
static const UChar notnivbSemicolonEntityName[] = {'n', 'o', 't', 'n', 'i', 'v', 'b', ';'};
static const UChar notnivcSemicolonEntityName[] = {'n', 'o', 't', 'n', 'i', 'v', 'c', ';'};
static const UChar nparSemicolonEntityName[] = {'n', 'p', 'a', 'r', ';'};
static const UChar nparallelSemicolonEntityName[] = {'n', 'p', 'a', 'r', 'a', 'l', 'l', 'e', 'l', ';'};
static const UChar npolintSemicolonEntityName[] = {'n', 'p', 'o', 'l', 'i', 'n', 't', ';'};
static const UChar nprSemicolonEntityName[] = {'n', 'p', 'r', ';'};
static const UChar nprcueSemicolonEntityName[] = {'n', 'p', 'r', 'c', 'u', 'e', ';'};
static const UChar nprecSemicolonEntityName[] = {'n', 'p', 'r', 'e', 'c', ';'};
static const UChar nrArrSemicolonEntityName[] = {'n', 'r', 'A', 'r', 'r', ';'};
static const UChar nrarrSemicolonEntityName[] = {'n', 'r', 'a', 'r', 'r', ';'};
static const UChar nrightarrowSemicolonEntityName[] = {'n', 'r', 'i', 'g', 'h', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar nrtriSemicolonEntityName[] = {'n', 'r', 't', 'r', 'i', ';'};
static const UChar nrtrieSemicolonEntityName[] = {'n', 'r', 't', 'r', 'i', 'e', ';'};
static const UChar nscSemicolonEntityName[] = {'n', 's', 'c', ';'};
static const UChar nsccueSemicolonEntityName[] = {'n', 's', 'c', 'c', 'u', 'e', ';'};
static const UChar nscrSemicolonEntityName[] = {'n', 's', 'c', 'r', ';'};
static const UChar nshortmidSemicolonEntityName[] = {'n', 's', 'h', 'o', 'r', 't', 'm', 'i', 'd', ';'};
static const UChar nshortparallelSemicolonEntityName[] = {'n', 's', 'h', 'o', 'r', 't', 'p', 'a', 'r', 'a', 'l', 'l', 'e', 'l', ';'};
static const UChar nsimSemicolonEntityName[] = {'n', 's', 'i', 'm', ';'};
static const UChar nsimeSemicolonEntityName[] = {'n', 's', 'i', 'm', 'e', ';'};
static const UChar nsimeqSemicolonEntityName[] = {'n', 's', 'i', 'm', 'e', 'q', ';'};
static const UChar nsmidSemicolonEntityName[] = {'n', 's', 'm', 'i', 'd', ';'};
static const UChar nsparSemicolonEntityName[] = {'n', 's', 'p', 'a', 'r', ';'};
static const UChar nsqsubeSemicolonEntityName[] = {'n', 's', 'q', 's', 'u', 'b', 'e', ';'};
static const UChar nsqsupeSemicolonEntityName[] = {'n', 's', 'q', 's', 'u', 'p', 'e', ';'};
static const UChar nsubSemicolonEntityName[] = {'n', 's', 'u', 'b', ';'};
static const UChar nsubeSemicolonEntityName[] = {'n', 's', 'u', 'b', 'e', ';'};
static const UChar nsubseteqSemicolonEntityName[] = {'n', 's', 'u', 'b', 's', 'e', 't', 'e', 'q', ';'};
static const UChar nsuccSemicolonEntityName[] = {'n', 's', 'u', 'c', 'c', ';'};
static const UChar nsupSemicolonEntityName[] = {'n', 's', 'u', 'p', ';'};
static const UChar nsupeSemicolonEntityName[] = {'n', 's', 'u', 'p', 'e', ';'};
static const UChar nsupseteqSemicolonEntityName[] = {'n', 's', 'u', 'p', 's', 'e', 't', 'e', 'q', ';'};
static const UChar ntglSemicolonEntityName[] = {'n', 't', 'g', 'l', ';'};
static const UChar ntildeEntityName[] = {'n', 't', 'i', 'l', 'd', 'e'};
static const UChar ntildeSemicolonEntityName[] = {'n', 't', 'i', 'l', 'd', 'e', ';'};
static const UChar ntlgSemicolonEntityName[] = {'n', 't', 'l', 'g', ';'};
static const UChar ntriangleleftSemicolonEntityName[] = {'n', 't', 'r', 'i', 'a', 'n', 'g', 'l', 'e', 'l', 'e', 'f', 't', ';'};
static const UChar ntrianglelefteqSemicolonEntityName[] = {'n', 't', 'r', 'i', 'a', 'n', 'g', 'l', 'e', 'l', 'e', 'f', 't', 'e', 'q', ';'};
static const UChar ntrianglerightSemicolonEntityName[] = {'n', 't', 'r', 'i', 'a', 'n', 'g', 'l', 'e', 'r', 'i', 'g', 'h', 't', ';'};
static const UChar ntrianglerighteqSemicolonEntityName[] = {'n', 't', 'r', 'i', 'a', 'n', 'g', 'l', 'e', 'r', 'i', 'g', 'h', 't', 'e', 'q', ';'};
static const UChar nuSemicolonEntityName[] = {'n', 'u', ';'};
static const UChar numSemicolonEntityName[] = {'n', 'u', 'm', ';'};
static const UChar numeroSemicolonEntityName[] = {'n', 'u', 'm', 'e', 'r', 'o', ';'};
static const UChar numspSemicolonEntityName[] = {'n', 'u', 'm', 's', 'p', ';'};
static const UChar nvDashSemicolonEntityName[] = {'n', 'v', 'D', 'a', 's', 'h', ';'};
static const UChar nvHarrSemicolonEntityName[] = {'n', 'v', 'H', 'a', 'r', 'r', ';'};
static const UChar nvdashSemicolonEntityName[] = {'n', 'v', 'd', 'a', 's', 'h', ';'};
static const UChar nvinfinSemicolonEntityName[] = {'n', 'v', 'i', 'n', 'f', 'i', 'n', ';'};
static const UChar nvlArrSemicolonEntityName[] = {'n', 'v', 'l', 'A', 'r', 'r', ';'};
static const UChar nvrArrSemicolonEntityName[] = {'n', 'v', 'r', 'A', 'r', 'r', ';'};
static const UChar nwArrSemicolonEntityName[] = {'n', 'w', 'A', 'r', 'r', ';'};
static const UChar nwarhkSemicolonEntityName[] = {'n', 'w', 'a', 'r', 'h', 'k', ';'};
static const UChar nwarrSemicolonEntityName[] = {'n', 'w', 'a', 'r', 'r', ';'};
static const UChar nwarrowSemicolonEntityName[] = {'n', 'w', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar nwnearSemicolonEntityName[] = {'n', 'w', 'n', 'e', 'a', 'r', ';'};
static const UChar oSSemicolonEntityName[] = {'o', 'S', ';'};
static const UChar oacuteEntityName[] = {'o', 'a', 'c', 'u', 't', 'e'};
static const UChar oacuteSemicolonEntityName[] = {'o', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar oastSemicolonEntityName[] = {'o', 'a', 's', 't', ';'};
static const UChar ocirSemicolonEntityName[] = {'o', 'c', 'i', 'r', ';'};
static const UChar ocircEntityName[] = {'o', 'c', 'i', 'r', 'c'};
static const UChar ocircSemicolonEntityName[] = {'o', 'c', 'i', 'r', 'c', ';'};
static const UChar ocySemicolonEntityName[] = {'o', 'c', 'y', ';'};
static const UChar odashSemicolonEntityName[] = {'o', 'd', 'a', 's', 'h', ';'};
static const UChar odblacSemicolonEntityName[] = {'o', 'd', 'b', 'l', 'a', 'c', ';'};
static const UChar odivSemicolonEntityName[] = {'o', 'd', 'i', 'v', ';'};
static const UChar odotSemicolonEntityName[] = {'o', 'd', 'o', 't', ';'};
static const UChar odsoldSemicolonEntityName[] = {'o', 'd', 's', 'o', 'l', 'd', ';'};
static const UChar oeligSemicolonEntityName[] = {'o', 'e', 'l', 'i', 'g', ';'};
static const UChar ofcirSemicolonEntityName[] = {'o', 'f', 'c', 'i', 'r', ';'};
static const UChar ofrSemicolonEntityName[] = {'o', 'f', 'r', ';'};
static const UChar ogonSemicolonEntityName[] = {'o', 'g', 'o', 'n', ';'};
static const UChar ograveEntityName[] = {'o', 'g', 'r', 'a', 'v', 'e'};
static const UChar ograveSemicolonEntityName[] = {'o', 'g', 'r', 'a', 'v', 'e', ';'};
static const UChar ogtSemicolonEntityName[] = {'o', 'g', 't', ';'};
static const UChar ohbarSemicolonEntityName[] = {'o', 'h', 'b', 'a', 'r', ';'};
static const UChar ohmSemicolonEntityName[] = {'o', 'h', 'm', ';'};
static const UChar ointSemicolonEntityName[] = {'o', 'i', 'n', 't', ';'};
static const UChar olarrSemicolonEntityName[] = {'o', 'l', 'a', 'r', 'r', ';'};
static const UChar olcirSemicolonEntityName[] = {'o', 'l', 'c', 'i', 'r', ';'};
static const UChar olcrossSemicolonEntityName[] = {'o', 'l', 'c', 'r', 'o', 's', 's', ';'};
static const UChar olineSemicolonEntityName[] = {'o', 'l', 'i', 'n', 'e', ';'};
static const UChar oltSemicolonEntityName[] = {'o', 'l', 't', ';'};
static const UChar omacrSemicolonEntityName[] = {'o', 'm', 'a', 'c', 'r', ';'};
static const UChar omegaSemicolonEntityName[] = {'o', 'm', 'e', 'g', 'a', ';'};
static const UChar omicronSemicolonEntityName[] = {'o', 'm', 'i', 'c', 'r', 'o', 'n', ';'};
static const UChar omidSemicolonEntityName[] = {'o', 'm', 'i', 'd', ';'};
static const UChar ominusSemicolonEntityName[] = {'o', 'm', 'i', 'n', 'u', 's', ';'};
static const UChar oopfSemicolonEntityName[] = {'o', 'o', 'p', 'f', ';'};
static const UChar oparSemicolonEntityName[] = {'o', 'p', 'a', 'r', ';'};
static const UChar operpSemicolonEntityName[] = {'o', 'p', 'e', 'r', 'p', ';'};
static const UChar oplusSemicolonEntityName[] = {'o', 'p', 'l', 'u', 's', ';'};
static const UChar orSemicolonEntityName[] = {'o', 'r', ';'};
static const UChar orarrSemicolonEntityName[] = {'o', 'r', 'a', 'r', 'r', ';'};
static const UChar ordSemicolonEntityName[] = {'o', 'r', 'd', ';'};
static const UChar orderSemicolonEntityName[] = {'o', 'r', 'd', 'e', 'r', ';'};
static const UChar orderofSemicolonEntityName[] = {'o', 'r', 'd', 'e', 'r', 'o', 'f', ';'};
static const UChar ordfEntityName[] = {'o', 'r', 'd', 'f'};
static const UChar ordfSemicolonEntityName[] = {'o', 'r', 'd', 'f', ';'};
static const UChar ordmEntityName[] = {'o', 'r', 'd', 'm'};
static const UChar ordmSemicolonEntityName[] = {'o', 'r', 'd', 'm', ';'};
static const UChar origofSemicolonEntityName[] = {'o', 'r', 'i', 'g', 'o', 'f', ';'};
static const UChar ororSemicolonEntityName[] = {'o', 'r', 'o', 'r', ';'};
static const UChar orslopeSemicolonEntityName[] = {'o', 'r', 's', 'l', 'o', 'p', 'e', ';'};
static const UChar orvSemicolonEntityName[] = {'o', 'r', 'v', ';'};
static const UChar oscrSemicolonEntityName[] = {'o', 's', 'c', 'r', ';'};
static const UChar oslashEntityName[] = {'o', 's', 'l', 'a', 's', 'h'};
static const UChar oslashSemicolonEntityName[] = {'o', 's', 'l', 'a', 's', 'h', ';'};
static const UChar osolSemicolonEntityName[] = {'o', 's', 'o', 'l', ';'};
static const UChar otildeEntityName[] = {'o', 't', 'i', 'l', 'd', 'e'};
static const UChar otildeSemicolonEntityName[] = {'o', 't', 'i', 'l', 'd', 'e', ';'};
static const UChar otimesSemicolonEntityName[] = {'o', 't', 'i', 'm', 'e', 's', ';'};
static const UChar otimesasSemicolonEntityName[] = {'o', 't', 'i', 'm', 'e', 's', 'a', 's', ';'};
static const UChar oumlEntityName[] = {'o', 'u', 'm', 'l'};
static const UChar oumlSemicolonEntityName[] = {'o', 'u', 'm', 'l', ';'};
static const UChar ovbarSemicolonEntityName[] = {'o', 'v', 'b', 'a', 'r', ';'};
static const UChar parSemicolonEntityName[] = {'p', 'a', 'r', ';'};
static const UChar paraEntityName[] = {'p', 'a', 'r', 'a'};
static const UChar paraSemicolonEntityName[] = {'p', 'a', 'r', 'a', ';'};
static const UChar parallelSemicolonEntityName[] = {'p', 'a', 'r', 'a', 'l', 'l', 'e', 'l', ';'};
static const UChar parsimSemicolonEntityName[] = {'p', 'a', 'r', 's', 'i', 'm', ';'};
static const UChar parslSemicolonEntityName[] = {'p', 'a', 'r', 's', 'l', ';'};
static const UChar partSemicolonEntityName[] = {'p', 'a', 'r', 't', ';'};
static const UChar pcySemicolonEntityName[] = {'p', 'c', 'y', ';'};
static const UChar percntSemicolonEntityName[] = {'p', 'e', 'r', 'c', 'n', 't', ';'};
static const UChar periodSemicolonEntityName[] = {'p', 'e', 'r', 'i', 'o', 'd', ';'};
static const UChar permilSemicolonEntityName[] = {'p', 'e', 'r', 'm', 'i', 'l', ';'};
static const UChar perpSemicolonEntityName[] = {'p', 'e', 'r', 'p', ';'};
static const UChar pertenkSemicolonEntityName[] = {'p', 'e', 'r', 't', 'e', 'n', 'k', ';'};
static const UChar pfrSemicolonEntityName[] = {'p', 'f', 'r', ';'};
static const UChar phiSemicolonEntityName[] = {'p', 'h', 'i', ';'};
static const UChar phivSemicolonEntityName[] = {'p', 'h', 'i', 'v', ';'};
static const UChar phmmatSemicolonEntityName[] = {'p', 'h', 'm', 'm', 'a', 't', ';'};
static const UChar phoneSemicolonEntityName[] = {'p', 'h', 'o', 'n', 'e', ';'};
static const UChar piSemicolonEntityName[] = {'p', 'i', ';'};
static const UChar pitchforkSemicolonEntityName[] = {'p', 'i', 't', 'c', 'h', 'f', 'o', 'r', 'k', ';'};
static const UChar pivSemicolonEntityName[] = {'p', 'i', 'v', ';'};
static const UChar planckSemicolonEntityName[] = {'p', 'l', 'a', 'n', 'c', 'k', ';'};
static const UChar planckhSemicolonEntityName[] = {'p', 'l', 'a', 'n', 'c', 'k', 'h', ';'};
static const UChar plankvSemicolonEntityName[] = {'p', 'l', 'a', 'n', 'k', 'v', ';'};
static const UChar plusSemicolonEntityName[] = {'p', 'l', 'u', 's', ';'};
static const UChar plusacirSemicolonEntityName[] = {'p', 'l', 'u', 's', 'a', 'c', 'i', 'r', ';'};
static const UChar plusbSemicolonEntityName[] = {'p', 'l', 'u', 's', 'b', ';'};
static const UChar pluscirSemicolonEntityName[] = {'p', 'l', 'u', 's', 'c', 'i', 'r', ';'};
static const UChar plusdoSemicolonEntityName[] = {'p', 'l', 'u', 's', 'd', 'o', ';'};
static const UChar plusduSemicolonEntityName[] = {'p', 'l', 'u', 's', 'd', 'u', ';'};
static const UChar pluseSemicolonEntityName[] = {'p', 'l', 'u', 's', 'e', ';'};
static const UChar plusmnEntityName[] = {'p', 'l', 'u', 's', 'm', 'n'};
static const UChar plusmnSemicolonEntityName[] = {'p', 'l', 'u', 's', 'm', 'n', ';'};
static const UChar plussimSemicolonEntityName[] = {'p', 'l', 'u', 's', 's', 'i', 'm', ';'};
static const UChar plustwoSemicolonEntityName[] = {'p', 'l', 'u', 's', 't', 'w', 'o', ';'};
static const UChar pmSemicolonEntityName[] = {'p', 'm', ';'};
static const UChar pointintSemicolonEntityName[] = {'p', 'o', 'i', 'n', 't', 'i', 'n', 't', ';'};
static const UChar popfSemicolonEntityName[] = {'p', 'o', 'p', 'f', ';'};
static const UChar poundEntityName[] = {'p', 'o', 'u', 'n', 'd'};
static const UChar poundSemicolonEntityName[] = {'p', 'o', 'u', 'n', 'd', ';'};
static const UChar prSemicolonEntityName[] = {'p', 'r', ';'};
static const UChar prESemicolonEntityName[] = {'p', 'r', 'E', ';'};
static const UChar prapSemicolonEntityName[] = {'p', 'r', 'a', 'p', ';'};
static const UChar prcueSemicolonEntityName[] = {'p', 'r', 'c', 'u', 'e', ';'};
static const UChar preSemicolonEntityName[] = {'p', 'r', 'e', ';'};
static const UChar precSemicolonEntityName[] = {'p', 'r', 'e', 'c', ';'};
static const UChar precapproxSemicolonEntityName[] = {'p', 'r', 'e', 'c', 'a', 'p', 'p', 'r', 'o', 'x', ';'};
static const UChar preccurlyeqSemicolonEntityName[] = {'p', 'r', 'e', 'c', 'c', 'u', 'r', 'l', 'y', 'e', 'q', ';'};
static const UChar preceqSemicolonEntityName[] = {'p', 'r', 'e', 'c', 'e', 'q', ';'};
static const UChar precnapproxSemicolonEntityName[] = {'p', 'r', 'e', 'c', 'n', 'a', 'p', 'p', 'r', 'o', 'x', ';'};
static const UChar precneqqSemicolonEntityName[] = {'p', 'r', 'e', 'c', 'n', 'e', 'q', 'q', ';'};
static const UChar precnsimSemicolonEntityName[] = {'p', 'r', 'e', 'c', 'n', 's', 'i', 'm', ';'};
static const UChar precsimSemicolonEntityName[] = {'p', 'r', 'e', 'c', 's', 'i', 'm', ';'};
static const UChar primeSemicolonEntityName[] = {'p', 'r', 'i', 'm', 'e', ';'};
static const UChar primesSemicolonEntityName[] = {'p', 'r', 'i', 'm', 'e', 's', ';'};
static const UChar prnESemicolonEntityName[] = {'p', 'r', 'n', 'E', ';'};
static const UChar prnapSemicolonEntityName[] = {'p', 'r', 'n', 'a', 'p', ';'};
static const UChar prnsimSemicolonEntityName[] = {'p', 'r', 'n', 's', 'i', 'm', ';'};
static const UChar prodSemicolonEntityName[] = {'p', 'r', 'o', 'd', ';'};
static const UChar profalarSemicolonEntityName[] = {'p', 'r', 'o', 'f', 'a', 'l', 'a', 'r', ';'};
static const UChar proflineSemicolonEntityName[] = {'p', 'r', 'o', 'f', 'l', 'i', 'n', 'e', ';'};
static const UChar profsurfSemicolonEntityName[] = {'p', 'r', 'o', 'f', 's', 'u', 'r', 'f', ';'};
static const UChar propSemicolonEntityName[] = {'p', 'r', 'o', 'p', ';'};
static const UChar proptoSemicolonEntityName[] = {'p', 'r', 'o', 'p', 't', 'o', ';'};
static const UChar prsimSemicolonEntityName[] = {'p', 'r', 's', 'i', 'm', ';'};
static const UChar prurelSemicolonEntityName[] = {'p', 'r', 'u', 'r', 'e', 'l', ';'};
static const UChar pscrSemicolonEntityName[] = {'p', 's', 'c', 'r', ';'};
static const UChar psiSemicolonEntityName[] = {'p', 's', 'i', ';'};
static const UChar puncspSemicolonEntityName[] = {'p', 'u', 'n', 'c', 's', 'p', ';'};
static const UChar qfrSemicolonEntityName[] = {'q', 'f', 'r', ';'};
static const UChar qintSemicolonEntityName[] = {'q', 'i', 'n', 't', ';'};
static const UChar qopfSemicolonEntityName[] = {'q', 'o', 'p', 'f', ';'};
static const UChar qprimeSemicolonEntityName[] = {'q', 'p', 'r', 'i', 'm', 'e', ';'};
static const UChar qscrSemicolonEntityName[] = {'q', 's', 'c', 'r', ';'};
static const UChar quaternionsSemicolonEntityName[] = {'q', 'u', 'a', 't', 'e', 'r', 'n', 'i', 'o', 'n', 's', ';'};
static const UChar quatintSemicolonEntityName[] = {'q', 'u', 'a', 't', 'i', 'n', 't', ';'};
static const UChar questSemicolonEntityName[] = {'q', 'u', 'e', 's', 't', ';'};
static const UChar questeqSemicolonEntityName[] = {'q', 'u', 'e', 's', 't', 'e', 'q', ';'};
static const UChar quotEntityName[] = {'q', 'u', 'o', 't'};
static const UChar quotSemicolonEntityName[] = {'q', 'u', 'o', 't', ';'};
static const UChar rAarrSemicolonEntityName[] = {'r', 'A', 'a', 'r', 'r', ';'};
static const UChar rArrSemicolonEntityName[] = {'r', 'A', 'r', 'r', ';'};
static const UChar rAtailSemicolonEntityName[] = {'r', 'A', 't', 'a', 'i', 'l', ';'};
static const UChar rBarrSemicolonEntityName[] = {'r', 'B', 'a', 'r', 'r', ';'};
static const UChar rHarSemicolonEntityName[] = {'r', 'H', 'a', 'r', ';'};
static const UChar racuteSemicolonEntityName[] = {'r', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar radicSemicolonEntityName[] = {'r', 'a', 'd', 'i', 'c', ';'};
static const UChar raemptyvSemicolonEntityName[] = {'r', 'a', 'e', 'm', 'p', 't', 'y', 'v', ';'};
static const UChar rangSemicolonEntityName[] = {'r', 'a', 'n', 'g', ';'};
static const UChar rangdSemicolonEntityName[] = {'r', 'a', 'n', 'g', 'd', ';'};
static const UChar rangeSemicolonEntityName[] = {'r', 'a', 'n', 'g', 'e', ';'};
static const UChar rangleSemicolonEntityName[] = {'r', 'a', 'n', 'g', 'l', 'e', ';'};
static const UChar raquoEntityName[] = {'r', 'a', 'q', 'u', 'o'};
static const UChar raquoSemicolonEntityName[] = {'r', 'a', 'q', 'u', 'o', ';'};
static const UChar rarrSemicolonEntityName[] = {'r', 'a', 'r', 'r', ';'};
static const UChar rarrapSemicolonEntityName[] = {'r', 'a', 'r', 'r', 'a', 'p', ';'};
static const UChar rarrbSemicolonEntityName[] = {'r', 'a', 'r', 'r', 'b', ';'};
static const UChar rarrbfsSemicolonEntityName[] = {'r', 'a', 'r', 'r', 'b', 'f', 's', ';'};
static const UChar rarrcSemicolonEntityName[] = {'r', 'a', 'r', 'r', 'c', ';'};
static const UChar rarrfsSemicolonEntityName[] = {'r', 'a', 'r', 'r', 'f', 's', ';'};
static const UChar rarrhkSemicolonEntityName[] = {'r', 'a', 'r', 'r', 'h', 'k', ';'};
static const UChar rarrlpSemicolonEntityName[] = {'r', 'a', 'r', 'r', 'l', 'p', ';'};
static const UChar rarrplSemicolonEntityName[] = {'r', 'a', 'r', 'r', 'p', 'l', ';'};
static const UChar rarrsimSemicolonEntityName[] = {'r', 'a', 'r', 'r', 's', 'i', 'm', ';'};
static const UChar rarrtlSemicolonEntityName[] = {'r', 'a', 'r', 'r', 't', 'l', ';'};
static const UChar rarrwSemicolonEntityName[] = {'r', 'a', 'r', 'r', 'w', ';'};
static const UChar ratailSemicolonEntityName[] = {'r', 'a', 't', 'a', 'i', 'l', ';'};
static const UChar ratioSemicolonEntityName[] = {'r', 'a', 't', 'i', 'o', ';'};
static const UChar rationalsSemicolonEntityName[] = {'r', 'a', 't', 'i', 'o', 'n', 'a', 'l', 's', ';'};
static const UChar rbarrSemicolonEntityName[] = {'r', 'b', 'a', 'r', 'r', ';'};
static const UChar rbbrkSemicolonEntityName[] = {'r', 'b', 'b', 'r', 'k', ';'};
static const UChar rbraceSemicolonEntityName[] = {'r', 'b', 'r', 'a', 'c', 'e', ';'};
static const UChar rbrackSemicolonEntityName[] = {'r', 'b', 'r', 'a', 'c', 'k', ';'};
static const UChar rbrkeSemicolonEntityName[] = {'r', 'b', 'r', 'k', 'e', ';'};
static const UChar rbrksldSemicolonEntityName[] = {'r', 'b', 'r', 'k', 's', 'l', 'd', ';'};
static const UChar rbrksluSemicolonEntityName[] = {'r', 'b', 'r', 'k', 's', 'l', 'u', ';'};
static const UChar rcaronSemicolonEntityName[] = {'r', 'c', 'a', 'r', 'o', 'n', ';'};
static const UChar rcedilSemicolonEntityName[] = {'r', 'c', 'e', 'd', 'i', 'l', ';'};
static const UChar rceilSemicolonEntityName[] = {'r', 'c', 'e', 'i', 'l', ';'};
static const UChar rcubSemicolonEntityName[] = {'r', 'c', 'u', 'b', ';'};
static const UChar rcySemicolonEntityName[] = {'r', 'c', 'y', ';'};
static const UChar rdcaSemicolonEntityName[] = {'r', 'd', 'c', 'a', ';'};
static const UChar rdldharSemicolonEntityName[] = {'r', 'd', 'l', 'd', 'h', 'a', 'r', ';'};
static const UChar rdquoSemicolonEntityName[] = {'r', 'd', 'q', 'u', 'o', ';'};
static const UChar rdquorSemicolonEntityName[] = {'r', 'd', 'q', 'u', 'o', 'r', ';'};
static const UChar rdshSemicolonEntityName[] = {'r', 'd', 's', 'h', ';'};
static const UChar realSemicolonEntityName[] = {'r', 'e', 'a', 'l', ';'};
static const UChar realineSemicolonEntityName[] = {'r', 'e', 'a', 'l', 'i', 'n', 'e', ';'};
static const UChar realpartSemicolonEntityName[] = {'r', 'e', 'a', 'l', 'p', 'a', 'r', 't', ';'};
static const UChar realsSemicolonEntityName[] = {'r', 'e', 'a', 'l', 's', ';'};
static const UChar rectSemicolonEntityName[] = {'r', 'e', 'c', 't', ';'};
static const UChar regEntityName[] = {'r', 'e', 'g'};
static const UChar regSemicolonEntityName[] = {'r', 'e', 'g', ';'};
static const UChar rfishtSemicolonEntityName[] = {'r', 'f', 'i', 's', 'h', 't', ';'};
static const UChar rfloorSemicolonEntityName[] = {'r', 'f', 'l', 'o', 'o', 'r', ';'};
static const UChar rfrSemicolonEntityName[] = {'r', 'f', 'r', ';'};
static const UChar rhardSemicolonEntityName[] = {'r', 'h', 'a', 'r', 'd', ';'};
static const UChar rharuSemicolonEntityName[] = {'r', 'h', 'a', 'r', 'u', ';'};
static const UChar rharulSemicolonEntityName[] = {'r', 'h', 'a', 'r', 'u', 'l', ';'};
static const UChar rhoSemicolonEntityName[] = {'r', 'h', 'o', ';'};
static const UChar rhovSemicolonEntityName[] = {'r', 'h', 'o', 'v', ';'};
static const UChar rightarrowSemicolonEntityName[] = {'r', 'i', 'g', 'h', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar rightarrowtailSemicolonEntityName[] = {'r', 'i', 'g', 'h', 't', 'a', 'r', 'r', 'o', 'w', 't', 'a', 'i', 'l', ';'};
static const UChar rightharpoondownSemicolonEntityName[] = {'r', 'i', 'g', 'h', 't', 'h', 'a', 'r', 'p', 'o', 'o', 'n', 'd', 'o', 'w', 'n', ';'};
static const UChar rightharpoonupSemicolonEntityName[] = {'r', 'i', 'g', 'h', 't', 'h', 'a', 'r', 'p', 'o', 'o', 'n', 'u', 'p', ';'};
static const UChar rightleftarrowsSemicolonEntityName[] = {'r', 'i', 'g', 'h', 't', 'l', 'e', 'f', 't', 'a', 'r', 'r', 'o', 'w', 's', ';'};
static const UChar rightleftharpoonsSemicolonEntityName[] = {'r', 'i', 'g', 'h', 't', 'l', 'e', 'f', 't', 'h', 'a', 'r', 'p', 'o', 'o', 'n', 's', ';'};
static const UChar rightrightarrowsSemicolonEntityName[] = {'r', 'i', 'g', 'h', 't', 'r', 'i', 'g', 'h', 't', 'a', 'r', 'r', 'o', 'w', 's', ';'};
static const UChar rightsquigarrowSemicolonEntityName[] = {'r', 'i', 'g', 'h', 't', 's', 'q', 'u', 'i', 'g', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar rightthreetimesSemicolonEntityName[] = {'r', 'i', 'g', 'h', 't', 't', 'h', 'r', 'e', 'e', 't', 'i', 'm', 'e', 's', ';'};
static const UChar ringSemicolonEntityName[] = {'r', 'i', 'n', 'g', ';'};
static const UChar risingdotseqSemicolonEntityName[] = {'r', 'i', 's', 'i', 'n', 'g', 'd', 'o', 't', 's', 'e', 'q', ';'};
static const UChar rlarrSemicolonEntityName[] = {'r', 'l', 'a', 'r', 'r', ';'};
static const UChar rlharSemicolonEntityName[] = {'r', 'l', 'h', 'a', 'r', ';'};
static const UChar rlmSemicolonEntityName[] = {'r', 'l', 'm', ';'};
static const UChar rmoustSemicolonEntityName[] = {'r', 'm', 'o', 'u', 's', 't', ';'};
static const UChar rmoustacheSemicolonEntityName[] = {'r', 'm', 'o', 'u', 's', 't', 'a', 'c', 'h', 'e', ';'};
static const UChar rnmidSemicolonEntityName[] = {'r', 'n', 'm', 'i', 'd', ';'};
static const UChar roangSemicolonEntityName[] = {'r', 'o', 'a', 'n', 'g', ';'};
static const UChar roarrSemicolonEntityName[] = {'r', 'o', 'a', 'r', 'r', ';'};
static const UChar robrkSemicolonEntityName[] = {'r', 'o', 'b', 'r', 'k', ';'};
static const UChar roparSemicolonEntityName[] = {'r', 'o', 'p', 'a', 'r', ';'};
static const UChar ropfSemicolonEntityName[] = {'r', 'o', 'p', 'f', ';'};
static const UChar roplusSemicolonEntityName[] = {'r', 'o', 'p', 'l', 'u', 's', ';'};
static const UChar rotimesSemicolonEntityName[] = {'r', 'o', 't', 'i', 'm', 'e', 's', ';'};
static const UChar rparSemicolonEntityName[] = {'r', 'p', 'a', 'r', ';'};
static const UChar rpargtSemicolonEntityName[] = {'r', 'p', 'a', 'r', 'g', 't', ';'};
static const UChar rppolintSemicolonEntityName[] = {'r', 'p', 'p', 'o', 'l', 'i', 'n', 't', ';'};
static const UChar rrarrSemicolonEntityName[] = {'r', 'r', 'a', 'r', 'r', ';'};
static const UChar rsaquoSemicolonEntityName[] = {'r', 's', 'a', 'q', 'u', 'o', ';'};
static const UChar rscrSemicolonEntityName[] = {'r', 's', 'c', 'r', ';'};
static const UChar rshSemicolonEntityName[] = {'r', 's', 'h', ';'};
static const UChar rsqbSemicolonEntityName[] = {'r', 's', 'q', 'b', ';'};
static const UChar rsquoSemicolonEntityName[] = {'r', 's', 'q', 'u', 'o', ';'};
static const UChar rsquorSemicolonEntityName[] = {'r', 's', 'q', 'u', 'o', 'r', ';'};
static const UChar rthreeSemicolonEntityName[] = {'r', 't', 'h', 'r', 'e', 'e', ';'};
static const UChar rtimesSemicolonEntityName[] = {'r', 't', 'i', 'm', 'e', 's', ';'};
static const UChar rtriSemicolonEntityName[] = {'r', 't', 'r', 'i', ';'};
static const UChar rtrieSemicolonEntityName[] = {'r', 't', 'r', 'i', 'e', ';'};
static const UChar rtrifSemicolonEntityName[] = {'r', 't', 'r', 'i', 'f', ';'};
static const UChar rtriltriSemicolonEntityName[] = {'r', 't', 'r', 'i', 'l', 't', 'r', 'i', ';'};
static const UChar ruluharSemicolonEntityName[] = {'r', 'u', 'l', 'u', 'h', 'a', 'r', ';'};
static const UChar rxSemicolonEntityName[] = {'r', 'x', ';'};
static const UChar sacuteSemicolonEntityName[] = {'s', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar sbquoSemicolonEntityName[] = {'s', 'b', 'q', 'u', 'o', ';'};
static const UChar scSemicolonEntityName[] = {'s', 'c', ';'};
static const UChar scESemicolonEntityName[] = {'s', 'c', 'E', ';'};
static const UChar scapSemicolonEntityName[] = {'s', 'c', 'a', 'p', ';'};
static const UChar scaronSemicolonEntityName[] = {'s', 'c', 'a', 'r', 'o', 'n', ';'};
static const UChar sccueSemicolonEntityName[] = {'s', 'c', 'c', 'u', 'e', ';'};
static const UChar sceSemicolonEntityName[] = {'s', 'c', 'e', ';'};
static const UChar scedilSemicolonEntityName[] = {'s', 'c', 'e', 'd', 'i', 'l', ';'};
static const UChar scircSemicolonEntityName[] = {'s', 'c', 'i', 'r', 'c', ';'};
static const UChar scnESemicolonEntityName[] = {'s', 'c', 'n', 'E', ';'};
static const UChar scnapSemicolonEntityName[] = {'s', 'c', 'n', 'a', 'p', ';'};
static const UChar scnsimSemicolonEntityName[] = {'s', 'c', 'n', 's', 'i', 'm', ';'};
static const UChar scpolintSemicolonEntityName[] = {'s', 'c', 'p', 'o', 'l', 'i', 'n', 't', ';'};
static const UChar scsimSemicolonEntityName[] = {'s', 'c', 's', 'i', 'm', ';'};
static const UChar scySemicolonEntityName[] = {'s', 'c', 'y', ';'};
static const UChar sdotSemicolonEntityName[] = {'s', 'd', 'o', 't', ';'};
static const UChar sdotbSemicolonEntityName[] = {'s', 'd', 'o', 't', 'b', ';'};
static const UChar sdoteSemicolonEntityName[] = {'s', 'd', 'o', 't', 'e', ';'};
static const UChar seArrSemicolonEntityName[] = {'s', 'e', 'A', 'r', 'r', ';'};
static const UChar searhkSemicolonEntityName[] = {'s', 'e', 'a', 'r', 'h', 'k', ';'};
static const UChar searrSemicolonEntityName[] = {'s', 'e', 'a', 'r', 'r', ';'};
static const UChar searrowSemicolonEntityName[] = {'s', 'e', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar sectEntityName[] = {'s', 'e', 'c', 't'};
static const UChar sectSemicolonEntityName[] = {'s', 'e', 'c', 't', ';'};
static const UChar semiSemicolonEntityName[] = {'s', 'e', 'm', 'i', ';'};
static const UChar seswarSemicolonEntityName[] = {'s', 'e', 's', 'w', 'a', 'r', ';'};
static const UChar setminusSemicolonEntityName[] = {'s', 'e', 't', 'm', 'i', 'n', 'u', 's', ';'};
static const UChar setmnSemicolonEntityName[] = {'s', 'e', 't', 'm', 'n', ';'};
static const UChar sextSemicolonEntityName[] = {'s', 'e', 'x', 't', ';'};
static const UChar sfrSemicolonEntityName[] = {'s', 'f', 'r', ';'};
static const UChar sfrownSemicolonEntityName[] = {'s', 'f', 'r', 'o', 'w', 'n', ';'};
static const UChar sharpSemicolonEntityName[] = {'s', 'h', 'a', 'r', 'p', ';'};
static const UChar shchcySemicolonEntityName[] = {'s', 'h', 'c', 'h', 'c', 'y', ';'};
static const UChar shcySemicolonEntityName[] = {'s', 'h', 'c', 'y', ';'};
static const UChar shortmidSemicolonEntityName[] = {'s', 'h', 'o', 'r', 't', 'm', 'i', 'd', ';'};
static const UChar shortparallelSemicolonEntityName[] = {'s', 'h', 'o', 'r', 't', 'p', 'a', 'r', 'a', 'l', 'l', 'e', 'l', ';'};
static const UChar shyEntityName[] = {'s', 'h', 'y'};
static const UChar shySemicolonEntityName[] = {'s', 'h', 'y', ';'};
static const UChar sigmaSemicolonEntityName[] = {'s', 'i', 'g', 'm', 'a', ';'};
static const UChar sigmafSemicolonEntityName[] = {'s', 'i', 'g', 'm', 'a', 'f', ';'};
static const UChar sigmavSemicolonEntityName[] = {'s', 'i', 'g', 'm', 'a', 'v', ';'};
static const UChar simSemicolonEntityName[] = {'s', 'i', 'm', ';'};
static const UChar simdotSemicolonEntityName[] = {'s', 'i', 'm', 'd', 'o', 't', ';'};
static const UChar simeSemicolonEntityName[] = {'s', 'i', 'm', 'e', ';'};
static const UChar simeqSemicolonEntityName[] = {'s', 'i', 'm', 'e', 'q', ';'};
static const UChar simgSemicolonEntityName[] = {'s', 'i', 'm', 'g', ';'};
static const UChar simgESemicolonEntityName[] = {'s', 'i', 'm', 'g', 'E', ';'};
static const UChar simlSemicolonEntityName[] = {'s', 'i', 'm', 'l', ';'};
static const UChar simlESemicolonEntityName[] = {'s', 'i', 'm', 'l', 'E', ';'};
static const UChar simneSemicolonEntityName[] = {'s', 'i', 'm', 'n', 'e', ';'};
static const UChar simplusSemicolonEntityName[] = {'s', 'i', 'm', 'p', 'l', 'u', 's', ';'};
static const UChar simrarrSemicolonEntityName[] = {'s', 'i', 'm', 'r', 'a', 'r', 'r', ';'};
static const UChar slarrSemicolonEntityName[] = {'s', 'l', 'a', 'r', 'r', ';'};
static const UChar smallsetminusSemicolonEntityName[] = {'s', 'm', 'a', 'l', 'l', 's', 'e', 't', 'm', 'i', 'n', 'u', 's', ';'};
static const UChar smashpSemicolonEntityName[] = {'s', 'm', 'a', 's', 'h', 'p', ';'};
static const UChar smeparslSemicolonEntityName[] = {'s', 'm', 'e', 'p', 'a', 'r', 's', 'l', ';'};
static const UChar smidSemicolonEntityName[] = {'s', 'm', 'i', 'd', ';'};
static const UChar smileSemicolonEntityName[] = {'s', 'm', 'i', 'l', 'e', ';'};
static const UChar smtSemicolonEntityName[] = {'s', 'm', 't', ';'};
static const UChar smteSemicolonEntityName[] = {'s', 'm', 't', 'e', ';'};
static const UChar softcySemicolonEntityName[] = {'s', 'o', 'f', 't', 'c', 'y', ';'};
static const UChar solSemicolonEntityName[] = {'s', 'o', 'l', ';'};
static const UChar solbSemicolonEntityName[] = {'s', 'o', 'l', 'b', ';'};
static const UChar solbarSemicolonEntityName[] = {'s', 'o', 'l', 'b', 'a', 'r', ';'};
static const UChar sopfSemicolonEntityName[] = {'s', 'o', 'p', 'f', ';'};
static const UChar spadesSemicolonEntityName[] = {'s', 'p', 'a', 'd', 'e', 's', ';'};
static const UChar spadesuitSemicolonEntityName[] = {'s', 'p', 'a', 'd', 'e', 's', 'u', 'i', 't', ';'};
static const UChar sparSemicolonEntityName[] = {'s', 'p', 'a', 'r', ';'};
static const UChar sqcapSemicolonEntityName[] = {'s', 'q', 'c', 'a', 'p', ';'};
static const UChar sqcupSemicolonEntityName[] = {'s', 'q', 'c', 'u', 'p', ';'};
static const UChar sqsubSemicolonEntityName[] = {'s', 'q', 's', 'u', 'b', ';'};
static const UChar sqsubeSemicolonEntityName[] = {'s', 'q', 's', 'u', 'b', 'e', ';'};
static const UChar sqsubsetSemicolonEntityName[] = {'s', 'q', 's', 'u', 'b', 's', 'e', 't', ';'};
static const UChar sqsubseteqSemicolonEntityName[] = {'s', 'q', 's', 'u', 'b', 's', 'e', 't', 'e', 'q', ';'};
static const UChar sqsupSemicolonEntityName[] = {'s', 'q', 's', 'u', 'p', ';'};
static const UChar sqsupeSemicolonEntityName[] = {'s', 'q', 's', 'u', 'p', 'e', ';'};
static const UChar sqsupsetSemicolonEntityName[] = {'s', 'q', 's', 'u', 'p', 's', 'e', 't', ';'};
static const UChar sqsupseteqSemicolonEntityName[] = {'s', 'q', 's', 'u', 'p', 's', 'e', 't', 'e', 'q', ';'};
static const UChar squSemicolonEntityName[] = {'s', 'q', 'u', ';'};
static const UChar squareSemicolonEntityName[] = {'s', 'q', 'u', 'a', 'r', 'e', ';'};
static const UChar squarfSemicolonEntityName[] = {'s', 'q', 'u', 'a', 'r', 'f', ';'};
static const UChar squfSemicolonEntityName[] = {'s', 'q', 'u', 'f', ';'};
static const UChar srarrSemicolonEntityName[] = {'s', 'r', 'a', 'r', 'r', ';'};
static const UChar sscrSemicolonEntityName[] = {'s', 's', 'c', 'r', ';'};
static const UChar ssetmnSemicolonEntityName[] = {'s', 's', 'e', 't', 'm', 'n', ';'};
static const UChar ssmileSemicolonEntityName[] = {'s', 's', 'm', 'i', 'l', 'e', ';'};
static const UChar sstarfSemicolonEntityName[] = {'s', 's', 't', 'a', 'r', 'f', ';'};
static const UChar starSemicolonEntityName[] = {'s', 't', 'a', 'r', ';'};
static const UChar starfSemicolonEntityName[] = {'s', 't', 'a', 'r', 'f', ';'};
static const UChar straightepsilonSemicolonEntityName[] = {'s', 't', 'r', 'a', 'i', 'g', 'h', 't', 'e', 'p', 's', 'i', 'l', 'o', 'n', ';'};
static const UChar straightphiSemicolonEntityName[] = {'s', 't', 'r', 'a', 'i', 'g', 'h', 't', 'p', 'h', 'i', ';'};
static const UChar strnsSemicolonEntityName[] = {'s', 't', 'r', 'n', 's', ';'};
static const UChar subSemicolonEntityName[] = {'s', 'u', 'b', ';'};
static const UChar subESemicolonEntityName[] = {'s', 'u', 'b', 'E', ';'};
static const UChar subdotSemicolonEntityName[] = {'s', 'u', 'b', 'd', 'o', 't', ';'};
static const UChar subeSemicolonEntityName[] = {'s', 'u', 'b', 'e', ';'};
static const UChar subedotSemicolonEntityName[] = {'s', 'u', 'b', 'e', 'd', 'o', 't', ';'};
static const UChar submultSemicolonEntityName[] = {'s', 'u', 'b', 'm', 'u', 'l', 't', ';'};
static const UChar subnESemicolonEntityName[] = {'s', 'u', 'b', 'n', 'E', ';'};
static const UChar subneSemicolonEntityName[] = {'s', 'u', 'b', 'n', 'e', ';'};
static const UChar subplusSemicolonEntityName[] = {'s', 'u', 'b', 'p', 'l', 'u', 's', ';'};
static const UChar subrarrSemicolonEntityName[] = {'s', 'u', 'b', 'r', 'a', 'r', 'r', ';'};
static const UChar subsetSemicolonEntityName[] = {'s', 'u', 'b', 's', 'e', 't', ';'};
static const UChar subseteqSemicolonEntityName[] = {'s', 'u', 'b', 's', 'e', 't', 'e', 'q', ';'};
static const UChar subseteqqSemicolonEntityName[] = {'s', 'u', 'b', 's', 'e', 't', 'e', 'q', 'q', ';'};
static const UChar subsetneqSemicolonEntityName[] = {'s', 'u', 'b', 's', 'e', 't', 'n', 'e', 'q', ';'};
static const UChar subsetneqqSemicolonEntityName[] = {'s', 'u', 'b', 's', 'e', 't', 'n', 'e', 'q', 'q', ';'};
static const UChar subsimSemicolonEntityName[] = {'s', 'u', 'b', 's', 'i', 'm', ';'};
static const UChar subsubSemicolonEntityName[] = {'s', 'u', 'b', 's', 'u', 'b', ';'};
static const UChar subsupSemicolonEntityName[] = {'s', 'u', 'b', 's', 'u', 'p', ';'};
static const UChar succSemicolonEntityName[] = {'s', 'u', 'c', 'c', ';'};
static const UChar succapproxSemicolonEntityName[] = {'s', 'u', 'c', 'c', 'a', 'p', 'p', 'r', 'o', 'x', ';'};
static const UChar succcurlyeqSemicolonEntityName[] = {'s', 'u', 'c', 'c', 'c', 'u', 'r', 'l', 'y', 'e', 'q', ';'};
static const UChar succeqSemicolonEntityName[] = {'s', 'u', 'c', 'c', 'e', 'q', ';'};
static const UChar succnapproxSemicolonEntityName[] = {'s', 'u', 'c', 'c', 'n', 'a', 'p', 'p', 'r', 'o', 'x', ';'};
static const UChar succneqqSemicolonEntityName[] = {'s', 'u', 'c', 'c', 'n', 'e', 'q', 'q', ';'};
static const UChar succnsimSemicolonEntityName[] = {'s', 'u', 'c', 'c', 'n', 's', 'i', 'm', ';'};
static const UChar succsimSemicolonEntityName[] = {'s', 'u', 'c', 'c', 's', 'i', 'm', ';'};
static const UChar sumSemicolonEntityName[] = {'s', 'u', 'm', ';'};
static const UChar sungSemicolonEntityName[] = {'s', 'u', 'n', 'g', ';'};
static const UChar sup1EntityName[] = {'s', 'u', 'p', '1'};
static const UChar sup1SemicolonEntityName[] = {'s', 'u', 'p', '1', ';'};
static const UChar sup2EntityName[] = {'s', 'u', 'p', '2'};
static const UChar sup2SemicolonEntityName[] = {'s', 'u', 'p', '2', ';'};
static const UChar sup3EntityName[] = {'s', 'u', 'p', '3'};
static const UChar sup3SemicolonEntityName[] = {'s', 'u', 'p', '3', ';'};
static const UChar supSemicolonEntityName[] = {'s', 'u', 'p', ';'};
static const UChar supESemicolonEntityName[] = {'s', 'u', 'p', 'E', ';'};
static const UChar supdotSemicolonEntityName[] = {'s', 'u', 'p', 'd', 'o', 't', ';'};
static const UChar supdsubSemicolonEntityName[] = {'s', 'u', 'p', 'd', 's', 'u', 'b', ';'};
static const UChar supeSemicolonEntityName[] = {'s', 'u', 'p', 'e', ';'};
static const UChar supedotSemicolonEntityName[] = {'s', 'u', 'p', 'e', 'd', 'o', 't', ';'};
static const UChar suphsolSemicolonEntityName[] = {'s', 'u', 'p', 'h', 's', 'o', 'l', ';'};
static const UChar suphsubSemicolonEntityName[] = {'s', 'u', 'p', 'h', 's', 'u', 'b', ';'};
static const UChar suplarrSemicolonEntityName[] = {'s', 'u', 'p', 'l', 'a', 'r', 'r', ';'};
static const UChar supmultSemicolonEntityName[] = {'s', 'u', 'p', 'm', 'u', 'l', 't', ';'};
static const UChar supnESemicolonEntityName[] = {'s', 'u', 'p', 'n', 'E', ';'};
static const UChar supneSemicolonEntityName[] = {'s', 'u', 'p', 'n', 'e', ';'};
static const UChar supplusSemicolonEntityName[] = {'s', 'u', 'p', 'p', 'l', 'u', 's', ';'};
static const UChar supsetSemicolonEntityName[] = {'s', 'u', 'p', 's', 'e', 't', ';'};
static const UChar supseteqSemicolonEntityName[] = {'s', 'u', 'p', 's', 'e', 't', 'e', 'q', ';'};
static const UChar supseteqqSemicolonEntityName[] = {'s', 'u', 'p', 's', 'e', 't', 'e', 'q', 'q', ';'};
static const UChar supsetneqSemicolonEntityName[] = {'s', 'u', 'p', 's', 'e', 't', 'n', 'e', 'q', ';'};
static const UChar supsetneqqSemicolonEntityName[] = {'s', 'u', 'p', 's', 'e', 't', 'n', 'e', 'q', 'q', ';'};
static const UChar supsimSemicolonEntityName[] = {'s', 'u', 'p', 's', 'i', 'm', ';'};
static const UChar supsubSemicolonEntityName[] = {'s', 'u', 'p', 's', 'u', 'b', ';'};
static const UChar supsupSemicolonEntityName[] = {'s', 'u', 'p', 's', 'u', 'p', ';'};
static const UChar swArrSemicolonEntityName[] = {'s', 'w', 'A', 'r', 'r', ';'};
static const UChar swarhkSemicolonEntityName[] = {'s', 'w', 'a', 'r', 'h', 'k', ';'};
static const UChar swarrSemicolonEntityName[] = {'s', 'w', 'a', 'r', 'r', ';'};
static const UChar swarrowSemicolonEntityName[] = {'s', 'w', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar swnwarSemicolonEntityName[] = {'s', 'w', 'n', 'w', 'a', 'r', ';'};
static const UChar szligEntityName[] = {'s', 'z', 'l', 'i', 'g'};
static const UChar szligSemicolonEntityName[] = {'s', 'z', 'l', 'i', 'g', ';'};
static const UChar targetSemicolonEntityName[] = {'t', 'a', 'r', 'g', 'e', 't', ';'};
static const UChar tauSemicolonEntityName[] = {'t', 'a', 'u', ';'};
static const UChar tbrkSemicolonEntityName[] = {'t', 'b', 'r', 'k', ';'};
static const UChar tcaronSemicolonEntityName[] = {'t', 'c', 'a', 'r', 'o', 'n', ';'};
static const UChar tcedilSemicolonEntityName[] = {'t', 'c', 'e', 'd', 'i', 'l', ';'};
static const UChar tcySemicolonEntityName[] = {'t', 'c', 'y', ';'};
static const UChar tdotSemicolonEntityName[] = {'t', 'd', 'o', 't', ';'};
static const UChar telrecSemicolonEntityName[] = {'t', 'e', 'l', 'r', 'e', 'c', ';'};
static const UChar tfrSemicolonEntityName[] = {'t', 'f', 'r', ';'};
static const UChar there4SemicolonEntityName[] = {'t', 'h', 'e', 'r', 'e', '4', ';'};
static const UChar thereforeSemicolonEntityName[] = {'t', 'h', 'e', 'r', 'e', 'f', 'o', 'r', 'e', ';'};
static const UChar thetaSemicolonEntityName[] = {'t', 'h', 'e', 't', 'a', ';'};
static const UChar thetasymSemicolonEntityName[] = {'t', 'h', 'e', 't', 'a', 's', 'y', 'm', ';'};
static const UChar thetavSemicolonEntityName[] = {'t', 'h', 'e', 't', 'a', 'v', ';'};
static const UChar thickapproxSemicolonEntityName[] = {'t', 'h', 'i', 'c', 'k', 'a', 'p', 'p', 'r', 'o', 'x', ';'};
static const UChar thicksimSemicolonEntityName[] = {'t', 'h', 'i', 'c', 'k', 's', 'i', 'm', ';'};
static const UChar thinspSemicolonEntityName[] = {'t', 'h', 'i', 'n', 's', 'p', ';'};
static const UChar thkapSemicolonEntityName[] = {'t', 'h', 'k', 'a', 'p', ';'};
static const UChar thksimSemicolonEntityName[] = {'t', 'h', 'k', 's', 'i', 'm', ';'};
static const UChar thornEntityName[] = {'t', 'h', 'o', 'r', 'n'};
static const UChar thornSemicolonEntityName[] = {'t', 'h', 'o', 'r', 'n', ';'};
static const UChar tildeSemicolonEntityName[] = {'t', 'i', 'l', 'd', 'e', ';'};
static const UChar timesEntityName[] = {'t', 'i', 'm', 'e', 's'};
static const UChar timesSemicolonEntityName[] = {'t', 'i', 'm', 'e', 's', ';'};
static const UChar timesbSemicolonEntityName[] = {'t', 'i', 'm', 'e', 's', 'b', ';'};
static const UChar timesbarSemicolonEntityName[] = {'t', 'i', 'm', 'e', 's', 'b', 'a', 'r', ';'};
static const UChar timesdSemicolonEntityName[] = {'t', 'i', 'm', 'e', 's', 'd', ';'};
static const UChar tintSemicolonEntityName[] = {'t', 'i', 'n', 't', ';'};
static const UChar toeaSemicolonEntityName[] = {'t', 'o', 'e', 'a', ';'};
static const UChar topSemicolonEntityName[] = {'t', 'o', 'p', ';'};
static const UChar topbotSemicolonEntityName[] = {'t', 'o', 'p', 'b', 'o', 't', ';'};
static const UChar topcirSemicolonEntityName[] = {'t', 'o', 'p', 'c', 'i', 'r', ';'};
static const UChar topfSemicolonEntityName[] = {'t', 'o', 'p', 'f', ';'};
static const UChar topforkSemicolonEntityName[] = {'t', 'o', 'p', 'f', 'o', 'r', 'k', ';'};
static const UChar tosaSemicolonEntityName[] = {'t', 'o', 's', 'a', ';'};
static const UChar tprimeSemicolonEntityName[] = {'t', 'p', 'r', 'i', 'm', 'e', ';'};
static const UChar tradeSemicolonEntityName[] = {'t', 'r', 'a', 'd', 'e', ';'};
static const UChar triangleSemicolonEntityName[] = {'t', 'r', 'i', 'a', 'n', 'g', 'l', 'e', ';'};
static const UChar triangledownSemicolonEntityName[] = {'t', 'r', 'i', 'a', 'n', 'g', 'l', 'e', 'd', 'o', 'w', 'n', ';'};
static const UChar triangleleftSemicolonEntityName[] = {'t', 'r', 'i', 'a', 'n', 'g', 'l', 'e', 'l', 'e', 'f', 't', ';'};
static const UChar trianglelefteqSemicolonEntityName[] = {'t', 'r', 'i', 'a', 'n', 'g', 'l', 'e', 'l', 'e', 'f', 't', 'e', 'q', ';'};
static const UChar triangleqSemicolonEntityName[] = {'t', 'r', 'i', 'a', 'n', 'g', 'l', 'e', 'q', ';'};
static const UChar trianglerightSemicolonEntityName[] = {'t', 'r', 'i', 'a', 'n', 'g', 'l', 'e', 'r', 'i', 'g', 'h', 't', ';'};
static const UChar trianglerighteqSemicolonEntityName[] = {'t', 'r', 'i', 'a', 'n', 'g', 'l', 'e', 'r', 'i', 'g', 'h', 't', 'e', 'q', ';'};
static const UChar tridotSemicolonEntityName[] = {'t', 'r', 'i', 'd', 'o', 't', ';'};
static const UChar trieSemicolonEntityName[] = {'t', 'r', 'i', 'e', ';'};
static const UChar triminusSemicolonEntityName[] = {'t', 'r', 'i', 'm', 'i', 'n', 'u', 's', ';'};
static const UChar triplusSemicolonEntityName[] = {'t', 'r', 'i', 'p', 'l', 'u', 's', ';'};
static const UChar trisbSemicolonEntityName[] = {'t', 'r', 'i', 's', 'b', ';'};
static const UChar tritimeSemicolonEntityName[] = {'t', 'r', 'i', 't', 'i', 'm', 'e', ';'};
static const UChar trpeziumSemicolonEntityName[] = {'t', 'r', 'p', 'e', 'z', 'i', 'u', 'm', ';'};
static const UChar tscrSemicolonEntityName[] = {'t', 's', 'c', 'r', ';'};
static const UChar tscySemicolonEntityName[] = {'t', 's', 'c', 'y', ';'};
static const UChar tshcySemicolonEntityName[] = {'t', 's', 'h', 'c', 'y', ';'};
static const UChar tstrokSemicolonEntityName[] = {'t', 's', 't', 'r', 'o', 'k', ';'};
static const UChar twixtSemicolonEntityName[] = {'t', 'w', 'i', 'x', 't', ';'};
static const UChar twoheadleftarrowSemicolonEntityName[] = {'t', 'w', 'o', 'h', 'e', 'a', 'd', 'l', 'e', 'f', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar twoheadrightarrowSemicolonEntityName[] = {'t', 'w', 'o', 'h', 'e', 'a', 'd', 'r', 'i', 'g', 'h', 't', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar uArrSemicolonEntityName[] = {'u', 'A', 'r', 'r', ';'};
static const UChar uHarSemicolonEntityName[] = {'u', 'H', 'a', 'r', ';'};
static const UChar uacuteEntityName[] = {'u', 'a', 'c', 'u', 't', 'e'};
static const UChar uacuteSemicolonEntityName[] = {'u', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar uarrSemicolonEntityName[] = {'u', 'a', 'r', 'r', ';'};
static const UChar ubrcySemicolonEntityName[] = {'u', 'b', 'r', 'c', 'y', ';'};
static const UChar ubreveSemicolonEntityName[] = {'u', 'b', 'r', 'e', 'v', 'e', ';'};
static const UChar ucircEntityName[] = {'u', 'c', 'i', 'r', 'c'};
static const UChar ucircSemicolonEntityName[] = {'u', 'c', 'i', 'r', 'c', ';'};
static const UChar ucySemicolonEntityName[] = {'u', 'c', 'y', ';'};
static const UChar udarrSemicolonEntityName[] = {'u', 'd', 'a', 'r', 'r', ';'};
static const UChar udblacSemicolonEntityName[] = {'u', 'd', 'b', 'l', 'a', 'c', ';'};
static const UChar udharSemicolonEntityName[] = {'u', 'd', 'h', 'a', 'r', ';'};
static const UChar ufishtSemicolonEntityName[] = {'u', 'f', 'i', 's', 'h', 't', ';'};
static const UChar ufrSemicolonEntityName[] = {'u', 'f', 'r', ';'};
static const UChar ugraveEntityName[] = {'u', 'g', 'r', 'a', 'v', 'e'};
static const UChar ugraveSemicolonEntityName[] = {'u', 'g', 'r', 'a', 'v', 'e', ';'};
static const UChar uharlSemicolonEntityName[] = {'u', 'h', 'a', 'r', 'l', ';'};
static const UChar uharrSemicolonEntityName[] = {'u', 'h', 'a', 'r', 'r', ';'};
static const UChar uhblkSemicolonEntityName[] = {'u', 'h', 'b', 'l', 'k', ';'};
static const UChar ulcornSemicolonEntityName[] = {'u', 'l', 'c', 'o', 'r', 'n', ';'};
static const UChar ulcornerSemicolonEntityName[] = {'u', 'l', 'c', 'o', 'r', 'n', 'e', 'r', ';'};
static const UChar ulcropSemicolonEntityName[] = {'u', 'l', 'c', 'r', 'o', 'p', ';'};
static const UChar ultriSemicolonEntityName[] = {'u', 'l', 't', 'r', 'i', ';'};
static const UChar umacrSemicolonEntityName[] = {'u', 'm', 'a', 'c', 'r', ';'};
static const UChar umlEntityName[] = {'u', 'm', 'l'};
static const UChar umlSemicolonEntityName[] = {'u', 'm', 'l', ';'};
static const UChar uogonSemicolonEntityName[] = {'u', 'o', 'g', 'o', 'n', ';'};
static const UChar uopfSemicolonEntityName[] = {'u', 'o', 'p', 'f', ';'};
static const UChar uparrowSemicolonEntityName[] = {'u', 'p', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar updownarrowSemicolonEntityName[] = {'u', 'p', 'd', 'o', 'w', 'n', 'a', 'r', 'r', 'o', 'w', ';'};
static const UChar upharpoonleftSemicolonEntityName[] = {'u', 'p', 'h', 'a', 'r', 'p', 'o', 'o', 'n', 'l', 'e', 'f', 't', ';'};
static const UChar upharpoonrightSemicolonEntityName[] = {'u', 'p', 'h', 'a', 'r', 'p', 'o', 'o', 'n', 'r', 'i', 'g', 'h', 't', ';'};
static const UChar uplusSemicolonEntityName[] = {'u', 'p', 'l', 'u', 's', ';'};
static const UChar upsiSemicolonEntityName[] = {'u', 'p', 's', 'i', ';'};
static const UChar upsihSemicolonEntityName[] = {'u', 'p', 's', 'i', 'h', ';'};
static const UChar upsilonSemicolonEntityName[] = {'u', 'p', 's', 'i', 'l', 'o', 'n', ';'};
static const UChar upuparrowsSemicolonEntityName[] = {'u', 'p', 'u', 'p', 'a', 'r', 'r', 'o', 'w', 's', ';'};
static const UChar urcornSemicolonEntityName[] = {'u', 'r', 'c', 'o', 'r', 'n', ';'};
static const UChar urcornerSemicolonEntityName[] = {'u', 'r', 'c', 'o', 'r', 'n', 'e', 'r', ';'};
static const UChar urcropSemicolonEntityName[] = {'u', 'r', 'c', 'r', 'o', 'p', ';'};
static const UChar uringSemicolonEntityName[] = {'u', 'r', 'i', 'n', 'g', ';'};
static const UChar urtriSemicolonEntityName[] = {'u', 'r', 't', 'r', 'i', ';'};
static const UChar uscrSemicolonEntityName[] = {'u', 's', 'c', 'r', ';'};
static const UChar utdotSemicolonEntityName[] = {'u', 't', 'd', 'o', 't', ';'};
static const UChar utildeSemicolonEntityName[] = {'u', 't', 'i', 'l', 'd', 'e', ';'};
static const UChar utriSemicolonEntityName[] = {'u', 't', 'r', 'i', ';'};
static const UChar utrifSemicolonEntityName[] = {'u', 't', 'r', 'i', 'f', ';'};
static const UChar uuarrSemicolonEntityName[] = {'u', 'u', 'a', 'r', 'r', ';'};
static const UChar uumlEntityName[] = {'u', 'u', 'm', 'l'};
static const UChar uumlSemicolonEntityName[] = {'u', 'u', 'm', 'l', ';'};
static const UChar uwangleSemicolonEntityName[] = {'u', 'w', 'a', 'n', 'g', 'l', 'e', ';'};
static const UChar vArrSemicolonEntityName[] = {'v', 'A', 'r', 'r', ';'};
static const UChar vBarSemicolonEntityName[] = {'v', 'B', 'a', 'r', ';'};
static const UChar vBarvSemicolonEntityName[] = {'v', 'B', 'a', 'r', 'v', ';'};
static const UChar vDashSemicolonEntityName[] = {'v', 'D', 'a', 's', 'h', ';'};
static const UChar vangrtSemicolonEntityName[] = {'v', 'a', 'n', 'g', 'r', 't', ';'};
static const UChar varepsilonSemicolonEntityName[] = {'v', 'a', 'r', 'e', 'p', 's', 'i', 'l', 'o', 'n', ';'};
static const UChar varkappaSemicolonEntityName[] = {'v', 'a', 'r', 'k', 'a', 'p', 'p', 'a', ';'};
static const UChar varnothingSemicolonEntityName[] = {'v', 'a', 'r', 'n', 'o', 't', 'h', 'i', 'n', 'g', ';'};
static const UChar varphiSemicolonEntityName[] = {'v', 'a', 'r', 'p', 'h', 'i', ';'};
static const UChar varpiSemicolonEntityName[] = {'v', 'a', 'r', 'p', 'i', ';'};
static const UChar varproptoSemicolonEntityName[] = {'v', 'a', 'r', 'p', 'r', 'o', 'p', 't', 'o', ';'};
static const UChar varrSemicolonEntityName[] = {'v', 'a', 'r', 'r', ';'};
static const UChar varrhoSemicolonEntityName[] = {'v', 'a', 'r', 'r', 'h', 'o', ';'};
static const UChar varsigmaSemicolonEntityName[] = {'v', 'a', 'r', 's', 'i', 'g', 'm', 'a', ';'};
static const UChar varthetaSemicolonEntityName[] = {'v', 'a', 'r', 't', 'h', 'e', 't', 'a', ';'};
static const UChar vartriangleleftSemicolonEntityName[] = {'v', 'a', 'r', 't', 'r', 'i', 'a', 'n', 'g', 'l', 'e', 'l', 'e', 'f', 't', ';'};
static const UChar vartrianglerightSemicolonEntityName[] = {'v', 'a', 'r', 't', 'r', 'i', 'a', 'n', 'g', 'l', 'e', 'r', 'i', 'g', 'h', 't', ';'};
static const UChar vcySemicolonEntityName[] = {'v', 'c', 'y', ';'};
static const UChar vdashSemicolonEntityName[] = {'v', 'd', 'a', 's', 'h', ';'};
static const UChar veeSemicolonEntityName[] = {'v', 'e', 'e', ';'};
static const UChar veebarSemicolonEntityName[] = {'v', 'e', 'e', 'b', 'a', 'r', ';'};
static const UChar veeeqSemicolonEntityName[] = {'v', 'e', 'e', 'e', 'q', ';'};
static const UChar vellipSemicolonEntityName[] = {'v', 'e', 'l', 'l', 'i', 'p', ';'};
static const UChar verbarSemicolonEntityName[] = {'v', 'e', 'r', 'b', 'a', 'r', ';'};
static const UChar vertSemicolonEntityName[] = {'v', 'e', 'r', 't', ';'};
static const UChar vfrSemicolonEntityName[] = {'v', 'f', 'r', ';'};
static const UChar vltriSemicolonEntityName[] = {'v', 'l', 't', 'r', 'i', ';'};
static const UChar vopfSemicolonEntityName[] = {'v', 'o', 'p', 'f', ';'};
static const UChar vpropSemicolonEntityName[] = {'v', 'p', 'r', 'o', 'p', ';'};
static const UChar vrtriSemicolonEntityName[] = {'v', 'r', 't', 'r', 'i', ';'};
static const UChar vscrSemicolonEntityName[] = {'v', 's', 'c', 'r', ';'};
static const UChar vzigzagSemicolonEntityName[] = {'v', 'z', 'i', 'g', 'z', 'a', 'g', ';'};
static const UChar wcircSemicolonEntityName[] = {'w', 'c', 'i', 'r', 'c', ';'};
static const UChar wedbarSemicolonEntityName[] = {'w', 'e', 'd', 'b', 'a', 'r', ';'};
static const UChar wedgeSemicolonEntityName[] = {'w', 'e', 'd', 'g', 'e', ';'};
static const UChar wedgeqSemicolonEntityName[] = {'w', 'e', 'd', 'g', 'e', 'q', ';'};
static const UChar weierpSemicolonEntityName[] = {'w', 'e', 'i', 'e', 'r', 'p', ';'};
static const UChar wfrSemicolonEntityName[] = {'w', 'f', 'r', ';'};
static const UChar wopfSemicolonEntityName[] = {'w', 'o', 'p', 'f', ';'};
static const UChar wpSemicolonEntityName[] = {'w', 'p', ';'};
static const UChar wrSemicolonEntityName[] = {'w', 'r', ';'};
static const UChar wreathSemicolonEntityName[] = {'w', 'r', 'e', 'a', 't', 'h', ';'};
static const UChar wscrSemicolonEntityName[] = {'w', 's', 'c', 'r', ';'};
static const UChar xcapSemicolonEntityName[] = {'x', 'c', 'a', 'p', ';'};
static const UChar xcircSemicolonEntityName[] = {'x', 'c', 'i', 'r', 'c', ';'};
static const UChar xcupSemicolonEntityName[] = {'x', 'c', 'u', 'p', ';'};
static const UChar xdtriSemicolonEntityName[] = {'x', 'd', 't', 'r', 'i', ';'};
static const UChar xfrSemicolonEntityName[] = {'x', 'f', 'r', ';'};
static const UChar xhArrSemicolonEntityName[] = {'x', 'h', 'A', 'r', 'r', ';'};
static const UChar xharrSemicolonEntityName[] = {'x', 'h', 'a', 'r', 'r', ';'};
static const UChar xiSemicolonEntityName[] = {'x', 'i', ';'};
static const UChar xlArrSemicolonEntityName[] = {'x', 'l', 'A', 'r', 'r', ';'};
static const UChar xlarrSemicolonEntityName[] = {'x', 'l', 'a', 'r', 'r', ';'};
static const UChar xmapSemicolonEntityName[] = {'x', 'm', 'a', 'p', ';'};
static const UChar xnisSemicolonEntityName[] = {'x', 'n', 'i', 's', ';'};
static const UChar xodotSemicolonEntityName[] = {'x', 'o', 'd', 'o', 't', ';'};
static const UChar xopfSemicolonEntityName[] = {'x', 'o', 'p', 'f', ';'};
static const UChar xoplusSemicolonEntityName[] = {'x', 'o', 'p', 'l', 'u', 's', ';'};
static const UChar xotimeSemicolonEntityName[] = {'x', 'o', 't', 'i', 'm', 'e', ';'};
static const UChar xrArrSemicolonEntityName[] = {'x', 'r', 'A', 'r', 'r', ';'};
static const UChar xrarrSemicolonEntityName[] = {'x', 'r', 'a', 'r', 'r', ';'};
static const UChar xscrSemicolonEntityName[] = {'x', 's', 'c', 'r', ';'};
static const UChar xsqcupSemicolonEntityName[] = {'x', 's', 'q', 'c', 'u', 'p', ';'};
static const UChar xuplusSemicolonEntityName[] = {'x', 'u', 'p', 'l', 'u', 's', ';'};
static const UChar xutriSemicolonEntityName[] = {'x', 'u', 't', 'r', 'i', ';'};
static const UChar xveeSemicolonEntityName[] = {'x', 'v', 'e', 'e', ';'};
static const UChar xwedgeSemicolonEntityName[] = {'x', 'w', 'e', 'd', 'g', 'e', ';'};
static const UChar yacuteEntityName[] = {'y', 'a', 'c', 'u', 't', 'e'};
static const UChar yacuteSemicolonEntityName[] = {'y', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar yacySemicolonEntityName[] = {'y', 'a', 'c', 'y', ';'};
static const UChar ycircSemicolonEntityName[] = {'y', 'c', 'i', 'r', 'c', ';'};
static const UChar ycySemicolonEntityName[] = {'y', 'c', 'y', ';'};
static const UChar yenEntityName[] = {'y', 'e', 'n'};
static const UChar yenSemicolonEntityName[] = {'y', 'e', 'n', ';'};
static const UChar yfrSemicolonEntityName[] = {'y', 'f', 'r', ';'};
static const UChar yicySemicolonEntityName[] = {'y', 'i', 'c', 'y', ';'};
static const UChar yopfSemicolonEntityName[] = {'y', 'o', 'p', 'f', ';'};
static const UChar yscrSemicolonEntityName[] = {'y', 's', 'c', 'r', ';'};
static const UChar yucySemicolonEntityName[] = {'y', 'u', 'c', 'y', ';'};
static const UChar yumlEntityName[] = {'y', 'u', 'm', 'l'};
static const UChar yumlSemicolonEntityName[] = {'y', 'u', 'm', 'l', ';'};
static const UChar zacuteSemicolonEntityName[] = {'z', 'a', 'c', 'u', 't', 'e', ';'};
static const UChar zcaronSemicolonEntityName[] = {'z', 'c', 'a', 'r', 'o', 'n', ';'};
static const UChar zcySemicolonEntityName[] = {'z', 'c', 'y', ';'};
static const UChar zdotSemicolonEntityName[] = {'z', 'd', 'o', 't', ';'};
static const UChar zeetrfSemicolonEntityName[] = {'z', 'e', 'e', 't', 'r', 'f', ';'};
static const UChar zetaSemicolonEntityName[] = {'z', 'e', 't', 'a', ';'};
static const UChar zfrSemicolonEntityName[] = {'z', 'f', 'r', ';'};
static const UChar zhcySemicolonEntityName[] = {'z', 'h', 'c', 'y', ';'};
static const UChar zigrarrSemicolonEntityName[] = {'z', 'i', 'g', 'r', 'a', 'r', 'r', ';'};
static const UChar zopfSemicolonEntityName[] = {'z', 'o', 'p', 'f', ';'};
static const UChar zscrSemicolonEntityName[] = {'z', 's', 'c', 'r', ';'};
static const UChar zwjSemicolonEntityName[] = {'z', 'w', 'j', ';'};
static const UChar zwnjSemicolonEntityName[] = {'z', 'w', 'n', 'j', ';'};

static const HTMLEntityTableEntry staticEntityTable[2138] = {
    { AEligEntityName, 5, 0x000C6 },
    { AEligSemicolonEntityName, 6, 0x000C6 },
    { AMPEntityName, 3, 0x00026 },
    { AMPSemicolonEntityName, 4, 0x00026 },
    { AacuteEntityName, 6, 0x000C1 },
    { AacuteSemicolonEntityName, 7, 0x000C1 },
    { AbreveSemicolonEntityName, 7, 0x00102 },
    { AcircEntityName, 5, 0x000C2 },
    { AcircSemicolonEntityName, 6, 0x000C2 },
    { AcySemicolonEntityName, 4, 0x00410 },
    { AfrSemicolonEntityName, 4, 0x1D504 },
    { AgraveEntityName, 6, 0x000C0 },
    { AgraveSemicolonEntityName, 7, 0x000C0 },
    { AlphaSemicolonEntityName, 6, 0x00391 },
    { AmacrSemicolonEntityName, 6, 0x00100 },
    { AndSemicolonEntityName, 4, 0x02A53 },
    { AogonSemicolonEntityName, 6, 0x00104 },
    { AopfSemicolonEntityName, 5, 0x1D538 },
    { ApplyFunctionSemicolonEntityName, 14, 0x02061 },
    { AringEntityName, 5, 0x000C5 },
    { AringSemicolonEntityName, 6, 0x000C5 },
    { AscrSemicolonEntityName, 5, 0x1D49C },
    { AssignSemicolonEntityName, 7, 0x02254 },
    { AtildeEntityName, 6, 0x000C3 },
    { AtildeSemicolonEntityName, 7, 0x000C3 },
    { AumlEntityName, 4, 0x000C4 },
    { AumlSemicolonEntityName, 5, 0x000C4 },
    { BackslashSemicolonEntityName, 10, 0x02216 },
    { BarvSemicolonEntityName, 5, 0x02AE7 },
    { BarwedSemicolonEntityName, 7, 0x02306 },
    { BcySemicolonEntityName, 4, 0x00411 },
    { BecauseSemicolonEntityName, 8, 0x02235 },
    { BernoullisSemicolonEntityName, 11, 0x0212C },
    { BetaSemicolonEntityName, 5, 0x00392 },
    { BfrSemicolonEntityName, 4, 0x1D505 },
    { BopfSemicolonEntityName, 5, 0x1D539 },
    { BreveSemicolonEntityName, 6, 0x002D8 },
    { BscrSemicolonEntityName, 5, 0x0212C },
    { BumpeqSemicolonEntityName, 7, 0x0224E },
    { CHcySemicolonEntityName, 5, 0x00427 },
    { COPYEntityName, 4, 0x000A9 },
    { COPYSemicolonEntityName, 5, 0x000A9 },
    { CacuteSemicolonEntityName, 7, 0x00106 },
    { CapSemicolonEntityName, 4, 0x022D2 },
    { CapitalDifferentialDSemicolonEntityName, 21, 0x02145 },
    { CayleysSemicolonEntityName, 8, 0x0212D },
    { CcaronSemicolonEntityName, 7, 0x0010C },
    { CcedilEntityName, 6, 0x000C7 },
    { CcedilSemicolonEntityName, 7, 0x000C7 },
    { CcircSemicolonEntityName, 6, 0x00108 },
    { CconintSemicolonEntityName, 8, 0x02230 },
    { CdotSemicolonEntityName, 5, 0x0010A },
    { CedillaSemicolonEntityName, 8, 0x000B8 },
    { CenterDotSemicolonEntityName, 10, 0x000B7 },
    { CfrSemicolonEntityName, 4, 0x0212D },
    { ChiSemicolonEntityName, 4, 0x003A7 },
    { CircleDotSemicolonEntityName, 10, 0x02299 },
    { CircleMinusSemicolonEntityName, 12, 0x02296 },
    { CirclePlusSemicolonEntityName, 11, 0x02295 },
    { CircleTimesSemicolonEntityName, 12, 0x02297 },
    { ClockwiseContourIntegralSemicolonEntityName, 25, 0x02232 },
    { CloseCurlyDoubleQuoteSemicolonEntityName, 22, 0x0201D },
    { CloseCurlyQuoteSemicolonEntityName, 16, 0x02019 },
    { ColonSemicolonEntityName, 6, 0x02237 },
    { ColoneSemicolonEntityName, 7, 0x02A74 },
    { CongruentSemicolonEntityName, 10, 0x02261 },
    { ConintSemicolonEntityName, 7, 0x0222F },
    { ContourIntegralSemicolonEntityName, 16, 0x0222E },
    { CopfSemicolonEntityName, 5, 0x02102 },
    { CoproductSemicolonEntityName, 10, 0x02210 },
    { CounterClockwiseContourIntegralSemicolonEntityName, 32, 0x02233 },
    { CrossSemicolonEntityName, 6, 0x02A2F },
    { CscrSemicolonEntityName, 5, 0x1D49E },
    { CupSemicolonEntityName, 4, 0x022D3 },
    { CupCapSemicolonEntityName, 7, 0x0224D },
    { DDSemicolonEntityName, 3, 0x02145 },
    { DDotrahdSemicolonEntityName, 9, 0x02911 },
    { DJcySemicolonEntityName, 5, 0x00402 },
    { DScySemicolonEntityName, 5, 0x00405 },
    { DZcySemicolonEntityName, 5, 0x0040F },
    { DaggerSemicolonEntityName, 7, 0x02021 },
    { DarrSemicolonEntityName, 5, 0x021A1 },
    { DashvSemicolonEntityName, 6, 0x02AE4 },
    { DcaronSemicolonEntityName, 7, 0x0010E },
    { DcySemicolonEntityName, 4, 0x00414 },
    { DelSemicolonEntityName, 4, 0x02207 },
    { DeltaSemicolonEntityName, 6, 0x00394 },
    { DfrSemicolonEntityName, 4, 0x1D507 },
    { DiacriticalAcuteSemicolonEntityName, 17, 0x000B4 },
    { DiacriticalDotSemicolonEntityName, 15, 0x002D9 },
    { DiacriticalDoubleAcuteSemicolonEntityName, 23, 0x002DD },
    { DiacriticalGraveSemicolonEntityName, 17, 0x00060 },
    { DiacriticalTildeSemicolonEntityName, 17, 0x002DC },
    { DiamondSemicolonEntityName, 8, 0x022C4 },
    { DifferentialDSemicolonEntityName, 14, 0x02146 },
    { DopfSemicolonEntityName, 5, 0x1D53B },
    { DotSemicolonEntityName, 4, 0x000A8 },
    { DotDotSemicolonEntityName, 7, 0x020DC },
    { DotEqualSemicolonEntityName, 9, 0x02250 },
    { DoubleContourIntegralSemicolonEntityName, 22, 0x0222F },
    { DoubleDotSemicolonEntityName, 10, 0x000A8 },
    { DoubleDownArrowSemicolonEntityName, 16, 0x021D3 },
    { DoubleLeftArrowSemicolonEntityName, 16, 0x021D0 },
    { DoubleLeftRightArrowSemicolonEntityName, 21, 0x021D4 },
    { DoubleLeftTeeSemicolonEntityName, 14, 0x02AE4 },
    { DoubleLongLeftArrowSemicolonEntityName, 20, 0x027F8 },
    { DoubleLongLeftRightArrowSemicolonEntityName, 25, 0x027FA },
    { DoubleLongRightArrowSemicolonEntityName, 21, 0x027F9 },
    { DoubleRightArrowSemicolonEntityName, 17, 0x021D2 },
    { DoubleRightTeeSemicolonEntityName, 15, 0x022A8 },
    { DoubleUpArrowSemicolonEntityName, 14, 0x021D1 },
    { DoubleUpDownArrowSemicolonEntityName, 18, 0x021D5 },
    { DoubleVerticalBarSemicolonEntityName, 18, 0x02225 },
    { DownArrowSemicolonEntityName, 10, 0x02193 },
    { DownArrowBarSemicolonEntityName, 13, 0x02913 },
    { DownArrowUpArrowSemicolonEntityName, 17, 0x021F5 },
    { DownBreveSemicolonEntityName, 10, 0x00311 },
    { DownLeftRightVectorSemicolonEntityName, 20, 0x02950 },
    { DownLeftTeeVectorSemicolonEntityName, 18, 0x0295E },
    { DownLeftVectorSemicolonEntityName, 15, 0x021BD },
    { DownLeftVectorBarSemicolonEntityName, 18, 0x02956 },
    { DownRightTeeVectorSemicolonEntityName, 19, 0x0295F },
    { DownRightVectorSemicolonEntityName, 16, 0x021C1 },
    { DownRightVectorBarSemicolonEntityName, 19, 0x02957 },
    { DownTeeSemicolonEntityName, 8, 0x022A4 },
    { DownTeeArrowSemicolonEntityName, 13, 0x021A7 },
    { DownarrowSemicolonEntityName, 10, 0x021D3 },
    { DscrSemicolonEntityName, 5, 0x1D49F },
    { DstrokSemicolonEntityName, 7, 0x00110 },
    { ENGSemicolonEntityName, 4, 0x0014A },
    { ETHEntityName, 3, 0x000D0 },
    { ETHSemicolonEntityName, 4, 0x000D0 },
    { EacuteEntityName, 6, 0x000C9 },
    { EacuteSemicolonEntityName, 7, 0x000C9 },
    { EcaronSemicolonEntityName, 7, 0x0011A },
    { EcircEntityName, 5, 0x000CA },
    { EcircSemicolonEntityName, 6, 0x000CA },
    { EcySemicolonEntityName, 4, 0x0042D },
    { EdotSemicolonEntityName, 5, 0x00116 },
    { EfrSemicolonEntityName, 4, 0x1D508 },
    { EgraveEntityName, 6, 0x000C8 },
    { EgraveSemicolonEntityName, 7, 0x000C8 },
    { ElementSemicolonEntityName, 8, 0x02208 },
    { EmacrSemicolonEntityName, 6, 0x00112 },
    { EmptySmallSquareSemicolonEntityName, 17, 0x025FB },
    { EmptyVerySmallSquareSemicolonEntityName, 21, 0x025AB },
    { EogonSemicolonEntityName, 6, 0x00118 },
    { EopfSemicolonEntityName, 5, 0x1D53C },
    { EpsilonSemicolonEntityName, 8, 0x00395 },
    { EqualSemicolonEntityName, 6, 0x02A75 },
    { EqualTildeSemicolonEntityName, 11, 0x02242 },
    { EquilibriumSemicolonEntityName, 12, 0x021CC },
    { EscrSemicolonEntityName, 5, 0x02130 },
    { EsimSemicolonEntityName, 5, 0x02A73 },
    { EtaSemicolonEntityName, 4, 0x00397 },
    { EumlEntityName, 4, 0x000CB },
    { EumlSemicolonEntityName, 5, 0x000CB },
    { ExistsSemicolonEntityName, 7, 0x02203 },
    { ExponentialESemicolonEntityName, 13, 0x02147 },
    { FcySemicolonEntityName, 4, 0x00424 },
    { FfrSemicolonEntityName, 4, 0x1D509 },
    { FilledSmallSquareSemicolonEntityName, 18, 0x025FC },
    { FilledVerySmallSquareSemicolonEntityName, 22, 0x025AA },
    { FopfSemicolonEntityName, 5, 0x1D53D },
    { ForAllSemicolonEntityName, 7, 0x02200 },
    { FouriertrfSemicolonEntityName, 11, 0x02131 },
    { FscrSemicolonEntityName, 5, 0x02131 },
    { GJcySemicolonEntityName, 5, 0x00403 },
    { GTEntityName, 2, 0x0003E },
    { GTSemicolonEntityName, 3, 0x0003E },
    { GammaSemicolonEntityName, 6, 0x00393 },
    { GammadSemicolonEntityName, 7, 0x003DC },
    { GbreveSemicolonEntityName, 7, 0x0011E },
    { GcedilSemicolonEntityName, 7, 0x00122 },
    { GcircSemicolonEntityName, 6, 0x0011C },
    { GcySemicolonEntityName, 4, 0x00413 },
    { GdotSemicolonEntityName, 5, 0x00120 },
    { GfrSemicolonEntityName, 4, 0x1D50A },
    { GgSemicolonEntityName, 3, 0x022D9 },
    { GopfSemicolonEntityName, 5, 0x1D53E },
    { GreaterEqualSemicolonEntityName, 13, 0x02265 },
    { GreaterEqualLessSemicolonEntityName, 17, 0x022DB },
    { GreaterFullEqualSemicolonEntityName, 17, 0x02267 },
    { GreaterGreaterSemicolonEntityName, 15, 0x02AA2 },
    { GreaterLessSemicolonEntityName, 12, 0x02277 },
    { GreaterSlantEqualSemicolonEntityName, 18, 0x02A7E },
    { GreaterTildeSemicolonEntityName, 13, 0x02273 },
    { GscrSemicolonEntityName, 5, 0x1D4A2 },
    { GtSemicolonEntityName, 3, 0x0226B },
    { HARDcySemicolonEntityName, 7, 0x0042A },
    { HacekSemicolonEntityName, 6, 0x002C7 },
    { HatSemicolonEntityName, 4, 0x0005E },
    { HcircSemicolonEntityName, 6, 0x00124 },
    { HfrSemicolonEntityName, 4, 0x0210C },
    { HilbertSpaceSemicolonEntityName, 13, 0x0210B },
    { HopfSemicolonEntityName, 5, 0x0210D },
    { HorizontalLineSemicolonEntityName, 15, 0x02500 },
    { HscrSemicolonEntityName, 5, 0x0210B },
    { HstrokSemicolonEntityName, 7, 0x00126 },
    { HumpDownHumpSemicolonEntityName, 13, 0x0224E },
    { HumpEqualSemicolonEntityName, 10, 0x0224F },
    { IEcySemicolonEntityName, 5, 0x00415 },
    { IJligSemicolonEntityName, 6, 0x00132 },
    { IOcySemicolonEntityName, 5, 0x00401 },
    { IacuteEntityName, 6, 0x000CD },
    { IacuteSemicolonEntityName, 7, 0x000CD },
    { IcircEntityName, 5, 0x000CE },
    { IcircSemicolonEntityName, 6, 0x000CE },
    { IcySemicolonEntityName, 4, 0x00418 },
    { IdotSemicolonEntityName, 5, 0x00130 },
    { IfrSemicolonEntityName, 4, 0x02111 },
    { IgraveEntityName, 6, 0x000CC },
    { IgraveSemicolonEntityName, 7, 0x000CC },
    { ImSemicolonEntityName, 3, 0x02111 },
    { ImacrSemicolonEntityName, 6, 0x0012A },
    { ImaginaryISemicolonEntityName, 11, 0x02148 },
    { ImpliesSemicolonEntityName, 8, 0x021D2 },
    { IntSemicolonEntityName, 4, 0x0222C },
    { IntegralSemicolonEntityName, 9, 0x0222B },
    { IntersectionSemicolonEntityName, 13, 0x022C2 },
    { InvisibleCommaSemicolonEntityName, 15, 0x02063 },
    { InvisibleTimesSemicolonEntityName, 15, 0x02062 },
    { IogonSemicolonEntityName, 6, 0x0012E },
    { IopfSemicolonEntityName, 5, 0x1D540 },
    { IotaSemicolonEntityName, 5, 0x00399 },
    { IscrSemicolonEntityName, 5, 0x02110 },
    { ItildeSemicolonEntityName, 7, 0x00128 },
    { IukcySemicolonEntityName, 6, 0x00406 },
    { IumlEntityName, 4, 0x000CF },
    { IumlSemicolonEntityName, 5, 0x000CF },
    { JcircSemicolonEntityName, 6, 0x00134 },
    { JcySemicolonEntityName, 4, 0x00419 },
    { JfrSemicolonEntityName, 4, 0x1D50D },
    { JopfSemicolonEntityName, 5, 0x1D541 },
    { JscrSemicolonEntityName, 5, 0x1D4A5 },
    { JsercySemicolonEntityName, 7, 0x00408 },
    { JukcySemicolonEntityName, 6, 0x00404 },
    { KHcySemicolonEntityName, 5, 0x00425 },
    { KJcySemicolonEntityName, 5, 0x0040C },
    { KappaSemicolonEntityName, 6, 0x0039A },
    { KcedilSemicolonEntityName, 7, 0x00136 },
    { KcySemicolonEntityName, 4, 0x0041A },
    { KfrSemicolonEntityName, 4, 0x1D50E },
    { KopfSemicolonEntityName, 5, 0x1D542 },
    { KscrSemicolonEntityName, 5, 0x1D4A6 },
    { LJcySemicolonEntityName, 5, 0x00409 },
    { LTEntityName, 2, 0x0003C },
    { LTSemicolonEntityName, 3, 0x0003C },
    { LacuteSemicolonEntityName, 7, 0x00139 },
    { LambdaSemicolonEntityName, 7, 0x0039B },
    { LangSemicolonEntityName, 5, 0x027EA },
    { LaplacetrfSemicolonEntityName, 11, 0x02112 },
    { LarrSemicolonEntityName, 5, 0x0219E },
    { LcaronSemicolonEntityName, 7, 0x0013D },
    { LcedilSemicolonEntityName, 7, 0x0013B },
    { LcySemicolonEntityName, 4, 0x0041B },
    { LeftAngleBracketSemicolonEntityName, 17, 0x027E8 },
    { LeftArrowSemicolonEntityName, 10, 0x02190 },
    { LeftArrowBarSemicolonEntityName, 13, 0x021E4 },
    { LeftArrowRightArrowSemicolonEntityName, 20, 0x021C6 },
    { LeftCeilingSemicolonEntityName, 12, 0x02308 },
    { LeftDoubleBracketSemicolonEntityName, 18, 0x027E6 },
    { LeftDownTeeVectorSemicolonEntityName, 18, 0x02961 },
    { LeftDownVectorSemicolonEntityName, 15, 0x021C3 },
    { LeftDownVectorBarSemicolonEntityName, 18, 0x02959 },
    { LeftFloorSemicolonEntityName, 10, 0x0230A },
    { LeftRightArrowSemicolonEntityName, 15, 0x02194 },
    { LeftRightVectorSemicolonEntityName, 16, 0x0294E },
    { LeftTeeSemicolonEntityName, 8, 0x022A3 },
    { LeftTeeArrowSemicolonEntityName, 13, 0x021A4 },
    { LeftTeeVectorSemicolonEntityName, 14, 0x0295A },
    { LeftTriangleSemicolonEntityName, 13, 0x022B2 },
    { LeftTriangleBarSemicolonEntityName, 16, 0x029CF },
    { LeftTriangleEqualSemicolonEntityName, 18, 0x022B4 },
    { LeftUpDownVectorSemicolonEntityName, 17, 0x02951 },
    { LeftUpTeeVectorSemicolonEntityName, 16, 0x02960 },
    { LeftUpVectorSemicolonEntityName, 13, 0x021BF },
    { LeftUpVectorBarSemicolonEntityName, 16, 0x02958 },
    { LeftVectorSemicolonEntityName, 11, 0x021BC },
    { LeftVectorBarSemicolonEntityName, 14, 0x02952 },
    { LeftarrowSemicolonEntityName, 10, 0x021D0 },
    { LeftrightarrowSemicolonEntityName, 15, 0x021D4 },
    { LessEqualGreaterSemicolonEntityName, 17, 0x022DA },
    { LessFullEqualSemicolonEntityName, 14, 0x02266 },
    { LessGreaterSemicolonEntityName, 12, 0x02276 },
    { LessLessSemicolonEntityName, 9, 0x02AA1 },
    { LessSlantEqualSemicolonEntityName, 15, 0x02A7D },
    { LessTildeSemicolonEntityName, 10, 0x02272 },
    { LfrSemicolonEntityName, 4, 0x1D50F },
    { LlSemicolonEntityName, 3, 0x022D8 },
    { LleftarrowSemicolonEntityName, 11, 0x021DA },
    { LmidotSemicolonEntityName, 7, 0x0013F },
    { LongLeftArrowSemicolonEntityName, 14, 0x027F5 },
    { LongLeftRightArrowSemicolonEntityName, 19, 0x027F7 },
    { LongRightArrowSemicolonEntityName, 15, 0x027F6 },
    { LongleftarrowSemicolonEntityName, 14, 0x027F8 },
    { LongleftrightarrowSemicolonEntityName, 19, 0x027FA },
    { LongrightarrowSemicolonEntityName, 15, 0x027F9 },
    { LopfSemicolonEntityName, 5, 0x1D543 },
    { LowerLeftArrowSemicolonEntityName, 15, 0x02199 },
    { LowerRightArrowSemicolonEntityName, 16, 0x02198 },
    { LscrSemicolonEntityName, 5, 0x02112 },
    { LshSemicolonEntityName, 4, 0x021B0 },
    { LstrokSemicolonEntityName, 7, 0x00141 },
    { LtSemicolonEntityName, 3, 0x0226A },
    { MapSemicolonEntityName, 4, 0x02905 },
    { McySemicolonEntityName, 4, 0x0041C },
    { MediumSpaceSemicolonEntityName, 12, 0x0205F },
    { MellintrfSemicolonEntityName, 10, 0x02133 },
    { MfrSemicolonEntityName, 4, 0x1D510 },
    { MinusPlusSemicolonEntityName, 10, 0x02213 },
    { MopfSemicolonEntityName, 5, 0x1D544 },
    { MscrSemicolonEntityName, 5, 0x02133 },
    { MuSemicolonEntityName, 3, 0x0039C },
    { NJcySemicolonEntityName, 5, 0x0040A },
    { NacuteSemicolonEntityName, 7, 0x00143 },
    { NcaronSemicolonEntityName, 7, 0x00147 },
    { NcedilSemicolonEntityName, 7, 0x00145 },
    { NcySemicolonEntityName, 4, 0x0041D },
    { NegativeMediumSpaceSemicolonEntityName, 20, 0x0200B },
    { NegativeThickSpaceSemicolonEntityName, 19, 0x0200B },
    { NegativeThinSpaceSemicolonEntityName, 18, 0x0200B },
    { NegativeVeryThinSpaceSemicolonEntityName, 22, 0x0200B },
    { NestedGreaterGreaterSemicolonEntityName, 21, 0x0226B },
    { NestedLessLessSemicolonEntityName, 15, 0x0226A },
    { NewLineSemicolonEntityName, 8, 0x0000A },
    { NfrSemicolonEntityName, 4, 0x1D511 },
    { NoBreakSemicolonEntityName, 8, 0x02060 },
    { NonBreakingSpaceSemicolonEntityName, 17, 0x000A0 },
    { NopfSemicolonEntityName, 5, 0x02115 },
    { NotSemicolonEntityName, 4, 0x02AEC },
    { NotCongruentSemicolonEntityName, 13, 0x02262 },
    { NotCupCapSemicolonEntityName, 10, 0x0226D },
    { NotDoubleVerticalBarSemicolonEntityName, 21, 0x02226 },
    { NotElementSemicolonEntityName, 11, 0x02209 },
    { NotEqualSemicolonEntityName, 9, 0x02260 },
    { NotExistsSemicolonEntityName, 10, 0x02204 },
    { NotGreaterSemicolonEntityName, 11, 0x0226F },
    { NotGreaterEqualSemicolonEntityName, 16, 0x02271 },
    { NotGreaterLessSemicolonEntityName, 15, 0x02279 },
    { NotGreaterTildeSemicolonEntityName, 16, 0x02275 },
    { NotLeftTriangleSemicolonEntityName, 16, 0x022EA },
    { NotLeftTriangleEqualSemicolonEntityName, 21, 0x022EC },
    { NotLessSemicolonEntityName, 8, 0x0226E },
    { NotLessEqualSemicolonEntityName, 13, 0x02270 },
    { NotLessGreaterSemicolonEntityName, 15, 0x02278 },
    { NotLessTildeSemicolonEntityName, 13, 0x02274 },
    { NotPrecedesSemicolonEntityName, 12, 0x02280 },
    { NotPrecedesSlantEqualSemicolonEntityName, 22, 0x022E0 },
    { NotReverseElementSemicolonEntityName, 18, 0x0220C },
    { NotRightTriangleSemicolonEntityName, 17, 0x022EB },
    { NotRightTriangleEqualSemicolonEntityName, 22, 0x022ED },
    { NotSquareSubsetEqualSemicolonEntityName, 21, 0x022E2 },
    { NotSquareSupersetEqualSemicolonEntityName, 23, 0x022E3 },
    { NotSubsetEqualSemicolonEntityName, 15, 0x02288 },
    { NotSucceedsSemicolonEntityName, 12, 0x02281 },
    { NotSucceedsSlantEqualSemicolonEntityName, 22, 0x022E1 },
    { NotSupersetEqualSemicolonEntityName, 17, 0x02289 },
    { NotTildeSemicolonEntityName, 9, 0x02241 },
    { NotTildeEqualSemicolonEntityName, 14, 0x02244 },
    { NotTildeFullEqualSemicolonEntityName, 18, 0x02247 },
    { NotTildeTildeSemicolonEntityName, 14, 0x02249 },
    { NotVerticalBarSemicolonEntityName, 15, 0x02224 },
    { NscrSemicolonEntityName, 5, 0x1D4A9 },
    { NtildeEntityName, 6, 0x000D1 },
    { NtildeSemicolonEntityName, 7, 0x000D1 },
    { NuSemicolonEntityName, 3, 0x0039D },
    { OEligSemicolonEntityName, 6, 0x00152 },
    { OacuteEntityName, 6, 0x000D3 },
    { OacuteSemicolonEntityName, 7, 0x000D3 },
    { OcircEntityName, 5, 0x000D4 },
    { OcircSemicolonEntityName, 6, 0x000D4 },
    { OcySemicolonEntityName, 4, 0x0041E },
    { OdblacSemicolonEntityName, 7, 0x00150 },
    { OfrSemicolonEntityName, 4, 0x1D512 },
    { OgraveEntityName, 6, 0x000D2 },
    { OgraveSemicolonEntityName, 7, 0x000D2 },
    { OmacrSemicolonEntityName, 6, 0x0014C },
    { OmegaSemicolonEntityName, 6, 0x003A9 },
    { OmicronSemicolonEntityName, 8, 0x0039F },
    { OopfSemicolonEntityName, 5, 0x1D546 },
    { OpenCurlyDoubleQuoteSemicolonEntityName, 21, 0x0201C },
    { OpenCurlyQuoteSemicolonEntityName, 15, 0x02018 },
    { OrSemicolonEntityName, 3, 0x02A54 },
    { OscrSemicolonEntityName, 5, 0x1D4AA },
    { OslashEntityName, 6, 0x000D8 },
    { OslashSemicolonEntityName, 7, 0x000D8 },
    { OtildeEntityName, 6, 0x000D5 },
    { OtildeSemicolonEntityName, 7, 0x000D5 },
    { OtimesSemicolonEntityName, 7, 0x02A37 },
    { OumlEntityName, 4, 0x000D6 },
    { OumlSemicolonEntityName, 5, 0x000D6 },
    { OverBarSemicolonEntityName, 8, 0x0203E },
    { OverBraceSemicolonEntityName, 10, 0x023DE },
    { OverBracketSemicolonEntityName, 12, 0x023B4 },
    { OverParenthesisSemicolonEntityName, 16, 0x023DC },
    { PartialDSemicolonEntityName, 9, 0x02202 },
    { PcySemicolonEntityName, 4, 0x0041F },
    { PfrSemicolonEntityName, 4, 0x1D513 },
    { PhiSemicolonEntityName, 4, 0x003A6 },
    { PiSemicolonEntityName, 3, 0x003A0 },
    { PlusMinusSemicolonEntityName, 10, 0x000B1 },
    { PoincareplaneSemicolonEntityName, 14, 0x0210C },
    { PopfSemicolonEntityName, 5, 0x02119 },
    { PrSemicolonEntityName, 3, 0x02ABB },
    { PrecedesSemicolonEntityName, 9, 0x0227A },
    { PrecedesEqualSemicolonEntityName, 14, 0x02AAF },
    { PrecedesSlantEqualSemicolonEntityName, 19, 0x0227C },
    { PrecedesTildeSemicolonEntityName, 14, 0x0227E },
    { PrimeSemicolonEntityName, 6, 0x02033 },
    { ProductSemicolonEntityName, 8, 0x0220F },
    { ProportionSemicolonEntityName, 11, 0x02237 },
    { ProportionalSemicolonEntityName, 13, 0x0221D },
    { PscrSemicolonEntityName, 5, 0x1D4AB },
    { PsiSemicolonEntityName, 4, 0x003A8 },
    { QUOTEntityName, 4, 0x00022 },
    { QUOTSemicolonEntityName, 5, 0x00022 },
    { QfrSemicolonEntityName, 4, 0x1D514 },
    { QopfSemicolonEntityName, 5, 0x0211A },
    { QscrSemicolonEntityName, 5, 0x1D4AC },
    { RBarrSemicolonEntityName, 6, 0x02910 },
    { REGEntityName, 3, 0x000AE },
    { REGSemicolonEntityName, 4, 0x000AE },
    { RacuteSemicolonEntityName, 7, 0x00154 },
    { RangSemicolonEntityName, 5, 0x027EB },
    { RarrSemicolonEntityName, 5, 0x021A0 },
    { RarrtlSemicolonEntityName, 7, 0x02916 },
    { RcaronSemicolonEntityName, 7, 0x00158 },
    { RcedilSemicolonEntityName, 7, 0x00156 },
    { RcySemicolonEntityName, 4, 0x00420 },
    { ReSemicolonEntityName, 3, 0x0211C },
    { ReverseElementSemicolonEntityName, 15, 0x0220B },
    { ReverseEquilibriumSemicolonEntityName, 19, 0x021CB },
    { ReverseUpEquilibriumSemicolonEntityName, 21, 0x0296F },
    { RfrSemicolonEntityName, 4, 0x0211C },
    { RhoSemicolonEntityName, 4, 0x003A1 },
    { RightAngleBracketSemicolonEntityName, 18, 0x027E9 },
    { RightArrowSemicolonEntityName, 11, 0x02192 },
    { RightArrowBarSemicolonEntityName, 14, 0x021E5 },
    { RightArrowLeftArrowSemicolonEntityName, 20, 0x021C4 },
    { RightCeilingSemicolonEntityName, 13, 0x02309 },
    { RightDoubleBracketSemicolonEntityName, 19, 0x027E7 },
    { RightDownTeeVectorSemicolonEntityName, 19, 0x0295D },
    { RightDownVectorSemicolonEntityName, 16, 0x021C2 },
    { RightDownVectorBarSemicolonEntityName, 19, 0x02955 },
    { RightFloorSemicolonEntityName, 11, 0x0230B },
    { RightTeeSemicolonEntityName, 9, 0x022A2 },
    { RightTeeArrowSemicolonEntityName, 14, 0x021A6 },
    { RightTeeVectorSemicolonEntityName, 15, 0x0295B },
    { RightTriangleSemicolonEntityName, 14, 0x022B3 },
    { RightTriangleBarSemicolonEntityName, 17, 0x029D0 },
    { RightTriangleEqualSemicolonEntityName, 19, 0x022B5 },
    { RightUpDownVectorSemicolonEntityName, 18, 0x0294F },
    { RightUpTeeVectorSemicolonEntityName, 17, 0x0295C },
    { RightUpVectorSemicolonEntityName, 14, 0x021BE },
    { RightUpVectorBarSemicolonEntityName, 17, 0x02954 },
    { RightVectorSemicolonEntityName, 12, 0x021C0 },
    { RightVectorBarSemicolonEntityName, 15, 0x02953 },
    { RightarrowSemicolonEntityName, 11, 0x021D2 },
    { RopfSemicolonEntityName, 5, 0x0211D },
    { RoundImpliesSemicolonEntityName, 13, 0x02970 },
    { RrightarrowSemicolonEntityName, 12, 0x021DB },
    { RscrSemicolonEntityName, 5, 0x0211B },
    { RshSemicolonEntityName, 4, 0x021B1 },
    { RuleDelayedSemicolonEntityName, 12, 0x029F4 },
    { SHCHcySemicolonEntityName, 7, 0x00429 },
    { SHcySemicolonEntityName, 5, 0x00428 },
    { SOFTcySemicolonEntityName, 7, 0x0042C },
    { SacuteSemicolonEntityName, 7, 0x0015A },
    { ScSemicolonEntityName, 3, 0x02ABC },
    { ScaronSemicolonEntityName, 7, 0x00160 },
    { ScedilSemicolonEntityName, 7, 0x0015E },
    { ScircSemicolonEntityName, 6, 0x0015C },
    { ScySemicolonEntityName, 4, 0x00421 },
    { SfrSemicolonEntityName, 4, 0x1D516 },
    { ShortDownArrowSemicolonEntityName, 15, 0x02193 },
    { ShortLeftArrowSemicolonEntityName, 15, 0x02190 },
    { ShortRightArrowSemicolonEntityName, 16, 0x02192 },
    { ShortUpArrowSemicolonEntityName, 13, 0x02191 },
    { SigmaSemicolonEntityName, 6, 0x003A3 },
    { SmallCircleSemicolonEntityName, 12, 0x02218 },
    { SopfSemicolonEntityName, 5, 0x1D54A },
    { SqrtSemicolonEntityName, 5, 0x0221A },
    { SquareSemicolonEntityName, 7, 0x025A1 },
    { SquareIntersectionSemicolonEntityName, 19, 0x02293 },
    { SquareSubsetSemicolonEntityName, 13, 0x0228F },
    { SquareSubsetEqualSemicolonEntityName, 18, 0x02291 },
    { SquareSupersetSemicolonEntityName, 15, 0x02290 },
    { SquareSupersetEqualSemicolonEntityName, 20, 0x02292 },
    { SquareUnionSemicolonEntityName, 12, 0x02294 },
    { SscrSemicolonEntityName, 5, 0x1D4AE },
    { StarSemicolonEntityName, 5, 0x022C6 },
    { SubSemicolonEntityName, 4, 0x022D0 },
    { SubsetSemicolonEntityName, 7, 0x022D0 },
    { SubsetEqualSemicolonEntityName, 12, 0x02286 },
    { SucceedsSemicolonEntityName, 9, 0x0227B },
    { SucceedsEqualSemicolonEntityName, 14, 0x02AB0 },
    { SucceedsSlantEqualSemicolonEntityName, 19, 0x0227D },
    { SucceedsTildeSemicolonEntityName, 14, 0x0227F },
    { SuchThatSemicolonEntityName, 9, 0x0220B },
    { SumSemicolonEntityName, 4, 0x02211 },
    { SupSemicolonEntityName, 4, 0x022D1 },
    { SupersetSemicolonEntityName, 9, 0x02283 },
    { SupersetEqualSemicolonEntityName, 14, 0x02287 },
    { SupsetSemicolonEntityName, 7, 0x022D1 },
    { THORNEntityName, 5, 0x000DE },
    { THORNSemicolonEntityName, 6, 0x000DE },
    { TRADESemicolonEntityName, 6, 0x02122 },
    { TSHcySemicolonEntityName, 6, 0x0040B },
    { TScySemicolonEntityName, 5, 0x00426 },
    { TabSemicolonEntityName, 4, 0x00009 },
    { TauSemicolonEntityName, 4, 0x003A4 },
    { TcaronSemicolonEntityName, 7, 0x00164 },
    { TcedilSemicolonEntityName, 7, 0x00162 },
    { TcySemicolonEntityName, 4, 0x00422 },
    { TfrSemicolonEntityName, 4, 0x1D517 },
    { ThereforeSemicolonEntityName, 10, 0x02234 },
    { ThetaSemicolonEntityName, 6, 0x00398 },
    { ThinSpaceSemicolonEntityName, 10, 0x02009 },
    { TildeSemicolonEntityName, 6, 0x0223C },
    { TildeEqualSemicolonEntityName, 11, 0x02243 },
    { TildeFullEqualSemicolonEntityName, 15, 0x02245 },
    { TildeTildeSemicolonEntityName, 11, 0x02248 },
    { TopfSemicolonEntityName, 5, 0x1D54B },
    { TripleDotSemicolonEntityName, 10, 0x020DB },
    { TscrSemicolonEntityName, 5, 0x1D4AF },
    { TstrokSemicolonEntityName, 7, 0x00166 },
    { UacuteEntityName, 6, 0x000DA },
    { UacuteSemicolonEntityName, 7, 0x000DA },
    { UarrSemicolonEntityName, 5, 0x0219F },
    { UarrocirSemicolonEntityName, 9, 0x02949 },
    { UbrcySemicolonEntityName, 6, 0x0040E },
    { UbreveSemicolonEntityName, 7, 0x0016C },
    { UcircEntityName, 5, 0x000DB },
    { UcircSemicolonEntityName, 6, 0x000DB },
    { UcySemicolonEntityName, 4, 0x00423 },
    { UdblacSemicolonEntityName, 7, 0x00170 },
    { UfrSemicolonEntityName, 4, 0x1D518 },
    { UgraveEntityName, 6, 0x000D9 },
    { UgraveSemicolonEntityName, 7, 0x000D9 },
    { UmacrSemicolonEntityName, 6, 0x0016A },
    { UnderBarSemicolonEntityName, 9, 0x0005F },
    { UnderBraceSemicolonEntityName, 11, 0x023DF },
    { UnderBracketSemicolonEntityName, 13, 0x023B5 },
    { UnderParenthesisSemicolonEntityName, 17, 0x023DD },
    { UnionSemicolonEntityName, 6, 0x022C3 },
    { UnionPlusSemicolonEntityName, 10, 0x0228E },
    { UogonSemicolonEntityName, 6, 0x00172 },
    { UopfSemicolonEntityName, 5, 0x1D54C },
    { UpArrowSemicolonEntityName, 8, 0x02191 },
    { UpArrowBarSemicolonEntityName, 11, 0x02912 },
    { UpArrowDownArrowSemicolonEntityName, 17, 0x021C5 },
    { UpDownArrowSemicolonEntityName, 12, 0x02195 },
    { UpEquilibriumSemicolonEntityName, 14, 0x0296E },
    { UpTeeSemicolonEntityName, 6, 0x022A5 },
    { UpTeeArrowSemicolonEntityName, 11, 0x021A5 },
    { UparrowSemicolonEntityName, 8, 0x021D1 },
    { UpdownarrowSemicolonEntityName, 12, 0x021D5 },
    { UpperLeftArrowSemicolonEntityName, 15, 0x02196 },
    { UpperRightArrowSemicolonEntityName, 16, 0x02197 },
    { UpsiSemicolonEntityName, 5, 0x003D2 },
    { UpsilonSemicolonEntityName, 8, 0x003A5 },
    { UringSemicolonEntityName, 6, 0x0016E },
    { UscrSemicolonEntityName, 5, 0x1D4B0 },
    { UtildeSemicolonEntityName, 7, 0x00168 },
    { UumlEntityName, 4, 0x000DC },
    { UumlSemicolonEntityName, 5, 0x000DC },
    { VDashSemicolonEntityName, 6, 0x022AB },
    { VbarSemicolonEntityName, 5, 0x02AEB },
    { VcySemicolonEntityName, 4, 0x00412 },
    { VdashSemicolonEntityName, 6, 0x022A9 },
    { VdashlSemicolonEntityName, 7, 0x02AE6 },
    { VeeSemicolonEntityName, 4, 0x022C1 },
    { VerbarSemicolonEntityName, 7, 0x02016 },
    { VertSemicolonEntityName, 5, 0x02016 },
    { VerticalBarSemicolonEntityName, 12, 0x02223 },
    { VerticalLineSemicolonEntityName, 13, 0x0007C },
    { VerticalSeparatorSemicolonEntityName, 18, 0x02758 },
    { VerticalTildeSemicolonEntityName, 14, 0x02240 },
    { VeryThinSpaceSemicolonEntityName, 14, 0x0200A },
    { VfrSemicolonEntityName, 4, 0x1D519 },
    { VopfSemicolonEntityName, 5, 0x1D54D },
    { VscrSemicolonEntityName, 5, 0x1D4B1 },
    { VvdashSemicolonEntityName, 7, 0x022AA },
    { WcircSemicolonEntityName, 6, 0x00174 },
    { WedgeSemicolonEntityName, 6, 0x022C0 },
    { WfrSemicolonEntityName, 4, 0x1D51A },
    { WopfSemicolonEntityName, 5, 0x1D54E },
    { WscrSemicolonEntityName, 5, 0x1D4B2 },
    { XfrSemicolonEntityName, 4, 0x1D51B },
    { XiSemicolonEntityName, 3, 0x0039E },
    { XopfSemicolonEntityName, 5, 0x1D54F },
    { XscrSemicolonEntityName, 5, 0x1D4B3 },
    { YAcySemicolonEntityName, 5, 0x0042F },
    { YIcySemicolonEntityName, 5, 0x00407 },
    { YUcySemicolonEntityName, 5, 0x0042E },
    { YacuteEntityName, 6, 0x000DD },
    { YacuteSemicolonEntityName, 7, 0x000DD },
    { YcircSemicolonEntityName, 6, 0x00176 },
    { YcySemicolonEntityName, 4, 0x0042B },
    { YfrSemicolonEntityName, 4, 0x1D51C },
    { YopfSemicolonEntityName, 5, 0x1D550 },
    { YscrSemicolonEntityName, 5, 0x1D4B4 },
    { YumlSemicolonEntityName, 5, 0x00178 },
    { ZHcySemicolonEntityName, 5, 0x00416 },
    { ZacuteSemicolonEntityName, 7, 0x00179 },
    { ZcaronSemicolonEntityName, 7, 0x0017D },
    { ZcySemicolonEntityName, 4, 0x00417 },
    { ZdotSemicolonEntityName, 5, 0x0017B },
    { ZeroWidthSpaceSemicolonEntityName, 15, 0x0200B },
    { ZetaSemicolonEntityName, 5, 0x00396 },
    { ZfrSemicolonEntityName, 4, 0x02128 },
    { ZopfSemicolonEntityName, 5, 0x02124 },
    { ZscrSemicolonEntityName, 5, 0x1D4B5 },
    { aacuteEntityName, 6, 0x000E1 },
    { aacuteSemicolonEntityName, 7, 0x000E1 },
    { abreveSemicolonEntityName, 7, 0x00103 },
    { acSemicolonEntityName, 3, 0x0223E },
    { acdSemicolonEntityName, 4, 0x0223F },
    { acircEntityName, 5, 0x000E2 },
    { acircSemicolonEntityName, 6, 0x000E2 },
    { acuteEntityName, 5, 0x000B4 },
    { acuteSemicolonEntityName, 6, 0x000B4 },
    { acySemicolonEntityName, 4, 0x00430 },
    { aeligEntityName, 5, 0x000E6 },
    { aeligSemicolonEntityName, 6, 0x000E6 },
    { afSemicolonEntityName, 3, 0x02061 },
    { afrSemicolonEntityName, 4, 0x1D51E },
    { agraveEntityName, 6, 0x000E0 },
    { agraveSemicolonEntityName, 7, 0x000E0 },
    { alefsymSemicolonEntityName, 8, 0x02135 },
    { alephSemicolonEntityName, 6, 0x02135 },
    { alphaSemicolonEntityName, 6, 0x003B1 },
    { amacrSemicolonEntityName, 6, 0x00101 },
    { amalgSemicolonEntityName, 6, 0x02A3F },
    { ampEntityName, 3, 0x00026 },
    { ampSemicolonEntityName, 4, 0x00026 },
    { andSemicolonEntityName, 4, 0x02227 },
    { andandSemicolonEntityName, 7, 0x02A55 },
    { anddSemicolonEntityName, 5, 0x02A5C },
    { andslopeSemicolonEntityName, 9, 0x02A58 },
    { andvSemicolonEntityName, 5, 0x02A5A },
    { angSemicolonEntityName, 4, 0x02220 },
    { angeSemicolonEntityName, 5, 0x029A4 },
    { angleSemicolonEntityName, 6, 0x02220 },
    { angmsdSemicolonEntityName, 7, 0x02221 },
    { angmsdaaSemicolonEntityName, 9, 0x029A8 },
    { angmsdabSemicolonEntityName, 9, 0x029A9 },
    { angmsdacSemicolonEntityName, 9, 0x029AA },
    { angmsdadSemicolonEntityName, 9, 0x029AB },
    { angmsdaeSemicolonEntityName, 9, 0x029AC },
    { angmsdafSemicolonEntityName, 9, 0x029AD },
    { angmsdagSemicolonEntityName, 9, 0x029AE },
    { angmsdahSemicolonEntityName, 9, 0x029AF },
    { angrtSemicolonEntityName, 6, 0x0221F },
    { angrtvbSemicolonEntityName, 8, 0x022BE },
    { angrtvbdSemicolonEntityName, 9, 0x0299D },
    { angsphSemicolonEntityName, 7, 0x02222 },
    { angstSemicolonEntityName, 6, 0x000C5 },
    { angzarrSemicolonEntityName, 8, 0x0237C },
    { aogonSemicolonEntityName, 6, 0x00105 },
    { aopfSemicolonEntityName, 5, 0x1D552 },
    { apSemicolonEntityName, 3, 0x02248 },
    { apESemicolonEntityName, 4, 0x02A70 },
    { apacirSemicolonEntityName, 7, 0x02A6F },
    { apeSemicolonEntityName, 4, 0x0224A },
    { apidSemicolonEntityName, 5, 0x0224B },
    { aposSemicolonEntityName, 5, 0x00027 },
    { approxSemicolonEntityName, 7, 0x02248 },
    { approxeqSemicolonEntityName, 9, 0x0224A },
    { aringEntityName, 5, 0x000E5 },
    { aringSemicolonEntityName, 6, 0x000E5 },
    { ascrSemicolonEntityName, 5, 0x1D4B6 },
    { astSemicolonEntityName, 4, 0x0002A },
    { asympSemicolonEntityName, 6, 0x02248 },
    { asympeqSemicolonEntityName, 8, 0x0224D },
    { atildeEntityName, 6, 0x000E3 },
    { atildeSemicolonEntityName, 7, 0x000E3 },
    { aumlEntityName, 4, 0x000E4 },
    { aumlSemicolonEntityName, 5, 0x000E4 },
    { awconintSemicolonEntityName, 9, 0x02233 },
    { awintSemicolonEntityName, 6, 0x02A11 },
    { bNotSemicolonEntityName, 5, 0x02AED },
    { backcongSemicolonEntityName, 9, 0x0224C },
    { backepsilonSemicolonEntityName, 12, 0x003F6 },
    { backprimeSemicolonEntityName, 10, 0x02035 },
    { backsimSemicolonEntityName, 8, 0x0223D },
    { backsimeqSemicolonEntityName, 10, 0x022CD },
    { barveeSemicolonEntityName, 7, 0x022BD },
    { barwedSemicolonEntityName, 7, 0x02305 },
    { barwedgeSemicolonEntityName, 9, 0x02305 },
    { bbrkSemicolonEntityName, 5, 0x023B5 },
    { bbrktbrkSemicolonEntityName, 9, 0x023B6 },
    { bcongSemicolonEntityName, 6, 0x0224C },
    { bcySemicolonEntityName, 4, 0x00431 },
    { bdquoSemicolonEntityName, 6, 0x0201E },
    { becausSemicolonEntityName, 7, 0x02235 },
    { becauseSemicolonEntityName, 8, 0x02235 },
    { bemptyvSemicolonEntityName, 8, 0x029B0 },
    { bepsiSemicolonEntityName, 6, 0x003F6 },
    { bernouSemicolonEntityName, 7, 0x0212C },
    { betaSemicolonEntityName, 5, 0x003B2 },
    { bethSemicolonEntityName, 5, 0x02136 },
    { betweenSemicolonEntityName, 8, 0x0226C },
    { bfrSemicolonEntityName, 4, 0x1D51F },
    { bigcapSemicolonEntityName, 7, 0x022C2 },
    { bigcircSemicolonEntityName, 8, 0x025EF },
    { bigcupSemicolonEntityName, 7, 0x022C3 },
    { bigodotSemicolonEntityName, 8, 0x02A00 },
    { bigoplusSemicolonEntityName, 9, 0x02A01 },
    { bigotimesSemicolonEntityName, 10, 0x02A02 },
    { bigsqcupSemicolonEntityName, 9, 0x02A06 },
    { bigstarSemicolonEntityName, 8, 0x02605 },
    { bigtriangledownSemicolonEntityName, 16, 0x025BD },
    { bigtriangleupSemicolonEntityName, 14, 0x025B3 },
    { biguplusSemicolonEntityName, 9, 0x02A04 },
    { bigveeSemicolonEntityName, 7, 0x022C1 },
    { bigwedgeSemicolonEntityName, 9, 0x022C0 },
    { bkarowSemicolonEntityName, 7, 0x0290D },
    { blacklozengeSemicolonEntityName, 13, 0x029EB },
    { blacksquareSemicolonEntityName, 12, 0x025AA },
    { blacktriangleSemicolonEntityName, 14, 0x025B4 },
    { blacktriangledownSemicolonEntityName, 18, 0x025BE },
    { blacktriangleleftSemicolonEntityName, 18, 0x025C2 },
    { blacktrianglerightSemicolonEntityName, 19, 0x025B8 },
    { blankSemicolonEntityName, 6, 0x02423 },
    { blk12SemicolonEntityName, 6, 0x02592 },
    { blk14SemicolonEntityName, 6, 0x02591 },
    { blk34SemicolonEntityName, 6, 0x02593 },
    { blockSemicolonEntityName, 6, 0x02588 },
    { bnotSemicolonEntityName, 5, 0x02310 },
    { bopfSemicolonEntityName, 5, 0x1D553 },
    { botSemicolonEntityName, 4, 0x022A5 },
    { bottomSemicolonEntityName, 7, 0x022A5 },
    { bowtieSemicolonEntityName, 7, 0x022C8 },
    { boxDLSemicolonEntityName, 6, 0x02557 },
    { boxDRSemicolonEntityName, 6, 0x02554 },
    { boxDlSemicolonEntityName, 6, 0x02556 },
    { boxDrSemicolonEntityName, 6, 0x02553 },
    { boxHSemicolonEntityName, 5, 0x02550 },
    { boxHDSemicolonEntityName, 6, 0x02566 },
    { boxHUSemicolonEntityName, 6, 0x02569 },
    { boxHdSemicolonEntityName, 6, 0x02564 },
    { boxHuSemicolonEntityName, 6, 0x02567 },
    { boxULSemicolonEntityName, 6, 0x0255D },
    { boxURSemicolonEntityName, 6, 0x0255A },
    { boxUlSemicolonEntityName, 6, 0x0255C },
    { boxUrSemicolonEntityName, 6, 0x02559 },
    { boxVSemicolonEntityName, 5, 0x02551 },
    { boxVHSemicolonEntityName, 6, 0x0256C },
    { boxVLSemicolonEntityName, 6, 0x02563 },
    { boxVRSemicolonEntityName, 6, 0x02560 },
    { boxVhSemicolonEntityName, 6, 0x0256B },
    { boxVlSemicolonEntityName, 6, 0x02562 },
    { boxVrSemicolonEntityName, 6, 0x0255F },
    { boxboxSemicolonEntityName, 7, 0x029C9 },
    { boxdLSemicolonEntityName, 6, 0x02555 },
    { boxdRSemicolonEntityName, 6, 0x02552 },
    { boxdlSemicolonEntityName, 6, 0x02510 },
    { boxdrSemicolonEntityName, 6, 0x0250C },
    { boxhSemicolonEntityName, 5, 0x02500 },
    { boxhDSemicolonEntityName, 6, 0x02565 },
    { boxhUSemicolonEntityName, 6, 0x02568 },
    { boxhdSemicolonEntityName, 6, 0x0252C },
    { boxhuSemicolonEntityName, 6, 0x02534 },
    { boxminusSemicolonEntityName, 9, 0x0229F },
    { boxplusSemicolonEntityName, 8, 0x0229E },
    { boxtimesSemicolonEntityName, 9, 0x022A0 },
    { boxuLSemicolonEntityName, 6, 0x0255B },
    { boxuRSemicolonEntityName, 6, 0x02558 },
    { boxulSemicolonEntityName, 6, 0x02518 },
    { boxurSemicolonEntityName, 6, 0x02514 },
    { boxvSemicolonEntityName, 5, 0x02502 },
    { boxvHSemicolonEntityName, 6, 0x0256A },
    { boxvLSemicolonEntityName, 6, 0x02561 },
    { boxvRSemicolonEntityName, 6, 0x0255E },
    { boxvhSemicolonEntityName, 6, 0x0253C },
    { boxvlSemicolonEntityName, 6, 0x02524 },
    { boxvrSemicolonEntityName, 6, 0x0251C },
    { bprimeSemicolonEntityName, 7, 0x02035 },
    { breveSemicolonEntityName, 6, 0x002D8 },
    { brvbarEntityName, 6, 0x000A6 },
    { brvbarSemicolonEntityName, 7, 0x000A6 },
    { bscrSemicolonEntityName, 5, 0x1D4B7 },
    { bsemiSemicolonEntityName, 6, 0x0204F },
    { bsimSemicolonEntityName, 5, 0x0223D },
    { bsimeSemicolonEntityName, 6, 0x022CD },
    { bsolSemicolonEntityName, 5, 0x0005C },
    { bsolbSemicolonEntityName, 6, 0x029C5 },
    { bsolhsubSemicolonEntityName, 9, 0x027C8 },
    { bullSemicolonEntityName, 5, 0x02022 },
    { bulletSemicolonEntityName, 7, 0x02022 },
    { bumpSemicolonEntityName, 5, 0x0224E },
    { bumpESemicolonEntityName, 6, 0x02AAE },
    { bumpeSemicolonEntityName, 6, 0x0224F },
    { bumpeqSemicolonEntityName, 7, 0x0224F },
    { cacuteSemicolonEntityName, 7, 0x00107 },
    { capSemicolonEntityName, 4, 0x02229 },
    { capandSemicolonEntityName, 7, 0x02A44 },
    { capbrcupSemicolonEntityName, 9, 0x02A49 },
    { capcapSemicolonEntityName, 7, 0x02A4B },
    { capcupSemicolonEntityName, 7, 0x02A47 },
    { capdotSemicolonEntityName, 7, 0x02A40 },
    { caretSemicolonEntityName, 6, 0x02041 },
    { caronSemicolonEntityName, 6, 0x002C7 },
    { ccapsSemicolonEntityName, 6, 0x02A4D },
    { ccaronSemicolonEntityName, 7, 0x0010D },
    { ccedilEntityName, 6, 0x000E7 },
    { ccedilSemicolonEntityName, 7, 0x000E7 },
    { ccircSemicolonEntityName, 6, 0x00109 },
    { ccupsSemicolonEntityName, 6, 0x02A4C },
    { ccupssmSemicolonEntityName, 8, 0x02A50 },
    { cdotSemicolonEntityName, 5, 0x0010B },
    { cedilEntityName, 5, 0x000B8 },
    { cedilSemicolonEntityName, 6, 0x000B8 },
    { cemptyvSemicolonEntityName, 8, 0x029B2 },
    { centEntityName, 4, 0x000A2 },
    { centSemicolonEntityName, 5, 0x000A2 },
    { centerdotSemicolonEntityName, 10, 0x000B7 },
    { cfrSemicolonEntityName, 4, 0x1D520 },
    { chcySemicolonEntityName, 5, 0x00447 },
    { checkSemicolonEntityName, 6, 0x02713 },
    { checkmarkSemicolonEntityName, 10, 0x02713 },
    { chiSemicolonEntityName, 4, 0x003C7 },
    { cirSemicolonEntityName, 4, 0x025CB },
    { cirESemicolonEntityName, 5, 0x029C3 },
    { circSemicolonEntityName, 5, 0x002C6 },
    { circeqSemicolonEntityName, 7, 0x02257 },
    { circlearrowleftSemicolonEntityName, 16, 0x021BA },
    { circlearrowrightSemicolonEntityName, 17, 0x021BB },
    { circledRSemicolonEntityName, 9, 0x000AE },
    { circledSSemicolonEntityName, 9, 0x024C8 },
    { circledastSemicolonEntityName, 11, 0x0229B },
    { circledcircSemicolonEntityName, 12, 0x0229A },
    { circleddashSemicolonEntityName, 12, 0x0229D },
    { cireSemicolonEntityName, 5, 0x02257 },
    { cirfnintSemicolonEntityName, 9, 0x02A10 },
    { cirmidSemicolonEntityName, 7, 0x02AEF },
    { cirscirSemicolonEntityName, 8, 0x029C2 },
    { clubsSemicolonEntityName, 6, 0x02663 },
    { clubsuitSemicolonEntityName, 9, 0x02663 },
    { colonSemicolonEntityName, 6, 0x0003A },
    { coloneSemicolonEntityName, 7, 0x02254 },
    { coloneqSemicolonEntityName, 8, 0x02254 },
    { commaSemicolonEntityName, 6, 0x0002C },
    { commatSemicolonEntityName, 7, 0x00040 },
    { compSemicolonEntityName, 5, 0x02201 },
    { compfnSemicolonEntityName, 7, 0x02218 },
    { complementSemicolonEntityName, 11, 0x02201 },
    { complexesSemicolonEntityName, 10, 0x02102 },
    { congSemicolonEntityName, 5, 0x02245 },
    { congdotSemicolonEntityName, 8, 0x02A6D },
    { conintSemicolonEntityName, 7, 0x0222E },
    { copfSemicolonEntityName, 5, 0x1D554 },
    { coprodSemicolonEntityName, 7, 0x02210 },
    { copyEntityName, 4, 0x000A9 },
    { copySemicolonEntityName, 5, 0x000A9 },
    { copysrSemicolonEntityName, 7, 0x02117 },
    { crarrSemicolonEntityName, 6, 0x021B5 },
    { crossSemicolonEntityName, 6, 0x02717 },
    { cscrSemicolonEntityName, 5, 0x1D4B8 },
    { csubSemicolonEntityName, 5, 0x02ACF },
    { csubeSemicolonEntityName, 6, 0x02AD1 },
    { csupSemicolonEntityName, 5, 0x02AD0 },
    { csupeSemicolonEntityName, 6, 0x02AD2 },
    { ctdotSemicolonEntityName, 6, 0x022EF },
    { cudarrlSemicolonEntityName, 8, 0x02938 },
    { cudarrrSemicolonEntityName, 8, 0x02935 },
    { cueprSemicolonEntityName, 6, 0x022DE },
    { cuescSemicolonEntityName, 6, 0x022DF },
    { cularrSemicolonEntityName, 7, 0x021B6 },
    { cularrpSemicolonEntityName, 8, 0x0293D },
    { cupSemicolonEntityName, 4, 0x0222A },
    { cupbrcapSemicolonEntityName, 9, 0x02A48 },
    { cupcapSemicolonEntityName, 7, 0x02A46 },
    { cupcupSemicolonEntityName, 7, 0x02A4A },
    { cupdotSemicolonEntityName, 7, 0x0228D },
    { cuporSemicolonEntityName, 6, 0x02A45 },
    { curarrSemicolonEntityName, 7, 0x021B7 },
    { curarrmSemicolonEntityName, 8, 0x0293C },
    { curlyeqprecSemicolonEntityName, 12, 0x022DE },
    { curlyeqsuccSemicolonEntityName, 12, 0x022DF },
    { curlyveeSemicolonEntityName, 9, 0x022CE },
    { curlywedgeSemicolonEntityName, 11, 0x022CF },
    { currenEntityName, 6, 0x000A4 },
    { currenSemicolonEntityName, 7, 0x000A4 },
    { curvearrowleftSemicolonEntityName, 15, 0x021B6 },
    { curvearrowrightSemicolonEntityName, 16, 0x021B7 },
    { cuveeSemicolonEntityName, 6, 0x022CE },
    { cuwedSemicolonEntityName, 6, 0x022CF },
    { cwconintSemicolonEntityName, 9, 0x02232 },
    { cwintSemicolonEntityName, 6, 0x02231 },
    { cylctySemicolonEntityName, 7, 0x0232D },
    { dArrSemicolonEntityName, 5, 0x021D3 },
    { dHarSemicolonEntityName, 5, 0x02965 },
    { daggerSemicolonEntityName, 7, 0x02020 },
    { dalethSemicolonEntityName, 7, 0x02138 },
    { darrSemicolonEntityName, 5, 0x02193 },
    { dashSemicolonEntityName, 5, 0x02010 },
    { dashvSemicolonEntityName, 6, 0x022A3 },
    { dbkarowSemicolonEntityName, 8, 0x0290F },
    { dblacSemicolonEntityName, 6, 0x002DD },
    { dcaronSemicolonEntityName, 7, 0x0010F },
    { dcySemicolonEntityName, 4, 0x00434 },
    { ddSemicolonEntityName, 3, 0x02146 },
    { ddaggerSemicolonEntityName, 8, 0x02021 },
    { ddarrSemicolonEntityName, 6, 0x021CA },
    { ddotseqSemicolonEntityName, 8, 0x02A77 },
    { degEntityName, 3, 0x000B0 },
    { degSemicolonEntityName, 4, 0x000B0 },
    { deltaSemicolonEntityName, 6, 0x003B4 },
    { demptyvSemicolonEntityName, 8, 0x029B1 },
    { dfishtSemicolonEntityName, 7, 0x0297F },
    { dfrSemicolonEntityName, 4, 0x1D521 },
    { dharlSemicolonEntityName, 6, 0x021C3 },
    { dharrSemicolonEntityName, 6, 0x021C2 },
    { diamSemicolonEntityName, 5, 0x022C4 },
    { diamondSemicolonEntityName, 8, 0x022C4 },
    { diamondsuitSemicolonEntityName, 12, 0x02666 },
    { diamsSemicolonEntityName, 6, 0x02666 },
    { dieSemicolonEntityName, 4, 0x000A8 },
    { digammaSemicolonEntityName, 8, 0x003DD },
    { disinSemicolonEntityName, 6, 0x022F2 },
    { divSemicolonEntityName, 4, 0x000F7 },
    { divideEntityName, 6, 0x000F7 },
    { divideSemicolonEntityName, 7, 0x000F7 },
    { divideontimesSemicolonEntityName, 14, 0x022C7 },
    { divonxSemicolonEntityName, 7, 0x022C7 },
    { djcySemicolonEntityName, 5, 0x00452 },
    { dlcornSemicolonEntityName, 7, 0x0231E },
    { dlcropSemicolonEntityName, 7, 0x0230D },
    { dollarSemicolonEntityName, 7, 0x00024 },
    { dopfSemicolonEntityName, 5, 0x1D555 },
    { dotSemicolonEntityName, 4, 0x002D9 },
    { doteqSemicolonEntityName, 6, 0x02250 },
    { doteqdotSemicolonEntityName, 9, 0x02251 },
    { dotminusSemicolonEntityName, 9, 0x02238 },
    { dotplusSemicolonEntityName, 8, 0x02214 },
    { dotsquareSemicolonEntityName, 10, 0x022A1 },
    { doublebarwedgeSemicolonEntityName, 15, 0x02306 },
    { downarrowSemicolonEntityName, 10, 0x02193 },
    { downdownarrowsSemicolonEntityName, 15, 0x021CA },
    { downharpoonleftSemicolonEntityName, 16, 0x021C3 },
    { downharpoonrightSemicolonEntityName, 17, 0x021C2 },
    { drbkarowSemicolonEntityName, 9, 0x02910 },
    { drcornSemicolonEntityName, 7, 0x0231F },
    { drcropSemicolonEntityName, 7, 0x0230C },
    { dscrSemicolonEntityName, 5, 0x1D4B9 },
    { dscySemicolonEntityName, 5, 0x00455 },
    { dsolSemicolonEntityName, 5, 0x029F6 },
    { dstrokSemicolonEntityName, 7, 0x00111 },
    { dtdotSemicolonEntityName, 6, 0x022F1 },
    { dtriSemicolonEntityName, 5, 0x025BF },
    { dtrifSemicolonEntityName, 6, 0x025BE },
    { duarrSemicolonEntityName, 6, 0x021F5 },
    { duharSemicolonEntityName, 6, 0x0296F },
    { dwangleSemicolonEntityName, 8, 0x029A6 },
    { dzcySemicolonEntityName, 5, 0x0045F },
    { dzigrarrSemicolonEntityName, 9, 0x027FF },
    { eDDotSemicolonEntityName, 6, 0x02A77 },
    { eDotSemicolonEntityName, 5, 0x02251 },
    { eacuteEntityName, 6, 0x000E9 },
    { eacuteSemicolonEntityName, 7, 0x000E9 },
    { easterSemicolonEntityName, 7, 0x02A6E },
    { ecaronSemicolonEntityName, 7, 0x0011B },
    { ecirSemicolonEntityName, 5, 0x02256 },
    { ecircEntityName, 5, 0x000EA },
    { ecircSemicolonEntityName, 6, 0x000EA },
    { ecolonSemicolonEntityName, 7, 0x02255 },
    { ecySemicolonEntityName, 4, 0x0044D },
    { edotSemicolonEntityName, 5, 0x00117 },
    { eeSemicolonEntityName, 3, 0x02147 },
    { efDotSemicolonEntityName, 6, 0x02252 },
    { efrSemicolonEntityName, 4, 0x1D522 },
    { egSemicolonEntityName, 3, 0x02A9A },
    { egraveEntityName, 6, 0x000E8 },
    { egraveSemicolonEntityName, 7, 0x000E8 },
    { egsSemicolonEntityName, 4, 0x02A96 },
    { egsdotSemicolonEntityName, 7, 0x02A98 },
    { elSemicolonEntityName, 3, 0x02A99 },
    { elintersSemicolonEntityName, 9, 0x023E7 },
    { ellSemicolonEntityName, 4, 0x02113 },
    { elsSemicolonEntityName, 4, 0x02A95 },
    { elsdotSemicolonEntityName, 7, 0x02A97 },
    { emacrSemicolonEntityName, 6, 0x00113 },
    { emptySemicolonEntityName, 6, 0x02205 },
    { emptysetSemicolonEntityName, 9, 0x02205 },
    { emptyvSemicolonEntityName, 7, 0x02205 },
    { emsp13SemicolonEntityName, 7, 0x02004 },
    { emsp14SemicolonEntityName, 7, 0x02005 },
    { emspSemicolonEntityName, 5, 0x02003 },
    { engSemicolonEntityName, 4, 0x0014B },
    { enspSemicolonEntityName, 5, 0x02002 },
    { eogonSemicolonEntityName, 6, 0x00119 },
    { eopfSemicolonEntityName, 5, 0x1D556 },
    { eparSemicolonEntityName, 5, 0x022D5 },
    { eparslSemicolonEntityName, 7, 0x029E3 },
    { eplusSemicolonEntityName, 6, 0x02A71 },
    { epsiSemicolonEntityName, 5, 0x003B5 },
    { epsilonSemicolonEntityName, 8, 0x003B5 },
    { epsivSemicolonEntityName, 6, 0x003F5 },
    { eqcircSemicolonEntityName, 7, 0x02256 },
    { eqcolonSemicolonEntityName, 8, 0x02255 },
    { eqsimSemicolonEntityName, 6, 0x02242 },
    { eqslantgtrSemicolonEntityName, 11, 0x02A96 },
    { eqslantlessSemicolonEntityName, 12, 0x02A95 },
    { equalsSemicolonEntityName, 7, 0x0003D },
    { equestSemicolonEntityName, 7, 0x0225F },
    { equivSemicolonEntityName, 6, 0x02261 },
    { equivDDSemicolonEntityName, 8, 0x02A78 },
    { eqvparslSemicolonEntityName, 9, 0x029E5 },
    { erDotSemicolonEntityName, 6, 0x02253 },
    { erarrSemicolonEntityName, 6, 0x02971 },
    { escrSemicolonEntityName, 5, 0x0212F },
    { esdotSemicolonEntityName, 6, 0x02250 },
    { esimSemicolonEntityName, 5, 0x02242 },
    { etaSemicolonEntityName, 4, 0x003B7 },
    { ethEntityName, 3, 0x000F0 },
    { ethSemicolonEntityName, 4, 0x000F0 },
    { eumlEntityName, 4, 0x000EB },
    { eumlSemicolonEntityName, 5, 0x000EB },
    { euroSemicolonEntityName, 5, 0x020AC },
    { exclSemicolonEntityName, 5, 0x00021 },
    { existSemicolonEntityName, 6, 0x02203 },
    { expectationSemicolonEntityName, 12, 0x02130 },
    { exponentialeSemicolonEntityName, 13, 0x02147 },
    { fallingdotseqSemicolonEntityName, 14, 0x02252 },
    { fcySemicolonEntityName, 4, 0x00444 },
    { femaleSemicolonEntityName, 7, 0x02640 },
    { ffiligSemicolonEntityName, 7, 0x0FB03 },
    { ffligSemicolonEntityName, 6, 0x0FB00 },
    { fflligSemicolonEntityName, 7, 0x0FB04 },
    { ffrSemicolonEntityName, 4, 0x1D523 },
    { filigSemicolonEntityName, 6, 0x0FB01 },
    { flatSemicolonEntityName, 5, 0x0266D },
    { flligSemicolonEntityName, 6, 0x0FB02 },
    { fltnsSemicolonEntityName, 6, 0x025B1 },
    { fnofSemicolonEntityName, 5, 0x00192 },
    { fopfSemicolonEntityName, 5, 0x1D557 },
    { forallSemicolonEntityName, 7, 0x02200 },
    { forkSemicolonEntityName, 5, 0x022D4 },
    { forkvSemicolonEntityName, 6, 0x02AD9 },
    { fpartintSemicolonEntityName, 9, 0x02A0D },
    { frac12EntityName, 6, 0x000BD },
    { frac12SemicolonEntityName, 7, 0x000BD },
    { frac13SemicolonEntityName, 7, 0x02153 },
    { frac14EntityName, 6, 0x000BC },
    { frac14SemicolonEntityName, 7, 0x000BC },
    { frac15SemicolonEntityName, 7, 0x02155 },
    { frac16SemicolonEntityName, 7, 0x02159 },
    { frac18SemicolonEntityName, 7, 0x0215B },
    { frac23SemicolonEntityName, 7, 0x02154 },
    { frac25SemicolonEntityName, 7, 0x02156 },
    { frac34EntityName, 6, 0x000BE },
    { frac34SemicolonEntityName, 7, 0x000BE },
    { frac35SemicolonEntityName, 7, 0x02157 },
    { frac38SemicolonEntityName, 7, 0x0215C },
    { frac45SemicolonEntityName, 7, 0x02158 },
    { frac56SemicolonEntityName, 7, 0x0215A },
    { frac58SemicolonEntityName, 7, 0x0215D },
    { frac78SemicolonEntityName, 7, 0x0215E },
    { fraslSemicolonEntityName, 6, 0x02044 },
    { frownSemicolonEntityName, 6, 0x02322 },
    { fscrSemicolonEntityName, 5, 0x1D4BB },
    { gESemicolonEntityName, 3, 0x02267 },
    { gElSemicolonEntityName, 4, 0x02A8C },
    { gacuteSemicolonEntityName, 7, 0x001F5 },
    { gammaSemicolonEntityName, 6, 0x003B3 },
    { gammadSemicolonEntityName, 7, 0x003DD },
    { gapSemicolonEntityName, 4, 0x02A86 },
    { gbreveSemicolonEntityName, 7, 0x0011F },
    { gcircSemicolonEntityName, 6, 0x0011D },
    { gcySemicolonEntityName, 4, 0x00433 },
    { gdotSemicolonEntityName, 5, 0x00121 },
    { geSemicolonEntityName, 3, 0x02265 },
    { gelSemicolonEntityName, 4, 0x022DB },
    { geqSemicolonEntityName, 4, 0x02265 },
    { geqqSemicolonEntityName, 5, 0x02267 },
    { geqslantSemicolonEntityName, 9, 0x02A7E },
    { gesSemicolonEntityName, 4, 0x02A7E },
    { gesccSemicolonEntityName, 6, 0x02AA9 },
    { gesdotSemicolonEntityName, 7, 0x02A80 },
    { gesdotoSemicolonEntityName, 8, 0x02A82 },
    { gesdotolSemicolonEntityName, 9, 0x02A84 },
    { geslesSemicolonEntityName, 7, 0x02A94 },
    { gfrSemicolonEntityName, 4, 0x1D524 },
    { ggSemicolonEntityName, 3, 0x0226B },
    { gggSemicolonEntityName, 4, 0x022D9 },
    { gimelSemicolonEntityName, 6, 0x02137 },
    { gjcySemicolonEntityName, 5, 0x00453 },
    { glSemicolonEntityName, 3, 0x02277 },
    { glESemicolonEntityName, 4, 0x02A92 },
    { glaSemicolonEntityName, 4, 0x02AA5 },
    { gljSemicolonEntityName, 4, 0x02AA4 },
    { gnESemicolonEntityName, 4, 0x02269 },
    { gnapSemicolonEntityName, 5, 0x02A8A },
    { gnapproxSemicolonEntityName, 9, 0x02A8A },
    { gneSemicolonEntityName, 4, 0x02A88 },
    { gneqSemicolonEntityName, 5, 0x02A88 },
    { gneqqSemicolonEntityName, 6, 0x02269 },
    { gnsimSemicolonEntityName, 6, 0x022E7 },
    { gopfSemicolonEntityName, 5, 0x1D558 },
    { graveSemicolonEntityName, 6, 0x00060 },
    { gscrSemicolonEntityName, 5, 0x0210A },
    { gsimSemicolonEntityName, 5, 0x02273 },
    { gsimeSemicolonEntityName, 6, 0x02A8E },
    { gsimlSemicolonEntityName, 6, 0x02A90 },
    { gtEntityName, 2, 0x0003E },
    { gtSemicolonEntityName, 3, 0x0003E },
    { gtccSemicolonEntityName, 5, 0x02AA7 },
    { gtcirSemicolonEntityName, 6, 0x02A7A },
    { gtdotSemicolonEntityName, 6, 0x022D7 },
    { gtlParSemicolonEntityName, 7, 0x02995 },
    { gtquestSemicolonEntityName, 8, 0x02A7C },
    { gtrapproxSemicolonEntityName, 10, 0x02A86 },
    { gtrarrSemicolonEntityName, 7, 0x02978 },
    { gtrdotSemicolonEntityName, 7, 0x022D7 },
    { gtreqlessSemicolonEntityName, 10, 0x022DB },
    { gtreqqlessSemicolonEntityName, 11, 0x02A8C },
    { gtrlessSemicolonEntityName, 8, 0x02277 },
    { gtrsimSemicolonEntityName, 7, 0x02273 },
    { hArrSemicolonEntityName, 5, 0x021D4 },
    { hairspSemicolonEntityName, 7, 0x0200A },
    { halfSemicolonEntityName, 5, 0x000BD },
    { hamiltSemicolonEntityName, 7, 0x0210B },
    { hardcySemicolonEntityName, 7, 0x0044A },
    { harrSemicolonEntityName, 5, 0x02194 },
    { harrcirSemicolonEntityName, 8, 0x02948 },
    { harrwSemicolonEntityName, 6, 0x021AD },
    { hbarSemicolonEntityName, 5, 0x0210F },
    { hcircSemicolonEntityName, 6, 0x00125 },
    { heartsSemicolonEntityName, 7, 0x02665 },
    { heartsuitSemicolonEntityName, 10, 0x02665 },
    { hellipSemicolonEntityName, 7, 0x02026 },
    { herconSemicolonEntityName, 7, 0x022B9 },
    { hfrSemicolonEntityName, 4, 0x1D525 },
    { hksearowSemicolonEntityName, 9, 0x02925 },
    { hkswarowSemicolonEntityName, 9, 0x02926 },
    { hoarrSemicolonEntityName, 6, 0x021FF },
    { homthtSemicolonEntityName, 7, 0x0223B },
    { hookleftarrowSemicolonEntityName, 14, 0x021A9 },
    { hookrightarrowSemicolonEntityName, 15, 0x021AA },
    { hopfSemicolonEntityName, 5, 0x1D559 },
    { horbarSemicolonEntityName, 7, 0x02015 },
    { hscrSemicolonEntityName, 5, 0x1D4BD },
    { hslashSemicolonEntityName, 7, 0x0210F },
    { hstrokSemicolonEntityName, 7, 0x00127 },
    { hybullSemicolonEntityName, 7, 0x02043 },
    { hyphenSemicolonEntityName, 7, 0x02010 },
    { iacuteEntityName, 6, 0x000ED },
    { iacuteSemicolonEntityName, 7, 0x000ED },
    { icSemicolonEntityName, 3, 0x02063 },
    { icircEntityName, 5, 0x000EE },
    { icircSemicolonEntityName, 6, 0x000EE },
    { icySemicolonEntityName, 4, 0x00438 },
    { iecySemicolonEntityName, 5, 0x00435 },
    { iexclEntityName, 5, 0x000A1 },
    { iexclSemicolonEntityName, 6, 0x000A1 },
    { iffSemicolonEntityName, 4, 0x021D4 },
    { ifrSemicolonEntityName, 4, 0x1D526 },
    { igraveEntityName, 6, 0x000EC },
    { igraveSemicolonEntityName, 7, 0x000EC },
    { iiSemicolonEntityName, 3, 0x02148 },
    { iiiintSemicolonEntityName, 7, 0x02A0C },
    { iiintSemicolonEntityName, 6, 0x0222D },
    { iinfinSemicolonEntityName, 7, 0x029DC },
    { iiotaSemicolonEntityName, 6, 0x02129 },
    { ijligSemicolonEntityName, 6, 0x00133 },
    { imacrSemicolonEntityName, 6, 0x0012B },
    { imageSemicolonEntityName, 6, 0x02111 },
    { imaglineSemicolonEntityName, 9, 0x02110 },
    { imagpartSemicolonEntityName, 9, 0x02111 },
    { imathSemicolonEntityName, 6, 0x00131 },
    { imofSemicolonEntityName, 5, 0x022B7 },
    { impedSemicolonEntityName, 6, 0x001B5 },
    { inSemicolonEntityName, 3, 0x02208 },
    { incareSemicolonEntityName, 7, 0x02105 },
    { infinSemicolonEntityName, 6, 0x0221E },
    { infintieSemicolonEntityName, 9, 0x029DD },
    { inodotSemicolonEntityName, 7, 0x00131 },
    { intSemicolonEntityName, 4, 0x0222B },
    { intcalSemicolonEntityName, 7, 0x022BA },
    { integersSemicolonEntityName, 9, 0x02124 },
    { intercalSemicolonEntityName, 9, 0x022BA },
    { intlarhkSemicolonEntityName, 9, 0x02A17 },
    { intprodSemicolonEntityName, 8, 0x02A3C },
    { iocySemicolonEntityName, 5, 0x00451 },
    { iogonSemicolonEntityName, 6, 0x0012F },
    { iopfSemicolonEntityName, 5, 0x1D55A },
    { iotaSemicolonEntityName, 5, 0x003B9 },
    { iprodSemicolonEntityName, 6, 0x02A3C },
    { iquestEntityName, 6, 0x000BF },
    { iquestSemicolonEntityName, 7, 0x000BF },
    { iscrSemicolonEntityName, 5, 0x1D4BE },
    { isinSemicolonEntityName, 5, 0x02208 },
    { isinESemicolonEntityName, 6, 0x022F9 },
    { isindotSemicolonEntityName, 8, 0x022F5 },
    { isinsSemicolonEntityName, 6, 0x022F4 },
    { isinsvSemicolonEntityName, 7, 0x022F3 },
    { isinvSemicolonEntityName, 6, 0x02208 },
    { itSemicolonEntityName, 3, 0x02062 },
    { itildeSemicolonEntityName, 7, 0x00129 },
    { iukcySemicolonEntityName, 6, 0x00456 },
    { iumlEntityName, 4, 0x000EF },
    { iumlSemicolonEntityName, 5, 0x000EF },
    { jcircSemicolonEntityName, 6, 0x00135 },
    { jcySemicolonEntityName, 4, 0x00439 },
    { jfrSemicolonEntityName, 4, 0x1D527 },
    { jmathSemicolonEntityName, 6, 0x00237 },
    { jopfSemicolonEntityName, 5, 0x1D55B },
    { jscrSemicolonEntityName, 5, 0x1D4BF },
    { jsercySemicolonEntityName, 7, 0x00458 },
    { jukcySemicolonEntityName, 6, 0x00454 },
    { kappaSemicolonEntityName, 6, 0x003BA },
    { kappavSemicolonEntityName, 7, 0x003F0 },
    { kcedilSemicolonEntityName, 7, 0x00137 },
    { kcySemicolonEntityName, 4, 0x0043A },
    { kfrSemicolonEntityName, 4, 0x1D528 },
    { kgreenSemicolonEntityName, 7, 0x00138 },
    { khcySemicolonEntityName, 5, 0x00445 },
    { kjcySemicolonEntityName, 5, 0x0045C },
    { kopfSemicolonEntityName, 5, 0x1D55C },
    { kscrSemicolonEntityName, 5, 0x1D4C0 },
    { lAarrSemicolonEntityName, 6, 0x021DA },
    { lArrSemicolonEntityName, 5, 0x021D0 },
    { lAtailSemicolonEntityName, 7, 0x0291B },
    { lBarrSemicolonEntityName, 6, 0x0290E },
    { lESemicolonEntityName, 3, 0x02266 },
    { lEgSemicolonEntityName, 4, 0x02A8B },
    { lHarSemicolonEntityName, 5, 0x02962 },
    { lacuteSemicolonEntityName, 7, 0x0013A },
    { laemptyvSemicolonEntityName, 9, 0x029B4 },
    { lagranSemicolonEntityName, 7, 0x02112 },
    { lambdaSemicolonEntityName, 7, 0x003BB },
    { langSemicolonEntityName, 5, 0x027E8 },
    { langdSemicolonEntityName, 6, 0x02991 },
    { langleSemicolonEntityName, 7, 0x027E8 },
    { lapSemicolonEntityName, 4, 0x02A85 },
    { laquoEntityName, 5, 0x000AB },
    { laquoSemicolonEntityName, 6, 0x000AB },
    { larrSemicolonEntityName, 5, 0x02190 },
    { larrbSemicolonEntityName, 6, 0x021E4 },
    { larrbfsSemicolonEntityName, 8, 0x0291F },
    { larrfsSemicolonEntityName, 7, 0x0291D },
    { larrhkSemicolonEntityName, 7, 0x021A9 },
    { larrlpSemicolonEntityName, 7, 0x021AB },
    { larrplSemicolonEntityName, 7, 0x02939 },
    { larrsimSemicolonEntityName, 8, 0x02973 },
    { larrtlSemicolonEntityName, 7, 0x021A2 },
    { latSemicolonEntityName, 4, 0x02AAB },
    { latailSemicolonEntityName, 7, 0x02919 },
    { lateSemicolonEntityName, 5, 0x02AAD },
    { lbarrSemicolonEntityName, 6, 0x0290C },
    { lbbrkSemicolonEntityName, 6, 0x02772 },
    { lbraceSemicolonEntityName, 7, 0x0007B },
    { lbrackSemicolonEntityName, 7, 0x0005B },
    { lbrkeSemicolonEntityName, 6, 0x0298B },
    { lbrksldSemicolonEntityName, 8, 0x0298F },
    { lbrksluSemicolonEntityName, 8, 0x0298D },
    { lcaronSemicolonEntityName, 7, 0x0013E },
    { lcedilSemicolonEntityName, 7, 0x0013C },
    { lceilSemicolonEntityName, 6, 0x02308 },
    { lcubSemicolonEntityName, 5, 0x0007B },
    { lcySemicolonEntityName, 4, 0x0043B },
    { ldcaSemicolonEntityName, 5, 0x02936 },
    { ldquoSemicolonEntityName, 6, 0x0201C },
    { ldquorSemicolonEntityName, 7, 0x0201E },
    { ldrdharSemicolonEntityName, 8, 0x02967 },
    { ldrusharSemicolonEntityName, 9, 0x0294B },
    { ldshSemicolonEntityName, 5, 0x021B2 },
    { leSemicolonEntityName, 3, 0x02264 },
    { leftarrowSemicolonEntityName, 10, 0x02190 },
    { leftarrowtailSemicolonEntityName, 14, 0x021A2 },
    { leftharpoondownSemicolonEntityName, 16, 0x021BD },
    { leftharpoonupSemicolonEntityName, 14, 0x021BC },
    { leftleftarrowsSemicolonEntityName, 15, 0x021C7 },
    { leftrightarrowSemicolonEntityName, 15, 0x02194 },
    { leftrightarrowsSemicolonEntityName, 16, 0x021C6 },
    { leftrightharpoonsSemicolonEntityName, 18, 0x021CB },
    { leftrightsquigarrowSemicolonEntityName, 20, 0x021AD },
    { leftthreetimesSemicolonEntityName, 15, 0x022CB },
    { legSemicolonEntityName, 4, 0x022DA },
    { leqSemicolonEntityName, 4, 0x02264 },
    { leqqSemicolonEntityName, 5, 0x02266 },
    { leqslantSemicolonEntityName, 9, 0x02A7D },
    { lesSemicolonEntityName, 4, 0x02A7D },
    { lesccSemicolonEntityName, 6, 0x02AA8 },
    { lesdotSemicolonEntityName, 7, 0x02A7F },
    { lesdotoSemicolonEntityName, 8, 0x02A81 },
    { lesdotorSemicolonEntityName, 9, 0x02A83 },
    { lesgesSemicolonEntityName, 7, 0x02A93 },
    { lessapproxSemicolonEntityName, 11, 0x02A85 },
    { lessdotSemicolonEntityName, 8, 0x022D6 },
    { lesseqgtrSemicolonEntityName, 10, 0x022DA },
    { lesseqqgtrSemicolonEntityName, 11, 0x02A8B },
    { lessgtrSemicolonEntityName, 8, 0x02276 },
    { lesssimSemicolonEntityName, 8, 0x02272 },
    { lfishtSemicolonEntityName, 7, 0x0297C },
    { lfloorSemicolonEntityName, 7, 0x0230A },
    { lfrSemicolonEntityName, 4, 0x1D529 },
    { lgSemicolonEntityName, 3, 0x02276 },
    { lgESemicolonEntityName, 4, 0x02A91 },
    { lhardSemicolonEntityName, 6, 0x021BD },
    { lharuSemicolonEntityName, 6, 0x021BC },
    { lharulSemicolonEntityName, 7, 0x0296A },
    { lhblkSemicolonEntityName, 6, 0x02584 },
    { ljcySemicolonEntityName, 5, 0x00459 },
    { llSemicolonEntityName, 3, 0x0226A },
    { llarrSemicolonEntityName, 6, 0x021C7 },
    { llcornerSemicolonEntityName, 9, 0x0231E },
    { llhardSemicolonEntityName, 7, 0x0296B },
    { lltriSemicolonEntityName, 6, 0x025FA },
    { lmidotSemicolonEntityName, 7, 0x00140 },
    { lmoustSemicolonEntityName, 7, 0x023B0 },
    { lmoustacheSemicolonEntityName, 11, 0x023B0 },
    { lnESemicolonEntityName, 4, 0x02268 },
    { lnapSemicolonEntityName, 5, 0x02A89 },
    { lnapproxSemicolonEntityName, 9, 0x02A89 },
    { lneSemicolonEntityName, 4, 0x02A87 },
    { lneqSemicolonEntityName, 5, 0x02A87 },
    { lneqqSemicolonEntityName, 6, 0x02268 },
    { lnsimSemicolonEntityName, 6, 0x022E6 },
    { loangSemicolonEntityName, 6, 0x027EC },
    { loarrSemicolonEntityName, 6, 0x021FD },
    { lobrkSemicolonEntityName, 6, 0x027E6 },
    { longleftarrowSemicolonEntityName, 14, 0x027F5 },
    { longleftrightarrowSemicolonEntityName, 19, 0x027F7 },
    { longmapstoSemicolonEntityName, 11, 0x027FC },
    { longrightarrowSemicolonEntityName, 15, 0x027F6 },
    { looparrowleftSemicolonEntityName, 14, 0x021AB },
    { looparrowrightSemicolonEntityName, 15, 0x021AC },
    { loparSemicolonEntityName, 6, 0x02985 },
    { lopfSemicolonEntityName, 5, 0x1D55D },
    { loplusSemicolonEntityName, 7, 0x02A2D },
    { lotimesSemicolonEntityName, 8, 0x02A34 },
    { lowastSemicolonEntityName, 7, 0x02217 },
    { lowbarSemicolonEntityName, 7, 0x0005F },
    { lozSemicolonEntityName, 4, 0x025CA },
    { lozengeSemicolonEntityName, 8, 0x025CA },
    { lozfSemicolonEntityName, 5, 0x029EB },
    { lparSemicolonEntityName, 5, 0x00028 },
    { lparltSemicolonEntityName, 7, 0x02993 },
    { lrarrSemicolonEntityName, 6, 0x021C6 },
    { lrcornerSemicolonEntityName, 9, 0x0231F },
    { lrharSemicolonEntityName, 6, 0x021CB },
    { lrhardSemicolonEntityName, 7, 0x0296D },
    { lrmSemicolonEntityName, 4, 0x0200E },
    { lrtriSemicolonEntityName, 6, 0x022BF },
    { lsaquoSemicolonEntityName, 7, 0x02039 },
    { lscrSemicolonEntityName, 5, 0x1D4C1 },
    { lshSemicolonEntityName, 4, 0x021B0 },
    { lsimSemicolonEntityName, 5, 0x02272 },
    { lsimeSemicolonEntityName, 6, 0x02A8D },
    { lsimgSemicolonEntityName, 6, 0x02A8F },
    { lsqbSemicolonEntityName, 5, 0x0005B },
    { lsquoSemicolonEntityName, 6, 0x02018 },
    { lsquorSemicolonEntityName, 7, 0x0201A },
    { lstrokSemicolonEntityName, 7, 0x00142 },
    { ltEntityName, 2, 0x0003C },
    { ltSemicolonEntityName, 3, 0x0003C },
    { ltccSemicolonEntityName, 5, 0x02AA6 },
    { ltcirSemicolonEntityName, 6, 0x02A79 },
    { ltdotSemicolonEntityName, 6, 0x022D6 },
    { lthreeSemicolonEntityName, 7, 0x022CB },
    { ltimesSemicolonEntityName, 7, 0x022C9 },
    { ltlarrSemicolonEntityName, 7, 0x02976 },
    { ltquestSemicolonEntityName, 8, 0x02A7B },
    { ltrParSemicolonEntityName, 7, 0x02996 },
    { ltriSemicolonEntityName, 5, 0x025C3 },
    { ltrieSemicolonEntityName, 6, 0x022B4 },
    { ltrifSemicolonEntityName, 6, 0x025C2 },
    { lurdsharSemicolonEntityName, 9, 0x0294A },
    { luruharSemicolonEntityName, 8, 0x02966 },
    { mDDotSemicolonEntityName, 6, 0x0223A },
    { macrEntityName, 4, 0x000AF },
    { macrSemicolonEntityName, 5, 0x000AF },
    { maleSemicolonEntityName, 5, 0x02642 },
    { maltSemicolonEntityName, 5, 0x02720 },
    { malteseSemicolonEntityName, 8, 0x02720 },
    { mapSemicolonEntityName, 4, 0x021A6 },
    { mapstoSemicolonEntityName, 7, 0x021A6 },
    { mapstodownSemicolonEntityName, 11, 0x021A7 },
    { mapstoleftSemicolonEntityName, 11, 0x021A4 },
    { mapstoupSemicolonEntityName, 9, 0x021A5 },
    { markerSemicolonEntityName, 7, 0x025AE },
    { mcommaSemicolonEntityName, 7, 0x02A29 },
    { mcySemicolonEntityName, 4, 0x0043C },
    { mdashSemicolonEntityName, 6, 0x02014 },
    { measuredangleSemicolonEntityName, 14, 0x02221 },
    { mfrSemicolonEntityName, 4, 0x1D52A },
    { mhoSemicolonEntityName, 4, 0x02127 },
    { microEntityName, 5, 0x000B5 },
    { microSemicolonEntityName, 6, 0x000B5 },
    { midSemicolonEntityName, 4, 0x02223 },
    { midastSemicolonEntityName, 7, 0x0002A },
    { midcirSemicolonEntityName, 7, 0x02AF0 },
    { middotEntityName, 6, 0x000B7 },
    { middotSemicolonEntityName, 7, 0x000B7 },
    { minusSemicolonEntityName, 6, 0x02212 },
    { minusbSemicolonEntityName, 7, 0x0229F },
    { minusdSemicolonEntityName, 7, 0x02238 },
    { minusduSemicolonEntityName, 8, 0x02A2A },
    { mlcpSemicolonEntityName, 5, 0x02ADB },
    { mldrSemicolonEntityName, 5, 0x02026 },
    { mnplusSemicolonEntityName, 7, 0x02213 },
    { modelsSemicolonEntityName, 7, 0x022A7 },
    { mopfSemicolonEntityName, 5, 0x1D55E },
    { mpSemicolonEntityName, 3, 0x02213 },
    { mscrSemicolonEntityName, 5, 0x1D4C2 },
    { mstposSemicolonEntityName, 7, 0x0223E },
    { muSemicolonEntityName, 3, 0x003BC },
    { multimapSemicolonEntityName, 9, 0x022B8 },
    { mumapSemicolonEntityName, 6, 0x022B8 },
    { nLeftarrowSemicolonEntityName, 11, 0x021CD },
    { nLeftrightarrowSemicolonEntityName, 16, 0x021CE },
    { nRightarrowSemicolonEntityName, 12, 0x021CF },
    { nVDashSemicolonEntityName, 7, 0x022AF },
    { nVdashSemicolonEntityName, 7, 0x022AE },
    { nablaSemicolonEntityName, 6, 0x02207 },
    { nacuteSemicolonEntityName, 7, 0x00144 },
    { napSemicolonEntityName, 4, 0x02249 },
    { naposSemicolonEntityName, 6, 0x00149 },
    { napproxSemicolonEntityName, 8, 0x02249 },
    { naturSemicolonEntityName, 6, 0x0266E },
    { naturalSemicolonEntityName, 8, 0x0266E },
    { naturalsSemicolonEntityName, 9, 0x02115 },
    { nbspEntityName, 4, 0x000A0 },
    { nbspSemicolonEntityName, 5, 0x000A0 },
    { ncapSemicolonEntityName, 5, 0x02A43 },
    { ncaronSemicolonEntityName, 7, 0x00148 },
    { ncedilSemicolonEntityName, 7, 0x00146 },
    { ncongSemicolonEntityName, 6, 0x02247 },
    { ncupSemicolonEntityName, 5, 0x02A42 },
    { ncySemicolonEntityName, 4, 0x0043D },
    { ndashSemicolonEntityName, 6, 0x02013 },
    { neSemicolonEntityName, 3, 0x02260 },
    { neArrSemicolonEntityName, 6, 0x021D7 },
    { nearhkSemicolonEntityName, 7, 0x02924 },
    { nearrSemicolonEntityName, 6, 0x02197 },
    { nearrowSemicolonEntityName, 8, 0x02197 },
    { nequivSemicolonEntityName, 7, 0x02262 },
    { nesearSemicolonEntityName, 7, 0x02928 },
    { nexistSemicolonEntityName, 7, 0x02204 },
    { nexistsSemicolonEntityName, 8, 0x02204 },
    { nfrSemicolonEntityName, 4, 0x1D52B },
    { ngeSemicolonEntityName, 4, 0x02271 },
    { ngeqSemicolonEntityName, 5, 0x02271 },
    { ngsimSemicolonEntityName, 6, 0x02275 },
    { ngtSemicolonEntityName, 4, 0x0226F },
    { ngtrSemicolonEntityName, 5, 0x0226F },
    { nhArrSemicolonEntityName, 6, 0x021CE },
    { nharrSemicolonEntityName, 6, 0x021AE },
    { nhparSemicolonEntityName, 6, 0x02AF2 },
    { niSemicolonEntityName, 3, 0x0220B },
    { nisSemicolonEntityName, 4, 0x022FC },
    { nisdSemicolonEntityName, 5, 0x022FA },
    { nivSemicolonEntityName, 4, 0x0220B },
    { njcySemicolonEntityName, 5, 0x0045A },
    { nlArrSemicolonEntityName, 6, 0x021CD },
    { nlarrSemicolonEntityName, 6, 0x0219A },
    { nldrSemicolonEntityName, 5, 0x02025 },
    { nleSemicolonEntityName, 4, 0x02270 },
    { nleftarrowSemicolonEntityName, 11, 0x0219A },
    { nleftrightarrowSemicolonEntityName, 16, 0x021AE },
    { nleqSemicolonEntityName, 5, 0x02270 },
    { nlessSemicolonEntityName, 6, 0x0226E },
    { nlsimSemicolonEntityName, 6, 0x02274 },
    { nltSemicolonEntityName, 4, 0x0226E },
    { nltriSemicolonEntityName, 6, 0x022EA },
    { nltrieSemicolonEntityName, 7, 0x022EC },
    { nmidSemicolonEntityName, 5, 0x02224 },
    { nopfSemicolonEntityName, 5, 0x1D55F },
    { notEntityName, 3, 0x000AC },
    { notSemicolonEntityName, 4, 0x000AC },
    { notinSemicolonEntityName, 6, 0x02209 },
    { notinvaSemicolonEntityName, 8, 0x02209 },
    { notinvbSemicolonEntityName, 8, 0x022F7 },
    { notinvcSemicolonEntityName, 8, 0x022F6 },
    { notniSemicolonEntityName, 6, 0x0220C },
    { notnivaSemicolonEntityName, 8, 0x0220C },
    { notnivbSemicolonEntityName, 8, 0x022FE },
    { notnivcSemicolonEntityName, 8, 0x022FD },
    { nparSemicolonEntityName, 5, 0x02226 },
    { nparallelSemicolonEntityName, 10, 0x02226 },
    { npolintSemicolonEntityName, 8, 0x02A14 },
    { nprSemicolonEntityName, 4, 0x02280 },
    { nprcueSemicolonEntityName, 7, 0x022E0 },
    { nprecSemicolonEntityName, 6, 0x02280 },
    { nrArrSemicolonEntityName, 6, 0x021CF },
    { nrarrSemicolonEntityName, 6, 0x0219B },
    { nrightarrowSemicolonEntityName, 12, 0x0219B },
    { nrtriSemicolonEntityName, 6, 0x022EB },
    { nrtrieSemicolonEntityName, 7, 0x022ED },
    { nscSemicolonEntityName, 4, 0x02281 },
    { nsccueSemicolonEntityName, 7, 0x022E1 },
    { nscrSemicolonEntityName, 5, 0x1D4C3 },
    { nshortmidSemicolonEntityName, 10, 0x02224 },
    { nshortparallelSemicolonEntityName, 15, 0x02226 },
    { nsimSemicolonEntityName, 5, 0x02241 },
    { nsimeSemicolonEntityName, 6, 0x02244 },
    { nsimeqSemicolonEntityName, 7, 0x02244 },
    { nsmidSemicolonEntityName, 6, 0x02224 },
    { nsparSemicolonEntityName, 6, 0x02226 },
    { nsqsubeSemicolonEntityName, 8, 0x022E2 },
    { nsqsupeSemicolonEntityName, 8, 0x022E3 },
    { nsubSemicolonEntityName, 5, 0x02284 },
    { nsubeSemicolonEntityName, 6, 0x02288 },
    { nsubseteqSemicolonEntityName, 10, 0x02288 },
    { nsuccSemicolonEntityName, 6, 0x02281 },
    { nsupSemicolonEntityName, 5, 0x02285 },
    { nsupeSemicolonEntityName, 6, 0x02289 },
    { nsupseteqSemicolonEntityName, 10, 0x02289 },
    { ntglSemicolonEntityName, 5, 0x02279 },
    { ntildeEntityName, 6, 0x000F1 },
    { ntildeSemicolonEntityName, 7, 0x000F1 },
    { ntlgSemicolonEntityName, 5, 0x02278 },
    { ntriangleleftSemicolonEntityName, 14, 0x022EA },
    { ntrianglelefteqSemicolonEntityName, 16, 0x022EC },
    { ntrianglerightSemicolonEntityName, 15, 0x022EB },
    { ntrianglerighteqSemicolonEntityName, 17, 0x022ED },
    { nuSemicolonEntityName, 3, 0x003BD },
    { numSemicolonEntityName, 4, 0x00023 },
    { numeroSemicolonEntityName, 7, 0x02116 },
    { numspSemicolonEntityName, 6, 0x02007 },
    { nvDashSemicolonEntityName, 7, 0x022AD },
    { nvHarrSemicolonEntityName, 7, 0x02904 },
    { nvdashSemicolonEntityName, 7, 0x022AC },
    { nvinfinSemicolonEntityName, 8, 0x029DE },
    { nvlArrSemicolonEntityName, 7, 0x02902 },
    { nvrArrSemicolonEntityName, 7, 0x02903 },
    { nwArrSemicolonEntityName, 6, 0x021D6 },
    { nwarhkSemicolonEntityName, 7, 0x02923 },
    { nwarrSemicolonEntityName, 6, 0x02196 },
    { nwarrowSemicolonEntityName, 8, 0x02196 },
    { nwnearSemicolonEntityName, 7, 0x02927 },
    { oSSemicolonEntityName, 3, 0x024C8 },
    { oacuteEntityName, 6, 0x000F3 },
    { oacuteSemicolonEntityName, 7, 0x000F3 },
    { oastSemicolonEntityName, 5, 0x0229B },
    { ocirSemicolonEntityName, 5, 0x0229A },
    { ocircEntityName, 5, 0x000F4 },
    { ocircSemicolonEntityName, 6, 0x000F4 },
    { ocySemicolonEntityName, 4, 0x0043E },
    { odashSemicolonEntityName, 6, 0x0229D },
    { odblacSemicolonEntityName, 7, 0x00151 },
    { odivSemicolonEntityName, 5, 0x02A38 },
    { odotSemicolonEntityName, 5, 0x02299 },
    { odsoldSemicolonEntityName, 7, 0x029BC },
    { oeligSemicolonEntityName, 6, 0x00153 },
    { ofcirSemicolonEntityName, 6, 0x029BF },
    { ofrSemicolonEntityName, 4, 0x1D52C },
    { ogonSemicolonEntityName, 5, 0x002DB },
    { ograveEntityName, 6, 0x000F2 },
    { ograveSemicolonEntityName, 7, 0x000F2 },
    { ogtSemicolonEntityName, 4, 0x029C1 },
    { ohbarSemicolonEntityName, 6, 0x029B5 },
    { ohmSemicolonEntityName, 4, 0x003A9 },
    { ointSemicolonEntityName, 5, 0x0222E },
    { olarrSemicolonEntityName, 6, 0x021BA },
    { olcirSemicolonEntityName, 6, 0x029BE },
    { olcrossSemicolonEntityName, 8, 0x029BB },
    { olineSemicolonEntityName, 6, 0x0203E },
    { oltSemicolonEntityName, 4, 0x029C0 },
    { omacrSemicolonEntityName, 6, 0x0014D },
    { omegaSemicolonEntityName, 6, 0x003C9 },
    { omicronSemicolonEntityName, 8, 0x003BF },
    { omidSemicolonEntityName, 5, 0x029B6 },
    { ominusSemicolonEntityName, 7, 0x02296 },
    { oopfSemicolonEntityName, 5, 0x1D560 },
    { oparSemicolonEntityName, 5, 0x029B7 },
    { operpSemicolonEntityName, 6, 0x029B9 },
    { oplusSemicolonEntityName, 6, 0x02295 },
    { orSemicolonEntityName, 3, 0x02228 },
    { orarrSemicolonEntityName, 6, 0x021BB },
    { ordSemicolonEntityName, 4, 0x02A5D },
    { orderSemicolonEntityName, 6, 0x02134 },
    { orderofSemicolonEntityName, 8, 0x02134 },
    { ordfEntityName, 4, 0x000AA },
    { ordfSemicolonEntityName, 5, 0x000AA },
    { ordmEntityName, 4, 0x000BA },
    { ordmSemicolonEntityName, 5, 0x000BA },
    { origofSemicolonEntityName, 7, 0x022B6 },
    { ororSemicolonEntityName, 5, 0x02A56 },
    { orslopeSemicolonEntityName, 8, 0x02A57 },
    { orvSemicolonEntityName, 4, 0x02A5B },
    { oscrSemicolonEntityName, 5, 0x02134 },
    { oslashEntityName, 6, 0x000F8 },
    { oslashSemicolonEntityName, 7, 0x000F8 },
    { osolSemicolonEntityName, 5, 0x02298 },
    { otildeEntityName, 6, 0x000F5 },
    { otildeSemicolonEntityName, 7, 0x000F5 },
    { otimesSemicolonEntityName, 7, 0x02297 },
    { otimesasSemicolonEntityName, 9, 0x02A36 },
    { oumlEntityName, 4, 0x000F6 },
    { oumlSemicolonEntityName, 5, 0x000F6 },
    { ovbarSemicolonEntityName, 6, 0x0233D },
    { parSemicolonEntityName, 4, 0x02225 },
    { paraEntityName, 4, 0x000B6 },
    { paraSemicolonEntityName, 5, 0x000B6 },
    { parallelSemicolonEntityName, 9, 0x02225 },
    { parsimSemicolonEntityName, 7, 0x02AF3 },
    { parslSemicolonEntityName, 6, 0x02AFD },
    { partSemicolonEntityName, 5, 0x02202 },
    { pcySemicolonEntityName, 4, 0x0043F },
    { percntSemicolonEntityName, 7, 0x00025 },
    { periodSemicolonEntityName, 7, 0x0002E },
    { permilSemicolonEntityName, 7, 0x02030 },
    { perpSemicolonEntityName, 5, 0x022A5 },
    { pertenkSemicolonEntityName, 8, 0x02031 },
    { pfrSemicolonEntityName, 4, 0x1D52D },
    { phiSemicolonEntityName, 4, 0x003C6 },
    { phivSemicolonEntityName, 5, 0x003D5 },
    { phmmatSemicolonEntityName, 7, 0x02133 },
    { phoneSemicolonEntityName, 6, 0x0260E },
    { piSemicolonEntityName, 3, 0x003C0 },
    { pitchforkSemicolonEntityName, 10, 0x022D4 },
    { pivSemicolonEntityName, 4, 0x003D6 },
    { planckSemicolonEntityName, 7, 0x0210F },
    { planckhSemicolonEntityName, 8, 0x0210E },
    { plankvSemicolonEntityName, 7, 0x0210F },
    { plusSemicolonEntityName, 5, 0x0002B },
    { plusacirSemicolonEntityName, 9, 0x02A23 },
    { plusbSemicolonEntityName, 6, 0x0229E },
    { pluscirSemicolonEntityName, 8, 0x02A22 },
    { plusdoSemicolonEntityName, 7, 0x02214 },
    { plusduSemicolonEntityName, 7, 0x02A25 },
    { pluseSemicolonEntityName, 6, 0x02A72 },
    { plusmnEntityName, 6, 0x000B1 },
    { plusmnSemicolonEntityName, 7, 0x000B1 },
    { plussimSemicolonEntityName, 8, 0x02A26 },
    { plustwoSemicolonEntityName, 8, 0x02A27 },
    { pmSemicolonEntityName, 3, 0x000B1 },
    { pointintSemicolonEntityName, 9, 0x02A15 },
    { popfSemicolonEntityName, 5, 0x1D561 },
    { poundEntityName, 5, 0x000A3 },
    { poundSemicolonEntityName, 6, 0x000A3 },
    { prSemicolonEntityName, 3, 0x0227A },
    { prESemicolonEntityName, 4, 0x02AB3 },
    { prapSemicolonEntityName, 5, 0x02AB7 },
    { prcueSemicolonEntityName, 6, 0x0227C },
    { preSemicolonEntityName, 4, 0x02AAF },
    { precSemicolonEntityName, 5, 0x0227A },
    { precapproxSemicolonEntityName, 11, 0x02AB7 },
    { preccurlyeqSemicolonEntityName, 12, 0x0227C },
    { preceqSemicolonEntityName, 7, 0x02AAF },
    { precnapproxSemicolonEntityName, 12, 0x02AB9 },
    { precneqqSemicolonEntityName, 9, 0x02AB5 },
    { precnsimSemicolonEntityName, 9, 0x022E8 },
    { precsimSemicolonEntityName, 8, 0x0227E },
    { primeSemicolonEntityName, 6, 0x02032 },
    { primesSemicolonEntityName, 7, 0x02119 },
    { prnESemicolonEntityName, 5, 0x02AB5 },
    { prnapSemicolonEntityName, 6, 0x02AB9 },
    { prnsimSemicolonEntityName, 7, 0x022E8 },
    { prodSemicolonEntityName, 5, 0x0220F },
    { profalarSemicolonEntityName, 9, 0x0232E },
    { proflineSemicolonEntityName, 9, 0x02312 },
    { profsurfSemicolonEntityName, 9, 0x02313 },
    { propSemicolonEntityName, 5, 0x0221D },
    { proptoSemicolonEntityName, 7, 0x0221D },
    { prsimSemicolonEntityName, 6, 0x0227E },
    { prurelSemicolonEntityName, 7, 0x022B0 },
    { pscrSemicolonEntityName, 5, 0x1D4C5 },
    { psiSemicolonEntityName, 4, 0x003C8 },
    { puncspSemicolonEntityName, 7, 0x02008 },
    { qfrSemicolonEntityName, 4, 0x1D52E },
    { qintSemicolonEntityName, 5, 0x02A0C },
    { qopfSemicolonEntityName, 5, 0x1D562 },
    { qprimeSemicolonEntityName, 7, 0x02057 },
    { qscrSemicolonEntityName, 5, 0x1D4C6 },
    { quaternionsSemicolonEntityName, 12, 0x0210D },
    { quatintSemicolonEntityName, 8, 0x02A16 },
    { questSemicolonEntityName, 6, 0x0003F },
    { questeqSemicolonEntityName, 8, 0x0225F },
    { quotEntityName, 4, 0x00022 },
    { quotSemicolonEntityName, 5, 0x00022 },
    { rAarrSemicolonEntityName, 6, 0x021DB },
    { rArrSemicolonEntityName, 5, 0x021D2 },
    { rAtailSemicolonEntityName, 7, 0x0291C },
    { rBarrSemicolonEntityName, 6, 0x0290F },
    { rHarSemicolonEntityName, 5, 0x02964 },
    { racuteSemicolonEntityName, 7, 0x00155 },
    { radicSemicolonEntityName, 6, 0x0221A },
    { raemptyvSemicolonEntityName, 9, 0x029B3 },
    { rangSemicolonEntityName, 5, 0x027E9 },
    { rangdSemicolonEntityName, 6, 0x02992 },
    { rangeSemicolonEntityName, 6, 0x029A5 },
    { rangleSemicolonEntityName, 7, 0x027E9 },
    { raquoEntityName, 5, 0x000BB },
    { raquoSemicolonEntityName, 6, 0x000BB },
    { rarrSemicolonEntityName, 5, 0x02192 },
    { rarrapSemicolonEntityName, 7, 0x02975 },
    { rarrbSemicolonEntityName, 6, 0x021E5 },
    { rarrbfsSemicolonEntityName, 8, 0x02920 },
    { rarrcSemicolonEntityName, 6, 0x02933 },
    { rarrfsSemicolonEntityName, 7, 0x0291E },
    { rarrhkSemicolonEntityName, 7, 0x021AA },
    { rarrlpSemicolonEntityName, 7, 0x021AC },
    { rarrplSemicolonEntityName, 7, 0x02945 },
    { rarrsimSemicolonEntityName, 8, 0x02974 },
    { rarrtlSemicolonEntityName, 7, 0x021A3 },
    { rarrwSemicolonEntityName, 6, 0x0219D },
    { ratailSemicolonEntityName, 7, 0x0291A },
    { ratioSemicolonEntityName, 6, 0x02236 },
    { rationalsSemicolonEntityName, 10, 0x0211A },
    { rbarrSemicolonEntityName, 6, 0x0290D },
    { rbbrkSemicolonEntityName, 6, 0x02773 },
    { rbraceSemicolonEntityName, 7, 0x0007D },
    { rbrackSemicolonEntityName, 7, 0x0005D },
    { rbrkeSemicolonEntityName, 6, 0x0298C },
    { rbrksldSemicolonEntityName, 8, 0x0298E },
    { rbrksluSemicolonEntityName, 8, 0x02990 },
    { rcaronSemicolonEntityName, 7, 0x00159 },
    { rcedilSemicolonEntityName, 7, 0x00157 },
    { rceilSemicolonEntityName, 6, 0x02309 },
    { rcubSemicolonEntityName, 5, 0x0007D },
    { rcySemicolonEntityName, 4, 0x00440 },
    { rdcaSemicolonEntityName, 5, 0x02937 },
    { rdldharSemicolonEntityName, 8, 0x02969 },
    { rdquoSemicolonEntityName, 6, 0x0201D },
    { rdquorSemicolonEntityName, 7, 0x0201D },
    { rdshSemicolonEntityName, 5, 0x021B3 },
    { realSemicolonEntityName, 5, 0x0211C },
    { realineSemicolonEntityName, 8, 0x0211B },
    { realpartSemicolonEntityName, 9, 0x0211C },
    { realsSemicolonEntityName, 6, 0x0211D },
    { rectSemicolonEntityName, 5, 0x025AD },
    { regEntityName, 3, 0x000AE },
    { regSemicolonEntityName, 4, 0x000AE },
    { rfishtSemicolonEntityName, 7, 0x0297D },
    { rfloorSemicolonEntityName, 7, 0x0230B },
    { rfrSemicolonEntityName, 4, 0x1D52F },
    { rhardSemicolonEntityName, 6, 0x021C1 },
    { rharuSemicolonEntityName, 6, 0x021C0 },
    { rharulSemicolonEntityName, 7, 0x0296C },
    { rhoSemicolonEntityName, 4, 0x003C1 },
    { rhovSemicolonEntityName, 5, 0x003F1 },
    { rightarrowSemicolonEntityName, 11, 0x02192 },
    { rightarrowtailSemicolonEntityName, 15, 0x021A3 },
    { rightharpoondownSemicolonEntityName, 17, 0x021C1 },
    { rightharpoonupSemicolonEntityName, 15, 0x021C0 },
    { rightleftarrowsSemicolonEntityName, 16, 0x021C4 },
    { rightleftharpoonsSemicolonEntityName, 18, 0x021CC },
    { rightrightarrowsSemicolonEntityName, 17, 0x021C9 },
    { rightsquigarrowSemicolonEntityName, 16, 0x0219D },
    { rightthreetimesSemicolonEntityName, 16, 0x022CC },
    { ringSemicolonEntityName, 5, 0x002DA },
    { risingdotseqSemicolonEntityName, 13, 0x02253 },
    { rlarrSemicolonEntityName, 6, 0x021C4 },
    { rlharSemicolonEntityName, 6, 0x021CC },
    { rlmSemicolonEntityName, 4, 0x0200F },
    { rmoustSemicolonEntityName, 7, 0x023B1 },
    { rmoustacheSemicolonEntityName, 11, 0x023B1 },
    { rnmidSemicolonEntityName, 6, 0x02AEE },
    { roangSemicolonEntityName, 6, 0x027ED },
    { roarrSemicolonEntityName, 6, 0x021FE },
    { robrkSemicolonEntityName, 6, 0x027E7 },
    { roparSemicolonEntityName, 6, 0x02986 },
    { ropfSemicolonEntityName, 5, 0x1D563 },
    { roplusSemicolonEntityName, 7, 0x02A2E },
    { rotimesSemicolonEntityName, 8, 0x02A35 },
    { rparSemicolonEntityName, 5, 0x00029 },
    { rpargtSemicolonEntityName, 7, 0x02994 },
    { rppolintSemicolonEntityName, 9, 0x02A12 },
    { rrarrSemicolonEntityName, 6, 0x021C9 },
    { rsaquoSemicolonEntityName, 7, 0x0203A },
    { rscrSemicolonEntityName, 5, 0x1D4C7 },
    { rshSemicolonEntityName, 4, 0x021B1 },
    { rsqbSemicolonEntityName, 5, 0x0005D },
    { rsquoSemicolonEntityName, 6, 0x02019 },
    { rsquorSemicolonEntityName, 7, 0x02019 },
    { rthreeSemicolonEntityName, 7, 0x022CC },
    { rtimesSemicolonEntityName, 7, 0x022CA },
    { rtriSemicolonEntityName, 5, 0x025B9 },
    { rtrieSemicolonEntityName, 6, 0x022B5 },
    { rtrifSemicolonEntityName, 6, 0x025B8 },
    { rtriltriSemicolonEntityName, 9, 0x029CE },
    { ruluharSemicolonEntityName, 8, 0x02968 },
    { rxSemicolonEntityName, 3, 0x0211E },
    { sacuteSemicolonEntityName, 7, 0x0015B },
    { sbquoSemicolonEntityName, 6, 0x0201A },
    { scSemicolonEntityName, 3, 0x0227B },
    { scESemicolonEntityName, 4, 0x02AB4 },
    { scapSemicolonEntityName, 5, 0x02AB8 },
    { scaronSemicolonEntityName, 7, 0x00161 },
    { sccueSemicolonEntityName, 6, 0x0227D },
    { sceSemicolonEntityName, 4, 0x02AB0 },
    { scedilSemicolonEntityName, 7, 0x0015F },
    { scircSemicolonEntityName, 6, 0x0015D },
    { scnESemicolonEntityName, 5, 0x02AB6 },
    { scnapSemicolonEntityName, 6, 0x02ABA },
    { scnsimSemicolonEntityName, 7, 0x022E9 },
    { scpolintSemicolonEntityName, 9, 0x02A13 },
    { scsimSemicolonEntityName, 6, 0x0227F },
    { scySemicolonEntityName, 4, 0x00441 },
    { sdotSemicolonEntityName, 5, 0x022C5 },
    { sdotbSemicolonEntityName, 6, 0x022A1 },
    { sdoteSemicolonEntityName, 6, 0x02A66 },
    { seArrSemicolonEntityName, 6, 0x021D8 },
    { searhkSemicolonEntityName, 7, 0x02925 },
    { searrSemicolonEntityName, 6, 0x02198 },
    { searrowSemicolonEntityName, 8, 0x02198 },
    { sectEntityName, 4, 0x000A7 },
    { sectSemicolonEntityName, 5, 0x000A7 },
    { semiSemicolonEntityName, 5, 0x0003B },
    { seswarSemicolonEntityName, 7, 0x02929 },
    { setminusSemicolonEntityName, 9, 0x02216 },
    { setmnSemicolonEntityName, 6, 0x02216 },
    { sextSemicolonEntityName, 5, 0x02736 },
    { sfrSemicolonEntityName, 4, 0x1D530 },
    { sfrownSemicolonEntityName, 7, 0x02322 },
    { sharpSemicolonEntityName, 6, 0x0266F },
    { shchcySemicolonEntityName, 7, 0x00449 },
    { shcySemicolonEntityName, 5, 0x00448 },
    { shortmidSemicolonEntityName, 9, 0x02223 },
    { shortparallelSemicolonEntityName, 14, 0x02225 },
    { shyEntityName, 3, 0x000AD  },
    { shySemicolonEntityName, 4, 0x000AD   },
    { sigmaSemicolonEntityName, 6, 0x003C3 },
    { sigmafSemicolonEntityName, 7, 0x003C2 },
    { sigmavSemicolonEntityName, 7, 0x003C2 },
    { simSemicolonEntityName, 4, 0x0223C },
    { simdotSemicolonEntityName, 7, 0x02A6A },
    { simeSemicolonEntityName, 5, 0x02243 },
    { simeqSemicolonEntityName, 6, 0x02243 },
    { simgSemicolonEntityName, 5, 0x02A9E },
    { simgESemicolonEntityName, 6, 0x02AA0 },
    { simlSemicolonEntityName, 5, 0x02A9D },
    { simlESemicolonEntityName, 6, 0x02A9F },
    { simneSemicolonEntityName, 6, 0x02246 },
    { simplusSemicolonEntityName, 8, 0x02A24 },
    { simrarrSemicolonEntityName, 8, 0x02972 },
    { slarrSemicolonEntityName, 6, 0x02190 },
    { smallsetminusSemicolonEntityName, 14, 0x02216 },
    { smashpSemicolonEntityName, 7, 0x02A33 },
    { smeparslSemicolonEntityName, 9, 0x029E4 },
    { smidSemicolonEntityName, 5, 0x02223 },
    { smileSemicolonEntityName, 6, 0x02323 },
    { smtSemicolonEntityName, 4, 0x02AAA },
    { smteSemicolonEntityName, 5, 0x02AAC },
    { softcySemicolonEntityName, 7, 0x0044C },
    { solSemicolonEntityName, 4, 0x0002F },
    { solbSemicolonEntityName, 5, 0x029C4 },
    { solbarSemicolonEntityName, 7, 0x0233F },
    { sopfSemicolonEntityName, 5, 0x1D564 },
    { spadesSemicolonEntityName, 7, 0x02660 },
    { spadesuitSemicolonEntityName, 10, 0x02660 },
    { sparSemicolonEntityName, 5, 0x02225 },
    { sqcapSemicolonEntityName, 6, 0x02293 },
    { sqcupSemicolonEntityName, 6, 0x02294 },
    { sqsubSemicolonEntityName, 6, 0x0228F },
    { sqsubeSemicolonEntityName, 7, 0x02291 },
    { sqsubsetSemicolonEntityName, 9, 0x0228F },
    { sqsubseteqSemicolonEntityName, 11, 0x02291 },
    { sqsupSemicolonEntityName, 6, 0x02290 },
    { sqsupeSemicolonEntityName, 7, 0x02292 },
    { sqsupsetSemicolonEntityName, 9, 0x02290 },
    { sqsupseteqSemicolonEntityName, 11, 0x02292 },
    { squSemicolonEntityName, 4, 0x025A1 },
    { squareSemicolonEntityName, 7, 0x025A1 },
    { squarfSemicolonEntityName, 7, 0x025AA },
    { squfSemicolonEntityName, 5, 0x025AA },
    { srarrSemicolonEntityName, 6, 0x02192 },
    { sscrSemicolonEntityName, 5, 0x1D4C8 },
    { ssetmnSemicolonEntityName, 7, 0x02216 },
    { ssmileSemicolonEntityName, 7, 0x02323 },
    { sstarfSemicolonEntityName, 7, 0x022C6 },
    { starSemicolonEntityName, 5, 0x02606 },
    { starfSemicolonEntityName, 6, 0x02605 },
    { straightepsilonSemicolonEntityName, 16, 0x003F5 },
    { straightphiSemicolonEntityName, 12, 0x003D5 },
    { strnsSemicolonEntityName, 6, 0x000AF },
    { subSemicolonEntityName, 4, 0x02282 },
    { subESemicolonEntityName, 5, 0x02AC5 },
    { subdotSemicolonEntityName, 7, 0x02ABD },
    { subeSemicolonEntityName, 5, 0x02286 },
    { subedotSemicolonEntityName, 8, 0x02AC3 },
    { submultSemicolonEntityName, 8, 0x02AC1 },
    { subnESemicolonEntityName, 6, 0x02ACB },
    { subneSemicolonEntityName, 6, 0x0228A },
    { subplusSemicolonEntityName, 8, 0x02ABF },
    { subrarrSemicolonEntityName, 8, 0x02979 },
    { subsetSemicolonEntityName, 7, 0x02282 },
    { subseteqSemicolonEntityName, 9, 0x02286 },
    { subseteqqSemicolonEntityName, 10, 0x02AC5 },
    { subsetneqSemicolonEntityName, 10, 0x0228A },
    { subsetneqqSemicolonEntityName, 11, 0x02ACB },
    { subsimSemicolonEntityName, 7, 0x02AC7 },
    { subsubSemicolonEntityName, 7, 0x02AD5 },
    { subsupSemicolonEntityName, 7, 0x02AD3 },
    { succSemicolonEntityName, 5, 0x0227B },
    { succapproxSemicolonEntityName, 11, 0x02AB8 },
    { succcurlyeqSemicolonEntityName, 12, 0x0227D },
    { succeqSemicolonEntityName, 7, 0x02AB0 },
    { succnapproxSemicolonEntityName, 12, 0x02ABA },
    { succneqqSemicolonEntityName, 9, 0x02AB6 },
    { succnsimSemicolonEntityName, 9, 0x022E9 },
    { succsimSemicolonEntityName, 8, 0x0227F },
    { sumSemicolonEntityName, 4, 0x02211 },
    { sungSemicolonEntityName, 5, 0x0266A },
    { sup1EntityName, 4, 0x000B9 },
    { sup1SemicolonEntityName, 5, 0x000B9 },
    { sup2EntityName, 4, 0x000B2 },
    { sup2SemicolonEntityName, 5, 0x000B2 },
    { sup3EntityName, 4, 0x000B3 },
    { sup3SemicolonEntityName, 5, 0x000B3 },
    { supSemicolonEntityName, 4, 0x02283 },
    { supESemicolonEntityName, 5, 0x02AC6 },
    { supdotSemicolonEntityName, 7, 0x02ABE },
    { supdsubSemicolonEntityName, 8, 0x02AD8 },
    { supeSemicolonEntityName, 5, 0x02287 },
    { supedotSemicolonEntityName, 8, 0x02AC4 },
    { suphsolSemicolonEntityName, 8, 0x027C9 },
    { suphsubSemicolonEntityName, 8, 0x02AD7 },
    { suplarrSemicolonEntityName, 8, 0x0297B },
    { supmultSemicolonEntityName, 8, 0x02AC2 },
    { supnESemicolonEntityName, 6, 0x02ACC },
    { supneSemicolonEntityName, 6, 0x0228B },
    { supplusSemicolonEntityName, 8, 0x02AC0 },
    { supsetSemicolonEntityName, 7, 0x02283 },
    { supseteqSemicolonEntityName, 9, 0x02287 },
    { supseteqqSemicolonEntityName, 10, 0x02AC6 },
    { supsetneqSemicolonEntityName, 10, 0x0228B },
    { supsetneqqSemicolonEntityName, 11, 0x02ACC },
    { supsimSemicolonEntityName, 7, 0x02AC8 },
    { supsubSemicolonEntityName, 7, 0x02AD4 },
    { supsupSemicolonEntityName, 7, 0x02AD6 },
    { swArrSemicolonEntityName, 6, 0x021D9 },
    { swarhkSemicolonEntityName, 7, 0x02926 },
    { swarrSemicolonEntityName, 6, 0x02199 },
    { swarrowSemicolonEntityName, 8, 0x02199 },
    { swnwarSemicolonEntityName, 7, 0x0292A },
    { szligEntityName, 5, 0x000DF },
    { szligSemicolonEntityName, 6, 0x000DF },
    { targetSemicolonEntityName, 7, 0x02316 },
    { tauSemicolonEntityName, 4, 0x003C4 },
    { tbrkSemicolonEntityName, 5, 0x023B4 },
    { tcaronSemicolonEntityName, 7, 0x00165 },
    { tcedilSemicolonEntityName, 7, 0x00163 },
    { tcySemicolonEntityName, 4, 0x00442 },
    { tdotSemicolonEntityName, 5, 0x020DB },
    { telrecSemicolonEntityName, 7, 0x02315 },
    { tfrSemicolonEntityName, 4, 0x1D531 },
    { there4SemicolonEntityName, 7, 0x02234 },
    { thereforeSemicolonEntityName, 10, 0x02234 },
    { thetaSemicolonEntityName, 6, 0x003B8 },
    { thetasymSemicolonEntityName, 9, 0x003D1 },
    { thetavSemicolonEntityName, 7, 0x003D1 },
    { thickapproxSemicolonEntityName, 12, 0x02248 },
    { thicksimSemicolonEntityName, 9, 0x0223C },
    { thinspSemicolonEntityName, 7, 0x02009 },
    { thkapSemicolonEntityName, 6, 0x02248 },
    { thksimSemicolonEntityName, 7, 0x0223C },
    { thornEntityName, 5, 0x000FE },
    { thornSemicolonEntityName, 6, 0x000FE },
    { tildeSemicolonEntityName, 6, 0x002DC },
    { timesEntityName, 5, 0x000D7 },
    { timesSemicolonEntityName, 6, 0x000D7 },
    { timesbSemicolonEntityName, 7, 0x022A0 },
    { timesbarSemicolonEntityName, 9, 0x02A31 },
    { timesdSemicolonEntityName, 7, 0x02A30 },
    { tintSemicolonEntityName, 5, 0x0222D },
    { toeaSemicolonEntityName, 5, 0x02928 },
    { topSemicolonEntityName, 4, 0x022A4 },
    { topbotSemicolonEntityName, 7, 0x02336 },
    { topcirSemicolonEntityName, 7, 0x02AF1 },
    { topfSemicolonEntityName, 5, 0x1D565 },
    { topforkSemicolonEntityName, 8, 0x02ADA },
    { tosaSemicolonEntityName, 5, 0x02929 },
    { tprimeSemicolonEntityName, 7, 0x02034 },
    { tradeSemicolonEntityName, 6, 0x02122 },
    { triangleSemicolonEntityName, 9, 0x025B5 },
    { triangledownSemicolonEntityName, 13, 0x025BF },
    { triangleleftSemicolonEntityName, 13, 0x025C3 },
    { trianglelefteqSemicolonEntityName, 15, 0x022B4 },
    { triangleqSemicolonEntityName, 10, 0x0225C },
    { trianglerightSemicolonEntityName, 14, 0x025B9 },
    { trianglerighteqSemicolonEntityName, 16, 0x022B5 },
    { tridotSemicolonEntityName, 7, 0x025EC },
    { trieSemicolonEntityName, 5, 0x0225C },
    { triminusSemicolonEntityName, 9, 0x02A3A },
    { triplusSemicolonEntityName, 8, 0x02A39 },
    { trisbSemicolonEntityName, 6, 0x029CD },
    { tritimeSemicolonEntityName, 8, 0x02A3B },
    { trpeziumSemicolonEntityName, 9, 0x023E2 },
    { tscrSemicolonEntityName, 5, 0x1D4C9 },
    { tscySemicolonEntityName, 5, 0x00446 },
    { tshcySemicolonEntityName, 6, 0x0045B },
    { tstrokSemicolonEntityName, 7, 0x00167 },
    { twixtSemicolonEntityName, 6, 0x0226C },
    { twoheadleftarrowSemicolonEntityName, 17, 0x0219E },
    { twoheadrightarrowSemicolonEntityName, 18, 0x021A0 },
    { uArrSemicolonEntityName, 5, 0x021D1 },
    { uHarSemicolonEntityName, 5, 0x02963 },
    { uacuteEntityName, 6, 0x000FA },
    { uacuteSemicolonEntityName, 7, 0x000FA },
    { uarrSemicolonEntityName, 5, 0x02191 },
    { ubrcySemicolonEntityName, 6, 0x0045E },
    { ubreveSemicolonEntityName, 7, 0x0016D },
    { ucircEntityName, 5, 0x000FB },
    { ucircSemicolonEntityName, 6, 0x000FB },
    { ucySemicolonEntityName, 4, 0x00443 },
    { udarrSemicolonEntityName, 6, 0x021C5 },
    { udblacSemicolonEntityName, 7, 0x00171 },
    { udharSemicolonEntityName, 6, 0x0296E },
    { ufishtSemicolonEntityName, 7, 0x0297E },
    { ufrSemicolonEntityName, 4, 0x1D532 },
    { ugraveEntityName, 6, 0x000F9 },
    { ugraveSemicolonEntityName, 7, 0x000F9 },
    { uharlSemicolonEntityName, 6, 0x021BF },
    { uharrSemicolonEntityName, 6, 0x021BE },
    { uhblkSemicolonEntityName, 6, 0x02580 },
    { ulcornSemicolonEntityName, 7, 0x0231C },
    { ulcornerSemicolonEntityName, 9, 0x0231C },
    { ulcropSemicolonEntityName, 7, 0x0230F },
    { ultriSemicolonEntityName, 6, 0x025F8 },
    { umacrSemicolonEntityName, 6, 0x0016B },
    { umlEntityName, 3, 0x000A8 },
    { umlSemicolonEntityName, 4, 0x000A8 },
    { uogonSemicolonEntityName, 6, 0x00173 },
    { uopfSemicolonEntityName, 5, 0x1D566 },
    { uparrowSemicolonEntityName, 8, 0x02191 },
    { updownarrowSemicolonEntityName, 12, 0x02195 },
    { upharpoonleftSemicolonEntityName, 14, 0x021BF },
    { upharpoonrightSemicolonEntityName, 15, 0x021BE },
    { uplusSemicolonEntityName, 6, 0x0228E },
    { upsiSemicolonEntityName, 5, 0x003C5 },
    { upsihSemicolonEntityName, 6, 0x003D2 },
    { upsilonSemicolonEntityName, 8, 0x003C5 },
    { upuparrowsSemicolonEntityName, 11, 0x021C8 },
    { urcornSemicolonEntityName, 7, 0x0231D },
    { urcornerSemicolonEntityName, 9, 0x0231D },
    { urcropSemicolonEntityName, 7, 0x0230E },
    { uringSemicolonEntityName, 6, 0x0016F },
    { urtriSemicolonEntityName, 6, 0x025F9 },
    { uscrSemicolonEntityName, 5, 0x1D4CA },
    { utdotSemicolonEntityName, 6, 0x022F0 },
    { utildeSemicolonEntityName, 7, 0x00169 },
    { utriSemicolonEntityName, 5, 0x025B5 },
    { utrifSemicolonEntityName, 6, 0x025B4 },
    { uuarrSemicolonEntityName, 6, 0x021C8 },
    { uumlEntityName, 4, 0x000FC },
    { uumlSemicolonEntityName, 5, 0x000FC },
    { uwangleSemicolonEntityName, 8, 0x029A7 },
    { vArrSemicolonEntityName, 5, 0x021D5 },
    { vBarSemicolonEntityName, 5, 0x02AE8 },
    { vBarvSemicolonEntityName, 6, 0x02AE9 },
    { vDashSemicolonEntityName, 6, 0x022A8 },
    { vangrtSemicolonEntityName, 7, 0x0299C },
    { varepsilonSemicolonEntityName, 11, 0x003F5 },
    { varkappaSemicolonEntityName, 9, 0x003F0 },
    { varnothingSemicolonEntityName, 11, 0x02205 },
    { varphiSemicolonEntityName, 7, 0x003D5 },
    { varpiSemicolonEntityName, 6, 0x003D6 },
    { varproptoSemicolonEntityName, 10, 0x0221D },
    { varrSemicolonEntityName, 5, 0x02195 },
    { varrhoSemicolonEntityName, 7, 0x003F1 },
    { varsigmaSemicolonEntityName, 9, 0x003C2 },
    { varthetaSemicolonEntityName, 9, 0x003D1 },
    { vartriangleleftSemicolonEntityName, 16, 0x022B2 },
    { vartrianglerightSemicolonEntityName, 17, 0x022B3 },
    { vcySemicolonEntityName, 4, 0x00432 },
    { vdashSemicolonEntityName, 6, 0x022A2 },
    { veeSemicolonEntityName, 4, 0x02228 },
    { veebarSemicolonEntityName, 7, 0x022BB },
    { veeeqSemicolonEntityName, 6, 0x0225A },
    { vellipSemicolonEntityName, 7, 0x022EE },
    { verbarSemicolonEntityName, 7, 0x0007C },
    { vertSemicolonEntityName, 5, 0x0007C },
    { vfrSemicolonEntityName, 4, 0x1D533 },
    { vltriSemicolonEntityName, 6, 0x022B2 },
    { vopfSemicolonEntityName, 5, 0x1D567 },
    { vpropSemicolonEntityName, 6, 0x0221D },
    { vrtriSemicolonEntityName, 6, 0x022B3 },
    { vscrSemicolonEntityName, 5, 0x1D4CB },
    { vzigzagSemicolonEntityName, 8, 0x0299A },
    { wcircSemicolonEntityName, 6, 0x00175 },
    { wedbarSemicolonEntityName, 7, 0x02A5F },
    { wedgeSemicolonEntityName, 6, 0x02227 },
    { wedgeqSemicolonEntityName, 7, 0x02259 },
    { weierpSemicolonEntityName, 7, 0x02118 },
    { wfrSemicolonEntityName, 4, 0x1D534 },
    { wopfSemicolonEntityName, 5, 0x1D568 },
    { wpSemicolonEntityName, 3, 0x02118 },
    { wrSemicolonEntityName, 3, 0x02240 },
    { wreathSemicolonEntityName, 7, 0x02240 },
    { wscrSemicolonEntityName, 5, 0x1D4CC },
    { xcapSemicolonEntityName, 5, 0x022C2 },
    { xcircSemicolonEntityName, 6, 0x025EF },
    { xcupSemicolonEntityName, 5, 0x022C3 },
    { xdtriSemicolonEntityName, 6, 0x025BD },
    { xfrSemicolonEntityName, 4, 0x1D535 },
    { xhArrSemicolonEntityName, 6, 0x027FA },
    { xharrSemicolonEntityName, 6, 0x027F7 },
    { xiSemicolonEntityName, 3, 0x003BE },
    { xlArrSemicolonEntityName, 6, 0x027F8 },
    { xlarrSemicolonEntityName, 6, 0x027F5 },
    { xmapSemicolonEntityName, 5, 0x027FC },
    { xnisSemicolonEntityName, 5, 0x022FB },
    { xodotSemicolonEntityName, 6, 0x02A00 },
    { xopfSemicolonEntityName, 5, 0x1D569 },
    { xoplusSemicolonEntityName, 7, 0x02A01 },
    { xotimeSemicolonEntityName, 7, 0x02A02 },
    { xrArrSemicolonEntityName, 6, 0x027F9 },
    { xrarrSemicolonEntityName, 6, 0x027F6 },
    { xscrSemicolonEntityName, 5, 0x1D4CD },
    { xsqcupSemicolonEntityName, 7, 0x02A06 },
    { xuplusSemicolonEntityName, 7, 0x02A04 },
    { xutriSemicolonEntityName, 6, 0x025B3 },
    { xveeSemicolonEntityName, 5, 0x022C1 },
    { xwedgeSemicolonEntityName, 7, 0x022C0 },
    { yacuteEntityName, 6, 0x000FD },
    { yacuteSemicolonEntityName, 7, 0x000FD },
    { yacySemicolonEntityName, 5, 0x0044F },
    { ycircSemicolonEntityName, 6, 0x00177 },
    { ycySemicolonEntityName, 4, 0x0044B },
    { yenEntityName, 3, 0x000A5 },
    { yenSemicolonEntityName, 4, 0x000A5 },
    { yfrSemicolonEntityName, 4, 0x1D536 },
    { yicySemicolonEntityName, 5, 0x00457 },
    { yopfSemicolonEntityName, 5, 0x1D56A },
    { yscrSemicolonEntityName, 5, 0x1D4CE },
    { yucySemicolonEntityName, 5, 0x0044E },
    { yumlEntityName, 4, 0x000FF },
    { yumlSemicolonEntityName, 5, 0x000FF },
    { zacuteSemicolonEntityName, 7, 0x0017A },
    { zcaronSemicolonEntityName, 7, 0x0017E },
    { zcySemicolonEntityName, 4, 0x00437 },
    { zdotSemicolonEntityName, 5, 0x0017C },
    { zeetrfSemicolonEntityName, 7, 0x02128 },
    { zetaSemicolonEntityName, 5, 0x003B6 },
    { zfrSemicolonEntityName, 4, 0x1D537 },
    { zhcySemicolonEntityName, 5, 0x00436 },
    { zigrarrSemicolonEntityName, 8, 0x021DD },
    { zopfSemicolonEntityName, 5, 0x1D56B },
    { zscrSemicolonEntityName, 5, 0x1D4CF },
    { zwjSemicolonEntityName, 4, 0x0200D },
    { zwnjSemicolonEntityName, 5, 0x0200C },
};

static const HTMLEntityTableEntry* uppercaseOffset[] = {
    &staticEntityTable[1],
    &staticEntityTable[27],
    &staticEntityTable[39],
    &staticEntityTable[75],
    &staticEntityTable[129],
    &staticEntityTable[159],
    &staticEntityTable[167],
    &staticEntityTable[189],
    &staticEntityTable[201],
    &staticEntityTable[230],
    &staticEntityTable[237],
    &staticEntityTable[245],
    &staticEntityTable[305],
    &staticEntityTable[314],
    &staticEntityTable[367],
    &staticEntityTable[396],
    &staticEntityTable[415],
    &staticEntityTable[420],
    &staticEntityTable[465],
    &staticEntityTable[505],
    &staticEntityTable[527],
    &staticEntityTable[567],
    &staticEntityTable[584],
    &staticEntityTable[589],
    &staticEntityTable[593],
    &staticEntityTable[604],
    &staticEntityTable[614],
};

static const HTMLEntityTableEntry* lowercaseOffset[] = {
    &staticEntityTable[614],
    &staticEntityTable[682],
    &staticEntityTable[796],
    &staticEntityTable[893],
    &staticEntityTable[959],
    &staticEntityTable[1026],
    &staticEntityTable[1064],
    &staticEntityTable[1121],
    &staticEntityTable[1149],
    &staticEntityTable[1205],
    &staticEntityTable[1213],
    &staticEntityTable[1223],
    &staticEntityTable[1373],
    &staticEntityTable[1413],
    &staticEntityTable[1535],
    &staticEntityTable[1596],
    &staticEntityTable[1665],
    &staticEntityTable[1676],
    &staticEntityTable[1779],
    &staticEntityTable[1934],
    &staticEntityTable[1992],
    &staticEntityTable[2044],
    &staticEntityTable[2076],
    &staticEntityTable[2087],
    &staticEntityTable[2111],
    &staticEntityTable[2125],
    &staticEntityTable[2138],
};

}

const HTMLEntityTableEntry* HTMLEntityTable::firstEntryStartingWith(UChar c)
{
    if (c >= 'A' && c <= 'Z')
        return uppercaseOffset[c - 'A'];
    if (c >= 'a' && c <= 'z')
        return lowercaseOffset[c - 'a'];
    return 0;
}

const HTMLEntityTableEntry* HTMLEntityTable::lastEntryStartingWith(UChar c)
{
    if (c >= 'A' && c <= 'Z')
        return uppercaseOffset[c - 'A' + 1] - 1;
    if (c >= 'a' && c <= 'z')
        return lowercaseOffset[c - 'a' + 1] - 1;
    return 0;
}

const HTMLEntityTableEntry* HTMLEntityTable::firstEntry()
{
    return &staticEntityTable[0];
}

const HTMLEntityTableEntry* HTMLEntityTable::lastEntry()
{
    return &staticEntityTable[2138 - 1];
}

}
