/*
 * THIS FILE IS AUTOMATICALLY GENERATED, DO NOT EDIT.
 *
 *
 * Copyright (C) 2005 Apple Computer, Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */


#include "config.h"
#include "HTMLElementFactory.h"
#include "HTMLNames.h"
#include "Page.h"
#include "Settings.h"
#include "HTMLAnchorElement.h"
#include "HTMLAbbrElement.h"
#include "HTMLAcronymElement.h"
#include "HTMLAddressElement.h"
#include "HTMLAppletElement.h"
#include "HTMLAreaElement.h"
#include "HTMLBElement.h"
#include "HTMLBaseElement.h"
#include "HTMLBaseFontElement.h"
#include "HTMLBdoElement.h"
#include "HTMLBigElement.h"
#include "HTMLBlockquoteElement.h"
#include "HTMLBodyElement.h"
#include "HTMLBRElement.h"
#include "HTMLButtonElement.h"
#include "HTMLCanvasElement.h"
#include "HTMLTableCaptionElement.h"
#include "HTMLCenterElement.h"
#include "HTMLCiteElement.h"
#include "HTMLCodeElement.h"
#include "HTMLTableColElement.h"
#include "HTMLColgroupElement.h"
#include "HTMLDdElement.h"
#include "HTMLModElement.h"
#include "HTMLDfnElement.h"
#include "HTMLDirectoryElement.h"
#include "HTMLDivElement.h"
#include "HTMLDListElement.h"
#include "HTMLDtElement.h"
#include "HTMLEmElement.h"
#include "HTMLEmbedElement.h"
#include "HTMLFieldSetElement.h"
#include "HTMLFontElement.h"
#include "HTMLFormElement.h"
#include "HTMLFrameElement.h"
#include "HTMLFrameSetElement.h"
#include "HTMLHeadingElement.h"
#include "HTMLH2Element.h"
#include "HTMLH3Element.h"
#include "HTMLH4Element.h"
#include "HTMLH5Element.h"
#include "HTMLH6Element.h"
#include "HTMLHeadElement.h"
#include "HTMLHRElement.h"
#include "HTMLHtmlElement.h"
#include "HTMLIElement.h"
#include "HTMLIFrameElement.h"
#include "HTMLImageElement.h"
#include "HTMLImageElement.h"
#include "HTMLInputElement.h"
#include "HTMLInsElement.h"
#include "HTMLIsIndexElement.h"
#include "HTMLKbdElement.h"
#include "HTMLKeygenElement.h"
#include "HTMLLabelElement.h"
#include "HTMLLayerElement.h"
#include "HTMLLegendElement.h"
#include "HTMLLIElement.h"
#include "HTMLLinkElement.h"
#include "HTMLListingElement.h"
#include "HTMLMapElement.h"
#include "HTMLMarqueeElement.h"
#include "HTMLMenuElement.h"
#include "HTMLMetaElement.h"
#include "HTMLNobrElement.h"
#include "HTMLNoembedElement.h"
#include "HTMLNoframesElement.h"
#include "HTMLNolayerElement.h"
#include "HTMLNoscriptElement.h"
#include "HTMLObjectElement.h"
#include "HTMLOListElement.h"
#include "HTMLOptGroupElement.h"
#include "HTMLOptionElement.h"
#include "HTMLParagraphElement.h"
#include "HTMLParamElement.h"
#include "HTMLPlaintextElement.h"
#include "HTMLPreElement.h"
#include "HTMLQuoteElement.h"
#include "HTMLSElement.h"
#include "HTMLSampElement.h"
#include "HTMLScriptElement.h"
#include "HTMLSelectElement.h"
#include "HTMLSmallElement.h"
#include "HTMLSpanElement.h"
#include "HTMLStrikeElement.h"
#include "HTMLStrongElement.h"
#include "HTMLStyleElement.h"
#include "HTMLSubElement.h"
#include "HTMLSupElement.h"
#include "HTMLTableElement.h"
#include "HTMLTableSectionElement.h"
#include "HTMLTableCellElement.h"
#include "HTMLTextAreaElement.h"
#include "HTMLTfootElement.h"
#include "HTMLThElement.h"
#include "HTMLTheadElement.h"
#include "HTMLTitleElement.h"
#include "HTMLTableRowElement.h"
#include "HTMLTtElement.h"
#include "HTMLUElement.h"
#include "HTMLUListElement.h"
#include "HTMLVarElement.h"
#include "HTMLWbrElement.h"
#include "HTMLXmpElement.h"
#include <wtf/HashMap.h>

using namespace WebCore;
using namespace WebCore::HTMLNames;

typedef HTMLElement* (*ConstructorFunc)(Document* doc, bool createdByParser);
typedef WTF::HashMap<AtomicStringImpl*, ConstructorFunc> FunctionMap;

static FunctionMap* gFunctionMap = 0;

namespace WebCore {

HTMLElement* aConstructor(Document* doc, bool createdByParser)
{
    return new HTMLAnchorElement(aTag, doc);
}

HTMLElement* abbrConstructor(Document* doc, bool createdByParser)
{
    return new HTMLAbbrElement(abbrTag, doc);
}

HTMLElement* acronymConstructor(Document* doc, bool createdByParser)
{
    return new HTMLAcronymElement(acronymTag, doc);
}

HTMLElement* addressConstructor(Document* doc, bool createdByParser)
{
    return new HTMLAddressElement(addressTag, doc);
}

HTMLElement* appletConstructor(Document* doc, bool createdByParser)
{
    return new HTMLAppletElement(appletTag, doc);
}

HTMLElement* areaConstructor(Document* doc, bool createdByParser)
{
    return new HTMLAreaElement(areaTag, doc);
}

HTMLElement* bConstructor(Document* doc, bool createdByParser)
{
    return new HTMLBElement(bTag, doc);
}

HTMLElement* baseConstructor(Document* doc, bool createdByParser)
{
    return new HTMLBaseElement(baseTag, doc);
}

HTMLElement* basefontConstructor(Document* doc, bool createdByParser)
{
    return new HTMLBaseFontElement(basefontTag, doc);
}

HTMLElement* bdoConstructor(Document* doc, bool createdByParser)
{
    return new HTMLBdoElement(bdoTag, doc);
}

HTMLElement* bigConstructor(Document* doc, bool createdByParser)
{
    return new HTMLBigElement(bigTag, doc);
}

HTMLElement* blockquoteConstructor(Document* doc, bool createdByParser)
{
    return new HTMLBlockquoteElement(blockquoteTag, doc);
}

HTMLElement* bodyConstructor(Document* doc, bool createdByParser)
{
    return new HTMLBodyElement(bodyTag, doc);
}

HTMLElement* brConstructor(Document* doc, bool createdByParser)
{
    return new HTMLBRElement(brTag, doc);
}

HTMLElement* buttonConstructor(Document* doc, bool createdByParser)
{
    return new HTMLButtonElement(buttonTag, doc);
}

HTMLElement* canvasConstructor(Document* doc, bool createdByParser)
{
    return new HTMLCanvasElement(canvasTag, doc);
}

HTMLElement* captionConstructor(Document* doc, bool createdByParser)
{
    return new HTMLTableCaptionElement(captionTag, doc);
}

HTMLElement* centerConstructor(Document* doc, bool createdByParser)
{
    return new HTMLCenterElement(centerTag, doc);
}

HTMLElement* citeConstructor(Document* doc, bool createdByParser)
{
    return new HTMLCiteElement(citeTag, doc);
}

HTMLElement* codeConstructor(Document* doc, bool createdByParser)
{
    return new HTMLCodeElement(codeTag, doc);
}

HTMLElement* colConstructor(Document* doc, bool createdByParser)
{
    return new HTMLTableColElement(colTag, doc);
}

HTMLElement* colgroupConstructor(Document* doc, bool createdByParser)
{
    return new HTMLColgroupElement(colgroupTag, doc);
}

HTMLElement* ddConstructor(Document* doc, bool createdByParser)
{
    return new HTMLDdElement(ddTag, doc);
}

HTMLElement* delConstructor(Document* doc, bool createdByParser)
{
    return new HTMLModElement(delTag, doc);
}

HTMLElement* dfnConstructor(Document* doc, bool createdByParser)
{
    return new HTMLDfnElement(dfnTag, doc);
}

HTMLElement* dirConstructor(Document* doc, bool createdByParser)
{
    return new HTMLDirectoryElement(dirTag, doc);
}

HTMLElement* divConstructor(Document* doc, bool createdByParser)
{
    return new HTMLDivElement(divTag, doc);
}

HTMLElement* dlConstructor(Document* doc, bool createdByParser)
{
    return new HTMLDListElement(dlTag, doc);
}

HTMLElement* dtConstructor(Document* doc, bool createdByParser)
{
    return new HTMLDtElement(dtTag, doc);
}

HTMLElement* emConstructor(Document* doc, bool createdByParser)
{
    return new HTMLEmElement(emTag, doc);
}

HTMLElement* embedConstructor(Document* doc, bool createdByParser)
{
    return new HTMLEmbedElement(embedTag, doc);
}

HTMLElement* fieldsetConstructor(Document* doc, bool createdByParser)
{
    return new HTMLFieldSetElement(fieldsetTag, doc);
}

HTMLElement* fontConstructor(Document* doc, bool createdByParser)
{
    return new HTMLFontElement(fontTag, doc);
}

HTMLElement* formConstructor(Document* doc, bool createdByParser)
{
    return new HTMLFormElement(formTag, doc);
}

HTMLElement* frameConstructor(Document* doc, bool createdByParser)
{
    return new HTMLFrameElement(frameTag, doc);
}

HTMLElement* framesetConstructor(Document* doc, bool createdByParser)
{
    return new HTMLFrameSetElement(framesetTag, doc);
}

HTMLElement* h1Constructor(Document* doc, bool createdByParser)
{
    return new HTMLHeadingElement(h1Tag, doc);
}

HTMLElement* h2Constructor(Document* doc, bool createdByParser)
{
    return new HTMLH2Element(h2Tag, doc);
}

HTMLElement* h3Constructor(Document* doc, bool createdByParser)
{
    return new HTMLH3Element(h3Tag, doc);
}

HTMLElement* h4Constructor(Document* doc, bool createdByParser)
{
    return new HTMLH4Element(h4Tag, doc);
}

HTMLElement* h5Constructor(Document* doc, bool createdByParser)
{
    return new HTMLH5Element(h5Tag, doc);
}

HTMLElement* h6Constructor(Document* doc, bool createdByParser)
{
    return new HTMLH6Element(h6Tag, doc);
}

HTMLElement* headConstructor(Document* doc, bool createdByParser)
{
    return new HTMLHeadElement(headTag, doc);
}

HTMLElement* hrConstructor(Document* doc, bool createdByParser)
{
    return new HTMLHRElement(hrTag, doc);
}

HTMLElement* htmlConstructor(Document* doc, bool createdByParser)
{
    return new HTMLHtmlElement(htmlTag, doc);
}

HTMLElement* iConstructor(Document* doc, bool createdByParser)
{
    return new HTMLIElement(iTag, doc);
}

HTMLElement* iframeConstructor(Document* doc, bool createdByParser)
{
    return new HTMLIFrameElement(iframeTag, doc);
}

HTMLElement* imageConstructor(Document* doc, bool createdByParser)
{
    return new HTMLImageElement(imageTag, doc);
}

HTMLElement* imgConstructor(Document* doc, bool createdByParser)
{
    return new HTMLImageElement(imgTag, doc);
}

HTMLElement* inputConstructor(Document* doc, bool createdByParser)
{
    return new HTMLInputElement(inputTag, doc);
}

HTMLElement* insConstructor(Document* doc, bool createdByParser)
{
    return new HTMLInsElement(insTag, doc);
}

HTMLElement* isindexConstructor(Document* doc, bool createdByParser)
{
    return new HTMLIsIndexElement(isindexTag, doc);
}

HTMLElement* kbdConstructor(Document* doc, bool createdByParser)
{
    return new HTMLKbdElement(kbdTag, doc);
}

HTMLElement* keygenConstructor(Document* doc, bool createdByParser)
{
    return new HTMLKeygenElement(keygenTag, doc);
}

HTMLElement* labelConstructor(Document* doc, bool createdByParser)
{
    return new HTMLLabelElement(labelTag, doc);
}

HTMLElement* layerConstructor(Document* doc, bool createdByParser)
{
    return new HTMLLayerElement(layerTag, doc);
}

HTMLElement* legendConstructor(Document* doc, bool createdByParser)
{
    return new HTMLLegendElement(legendTag, doc);
}

HTMLElement* liConstructor(Document* doc, bool createdByParser)
{
    return new HTMLLIElement(liTag, doc);
}

HTMLElement* linkConstructor(Document* doc, bool createdByParser)
{
    return new HTMLLinkElement(linkTag, doc);
}

HTMLElement* listingConstructor(Document* doc, bool createdByParser)
{
    return new HTMLListingElement(listingTag, doc);
}

HTMLElement* mapConstructor(Document* doc, bool createdByParser)
{
    return new HTMLMapElement(mapTag, doc);
}

HTMLElement* marqueeConstructor(Document* doc, bool createdByParser)
{
    return new HTMLMarqueeElement(marqueeTag, doc);
}

HTMLElement* menuConstructor(Document* doc, bool createdByParser)
{
    return new HTMLMenuElement(menuTag, doc);
}

HTMLElement* metaConstructor(Document* doc, bool createdByParser)
{
    return new HTMLMetaElement(metaTag, doc);
}

HTMLElement* nobrConstructor(Document* doc, bool createdByParser)
{
    return new HTMLNobrElement(nobrTag, doc);
}

HTMLElement* noembedConstructor(Document* doc, bool createdByParser)
{
    return new HTMLNoembedElement(noembedTag, doc);
}

HTMLElement* noframesConstructor(Document* doc, bool createdByParser)
{
    return new HTMLNoframesElement(noframesTag, doc);
}

HTMLElement* nolayerConstructor(Document* doc, bool createdByParser)
{
    return new HTMLNolayerElement(nolayerTag, doc);
}

HTMLElement* noscriptConstructor(Document* doc, bool createdByParser)
{
    return new HTMLNoscriptElement(noscriptTag, doc);
}

HTMLElement* objectConstructor(Document* doc, bool createdByParser)
{
    return new HTMLObjectElement(objectTag, doc);
}

HTMLElement* olConstructor(Document* doc, bool createdByParser)
{
    return new HTMLOListElement(olTag, doc);
}

HTMLElement* optgroupConstructor(Document* doc, bool createdByParser)
{
    return new HTMLOptGroupElement(optgroupTag, doc);
}

HTMLElement* optionConstructor(Document* doc, bool createdByParser)
{
    return new HTMLOptionElement(optionTag, doc);
}

HTMLElement* pConstructor(Document* doc, bool createdByParser)
{
    return new HTMLParagraphElement(pTag, doc);
}

HTMLElement* paramConstructor(Document* doc, bool createdByParser)
{
    return new HTMLParamElement(paramTag, doc);
}

HTMLElement* plaintextConstructor(Document* doc, bool createdByParser)
{
    return new HTMLPlaintextElement(plaintextTag, doc);
}

HTMLElement* preConstructor(Document* doc, bool createdByParser)
{
    return new HTMLPreElement(preTag, doc);
}

HTMLElement* qConstructor(Document* doc, bool createdByParser)
{
    return new HTMLQuoteElement(qTag, doc);
}

HTMLElement* sConstructor(Document* doc, bool createdByParser)
{
    return new HTMLSElement(sTag, doc);
}

HTMLElement* sampConstructor(Document* doc, bool createdByParser)
{
    return new HTMLSampElement(sampTag, doc);
}

HTMLElement* scriptConstructor(Document* doc, bool createdByParser)
{
    return new HTMLScriptElement(scriptTag, doc);
}

HTMLElement* selectConstructor(Document* doc, bool createdByParser)
{
    return new HTMLSelectElement(selectTag, doc);
}

HTMLElement* smallConstructor(Document* doc, bool createdByParser)
{
    return new HTMLSmallElement(smallTag, doc);
}

HTMLElement* spanConstructor(Document* doc, bool createdByParser)
{
    return new HTMLSpanElement(spanTag, doc);
}

HTMLElement* strikeConstructor(Document* doc, bool createdByParser)
{
    return new HTMLStrikeElement(strikeTag, doc);
}

HTMLElement* strongConstructor(Document* doc, bool createdByParser)
{
    return new HTMLStrongElement(strongTag, doc);
}

HTMLElement* styleConstructor(Document* doc, bool createdByParser)
{
    return new HTMLStyleElement(styleTag, doc);
}

HTMLElement* subConstructor(Document* doc, bool createdByParser)
{
    return new HTMLSubElement(subTag, doc);
}

HTMLElement* supConstructor(Document* doc, bool createdByParser)
{
    return new HTMLSupElement(supTag, doc);
}

HTMLElement* tableConstructor(Document* doc, bool createdByParser)
{
    return new HTMLTableElement(tableTag, doc);
}

HTMLElement* tbodyConstructor(Document* doc, bool createdByParser)
{
    return new HTMLTableSectionElement(tbodyTag, doc);
}

HTMLElement* tdConstructor(Document* doc, bool createdByParser)
{
    return new HTMLTableCellElement(tdTag, doc);
}

HTMLElement* textareaConstructor(Document* doc, bool createdByParser)
{
    return new HTMLTextAreaElement(textareaTag, doc);
}

HTMLElement* tfootConstructor(Document* doc, bool createdByParser)
{
    return new HTMLTfootElement(tfootTag, doc);
}

HTMLElement* thConstructor(Document* doc, bool createdByParser)
{
    return new HTMLThElement(thTag, doc);
}

HTMLElement* theadConstructor(Document* doc, bool createdByParser)
{
    return new HTMLTheadElement(theadTag, doc);
}

HTMLElement* titleConstructor(Document* doc, bool createdByParser)
{
    return new HTMLTitleElement(titleTag, doc);
}

HTMLElement* trConstructor(Document* doc, bool createdByParser)
{
    return new HTMLTableRowElement(trTag, doc);
}

HTMLElement* ttConstructor(Document* doc, bool createdByParser)
{
    return new HTMLTtElement(ttTag, doc);
}

HTMLElement* uConstructor(Document* doc, bool createdByParser)
{
    return new HTMLUElement(uTag, doc);
}

HTMLElement* ulConstructor(Document* doc, bool createdByParser)
{
    return new HTMLUListElement(ulTag, doc);
}

HTMLElement* varConstructor(Document* doc, bool createdByParser)
{
    return new HTMLVarElement(varTag, doc);
}

HTMLElement* wbrConstructor(Document* doc, bool createdByParser)
{
    return new HTMLWbrElement(wbrTag, doc);
}

HTMLElement* xmpConstructor(Document* doc, bool createdByParser)
{
    return new HTMLXmpElement(xmpTag, doc);
}

static inline void createFunctionMapIfNecessary()
{
    if (gFunctionMap)
        return;
    // Create the table.
    gFunctionMap = new FunctionMap;
    
    // Populate it with constructor functions.
    gFunctionMap->set(aTag.localName().impl(), aConstructor);
    gFunctionMap->set(abbrTag.localName().impl(), abbrConstructor);
    gFunctionMap->set(acronymTag.localName().impl(), acronymConstructor);
    gFunctionMap->set(addressTag.localName().impl(), addressConstructor);
    gFunctionMap->set(appletTag.localName().impl(), appletConstructor);
    gFunctionMap->set(areaTag.localName().impl(), areaConstructor);
    gFunctionMap->set(bTag.localName().impl(), bConstructor);
    gFunctionMap->set(baseTag.localName().impl(), baseConstructor);
    gFunctionMap->set(basefontTag.localName().impl(), basefontConstructor);
    gFunctionMap->set(bdoTag.localName().impl(), bdoConstructor);
    gFunctionMap->set(bigTag.localName().impl(), bigConstructor);
    gFunctionMap->set(blockquoteTag.localName().impl(), blockquoteConstructor);
    gFunctionMap->set(bodyTag.localName().impl(), bodyConstructor);
    gFunctionMap->set(brTag.localName().impl(), brConstructor);
    gFunctionMap->set(buttonTag.localName().impl(), buttonConstructor);
    gFunctionMap->set(canvasTag.localName().impl(), canvasConstructor);
    gFunctionMap->set(captionTag.localName().impl(), captionConstructor);
    gFunctionMap->set(centerTag.localName().impl(), centerConstructor);
    gFunctionMap->set(citeTag.localName().impl(), citeConstructor);
    gFunctionMap->set(codeTag.localName().impl(), codeConstructor);
    gFunctionMap->set(colTag.localName().impl(), colConstructor);
    gFunctionMap->set(colgroupTag.localName().impl(), colgroupConstructor);
    gFunctionMap->set(ddTag.localName().impl(), ddConstructor);
    gFunctionMap->set(delTag.localName().impl(), delConstructor);
    gFunctionMap->set(dfnTag.localName().impl(), dfnConstructor);
    gFunctionMap->set(dirTag.localName().impl(), dirConstructor);
    gFunctionMap->set(divTag.localName().impl(), divConstructor);
    gFunctionMap->set(dlTag.localName().impl(), dlConstructor);
    gFunctionMap->set(dtTag.localName().impl(), dtConstructor);
    gFunctionMap->set(emTag.localName().impl(), emConstructor);
    gFunctionMap->set(embedTag.localName().impl(), embedConstructor);
    gFunctionMap->set(fieldsetTag.localName().impl(), fieldsetConstructor);
    gFunctionMap->set(fontTag.localName().impl(), fontConstructor);
    gFunctionMap->set(formTag.localName().impl(), formConstructor);
    gFunctionMap->set(frameTag.localName().impl(), frameConstructor);
    gFunctionMap->set(framesetTag.localName().impl(), framesetConstructor);
    gFunctionMap->set(h1Tag.localName().impl(), h1Constructor);
    gFunctionMap->set(h2Tag.localName().impl(), h2Constructor);
    gFunctionMap->set(h3Tag.localName().impl(), h3Constructor);
    gFunctionMap->set(h4Tag.localName().impl(), h4Constructor);
    gFunctionMap->set(h5Tag.localName().impl(), h5Constructor);
    gFunctionMap->set(h6Tag.localName().impl(), h6Constructor);
    gFunctionMap->set(headTag.localName().impl(), headConstructor);
    gFunctionMap->set(hrTag.localName().impl(), hrConstructor);
    gFunctionMap->set(htmlTag.localName().impl(), htmlConstructor);
    gFunctionMap->set(iTag.localName().impl(), iConstructor);
    gFunctionMap->set(iframeTag.localName().impl(), iframeConstructor);
    gFunctionMap->set(imageTag.localName().impl(), imageConstructor);
    gFunctionMap->set(imgTag.localName().impl(), imgConstructor);
    gFunctionMap->set(inputTag.localName().impl(), inputConstructor);
    gFunctionMap->set(insTag.localName().impl(), insConstructor);
    gFunctionMap->set(isindexTag.localName().impl(), isindexConstructor);
    gFunctionMap->set(kbdTag.localName().impl(), kbdConstructor);
    gFunctionMap->set(keygenTag.localName().impl(), keygenConstructor);
    gFunctionMap->set(labelTag.localName().impl(), labelConstructor);
    gFunctionMap->set(layerTag.localName().impl(), layerConstructor);
    gFunctionMap->set(legendTag.localName().impl(), legendConstructor);
    gFunctionMap->set(liTag.localName().impl(), liConstructor);
    gFunctionMap->set(linkTag.localName().impl(), linkConstructor);
    gFunctionMap->set(listingTag.localName().impl(), listingConstructor);
    gFunctionMap->set(mapTag.localName().impl(), mapConstructor);
    gFunctionMap->set(marqueeTag.localName().impl(), marqueeConstructor);
    gFunctionMap->set(menuTag.localName().impl(), menuConstructor);
    gFunctionMap->set(metaTag.localName().impl(), metaConstructor);
    gFunctionMap->set(nobrTag.localName().impl(), nobrConstructor);
    gFunctionMap->set(noembedTag.localName().impl(), noembedConstructor);
    gFunctionMap->set(noframesTag.localName().impl(), noframesConstructor);
    gFunctionMap->set(nolayerTag.localName().impl(), nolayerConstructor);
    gFunctionMap->set(noscriptTag.localName().impl(), noscriptConstructor);
    gFunctionMap->set(objectTag.localName().impl(), objectConstructor);
    gFunctionMap->set(olTag.localName().impl(), olConstructor);
    gFunctionMap->set(optgroupTag.localName().impl(), optgroupConstructor);
    gFunctionMap->set(optionTag.localName().impl(), optionConstructor);
    gFunctionMap->set(pTag.localName().impl(), pConstructor);
    gFunctionMap->set(paramTag.localName().impl(), paramConstructor);
    gFunctionMap->set(plaintextTag.localName().impl(), plaintextConstructor);
    gFunctionMap->set(preTag.localName().impl(), preConstructor);
    gFunctionMap->set(qTag.localName().impl(), qConstructor);
    gFunctionMap->set(sTag.localName().impl(), sConstructor);
    gFunctionMap->set(sampTag.localName().impl(), sampConstructor);
    gFunctionMap->set(scriptTag.localName().impl(), scriptConstructor);
    gFunctionMap->set(selectTag.localName().impl(), selectConstructor);
    gFunctionMap->set(smallTag.localName().impl(), smallConstructor);
    gFunctionMap->set(spanTag.localName().impl(), spanConstructor);
    gFunctionMap->set(strikeTag.localName().impl(), strikeConstructor);
    gFunctionMap->set(strongTag.localName().impl(), strongConstructor);
    gFunctionMap->set(styleTag.localName().impl(), styleConstructor);
    gFunctionMap->set(subTag.localName().impl(), subConstructor);
    gFunctionMap->set(supTag.localName().impl(), supConstructor);
    gFunctionMap->set(tableTag.localName().impl(), tableConstructor);
    gFunctionMap->set(tbodyTag.localName().impl(), tbodyConstructor);
    gFunctionMap->set(tdTag.localName().impl(), tdConstructor);
    gFunctionMap->set(textareaTag.localName().impl(), textareaConstructor);
    gFunctionMap->set(tfootTag.localName().impl(), tfootConstructor);
    gFunctionMap->set(thTag.localName().impl(), thConstructor);
    gFunctionMap->set(theadTag.localName().impl(), theadConstructor);
    gFunctionMap->set(titleTag.localName().impl(), titleConstructor);
    gFunctionMap->set(trTag.localName().impl(), trConstructor);
    gFunctionMap->set(ttTag.localName().impl(), ttConstructor);
    gFunctionMap->set(uTag.localName().impl(), uConstructor);
    gFunctionMap->set(ulTag.localName().impl(), ulConstructor);
    gFunctionMap->set(varTag.localName().impl(), varConstructor);
    gFunctionMap->set(wbrTag.localName().impl(), wbrConstructor);
    gFunctionMap->set(xmpTag.localName().impl(), xmpConstructor);
}
HTMLElement* HTMLElementFactory::createHTMLElement(const QualifiedName& qName, Document* doc, bool createdByParser)
{
    // Don't make elements without a document
    if (!doc)
        return 0;

#if ENABLE(DASHBOARD_SUPPORT)
    Settings* settings = doc->settings();
    if (settings && settings->usesDashboardBackwardCompatibilityMode())
        return 0;
#endif

    createFunctionMapIfNecessary();
    ConstructorFunc func = gFunctionMap->get(qName.localName().impl());
    if (func)
        return func(doc, createdByParser);

    return new HTMLElement(qName, doc);
}

} // namespace

