/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"


#if ENABLE(XPATH)

#include "JSXPathResult.h"

#include <wtf/GetPtr.h>

#include "JSNode.h"
#include "KURL.h"
#include "Node.h"
#include "XPathResult.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSXPathResultTableValues[9] =
{
    { "resultType", (intptr_t)JSXPathResult::ResultTypeAttrNum, DontDelete|ReadOnly, 0 },
    { "numberValue", (intptr_t)JSXPathResult::NumberValueAttrNum, DontDelete|ReadOnly, 0 },
    { "stringValue", (intptr_t)JSXPathResult::StringValueAttrNum, DontDelete|ReadOnly, 0 },
    { "booleanValue", (intptr_t)JSXPathResult::BooleanValueAttrNum, DontDelete|ReadOnly, 0 },
    { "singleNodeValue", (intptr_t)JSXPathResult::SingleNodeValueAttrNum, DontDelete|ReadOnly, 0 },
    { "invalidIteratorState", (intptr_t)JSXPathResult::InvalidIteratorStateAttrNum, DontDelete|ReadOnly, 0 },
    { "snapshotLength", (intptr_t)JSXPathResult::SnapshotLengthAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSXPathResult::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSXPathResultTable = { 63, JSXPathResultTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSXPathResultConstructorTableValues[11] =
{
    { "ANY_TYPE", (intptr_t)0, DontDelete|ReadOnly, 0 },
    { "NUMBER_TYPE", (intptr_t)1, DontDelete|ReadOnly, 0 },
    { "STRING_TYPE", (intptr_t)2, DontDelete|ReadOnly, 0 },
    { "BOOLEAN_TYPE", (intptr_t)3, DontDelete|ReadOnly, 0 },
    { "UNORDERED_NODE_ITERATOR_TYPE", (intptr_t)4, DontDelete|ReadOnly, 0 },
    { "ORDERED_NODE_ITERATOR_TYPE", (intptr_t)5, DontDelete|ReadOnly, 0 },
    { "UNORDERED_NODE_SNAPSHOT_TYPE", (intptr_t)6, DontDelete|ReadOnly, 0 },
    { "ORDERED_NODE_SNAPSHOT_TYPE", (intptr_t)7, DontDelete|ReadOnly, 0 },
    { "ANY_UNORDERED_NODE_TYPE", (intptr_t)8, DontDelete|ReadOnly, 0 },
    { "FIRST_ORDERED_NODE_TYPE", (intptr_t)9, DontDelete|ReadOnly, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSXPathResultConstructorTable = { 127, JSXPathResultConstructorTableValues, 0 };

class JSXPathResultConstructor : public DOMObject {
public:
    JSXPathResultConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSXPathResultPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSXPathResultConstructor::s_info = { "XPathResultConstructor", 0, &JSXPathResultConstructorTable, 0 };

bool JSXPathResultConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXPathResultConstructor, DOMObject>(exec, &JSXPathResultConstructorTable, this, propertyName, slot);
}

JSValue* JSXPathResultConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSXPathResultPrototypeTableValues[13] =
{
    { "ANY_TYPE", (intptr_t)0, DontDelete|ReadOnly, 0 },
    { "NUMBER_TYPE", (intptr_t)1, DontDelete|ReadOnly, 0 },
    { "STRING_TYPE", (intptr_t)2, DontDelete|ReadOnly, 0 },
    { "BOOLEAN_TYPE", (intptr_t)3, DontDelete|ReadOnly, 0 },
    { "UNORDERED_NODE_ITERATOR_TYPE", (intptr_t)4, DontDelete|ReadOnly, 0 },
    { "ORDERED_NODE_ITERATOR_TYPE", (intptr_t)5, DontDelete|ReadOnly, 0 },
    { "UNORDERED_NODE_SNAPSHOT_TYPE", (intptr_t)6, DontDelete|ReadOnly, 0 },
    { "ORDERED_NODE_SNAPSHOT_TYPE", (intptr_t)7, DontDelete|ReadOnly, 0 },
    { "ANY_UNORDERED_NODE_TYPE", (intptr_t)8, DontDelete|ReadOnly, 0 },
    { "FIRST_ORDERED_NODE_TYPE", (intptr_t)9, DontDelete|ReadOnly, 0 },
    { "iterateNext", (intptr_t)jsXPathResultPrototypeFunctionIterateNext, DontDelete|Function, 0 },
    { "snapshotItem", (intptr_t)jsXPathResultPrototypeFunctionSnapshotItem, DontDelete|Function, 1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSXPathResultPrototypeTable = { 127, JSXPathResultPrototypeTableValues, 0 };

const ClassInfo JSXPathResultPrototype::s_info = { "XPathResultPrototype", 0, &JSXPathResultPrototypeTable, 0 };

JSObject* JSXPathResultPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSXPathResult.prototype]]");
    return KJS::cacheGlobalObject<JSXPathResultPrototype>(exec, prototypeIdentifier);
}

bool JSXPathResultPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSXPathResultPrototype, JSObject>(exec, &JSXPathResultPrototypeTable, this, propertyName, slot);
}

JSValue* JSXPathResultPrototype::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

const ClassInfo JSXPathResult::s_info = { "XPathResult", 0, &JSXPathResultTable , 0 };

JSXPathResult::JSXPathResult(JSObject* prototype, XPathResult* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSXPathResult::~JSXPathResult()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSXPathResult::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXPathResult, Base>(exec, &JSXPathResultTable, this, propertyName, slot);
}

JSValue* JSXPathResult::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ResultTypeAttrNum: {
        XPathResult* imp = static_cast<XPathResult*>(impl());
        return jsNumber(exec, imp->resultType());
    }
    case NumberValueAttrNum: {
        ExceptionCode ec = 0;
        XPathResult* imp = static_cast<XPathResult*>(impl());
        KJS::JSValue* result = jsNumber(exec, imp->numberValue(ec));
        setDOMException(exec, ec);
        return result;
    }
    case StringValueAttrNum: {
        ExceptionCode ec = 0;
        XPathResult* imp = static_cast<XPathResult*>(impl());
        KJS::JSValue* result = jsString(exec, imp->stringValue(ec));
        setDOMException(exec, ec);
        return result;
    }
    case BooleanValueAttrNum: {
        ExceptionCode ec = 0;
        XPathResult* imp = static_cast<XPathResult*>(impl());
        KJS::JSValue* result = jsBoolean(imp->booleanValue(ec));
        setDOMException(exec, ec);
        return result;
    }
    case SingleNodeValueAttrNum: {
        ExceptionCode ec = 0;
        XPathResult* imp = static_cast<XPathResult*>(impl());
        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->singleNodeValue(ec)));
        setDOMException(exec, ec);
        return result;
    }
    case InvalidIteratorStateAttrNum: {
        XPathResult* imp = static_cast<XPathResult*>(impl());
        return jsBoolean(imp->invalidIteratorState());
    }
    case SnapshotLengthAttrNum: {
        ExceptionCode ec = 0;
        XPathResult* imp = static_cast<XPathResult*>(impl());
        KJS::JSValue* result = jsNumber(exec, imp->snapshotLength(ec));
        setDOMException(exec, ec);
        return result;
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSXPathResult::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[XPathResult.constructor]]");
    return KJS::cacheGlobalObject<JSXPathResultConstructor>(exec, constructorIdentifier);
}

JSValue* jsXPathResultPrototypeFunctionIterateNext(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSXPathResult::s_info))
        return throwError(exec, TypeError);
    JSXPathResult* castedThisObj = static_cast<JSXPathResult*>(thisValue);
    XPathResult* imp = static_cast<XPathResult*>(castedThisObj->impl());
    ExceptionCode ec = 0;


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->iterateNext(ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsXPathResultPrototypeFunctionSnapshotItem(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSXPathResult::s_info))
        return throwError(exec, TypeError);
    JSXPathResult* castedThisObj = static_cast<JSXPathResult*>(thisValue);
    XPathResult* imp = static_cast<XPathResult*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    unsigned index = args[0]->toInt32(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->snapshotItem(index, ec)));
    setDOMException(exec, ec);
    return result;
}

KJS::JSValue* toJS(KJS::ExecState* exec, XPathResult* obj)
{
    return cacheDOMObject<XPathResult, JSXPathResult, JSXPathResultPrototype>(exec, obj);
}
XPathResult* toXPathResult(KJS::JSValue* val)
{
    return val->isObject(&JSXPathResult::s_info) ? static_cast<JSXPathResult*>(val)->impl() : 0;
}

}

#endif // ENABLE(XPATH)
