/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"


#if ENABLE(XPATH)

#include "JSXPathExpression.h"

#include <wtf/GetPtr.h>

#include "JSNode.h"
#include "JSXPathResult.h"
#include "XPathExpression.h"
#include "XPathResult.h"

using namespace KJS;

namespace WebCore {

/* Hash table for prototype */

static const HashTableValue JSXPathExpressionPrototypeTableValues[2] =
{
    { "evaluate", (intptr_t)jsXPathExpressionPrototypeFunctionEvaluate, DontDelete|Function, 3 },
    { 0, 0, 0, 0 }
};

static const HashTable JSXPathExpressionPrototypeTable = { 0, JSXPathExpressionPrototypeTableValues, 0 };

const ClassInfo JSXPathExpressionPrototype::s_info = { "XPathExpressionPrototype", 0, &JSXPathExpressionPrototypeTable, 0 };

JSObject* JSXPathExpressionPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSXPathExpression.prototype]]");
    return KJS::cacheGlobalObject<JSXPathExpressionPrototype>(exec, prototypeIdentifier);
}

bool JSXPathExpressionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSXPathExpressionPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSXPathExpression::s_info = { "XPathExpression", 0, 0 , 0 };

JSXPathExpression::JSXPathExpression(JSObject* prototype, XPathExpression* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSXPathExpression::~JSXPathExpression()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

JSValue* jsXPathExpressionPrototypeFunctionEvaluate(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSXPathExpression::s_info))
        return throwError(exec, TypeError);
    JSXPathExpression* castedThisObj = static_cast<JSXPathExpression*>(thisValue);
    XPathExpression* imp = static_cast<XPathExpression*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* contextNode = toNode(args[0]);
    unsigned short type = args[1]->toInt32(exec);
    XPathResult* inResult = toXPathResult(args[2]);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->evaluate(contextNode, type, inResult, ec)));
    setDOMException(exec, ec);
    return result;
}

KJS::JSValue* toJS(KJS::ExecState* exec, XPathExpression* obj)
{
    return cacheDOMObject<XPathExpression, JSXPathExpression, JSXPathExpressionPrototype>(exec, obj);
}
XPathExpression* toXPathExpression(KJS::JSValue* val)
{
    return val->isObject(&JSXPathExpression::s_info) ? static_cast<JSXPathExpression*>(val)->impl() : 0;
}

}

#endif // ENABLE(XPATH)
