/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"


#if ENABLE(XPATH)

#include "JSXPathEvaluator.h"

#include <wtf/GetPtr.h>

#include "JSCustomXPathNSResolver.h"
#include "JSNode.h"
#include "JSXPathExpression.h"
#include "JSXPathNSResolver.h"
#include "JSXPathResult.h"
#include "PlatformString.h"
#include "XPathEvaluator.h"
#include "XPathExpression.h"
#include "XPathNSResolver.h"
#include "XPathResult.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSXPathEvaluatorTableValues[2] =
{
    { "constructor", (intptr_t)JSXPathEvaluator::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSXPathEvaluatorTable = { 0, JSXPathEvaluatorTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSXPathEvaluatorConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSXPathEvaluatorConstructorTable = { 0, JSXPathEvaluatorConstructorTableValues, 0 };

class JSXPathEvaluatorConstructor : public DOMObject {
public:
    JSXPathEvaluatorConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSXPathEvaluatorPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
    static JSObject* construct(ExecState* exec, JSObject*, const ArgList&)
    {
        return static_cast<JSObject*>(toJS(exec, XPathEvaluator::create()));
    }
    virtual ConstructType getConstructData(ConstructData& constructData)
    {
        constructData.native.function = construct;
        return ConstructTypeNative;
    }
};

const ClassInfo JSXPathEvaluatorConstructor::s_info = { "XPathEvaluatorConstructor", 0, &JSXPathEvaluatorConstructorTable, 0 };

bool JSXPathEvaluatorConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXPathEvaluatorConstructor, DOMObject>(exec, &JSXPathEvaluatorConstructorTable, this, propertyName, slot);
}

JSValue* JSXPathEvaluatorConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSXPathEvaluatorPrototypeTableValues[4] =
{
    { "createExpression", (intptr_t)jsXPathEvaluatorPrototypeFunctionCreateExpression, DontDelete|Function, 2 },
    { "createNSResolver", (intptr_t)jsXPathEvaluatorPrototypeFunctionCreateNSResolver, DontDelete|Function, 1 },
    { "evaluate", (intptr_t)jsXPathEvaluatorPrototypeFunctionEvaluate, DontDelete|Function, 5 },
    { 0, 0, 0, 0 }
};

static const HashTable JSXPathEvaluatorPrototypeTable = { 3, JSXPathEvaluatorPrototypeTableValues, 0 };

const ClassInfo JSXPathEvaluatorPrototype::s_info = { "XPathEvaluatorPrototype", 0, &JSXPathEvaluatorPrototypeTable, 0 };

JSObject* JSXPathEvaluatorPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSXPathEvaluator.prototype]]");
    return KJS::cacheGlobalObject<JSXPathEvaluatorPrototype>(exec, prototypeIdentifier);
}

bool JSXPathEvaluatorPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSXPathEvaluatorPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSXPathEvaluator::s_info = { "XPathEvaluator", 0, &JSXPathEvaluatorTable , 0 };

JSXPathEvaluator::JSXPathEvaluator(JSObject* prototype, XPathEvaluator* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSXPathEvaluator::~JSXPathEvaluator()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSXPathEvaluator::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXPathEvaluator, Base>(exec, &JSXPathEvaluatorTable, this, propertyName, slot);
}

JSValue* JSXPathEvaluator::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSXPathEvaluator::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[XPathEvaluator.constructor]]");
    return KJS::cacheGlobalObject<JSXPathEvaluatorConstructor>(exec, constructorIdentifier);
}

JSValue* jsXPathEvaluatorPrototypeFunctionCreateExpression(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSXPathEvaluator::s_info))
        return throwError(exec, TypeError);
    JSXPathEvaluator* castedThisObj = static_cast<JSXPathEvaluator*>(thisValue);
    XPathEvaluator* imp = static_cast<XPathEvaluator*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& expression = args[0]->toString(exec);
    RefPtr<XPathNSResolver> customResolver;
    XPathNSResolver* resolver = toXPathNSResolver(args[1]);
    if (!resolver) {
        customResolver = JSCustomXPathNSResolver::create(exec, args[1]);
        if (exec->hadException())
            return jsUndefined();
        resolver = customResolver.get();
    }


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createExpression(expression, resolver, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsXPathEvaluatorPrototypeFunctionCreateNSResolver(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSXPathEvaluator::s_info))
        return throwError(exec, TypeError);
    JSXPathEvaluator* castedThisObj = static_cast<JSXPathEvaluator*>(thisValue);
    XPathEvaluator* imp = static_cast<XPathEvaluator*>(castedThisObj->impl());
    Node* nodeResolver = toNode(args[0]);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createNSResolver(nodeResolver)));
    return result;
}

JSValue* jsXPathEvaluatorPrototypeFunctionEvaluate(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSXPathEvaluator::s_info))
        return throwError(exec, TypeError);
    JSXPathEvaluator* castedThisObj = static_cast<JSXPathEvaluator*>(thisValue);
    XPathEvaluator* imp = static_cast<XPathEvaluator*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& expression = args[0]->toString(exec);
    Node* contextNode = toNode(args[1]);
    RefPtr<XPathNSResolver> customResolver;
    XPathNSResolver* resolver = toXPathNSResolver(args[2]);
    if (!resolver) {
        customResolver = JSCustomXPathNSResolver::create(exec, args[2]);
        if (exec->hadException())
            return jsUndefined();
        resolver = customResolver.get();
    }
    unsigned short type = args[3]->toInt32(exec);
    XPathResult* inResult = toXPathResult(args[4]);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->evaluate(expression, contextNode, resolver, type, inResult, ec)));
    setDOMException(exec, ec);
    return result;
}

KJS::JSValue* toJS(KJS::ExecState* exec, XPathEvaluator* obj)
{
    return cacheDOMObject<XPathEvaluator, JSXPathEvaluator, JSXPathEvaluatorPrototype>(exec, obj);
}
XPathEvaluator* toXPathEvaluator(KJS::JSValue* val)
{
    return val->isObject(&JSXPathEvaluator::s_info) ? static_cast<JSXPathEvaluator*>(val)->impl() : 0;
}

}

#endif // ENABLE(XPATH)
