/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSXMLHttpRequest_h
#define JSXMLHttpRequest_h

#include "JSDOMBinding.h"
#include <kjs/JSGlobalObject.h>
#include <kjs/ObjectPrototype.h>

namespace WebCore {

class XMLHttpRequest;

class JSXMLHttpRequest : public DOMObject {
    typedef DOMObject Base;
public:
    JSXMLHttpRequest(KJS::JSObject* prototype, XMLHttpRequest*);
    virtual ~JSXMLHttpRequest();
    virtual bool getOwnPropertySlot(KJS::ExecState*, const KJS::Identifier& propertyName, KJS::PropertySlot&);
    KJS::JSValue* getValueProperty(KJS::ExecState*, int token) const;
    virtual void put(KJS::ExecState*, const KJS::Identifier& propertyName, KJS::JSValue*);
    void putValueProperty(KJS::ExecState*, int, KJS::JSValue*);
    virtual const KJS::ClassInfo* classInfo() const { return &s_info; }
    static const KJS::ClassInfo s_info;

    virtual void mark();

    enum {
        // Attributes
        OnabortAttrNum, OnerrorAttrNum, OnloadAttrNum, OnloadstartAttrNum, 
        OnprogressAttrNum, OnreadystatechangeAttrNum, ReadyStateAttrNum, ResponseTextAttrNum, 
        ResponseXMLAttrNum, StatusAttrNum, StatusTextAttrNum, 
    };

    // Custom attributes
    KJS::JSValue* onabort(KJS::ExecState*) const;
    void setOnabort(KJS::ExecState*, KJS::JSValue*);
    KJS::JSValue* onerror(KJS::ExecState*) const;
    void setOnerror(KJS::ExecState*, KJS::JSValue*);
    KJS::JSValue* onload(KJS::ExecState*) const;
    void setOnload(KJS::ExecState*, KJS::JSValue*);
    KJS::JSValue* onloadstart(KJS::ExecState*) const;
    void setOnloadstart(KJS::ExecState*, KJS::JSValue*);
    KJS::JSValue* onprogress(KJS::ExecState*) const;
    void setOnprogress(KJS::ExecState*, KJS::JSValue*);
    KJS::JSValue* onreadystatechange(KJS::ExecState*) const;
    void setOnreadystatechange(KJS::ExecState*, KJS::JSValue*);

    // Custom functions
    KJS::JSValue* open(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* setRequestHeader(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* send(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* getResponseHeader(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* overrideMimeType(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* addEventListener(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* removeEventListener(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* dispatchEvent(KJS::ExecState*, const KJS::ArgList&);
    XMLHttpRequest* impl() const { return m_impl.get(); }

private:
    RefPtr<XMLHttpRequest> m_impl;
};

KJS::JSValue* toJS(KJS::ExecState*, XMLHttpRequest*);
XMLHttpRequest* toXMLHttpRequest(KJS::JSValue*);

class JSXMLHttpRequestPrototype : public KJS::JSObject {
public:
    static KJS::JSObject* self(KJS::ExecState*);
    virtual const KJS::ClassInfo* classInfo() const { return &s_info; }
    static const KJS::ClassInfo s_info;
    bool getOwnPropertySlot(KJS::ExecState*, const KJS::Identifier&, KJS::PropertySlot&);
    KJS::JSValue* getValueProperty(KJS::ExecState*, int token) const;
    JSXMLHttpRequestPrototype(KJS::ExecState* exec)
        : KJS::JSObject(exec->lexicalGlobalObject()->objectPrototype()) { }
};

// Functions

KJS::JSValue* jsXMLHttpRequestPrototypeFunctionOpen(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsXMLHttpRequestPrototypeFunctionSetRequestHeader(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsXMLHttpRequestPrototypeFunctionSend(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsXMLHttpRequestPrototypeFunctionAbort(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsXMLHttpRequestPrototypeFunctionGetAllResponseHeaders(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsXMLHttpRequestPrototypeFunctionGetResponseHeader(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsXMLHttpRequestPrototypeFunctionOverrideMimeType(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsXMLHttpRequestPrototypeFunctionAddEventListener(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsXMLHttpRequestPrototypeFunctionRemoveEventListener(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsXMLHttpRequestPrototypeFunctionDispatchEvent(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
} // namespace WebCore

#endif
