/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSWheelEvent.h"

#include <wtf/GetPtr.h>

#include "WheelEvent.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWheelEventTableValues[17] =
{
    { "screenX", (intptr_t)JSWheelEvent::ScreenXAttrNum, DontDelete|ReadOnly, 0 },
    { "screenY", (intptr_t)JSWheelEvent::ScreenYAttrNum, DontDelete|ReadOnly, 0 },
    { "clientX", (intptr_t)JSWheelEvent::ClientXAttrNum, DontDelete|ReadOnly, 0 },
    { "clientY", (intptr_t)JSWheelEvent::ClientYAttrNum, DontDelete|ReadOnly, 0 },
    { "ctrlKey", (intptr_t)JSWheelEvent::CtrlKeyAttrNum, DontDelete|ReadOnly, 0 },
    { "shiftKey", (intptr_t)JSWheelEvent::ShiftKeyAttrNum, DontDelete|ReadOnly, 0 },
    { "altKey", (intptr_t)JSWheelEvent::AltKeyAttrNum, DontDelete|ReadOnly, 0 },
    { "metaKey", (intptr_t)JSWheelEvent::MetaKeyAttrNum, DontDelete|ReadOnly, 0 },
    { "wheelDelta", (intptr_t)JSWheelEvent::WheelDeltaAttrNum, DontDelete|ReadOnly, 0 },
    { "wheelDeltaX", (intptr_t)JSWheelEvent::WheelDeltaXAttrNum, DontDelete|ReadOnly, 0 },
    { "wheelDeltaY", (intptr_t)JSWheelEvent::WheelDeltaYAttrNum, DontDelete|ReadOnly, 0 },
    { "offsetX", (intptr_t)JSWheelEvent::OffsetXAttrNum, DontDelete|ReadOnly, 0 },
    { "offsetY", (intptr_t)JSWheelEvent::OffsetYAttrNum, DontDelete|ReadOnly, 0 },
    { "x", (intptr_t)JSWheelEvent::XAttrNum, DontDelete|ReadOnly, 0 },
    { "y", (intptr_t)JSWheelEvent::YAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSWheelEvent::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSWheelEventTable = { 127, JSWheelEventTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSWheelEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSWheelEventConstructorTable = { 0, JSWheelEventConstructorTableValues, 0 };

class JSWheelEventConstructor : public DOMObject {
public:
    JSWheelEventConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSWheelEventPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSWheelEventConstructor::s_info = { "WheelEventConstructor", 0, &JSWheelEventConstructorTable, 0 };

bool JSWheelEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWheelEventConstructor, DOMObject>(exec, &JSWheelEventConstructorTable, this, propertyName, slot);
}

JSValue* JSWheelEventConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSWheelEventPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSWheelEventPrototypeTable = { 0, JSWheelEventPrototypeTableValues, 0 };

const ClassInfo JSWheelEventPrototype::s_info = { "WheelEventPrototype", 0, &JSWheelEventPrototypeTable, 0 };

JSObject* JSWheelEventPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSWheelEvent.prototype]]");
    return KJS::cacheGlobalObject<JSWheelEventPrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSWheelEvent::s_info = { "WheelEvent", &JSUIEvent::s_info, &JSWheelEventTable , 0 };

JSWheelEvent::JSWheelEvent(JSObject* prototype, WheelEvent* impl)
    : JSUIEvent(prototype, impl)
{
}

bool JSWheelEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWheelEvent, Base>(exec, &JSWheelEventTable, this, propertyName, slot);
}

JSValue* JSWheelEvent::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ScreenXAttrNum: {
        WheelEvent* imp = static_cast<WheelEvent*>(impl());
        return jsNumber(exec, imp->screenX());
    }
    case ScreenYAttrNum: {
        WheelEvent* imp = static_cast<WheelEvent*>(impl());
        return jsNumber(exec, imp->screenY());
    }
    case ClientXAttrNum: {
        WheelEvent* imp = static_cast<WheelEvent*>(impl());
        return jsNumber(exec, imp->clientX());
    }
    case ClientYAttrNum: {
        WheelEvent* imp = static_cast<WheelEvent*>(impl());
        return jsNumber(exec, imp->clientY());
    }
    case CtrlKeyAttrNum: {
        WheelEvent* imp = static_cast<WheelEvent*>(impl());
        return jsBoolean(imp->ctrlKey());
    }
    case ShiftKeyAttrNum: {
        WheelEvent* imp = static_cast<WheelEvent*>(impl());
        return jsBoolean(imp->shiftKey());
    }
    case AltKeyAttrNum: {
        WheelEvent* imp = static_cast<WheelEvent*>(impl());
        return jsBoolean(imp->altKey());
    }
    case MetaKeyAttrNum: {
        WheelEvent* imp = static_cast<WheelEvent*>(impl());
        return jsBoolean(imp->metaKey());
    }
    case WheelDeltaAttrNum: {
        WheelEvent* imp = static_cast<WheelEvent*>(impl());
        return jsNumber(exec, imp->wheelDelta());
    }
    case WheelDeltaXAttrNum: {
        WheelEvent* imp = static_cast<WheelEvent*>(impl());
        return jsNumber(exec, imp->wheelDeltaX());
    }
    case WheelDeltaYAttrNum: {
        WheelEvent* imp = static_cast<WheelEvent*>(impl());
        return jsNumber(exec, imp->wheelDeltaY());
    }
    case OffsetXAttrNum: {
        WheelEvent* imp = static_cast<WheelEvent*>(impl());
        return jsNumber(exec, imp->offsetX());
    }
    case OffsetYAttrNum: {
        WheelEvent* imp = static_cast<WheelEvent*>(impl());
        return jsNumber(exec, imp->offsetY());
    }
    case XAttrNum: {
        WheelEvent* imp = static_cast<WheelEvent*>(impl());
        return jsNumber(exec, imp->x());
    }
    case YAttrNum: {
        WheelEvent* imp = static_cast<WheelEvent*>(impl());
        return jsNumber(exec, imp->y());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSWheelEvent::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[WheelEvent.constructor]]");
    return KJS::cacheGlobalObject<JSWheelEventConstructor>(exec, constructorIdentifier);
}


}
