/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSUIEvent.h"

#include <wtf/GetPtr.h>

#include "DOMWindow.h"
#include "JSDOMWindow.h"
#include "UIEvent.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSUIEventTableValues[11] =
{
    { "view", (intptr_t)JSUIEvent::ViewAttrNum, DontDelete|ReadOnly, 0 },
    { "detail", (intptr_t)JSUIEvent::DetailAttrNum, DontDelete|ReadOnly, 0 },
    { "keyCode", (intptr_t)JSUIEvent::KeyCodeAttrNum, DontDelete|ReadOnly, 0 },
    { "charCode", (intptr_t)JSUIEvent::CharCodeAttrNum, DontDelete|ReadOnly, 0 },
    { "layerX", (intptr_t)JSUIEvent::LayerXAttrNum, DontDelete|ReadOnly, 0 },
    { "layerY", (intptr_t)JSUIEvent::LayerYAttrNum, DontDelete|ReadOnly, 0 },
    { "pageX", (intptr_t)JSUIEvent::PageXAttrNum, DontDelete|ReadOnly, 0 },
    { "pageY", (intptr_t)JSUIEvent::PageYAttrNum, DontDelete|ReadOnly, 0 },
    { "which", (intptr_t)JSUIEvent::WhichAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSUIEvent::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSUIEventTable = { 255, JSUIEventTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSUIEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSUIEventConstructorTable = { 0, JSUIEventConstructorTableValues, 0 };

class JSUIEventConstructor : public DOMObject {
public:
    JSUIEventConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSUIEventPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSUIEventConstructor::s_info = { "UIEventConstructor", 0, &JSUIEventConstructorTable, 0 };

bool JSUIEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSUIEventConstructor, DOMObject>(exec, &JSUIEventConstructorTable, this, propertyName, slot);
}

JSValue* JSUIEventConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSUIEventPrototypeTableValues[2] =
{
    { "initUIEvent", (intptr_t)jsUIEventPrototypeFunctionInitUIEvent, DontDelete|Function, 5 },
    { 0, 0, 0, 0 }
};

static const HashTable JSUIEventPrototypeTable = { 0, JSUIEventPrototypeTableValues, 0 };

const ClassInfo JSUIEventPrototype::s_info = { "UIEventPrototype", 0, &JSUIEventPrototypeTable, 0 };

JSObject* JSUIEventPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSUIEvent.prototype]]");
    return KJS::cacheGlobalObject<JSUIEventPrototype>(exec, prototypeIdentifier);
}

bool JSUIEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSUIEventPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSUIEvent::s_info = { "UIEvent", &JSEvent::s_info, &JSUIEventTable , 0 };

JSUIEvent::JSUIEvent(JSObject* prototype, UIEvent* impl)
    : JSEvent(prototype, impl)
{
}

bool JSUIEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSUIEvent, Base>(exec, &JSUIEventTable, this, propertyName, slot);
}

JSValue* JSUIEvent::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ViewAttrNum: {
        UIEvent* imp = static_cast<UIEvent*>(impl());
        return toJS(exec, WTF::getPtr(imp->view()));
    }
    case DetailAttrNum: {
        UIEvent* imp = static_cast<UIEvent*>(impl());
        return jsNumber(exec, imp->detail());
    }
    case KeyCodeAttrNum: {
        UIEvent* imp = static_cast<UIEvent*>(impl());
        return jsNumber(exec, imp->keyCode());
    }
    case CharCodeAttrNum: {
        UIEvent* imp = static_cast<UIEvent*>(impl());
        return jsNumber(exec, imp->charCode());
    }
    case LayerXAttrNum: {
        UIEvent* imp = static_cast<UIEvent*>(impl());
        return jsNumber(exec, imp->layerX());
    }
    case LayerYAttrNum: {
        UIEvent* imp = static_cast<UIEvent*>(impl());
        return jsNumber(exec, imp->layerY());
    }
    case PageXAttrNum: {
        UIEvent* imp = static_cast<UIEvent*>(impl());
        return jsNumber(exec, imp->pageX());
    }
    case PageYAttrNum: {
        UIEvent* imp = static_cast<UIEvent*>(impl());
        return jsNumber(exec, imp->pageY());
    }
    case WhichAttrNum: {
        UIEvent* imp = static_cast<UIEvent*>(impl());
        return jsNumber(exec, imp->which());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSUIEvent::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[UIEvent.constructor]]");
    return KJS::cacheGlobalObject<JSUIEventConstructor>(exec, constructorIdentifier);
}

JSValue* jsUIEventPrototypeFunctionInitUIEvent(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSUIEvent::s_info))
        return throwError(exec, TypeError);
    JSUIEvent* castedThisObj = static_cast<JSUIEvent*>(thisValue);
    UIEvent* imp = static_cast<UIEvent*>(castedThisObj->impl());
    const UString& type = args[0]->toString(exec);
    bool canBubble = args[1]->toBoolean(exec);
    bool cancelable = args[2]->toBoolean(exec);
    DOMWindow* view = toDOMWindow(args[3]);
    int detail = args[4]->toInt32(exec);

    imp->initUIEvent(type, canBubble, cancelable, view, detail);
    return jsUndefined();
}


}
