/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSTreeWalker_h
#define JSTreeWalker_h

#include "JSDOMBinding.h"
#include <kjs/JSGlobalObject.h>
#include <kjs/ObjectPrototype.h>

namespace WebCore {

class TreeWalker;

class JSTreeWalker : public DOMObject {
    typedef DOMObject Base;
public:
    JSTreeWalker(KJS::JSObject* prototype, TreeWalker*);
    virtual ~JSTreeWalker();
    virtual bool getOwnPropertySlot(KJS::ExecState*, const KJS::Identifier& propertyName, KJS::PropertySlot&);
    KJS::JSValue* getValueProperty(KJS::ExecState*, int token) const;
    virtual void put(KJS::ExecState*, const KJS::Identifier& propertyName, KJS::JSValue*);
    void putValueProperty(KJS::ExecState*, int, KJS::JSValue*);
    virtual const KJS::ClassInfo* classInfo() const { return &s_info; }
    static const KJS::ClassInfo s_info;

    virtual void mark();

    enum {
        // Attributes
        RootAttrNum, WhatToShowAttrNum, FilterAttrNum, ExpandEntityReferencesAttrNum, 
        CurrentNodeAttrNum, 
    };

    // Custom functions
    KJS::JSValue* parentNode(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* firstChild(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* lastChild(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* previousSibling(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* nextSibling(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* previousNode(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* nextNode(KJS::ExecState*, const KJS::ArgList&);
    TreeWalker* impl() const { return m_impl.get(); }

private:
    RefPtr<TreeWalker> m_impl;
};

KJS::JSValue* toJS(KJS::ExecState*, TreeWalker*);
TreeWalker* toTreeWalker(KJS::JSValue*);

class JSTreeWalkerPrototype : public KJS::JSObject {
public:
    static KJS::JSObject* self(KJS::ExecState*);
    virtual const KJS::ClassInfo* classInfo() const { return &s_info; }
    static const KJS::ClassInfo s_info;
    bool getOwnPropertySlot(KJS::ExecState*, const KJS::Identifier&, KJS::PropertySlot&);
    JSTreeWalkerPrototype(KJS::ExecState* exec)
        : KJS::JSObject(exec->lexicalGlobalObject()->objectPrototype()) { }
};

// Functions

KJS::JSValue* jsTreeWalkerPrototypeFunctionParentNode(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsTreeWalkerPrototypeFunctionFirstChild(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsTreeWalkerPrototypeFunctionLastChild(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsTreeWalkerPrototypeFunctionPreviousSibling(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsTreeWalkerPrototypeFunctionNextSibling(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsTreeWalkerPrototypeFunctionPreviousNode(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsTreeWalkerPrototypeFunctionNextNode(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
} // namespace WebCore

#endif
