/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSRangeException.h"

#include <wtf/GetPtr.h>

#include "KURL.h"
#include "RangeException.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSRangeExceptionTableValues[5] =
{
    { "code", (intptr_t)JSRangeException::CodeAttrNum, DontDelete|ReadOnly, 0 },
    { "name", (intptr_t)JSRangeException::NameAttrNum, DontDelete|ReadOnly, 0 },
    { "message", (intptr_t)JSRangeException::MessageAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSRangeException::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSRangeExceptionTable = { 127, JSRangeExceptionTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSRangeExceptionConstructorTableValues[3] =
{
    { "BAD_BOUNDARYPOINTS_ERR", (intptr_t)1, DontDelete|ReadOnly, 0 },
    { "INVALID_NODE_TYPE_ERR", (intptr_t)2, DontDelete|ReadOnly, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSRangeExceptionConstructorTable = { 1, JSRangeExceptionConstructorTableValues, 0 };

class JSRangeExceptionConstructor : public DOMObject {
public:
    JSRangeExceptionConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSRangeExceptionPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSRangeExceptionConstructor::s_info = { "RangeExceptionConstructor", 0, &JSRangeExceptionConstructorTable, 0 };

bool JSRangeExceptionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSRangeExceptionConstructor, DOMObject>(exec, &JSRangeExceptionConstructorTable, this, propertyName, slot);
}

JSValue* JSRangeExceptionConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSRangeExceptionPrototypeTableValues[4] =
{
    { "BAD_BOUNDARYPOINTS_ERR", (intptr_t)1, DontDelete|ReadOnly, 0 },
    { "INVALID_NODE_TYPE_ERR", (intptr_t)2, DontDelete|ReadOnly, 0 },
    { "toString", (intptr_t)jsRangeExceptionPrototypeFunctionToString, DontDelete|DontEnum|Function, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSRangeExceptionPrototypeTable = { 3, JSRangeExceptionPrototypeTableValues, 0 };

const ClassInfo JSRangeExceptionPrototype::s_info = { "RangeExceptionPrototype", 0, &JSRangeExceptionPrototypeTable, 0 };

JSObject* JSRangeExceptionPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSRangeException.prototype]]");
    return KJS::cacheGlobalObject<JSRangeExceptionPrototype>(exec, prototypeIdentifier);
}

bool JSRangeExceptionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSRangeExceptionPrototype, JSObject>(exec, &JSRangeExceptionPrototypeTable, this, propertyName, slot);
}

JSValue* JSRangeExceptionPrototype::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

const ClassInfo JSRangeException::s_info = { "RangeException", 0, &JSRangeExceptionTable , 0 };

JSRangeException::JSRangeException(JSObject* prototype, RangeException* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSRangeException::~JSRangeException()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSRangeException::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSRangeException, Base>(exec, &JSRangeExceptionTable, this, propertyName, slot);
}

JSValue* JSRangeException::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CodeAttrNum: {
        RangeException* imp = static_cast<RangeException*>(impl());
        return jsNumber(exec, imp->code());
    }
    case NameAttrNum: {
        RangeException* imp = static_cast<RangeException*>(impl());
        return jsString(exec, imp->name());
    }
    case MessageAttrNum: {
        RangeException* imp = static_cast<RangeException*>(impl());
        return jsString(exec, imp->message());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSRangeException::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[RangeException.constructor]]");
    return KJS::cacheGlobalObject<JSRangeExceptionConstructor>(exec, constructorIdentifier);
}

JSValue* jsRangeExceptionPrototypeFunctionToString(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRangeException::s_info))
        return throwError(exec, TypeError);
    JSRangeException* castedThisObj = static_cast<JSRangeException*>(thisValue);
    RangeException* imp = static_cast<RangeException*>(castedThisObj->impl());


    KJS::JSValue* result = jsString(exec, imp->toString());
    return result;
}

KJS::JSValue* toJS(KJS::ExecState* exec, RangeException* obj)
{
    return cacheDOMObject<RangeException, JSRangeException, JSRangeExceptionPrototype>(exec, obj);
}
RangeException* toRangeException(KJS::JSValue* val)
{
    return val->isObject(&JSRangeException::s_info) ? static_cast<JSRangeException*>(val)->impl() : 0;
}

}
