/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSRange.h"

#include <wtf/GetPtr.h>

#include "DocumentFragment.h"
#include "JSDocumentFragment.h"
#include "JSNode.h"
#include "JSRange.h"
#include "KURL.h"
#include "Node.h"
#include "Range.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSRangeTableValues[8] =
{
    { "startContainer", (intptr_t)JSRange::StartContainerAttrNum, DontDelete|ReadOnly, 0 },
    { "startOffset", (intptr_t)JSRange::StartOffsetAttrNum, DontDelete|ReadOnly, 0 },
    { "endContainer", (intptr_t)JSRange::EndContainerAttrNum, DontDelete|ReadOnly, 0 },
    { "endOffset", (intptr_t)JSRange::EndOffsetAttrNum, DontDelete|ReadOnly, 0 },
    { "collapsed", (intptr_t)JSRange::CollapsedAttrNum, DontDelete|ReadOnly, 0 },
    { "commonAncestorContainer", (intptr_t)JSRange::CommonAncestorContainerAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSRange::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSRangeTable = { 63, JSRangeTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSRangeConstructorTableValues[9] =
{
    { "START_TO_START", (intptr_t)0, DontDelete|ReadOnly, 0 },
    { "START_TO_END", (intptr_t)1, DontDelete|ReadOnly, 0 },
    { "END_TO_END", (intptr_t)2, DontDelete|ReadOnly, 0 },
    { "END_TO_START", (intptr_t)3, DontDelete|ReadOnly, 0 },
    { "NODE_BEFORE", (intptr_t)0, DontDelete|ReadOnly, 0 },
    { "NODE_AFTER", (intptr_t)1, DontDelete|ReadOnly, 0 },
    { "NODE_BEFORE_AND_AFTER", (intptr_t)2, DontDelete|ReadOnly, 0 },
    { "NODE_INSIDE", (intptr_t)3, DontDelete|ReadOnly, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSRangeConstructorTable = { 511, JSRangeConstructorTableValues, 0 };

class JSRangeConstructor : public DOMObject {
public:
    JSRangeConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSRangePrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSRangeConstructor::s_info = { "RangeConstructor", 0, &JSRangeConstructorTable, 0 };

bool JSRangeConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSRangeConstructor, DOMObject>(exec, &JSRangeConstructorTable, this, propertyName, slot);
}

JSValue* JSRangeConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSRangePrototypeTableValues[32] =
{
    { "START_TO_START", (intptr_t)0, DontDelete|ReadOnly, 0 },
    { "START_TO_END", (intptr_t)1, DontDelete|ReadOnly, 0 },
    { "END_TO_END", (intptr_t)2, DontDelete|ReadOnly, 0 },
    { "END_TO_START", (intptr_t)3, DontDelete|ReadOnly, 0 },
    { "NODE_BEFORE", (intptr_t)0, DontDelete|ReadOnly, 0 },
    { "NODE_AFTER", (intptr_t)1, DontDelete|ReadOnly, 0 },
    { "NODE_BEFORE_AND_AFTER", (intptr_t)2, DontDelete|ReadOnly, 0 },
    { "NODE_INSIDE", (intptr_t)3, DontDelete|ReadOnly, 0 },
    { "setStart", (intptr_t)jsRangePrototypeFunctionSetStart, DontDelete|Function, 2 },
    { "setEnd", (intptr_t)jsRangePrototypeFunctionSetEnd, DontDelete|Function, 2 },
    { "setStartBefore", (intptr_t)jsRangePrototypeFunctionSetStartBefore, DontDelete|Function, 1 },
    { "setStartAfter", (intptr_t)jsRangePrototypeFunctionSetStartAfter, DontDelete|Function, 1 },
    { "setEndBefore", (intptr_t)jsRangePrototypeFunctionSetEndBefore, DontDelete|Function, 1 },
    { "setEndAfter", (intptr_t)jsRangePrototypeFunctionSetEndAfter, DontDelete|Function, 1 },
    { "collapse", (intptr_t)jsRangePrototypeFunctionCollapse, DontDelete|Function, 1 },
    { "selectNode", (intptr_t)jsRangePrototypeFunctionSelectNode, DontDelete|Function, 1 },
    { "selectNodeContents", (intptr_t)jsRangePrototypeFunctionSelectNodeContents, DontDelete|Function, 1 },
    { "compareBoundaryPoints", (intptr_t)jsRangePrototypeFunctionCompareBoundaryPoints, DontDelete|Function, 2 },
    { "deleteContents", (intptr_t)jsRangePrototypeFunctionDeleteContents, DontDelete|Function, 0 },
    { "extractContents", (intptr_t)jsRangePrototypeFunctionExtractContents, DontDelete|Function, 0 },
    { "cloneContents", (intptr_t)jsRangePrototypeFunctionCloneContents, DontDelete|Function, 0 },
    { "insertNode", (intptr_t)jsRangePrototypeFunctionInsertNode, DontDelete|Function, 1 },
    { "surroundContents", (intptr_t)jsRangePrototypeFunctionSurroundContents, DontDelete|Function, 1 },
    { "cloneRange", (intptr_t)jsRangePrototypeFunctionCloneRange, DontDelete|Function, 0 },
    { "toString", (intptr_t)jsRangePrototypeFunctionToString, DontDelete|Function, 0 },
    { "detach", (intptr_t)jsRangePrototypeFunctionDetach, DontDelete|Function, 0 },
    { "createContextualFragment", (intptr_t)jsRangePrototypeFunctionCreateContextualFragment, DontDelete|Function, 1 },
    { "intersectsNode", (intptr_t)jsRangePrototypeFunctionIntersectsNode, DontDelete|Function, 1 },
    { "compareNode", (intptr_t)jsRangePrototypeFunctionCompareNode, DontDelete|Function, 1 },
    { "comparePoint", (intptr_t)jsRangePrototypeFunctionComparePoint, DontDelete|Function, 2 },
    { "isPointInRange", (intptr_t)jsRangePrototypeFunctionIsPointInRange, DontDelete|Function, 2 },
    { 0, 0, 0, 0 }
};

static const HashTable JSRangePrototypeTable = { 1023, JSRangePrototypeTableValues, 0 };

const ClassInfo JSRangePrototype::s_info = { "RangePrototype", 0, &JSRangePrototypeTable, 0 };

JSObject* JSRangePrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSRange.prototype]]");
    return KJS::cacheGlobalObject<JSRangePrototype>(exec, prototypeIdentifier);
}

bool JSRangePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSRangePrototype, JSObject>(exec, &JSRangePrototypeTable, this, propertyName, slot);
}

JSValue* JSRangePrototype::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

const ClassInfo JSRange::s_info = { "Range", 0, &JSRangeTable , 0 };

JSRange::JSRange(JSObject* prototype, Range* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSRange::~JSRange()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSRange::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSRange, Base>(exec, &JSRangeTable, this, propertyName, slot);
}

JSValue* JSRange::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case StartContainerAttrNum: {
        ExceptionCode ec = 0;
        Range* imp = static_cast<Range*>(impl());
        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->startContainer(ec)));
        setDOMException(exec, ec);
        return result;
    }
    case StartOffsetAttrNum: {
        ExceptionCode ec = 0;
        Range* imp = static_cast<Range*>(impl());
        KJS::JSValue* result = jsNumber(exec, imp->startOffset(ec));
        setDOMException(exec, ec);
        return result;
    }
    case EndContainerAttrNum: {
        ExceptionCode ec = 0;
        Range* imp = static_cast<Range*>(impl());
        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->endContainer(ec)));
        setDOMException(exec, ec);
        return result;
    }
    case EndOffsetAttrNum: {
        ExceptionCode ec = 0;
        Range* imp = static_cast<Range*>(impl());
        KJS::JSValue* result = jsNumber(exec, imp->endOffset(ec));
        setDOMException(exec, ec);
        return result;
    }
    case CollapsedAttrNum: {
        ExceptionCode ec = 0;
        Range* imp = static_cast<Range*>(impl());
        KJS::JSValue* result = jsBoolean(imp->collapsed(ec));
        setDOMException(exec, ec);
        return result;
    }
    case CommonAncestorContainerAttrNum: {
        ExceptionCode ec = 0;
        Range* imp = static_cast<Range*>(impl());
        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->commonAncestorContainer(ec)));
        setDOMException(exec, ec);
        return result;
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSRange::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[Range.constructor]]");
    return KJS::cacheGlobalObject<JSRangeConstructor>(exec, constructorIdentifier);
}

JSValue* jsRangePrototypeFunctionSetStart(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRange::s_info))
        return throwError(exec, TypeError);
    JSRange* castedThisObj = static_cast<JSRange*>(thisValue);
    Range* imp = static_cast<Range*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* refNode = toNode(args[0]);
    int offset = args[1]->toInt32(exec);

    imp->setStart(refNode, offset, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsRangePrototypeFunctionSetEnd(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRange::s_info))
        return throwError(exec, TypeError);
    JSRange* castedThisObj = static_cast<JSRange*>(thisValue);
    Range* imp = static_cast<Range*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* refNode = toNode(args[0]);
    int offset = args[1]->toInt32(exec);

    imp->setEnd(refNode, offset, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsRangePrototypeFunctionSetStartBefore(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRange::s_info))
        return throwError(exec, TypeError);
    JSRange* castedThisObj = static_cast<JSRange*>(thisValue);
    Range* imp = static_cast<Range*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* refNode = toNode(args[0]);

    imp->setStartBefore(refNode, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsRangePrototypeFunctionSetStartAfter(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRange::s_info))
        return throwError(exec, TypeError);
    JSRange* castedThisObj = static_cast<JSRange*>(thisValue);
    Range* imp = static_cast<Range*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* refNode = toNode(args[0]);

    imp->setStartAfter(refNode, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsRangePrototypeFunctionSetEndBefore(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRange::s_info))
        return throwError(exec, TypeError);
    JSRange* castedThisObj = static_cast<JSRange*>(thisValue);
    Range* imp = static_cast<Range*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* refNode = toNode(args[0]);

    imp->setEndBefore(refNode, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsRangePrototypeFunctionSetEndAfter(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRange::s_info))
        return throwError(exec, TypeError);
    JSRange* castedThisObj = static_cast<JSRange*>(thisValue);
    Range* imp = static_cast<Range*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* refNode = toNode(args[0]);

    imp->setEndAfter(refNode, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsRangePrototypeFunctionCollapse(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRange::s_info))
        return throwError(exec, TypeError);
    JSRange* castedThisObj = static_cast<JSRange*>(thisValue);
    Range* imp = static_cast<Range*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    bool toStart = args[0]->toBoolean(exec);

    imp->collapse(toStart, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsRangePrototypeFunctionSelectNode(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRange::s_info))
        return throwError(exec, TypeError);
    JSRange* castedThisObj = static_cast<JSRange*>(thisValue);
    Range* imp = static_cast<Range*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* refNode = toNode(args[0]);

    imp->selectNode(refNode, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsRangePrototypeFunctionSelectNodeContents(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRange::s_info))
        return throwError(exec, TypeError);
    JSRange* castedThisObj = static_cast<JSRange*>(thisValue);
    Range* imp = static_cast<Range*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* refNode = toNode(args[0]);

    imp->selectNodeContents(refNode, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsRangePrototypeFunctionCompareBoundaryPoints(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRange::s_info))
        return throwError(exec, TypeError);
    JSRange* castedThisObj = static_cast<JSRange*>(thisValue);
    Range* imp = static_cast<Range*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Range::CompareHow how = static_cast<Range::CompareHow>(args[0]->toInt32(exec));
    Range* sourceRange = toRange(args[1]);


    KJS::JSValue* result = jsNumber(exec, imp->compareBoundaryPoints(how, sourceRange, ec));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsRangePrototypeFunctionDeleteContents(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRange::s_info))
        return throwError(exec, TypeError);
    JSRange* castedThisObj = static_cast<JSRange*>(thisValue);
    Range* imp = static_cast<Range*>(castedThisObj->impl());
    ExceptionCode ec = 0;

    imp->deleteContents(ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsRangePrototypeFunctionExtractContents(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRange::s_info))
        return throwError(exec, TypeError);
    JSRange* castedThisObj = static_cast<JSRange*>(thisValue);
    Range* imp = static_cast<Range*>(castedThisObj->impl());
    ExceptionCode ec = 0;


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->extractContents(ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsRangePrototypeFunctionCloneContents(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRange::s_info))
        return throwError(exec, TypeError);
    JSRange* castedThisObj = static_cast<JSRange*>(thisValue);
    Range* imp = static_cast<Range*>(castedThisObj->impl());
    ExceptionCode ec = 0;


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->cloneContents(ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsRangePrototypeFunctionInsertNode(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRange::s_info))
        return throwError(exec, TypeError);
    JSRange* castedThisObj = static_cast<JSRange*>(thisValue);
    Range* imp = static_cast<Range*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* newNode = toNode(args[0]);

    imp->insertNode(newNode, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsRangePrototypeFunctionSurroundContents(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRange::s_info))
        return throwError(exec, TypeError);
    JSRange* castedThisObj = static_cast<JSRange*>(thisValue);
    Range* imp = static_cast<Range*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* newParent = toNode(args[0]);

    imp->surroundContents(newParent, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsRangePrototypeFunctionCloneRange(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRange::s_info))
        return throwError(exec, TypeError);
    JSRange* castedThisObj = static_cast<JSRange*>(thisValue);
    Range* imp = static_cast<Range*>(castedThisObj->impl());
    ExceptionCode ec = 0;


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->cloneRange(ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsRangePrototypeFunctionToString(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRange::s_info))
        return throwError(exec, TypeError);
    JSRange* castedThisObj = static_cast<JSRange*>(thisValue);
    Range* imp = static_cast<Range*>(castedThisObj->impl());
    ExceptionCode ec = 0;


    KJS::JSValue* result = jsString(exec, imp->toString(ec));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsRangePrototypeFunctionDetach(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRange::s_info))
        return throwError(exec, TypeError);
    JSRange* castedThisObj = static_cast<JSRange*>(thisValue);
    Range* imp = static_cast<Range*>(castedThisObj->impl());
    ExceptionCode ec = 0;

    imp->detach(ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsRangePrototypeFunctionCreateContextualFragment(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRange::s_info))
        return throwError(exec, TypeError);
    JSRange* castedThisObj = static_cast<JSRange*>(thisValue);
    Range* imp = static_cast<Range*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& html = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createContextualFragment(html, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsRangePrototypeFunctionIntersectsNode(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRange::s_info))
        return throwError(exec, TypeError);
    JSRange* castedThisObj = static_cast<JSRange*>(thisValue);
    Range* imp = static_cast<Range*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* refNode = toNode(args[0]);


    KJS::JSValue* result = jsBoolean(imp->intersectsNode(refNode, ec));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsRangePrototypeFunctionCompareNode(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRange::s_info))
        return throwError(exec, TypeError);
    JSRange* castedThisObj = static_cast<JSRange*>(thisValue);
    Range* imp = static_cast<Range*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* refNode = toNode(args[0]);


    KJS::JSValue* result = jsNumber(exec, imp->compareNode(refNode, ec));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsRangePrototypeFunctionComparePoint(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRange::s_info))
        return throwError(exec, TypeError);
    JSRange* castedThisObj = static_cast<JSRange*>(thisValue);
    Range* imp = static_cast<Range*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* refNode = toNode(args[0]);
    int offset = args[1]->toInt32(exec);


    KJS::JSValue* result = jsNumber(exec, imp->comparePoint(refNode, offset, ec));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsRangePrototypeFunctionIsPointInRange(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSRange::s_info))
        return throwError(exec, TypeError);
    JSRange* castedThisObj = static_cast<JSRange*>(thisValue);
    Range* imp = static_cast<Range*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* refNode = toNode(args[0]);
    int offset = args[1]->toInt32(exec);


    KJS::JSValue* result = jsBoolean(imp->isPointInRange(refNode, offset, ec));
    setDOMException(exec, ec);
    return result;
}

KJS::JSValue* toJS(KJS::ExecState* exec, Range* obj)
{
    return cacheDOMObject<Range, JSRange, JSRangePrototype>(exec, obj);
}
Range* toRange(KJS::JSValue* val)
{
    return val->isObject(&JSRange::s_info) ? static_cast<JSRange*>(val)->impl() : 0;
}

}
