/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSProcessingInstruction.h"

#include <wtf/GetPtr.h>

#include "JSStyleSheet.h"
#include "KURL.h"
#include "ProcessingInstruction.h"
#include "StyleSheet.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSProcessingInstructionTableValues[5] =
{
    { "target", (intptr_t)JSProcessingInstruction::TargetAttrNum, DontDelete|ReadOnly, 0 },
    { "data", (intptr_t)JSProcessingInstruction::DataAttrNum, DontDelete, 0 },
    { "sheet", (intptr_t)JSProcessingInstruction::SheetAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSProcessingInstruction::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSProcessingInstructionTable = { 7, JSProcessingInstructionTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSProcessingInstructionConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSProcessingInstructionConstructorTable = { 0, JSProcessingInstructionConstructorTableValues, 0 };

class JSProcessingInstructionConstructor : public DOMObject {
public:
    JSProcessingInstructionConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSProcessingInstructionPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSProcessingInstructionConstructor::s_info = { "ProcessingInstructionConstructor", 0, &JSProcessingInstructionConstructorTable, 0 };

bool JSProcessingInstructionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSProcessingInstructionConstructor, DOMObject>(exec, &JSProcessingInstructionConstructorTable, this, propertyName, slot);
}

JSValue* JSProcessingInstructionConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSProcessingInstructionPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSProcessingInstructionPrototypeTable = { 0, JSProcessingInstructionPrototypeTableValues, 0 };

const ClassInfo JSProcessingInstructionPrototype::s_info = { "ProcessingInstructionPrototype", 0, &JSProcessingInstructionPrototypeTable, 0 };

JSObject* JSProcessingInstructionPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSProcessingInstruction.prototype]]");
    return KJS::cacheGlobalObject<JSProcessingInstructionPrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSProcessingInstruction::s_info = { "ProcessingInstruction", &JSNode::s_info, &JSProcessingInstructionTable , 0 };

JSProcessingInstruction::JSProcessingInstruction(JSObject* prototype, ProcessingInstruction* impl)
    : JSNode(prototype, impl)
{
}

bool JSProcessingInstruction::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSProcessingInstruction, Base>(exec, &JSProcessingInstructionTable, this, propertyName, slot);
}

JSValue* JSProcessingInstruction::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case TargetAttrNum: {
        ProcessingInstruction* imp = static_cast<ProcessingInstruction*>(impl());
        return jsStringOrNull(exec, imp->target());
    }
    case DataAttrNum: {
        ProcessingInstruction* imp = static_cast<ProcessingInstruction*>(impl());
        return jsStringOrNull(exec, imp->data());
    }
    case SheetAttrNum: {
        ProcessingInstruction* imp = static_cast<ProcessingInstruction*>(impl());
        return toJS(exec, WTF::getPtr(imp->sheet()));
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSProcessingInstruction::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSProcessingInstruction, Base>(exec, propertyName, value, &JSProcessingInstructionTable, this);
}

void JSProcessingInstruction::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case DataAttrNum: {
        ProcessingInstruction* imp = static_cast<ProcessingInstruction*>(impl());
        ExceptionCode ec = 0;
        imp->setData(valueToStringWithNullCheck(exec, value), ec);
        setDOMException(exec, ec);
        break;
    }
    }
}

JSValue* JSProcessingInstruction::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[ProcessingInstruction.constructor]]");
    return KJS::cacheGlobalObject<JSProcessingInstructionConstructor>(exec, constructorIdentifier);
}


}
