/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSNotation.h"

#include <wtf/GetPtr.h>

#include "KURL.h"
#include "Notation.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSNotationTableValues[4] =
{
    { "publicId", (intptr_t)JSNotation::PublicIdAttrNum, DontDelete|ReadOnly, 0 },
    { "systemId", (intptr_t)JSNotation::SystemIdAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSNotation::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSNotationTable = { 15, JSNotationTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSNotationConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSNotationConstructorTable = { 0, JSNotationConstructorTableValues, 0 };

class JSNotationConstructor : public DOMObject {
public:
    JSNotationConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSNotationPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSNotationConstructor::s_info = { "NotationConstructor", 0, &JSNotationConstructorTable, 0 };

bool JSNotationConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNotationConstructor, DOMObject>(exec, &JSNotationConstructorTable, this, propertyName, slot);
}

JSValue* JSNotationConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSNotationPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSNotationPrototypeTable = { 0, JSNotationPrototypeTableValues, 0 };

const ClassInfo JSNotationPrototype::s_info = { "NotationPrototype", 0, &JSNotationPrototypeTable, 0 };

JSObject* JSNotationPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSNotation.prototype]]");
    return KJS::cacheGlobalObject<JSNotationPrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSNotation::s_info = { "Notation", &JSNode::s_info, &JSNotationTable , 0 };

JSNotation::JSNotation(JSObject* prototype, Notation* impl)
    : JSNode(prototype, impl)
{
}

bool JSNotation::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNotation, Base>(exec, &JSNotationTable, this, propertyName, slot);
}

JSValue* JSNotation::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case PublicIdAttrNum: {
        Notation* imp = static_cast<Notation*>(impl());
        return jsStringOrNull(exec, imp->publicId());
    }
    case SystemIdAttrNum: {
        Notation* imp = static_cast<Notation*>(impl());
        return jsStringOrNull(exec, imp->systemId());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSNotation::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[Notation.constructor]]");
    return KJS::cacheGlobalObject<JSNotationConstructor>(exec, constructorIdentifier);
}


}
