/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSNodeIterator.h"

#include <wtf/GetPtr.h>

#include "JSNode.h"
#include "JSNodeFilter.h"
#include "Node.h"
#include "NodeFilter.h"
#include "NodeIterator.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSNodeIteratorTableValues[7] =
{
    { "root", (intptr_t)JSNodeIterator::RootAttrNum, DontDelete|ReadOnly, 0 },
    { "whatToShow", (intptr_t)JSNodeIterator::WhatToShowAttrNum, DontDelete|ReadOnly, 0 },
    { "filter", (intptr_t)JSNodeIterator::FilterAttrNum, DontDelete|ReadOnly, 0 },
    { "expandEntityReferences", (intptr_t)JSNodeIterator::ExpandEntityReferencesAttrNum, DontDelete|ReadOnly, 0 },
    { "referenceNode", (intptr_t)JSNodeIterator::ReferenceNodeAttrNum, DontDelete|ReadOnly, 0 },
    { "pointerBeforeReferenceNode", (intptr_t)JSNodeIterator::PointerBeforeReferenceNodeAttrNum, DontDelete|ReadOnly, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSNodeIteratorTable = { 255, JSNodeIteratorTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSNodeIteratorPrototypeTableValues[4] =
{
    { "nextNode", (intptr_t)jsNodeIteratorPrototypeFunctionNextNode, DontDelete|Function, 0 },
    { "previousNode", (intptr_t)jsNodeIteratorPrototypeFunctionPreviousNode, DontDelete|Function, 0 },
    { "detach", (intptr_t)jsNodeIteratorPrototypeFunctionDetach, DontDelete|Function, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSNodeIteratorPrototypeTable = { 3, JSNodeIteratorPrototypeTableValues, 0 };

const ClassInfo JSNodeIteratorPrototype::s_info = { "NodeIteratorPrototype", 0, &JSNodeIteratorPrototypeTable, 0 };

JSObject* JSNodeIteratorPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSNodeIterator.prototype]]");
    return KJS::cacheGlobalObject<JSNodeIteratorPrototype>(exec, prototypeIdentifier);
}

bool JSNodeIteratorPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSNodeIteratorPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSNodeIterator::s_info = { "NodeIterator", 0, &JSNodeIteratorTable , 0 };

JSNodeIterator::JSNodeIterator(JSObject* prototype, NodeIterator* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSNodeIterator::~JSNodeIterator()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSNodeIterator::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNodeIterator, Base>(exec, &JSNodeIteratorTable, this, propertyName, slot);
}

JSValue* JSNodeIterator::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case RootAttrNum: {
        NodeIterator* imp = static_cast<NodeIterator*>(impl());
        return toJS(exec, WTF::getPtr(imp->root()));
    }
    case WhatToShowAttrNum: {
        NodeIterator* imp = static_cast<NodeIterator*>(impl());
        return jsNumber(exec, imp->whatToShow());
    }
    case FilterAttrNum: {
        NodeIterator* imp = static_cast<NodeIterator*>(impl());
        return toJS(exec, WTF::getPtr(imp->filter()));
    }
    case ExpandEntityReferencesAttrNum: {
        NodeIterator* imp = static_cast<NodeIterator*>(impl());
        return jsBoolean(imp->expandEntityReferences());
    }
    case ReferenceNodeAttrNum: {
        NodeIterator* imp = static_cast<NodeIterator*>(impl());
        return toJS(exec, WTF::getPtr(imp->referenceNode()));
    }
    case PointerBeforeReferenceNodeAttrNum: {
        NodeIterator* imp = static_cast<NodeIterator*>(impl());
        return jsBoolean(imp->pointerBeforeReferenceNode());
    }
    }
    return 0;
}

JSValue* jsNodeIteratorPrototypeFunctionNextNode(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSNodeIterator::s_info))
        return throwError(exec, TypeError);
    JSNodeIterator* castedThisObj = static_cast<JSNodeIterator*>(thisValue);
    return castedThisObj->nextNode(exec, args);
}

JSValue* jsNodeIteratorPrototypeFunctionPreviousNode(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSNodeIterator::s_info))
        return throwError(exec, TypeError);
    JSNodeIterator* castedThisObj = static_cast<JSNodeIterator*>(thisValue);
    return castedThisObj->previousNode(exec, args);
}

JSValue* jsNodeIteratorPrototypeFunctionDetach(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSNodeIterator::s_info))
        return throwError(exec, TypeError);
    JSNodeIterator* castedThisObj = static_cast<JSNodeIterator*>(thisValue);
    NodeIterator* imp = static_cast<NodeIterator*>(castedThisObj->impl());

    imp->detach();
    return jsUndefined();
}

KJS::JSValue* toJS(KJS::ExecState* exec, NodeIterator* obj)
{
    return cacheDOMObject<NodeIterator, JSNodeIterator, JSNodeIteratorPrototype>(exec, obj);
}
NodeIterator* toNodeIterator(KJS::JSValue* val)
{
    return val->isObject(&JSNodeIterator::s_info) ? static_cast<JSNodeIterator*>(val)->impl() : 0;
}

}
