/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSNamedNodeMap.h"

#include <wtf/GetPtr.h>

#include <kjs/PropertyNameArray.h>
#include "AtomicString.h"
#include "JSNode.h"
#include "NamedNodeMap.h"
#include "Node.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSNamedNodeMapTableValues[3] =
{
    { "length", (intptr_t)JSNamedNodeMap::LengthAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSNamedNodeMap::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSNamedNodeMapTable = { 15, JSNamedNodeMapTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSNamedNodeMapConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSNamedNodeMapConstructorTable = { 0, JSNamedNodeMapConstructorTableValues, 0 };

class JSNamedNodeMapConstructor : public DOMObject {
public:
    JSNamedNodeMapConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSNamedNodeMapPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSNamedNodeMapConstructor::s_info = { "NamedNodeMapConstructor", 0, &JSNamedNodeMapConstructorTable, 0 };

bool JSNamedNodeMapConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNamedNodeMapConstructor, DOMObject>(exec, &JSNamedNodeMapConstructorTable, this, propertyName, slot);
}

JSValue* JSNamedNodeMapConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSNamedNodeMapPrototypeTableValues[8] =
{
    { "getNamedItem", (intptr_t)jsNamedNodeMapPrototypeFunctionGetNamedItem, DontDelete|Function, 1 },
    { "setNamedItem", (intptr_t)jsNamedNodeMapPrototypeFunctionSetNamedItem, DontDelete|Function, 1 },
    { "removeNamedItem", (intptr_t)jsNamedNodeMapPrototypeFunctionRemoveNamedItem, DontDelete|Function, 1 },
    { "item", (intptr_t)jsNamedNodeMapPrototypeFunctionItem, DontDelete|Function, 1 },
    { "getNamedItemNS", (intptr_t)jsNamedNodeMapPrototypeFunctionGetNamedItemNS, DontDelete|Function, 2 },
    { "setNamedItemNS", (intptr_t)jsNamedNodeMapPrototypeFunctionSetNamedItemNS, DontDelete|Function, 1 },
    { "removeNamedItemNS", (intptr_t)jsNamedNodeMapPrototypeFunctionRemoveNamedItemNS, DontDelete|Function, 2 },
    { 0, 0, 0, 0 }
};

static const HashTable JSNamedNodeMapPrototypeTable = { 15, JSNamedNodeMapPrototypeTableValues, 0 };

const ClassInfo JSNamedNodeMapPrototype::s_info = { "NamedNodeMapPrototype", 0, &JSNamedNodeMapPrototypeTable, 0 };

JSObject* JSNamedNodeMapPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSNamedNodeMap.prototype]]");
    return KJS::cacheGlobalObject<JSNamedNodeMapPrototype>(exec, prototypeIdentifier);
}

bool JSNamedNodeMapPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSNamedNodeMapPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSNamedNodeMap::s_info = { "NamedNodeMap", 0, &JSNamedNodeMapTable , 0 };

JSNamedNodeMap::JSNamedNodeMap(JSObject* prototype, NamedNodeMap* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSNamedNodeMap::~JSNamedNodeMap()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSNamedNodeMap::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    JSValue* proto = prototype();
    if (proto->isObject() && static_cast<JSObject*>(proto)->hasProperty(exec, propertyName))
        return false;

    const HashEntry* entry = JSNamedNodeMapTable.entry(exec, propertyName);
    if (entry) {
        slot.setStaticEntry(this, entry, staticValueGetter<JSNamedNodeMap>);
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<NamedNodeMap*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<NamedNodeMap*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    return getStaticValueSlot<JSNamedNodeMap, Base>(exec, &JSNamedNodeMapTable, this, propertyName, slot);
}

bool JSNamedNodeMap::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<NamedNodeMap*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue* JSNamedNodeMap::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case LengthAttrNum: {
        NamedNodeMap* imp = static_cast<NamedNodeMap*>(impl());
        return jsNumber(exec, imp->length());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSNamedNodeMap::getPropertyNames(ExecState* exec, PropertyNameArray& propertyNames)
{
    for (unsigned i = 0; i < static_cast<NamedNodeMap*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getPropertyNames(exec, propertyNames);
}

JSValue* JSNamedNodeMap::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[NamedNodeMap.constructor]]");
    return KJS::cacheGlobalObject<JSNamedNodeMapConstructor>(exec, constructorIdentifier);
}

JSValue* jsNamedNodeMapPrototypeFunctionGetNamedItem(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSNamedNodeMap::s_info))
        return throwError(exec, TypeError);
    JSNamedNodeMap* castedThisObj = static_cast<JSNamedNodeMap*>(thisValue);
    NamedNodeMap* imp = static_cast<NamedNodeMap*>(castedThisObj->impl());
    const UString& name = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getNamedItem(name)));
    return result;
}

JSValue* jsNamedNodeMapPrototypeFunctionSetNamedItem(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSNamedNodeMap::s_info))
        return throwError(exec, TypeError);
    JSNamedNodeMap* castedThisObj = static_cast<JSNamedNodeMap*>(thisValue);
    NamedNodeMap* imp = static_cast<NamedNodeMap*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* node = toNode(args[0]);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->setNamedItem(node, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsNamedNodeMapPrototypeFunctionRemoveNamedItem(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSNamedNodeMap::s_info))
        return throwError(exec, TypeError);
    JSNamedNodeMap* castedThisObj = static_cast<JSNamedNodeMap*>(thisValue);
    NamedNodeMap* imp = static_cast<NamedNodeMap*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& name = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->removeNamedItem(name, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsNamedNodeMapPrototypeFunctionItem(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSNamedNodeMap::s_info))
        return throwError(exec, TypeError);
    JSNamedNodeMap* castedThisObj = static_cast<JSNamedNodeMap*>(thisValue);
    NamedNodeMap* imp = static_cast<NamedNodeMap*>(castedThisObj->impl());
    unsigned index = args[0]->toInt32(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->item(index)));
    return result;
}

JSValue* jsNamedNodeMapPrototypeFunctionGetNamedItemNS(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSNamedNodeMap::s_info))
        return throwError(exec, TypeError);
    JSNamedNodeMap* castedThisObj = static_cast<JSNamedNodeMap*>(thisValue);
    NamedNodeMap* imp = static_cast<NamedNodeMap*>(castedThisObj->impl());
    const UString& namespaceURI = valueToStringWithNullCheck(exec, args[0]);
    const UString& localName = args[1]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getNamedItemNS(namespaceURI, localName)));
    return result;
}

JSValue* jsNamedNodeMapPrototypeFunctionSetNamedItemNS(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSNamedNodeMap::s_info))
        return throwError(exec, TypeError);
    JSNamedNodeMap* castedThisObj = static_cast<JSNamedNodeMap*>(thisValue);
    NamedNodeMap* imp = static_cast<NamedNodeMap*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* node = toNode(args[0]);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->setNamedItemNS(node, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsNamedNodeMapPrototypeFunctionRemoveNamedItemNS(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSNamedNodeMap::s_info))
        return throwError(exec, TypeError);
    JSNamedNodeMap* castedThisObj = static_cast<JSNamedNodeMap*>(thisValue);
    NamedNodeMap* imp = static_cast<NamedNodeMap*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& namespaceURI = valueToStringWithNullCheck(exec, args[0]);
    const UString& localName = args[1]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->removeNamedItemNS(namespaceURI, localName, ec)));
    setDOMException(exec, ec);
    return result;
}


JSValue* JSNamedNodeMap::indexGetter(ExecState* exec, const Identifier& propertyName, const PropertySlot& slot)
{
    JSNamedNodeMap* thisObj = static_cast<JSNamedNodeMap*>(slot.slotBase());
    return toJS(exec, static_cast<NamedNodeMap*>(thisObj->impl())->item(slot.index()));
}
KJS::JSValue* toJS(KJS::ExecState* exec, NamedNodeMap* obj)
{
    return cacheDOMObject<NamedNodeMap, JSNamedNodeMap, JSNamedNodeMapPrototype>(exec, obj);
}
NamedNodeMap* toNamedNodeMap(KJS::JSValue* val)
{
    return val->isObject(&JSNamedNodeMap::s_info) ? static_cast<JSNamedNodeMap*>(val)->impl() : 0;
}

}
