/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSMediaList.h"

#include <wtf/GetPtr.h>

#include <kjs/PropertyNameArray.h>
#include "KURL.h"
#include "MediaList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSMediaListTableValues[4] =
{
    { "mediaText", (intptr_t)JSMediaList::MediaTextAttrNum, DontDelete, 0 },
    { "length", (intptr_t)JSMediaList::LengthAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSMediaList::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSMediaListTable = { 15, JSMediaListTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSMediaListConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSMediaListConstructorTable = { 0, JSMediaListConstructorTableValues, 0 };

class JSMediaListConstructor : public DOMObject {
public:
    JSMediaListConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSMediaListPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSMediaListConstructor::s_info = { "MediaListConstructor", 0, &JSMediaListConstructorTable, 0 };

bool JSMediaListConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMediaListConstructor, DOMObject>(exec, &JSMediaListConstructorTable, this, propertyName, slot);
}

JSValue* JSMediaListConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSMediaListPrototypeTableValues[4] =
{
    { "item", (intptr_t)jsMediaListPrototypeFunctionItem, DontDelete|Function, 1 },
    { "deleteMedium", (intptr_t)jsMediaListPrototypeFunctionDeleteMedium, DontDelete|Function, 1 },
    { "appendMedium", (intptr_t)jsMediaListPrototypeFunctionAppendMedium, DontDelete|Function, 1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSMediaListPrototypeTable = { 7, JSMediaListPrototypeTableValues, 0 };

const ClassInfo JSMediaListPrototype::s_info = { "MediaListPrototype", 0, &JSMediaListPrototypeTable, 0 };

JSObject* JSMediaListPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSMediaList.prototype]]");
    return KJS::cacheGlobalObject<JSMediaListPrototype>(exec, prototypeIdentifier);
}

bool JSMediaListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSMediaListPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSMediaList::s_info = { "MediaList", 0, &JSMediaListTable , 0 };

JSMediaList::JSMediaList(JSObject* prototype, MediaList* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSMediaList::~JSMediaList()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSMediaList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = JSMediaListTable.entry(exec, propertyName);
    if (entry) {
        slot.setStaticEntry(this, entry, staticValueGetter<JSMediaList>);
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<MediaList*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSMediaList, Base>(exec, &JSMediaListTable, this, propertyName, slot);
}

bool JSMediaList::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<MediaList*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue* JSMediaList::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case MediaTextAttrNum: {
        MediaList* imp = static_cast<MediaList*>(impl());
        return jsStringOrNull(exec, imp->mediaText());
    }
    case LengthAttrNum: {
        MediaList* imp = static_cast<MediaList*>(impl());
        return jsNumber(exec, imp->length());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSMediaList::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSMediaList, Base>(exec, propertyName, value, &JSMediaListTable, this);
}

void JSMediaList::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case MediaTextAttrNum: {
        MediaList* imp = static_cast<MediaList*>(impl());
        ExceptionCode ec = 0;
        imp->setMediaText(valueToStringWithNullCheck(exec, value), ec);
        setDOMException(exec, ec);
        break;
    }
    }
}

void JSMediaList::getPropertyNames(ExecState* exec, PropertyNameArray& propertyNames)
{
    for (unsigned i = 0; i < static_cast<MediaList*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getPropertyNames(exec, propertyNames);
}

JSValue* JSMediaList::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[MediaList.constructor]]");
    return KJS::cacheGlobalObject<JSMediaListConstructor>(exec, constructorIdentifier);
}

JSValue* jsMediaListPrototypeFunctionItem(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSMediaList::s_info))
        return throwError(exec, TypeError);
    JSMediaList* castedThisObj = static_cast<JSMediaList*>(thisValue);
    MediaList* imp = static_cast<MediaList*>(castedThisObj->impl());
    unsigned index = args[0]->toInt32(exec);


    KJS::JSValue* result = jsStringOrNull(exec, imp->item(index));
    return result;
}

JSValue* jsMediaListPrototypeFunctionDeleteMedium(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSMediaList::s_info))
        return throwError(exec, TypeError);
    JSMediaList* castedThisObj = static_cast<JSMediaList*>(thisValue);
    MediaList* imp = static_cast<MediaList*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& oldMedium = args[0]->toString(exec);

    imp->deleteMedium(oldMedium, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsMediaListPrototypeFunctionAppendMedium(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSMediaList::s_info))
        return throwError(exec, TypeError);
    JSMediaList* castedThisObj = static_cast<JSMediaList*>(thisValue);
    MediaList* imp = static_cast<MediaList*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& newMedium = args[0]->toString(exec);

    imp->appendMedium(newMedium, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}


JSValue* JSMediaList::indexGetter(ExecState* exec, const Identifier& propertyName, const PropertySlot& slot)
{
    JSMediaList* thisObj = static_cast<JSMediaList*>(slot.slotBase());
    return jsStringOrNull(exec, thisObj->impl()->item(slot.index()));
}
KJS::JSValue* toJS(KJS::ExecState* exec, MediaList* obj)
{
    return cacheDOMObject<MediaList, JSMediaList, JSMediaListPrototype>(exec, obj);
}
MediaList* toMediaList(KJS::JSValue* val)
{
    return val->isObject(&JSMediaList::s_info) ? static_cast<JSMediaList*>(val)->impl() : 0;
}

}
