/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009
*/

#include "config.h"


#if ENABLE(VIDEO)

#include "JSMediaError.h"

#include <wtf/GetPtr.h>

#include "MediaError.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSMediaErrorTableValues[3] =
{
    { "code", (intptr_t)JSMediaError::CodeAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSMediaError::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSMediaErrorTable = { 15, JSMediaErrorTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSMediaErrorConstructorTableValues[4] =
{
    { "MEDIA_ERR_ABORTED", (intptr_t)1, DontDelete|ReadOnly, 0 },
    { "MEDIA_ERR_NETWORK", (intptr_t)2, DontDelete|ReadOnly, 0 },
    { "MEDIA_ERR_DECODE", (intptr_t)3, DontDelete|ReadOnly, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSMediaErrorConstructorTable = { 3, JSMediaErrorConstructorTableValues, 0 };

class JSMediaErrorConstructor : public DOMObject {
public:
    JSMediaErrorConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSMediaErrorPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSMediaErrorConstructor::s_info = { "MediaErrorConstructor", 0, &JSMediaErrorConstructorTable, 0 };

bool JSMediaErrorConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMediaErrorConstructor, DOMObject>(exec, &JSMediaErrorConstructorTable, this, propertyName, slot);
}

JSValue* JSMediaErrorConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSMediaErrorPrototypeTableValues[4] =
{
    { "MEDIA_ERR_ABORTED", (intptr_t)1, DontDelete|ReadOnly, 0 },
    { "MEDIA_ERR_NETWORK", (intptr_t)2, DontDelete|ReadOnly, 0 },
    { "MEDIA_ERR_DECODE", (intptr_t)3, DontDelete|ReadOnly, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSMediaErrorPrototypeTable = { 3, JSMediaErrorPrototypeTableValues, 0 };

const ClassInfo JSMediaErrorPrototype::s_info = { "MediaErrorPrototype", 0, &JSMediaErrorPrototypeTable, 0 };

JSObject* JSMediaErrorPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSMediaError.prototype]]");
    return KJS::cacheGlobalObject<JSMediaErrorPrototype>(exec, prototypeIdentifier);
}

bool JSMediaErrorPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMediaErrorPrototype, JSObject>(exec, &JSMediaErrorPrototypeTable, this, propertyName, slot);
}

JSValue* JSMediaErrorPrototype::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

const ClassInfo JSMediaError::s_info = { "MediaError", 0, &JSMediaErrorTable , 0 };

JSMediaError::JSMediaError(JSObject* prototype, MediaError* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSMediaError::~JSMediaError()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSMediaError::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMediaError, Base>(exec, &JSMediaErrorTable, this, propertyName, slot);
}

JSValue* JSMediaError::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CodeAttrNum: {
        MediaError* imp = static_cast<MediaError*>(impl());
        return jsNumber(exec, imp->code());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSMediaError::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[MediaError.constructor]]");
    return KJS::cacheGlobalObject<JSMediaErrorConstructor>(exec, constructorIdentifier);
}

KJS::JSValue* toJS(KJS::ExecState* exec, MediaError* obj)
{
    return cacheDOMObject<MediaError, JSMediaError, JSMediaErrorPrototype>(exec, obj);
}
MediaError* toMediaError(KJS::JSValue* val)
{
    return val->isObject(&JSMediaError::s_info) ? static_cast<JSMediaError*>(val)->impl() : 0;
}

}

#endif // ENABLE(VIDEO)
