/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSLocation_h
#define JSLocation_h

#include "JSDOMBinding.h"
#include <kjs/JSGlobalObject.h>
#include <kjs/ObjectPrototype.h>

namespace WebCore {

class Location;

class JSLocation : public DOMObject {
    typedef DOMObject Base;
public:
    JSLocation(KJS::JSObject* prototype, Location*);
    virtual ~JSLocation();
    virtual bool getOwnPropertySlot(KJS::ExecState*, const KJS::Identifier& propertyName, KJS::PropertySlot&);
    KJS::JSValue* getValueProperty(KJS::ExecState*, int token) const;
    bool customGetOwnPropertySlot(KJS::ExecState*, const KJS::Identifier&, KJS::PropertySlot&);
    virtual void put(KJS::ExecState*, const KJS::Identifier& propertyName, KJS::JSValue*);
    void putValueProperty(KJS::ExecState*, int, KJS::JSValue*);
    bool customPut(KJS::ExecState*, const KJS::Identifier&, KJS::JSValue*);
    virtual const KJS::ClassInfo* classInfo() const { return &s_info; }
    static const KJS::ClassInfo s_info;

    virtual bool deleteProperty(KJS::ExecState*, const KJS::Identifier&);
    virtual void getPropertyNames(KJS::ExecState*, KJS::PropertyNameArray&);
    bool customGetPropertyNames(KJS::ExecState*, KJS::PropertyNameArray&);
    enum {
        // Attributes
        HrefAttrNum, ProtocolAttrNum, HostAttrNum, HostnameAttrNum, 
        PortAttrNum, PathnameAttrNum, SearchAttrNum, HashAttrNum, 
    };

    // Custom attributes
    void setHref(KJS::ExecState*, KJS::JSValue*);
    void setProtocol(KJS::ExecState*, KJS::JSValue*);
    void setHost(KJS::ExecState*, KJS::JSValue*);
    void setHostname(KJS::ExecState*, KJS::JSValue*);
    void setPort(KJS::ExecState*, KJS::JSValue*);
    void setPathname(KJS::ExecState*, KJS::JSValue*);
    void setSearch(KJS::ExecState*, KJS::JSValue*);
    void setHash(KJS::ExecState*, KJS::JSValue*);

    // Custom functions
    KJS::JSValue* assign(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* replace(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* reload(KJS::ExecState*, const KJS::ArgList&);
    KJS::JSValue* toString(KJS::ExecState*, const KJS::ArgList&);
    Location* impl() const { return m_impl.get(); }

private:
    RefPtr<Location> m_impl;
};

KJS::JSValue* toJS(KJS::ExecState*, Location*);
Location* toLocation(KJS::JSValue*);

class JSLocationPrototype : public KJS::JSObject {
public:
    static KJS::JSObject* self(KJS::ExecState*);
    virtual const KJS::ClassInfo* classInfo() const { return &s_info; }
    static const KJS::ClassInfo s_info;
    bool getOwnPropertySlot(KJS::ExecState*, const KJS::Identifier&, KJS::PropertySlot&);
    JSLocationPrototype(KJS::ExecState* exec)
        : KJS::JSObject(exec->lexicalGlobalObject()->objectPrototype()) { }
};

// Functions

KJS::JSValue* jsLocationPrototypeFunctionAssign(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsLocationPrototypeFunctionReplace(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsLocationPrototypeFunctionReload(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
KJS::JSValue* jsLocationPrototypeFunctionToString(KJS::ExecState*, KJS::JSObject*, KJS::JSValue*, const KJS::ArgList&);
} // namespace WebCore

#endif
