/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSLocation.h"

#include <wtf/GetPtr.h>

#include "JSLocationCustom.h"
#include "KURL.h"
#include "Location.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSLocationTableValues[9] =
{
    { "href", (intptr_t)JSLocation::HrefAttrNum, DontDelete, 0 },
    { "protocol", (intptr_t)JSLocation::ProtocolAttrNum, DontDelete, 0 },
    { "host", (intptr_t)JSLocation::HostAttrNum, DontDelete, 0 },
    { "hostname", (intptr_t)JSLocation::HostnameAttrNum, DontDelete, 0 },
    { "port", (intptr_t)JSLocation::PortAttrNum, DontDelete, 0 },
    { "pathname", (intptr_t)JSLocation::PathnameAttrNum, DontDelete, 0 },
    { "search", (intptr_t)JSLocation::SearchAttrNum, DontDelete, 0 },
    { "hash", (intptr_t)JSLocation::HashAttrNum, DontDelete, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSLocationTable = { 63, JSLocationTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSLocationPrototypeTableValues[5] =
{
    { "assign", (intptr_t)jsLocationPrototypeFunctionAssign, DontDelete|Function, 1 },
    { "replace", (intptr_t)jsLocationPrototypeFunctionReplace, DontDelete|Function, 1 },
    { "reload", (intptr_t)jsLocationPrototypeFunctionReload, DontDelete|Function, 0 },
    { "toString", (intptr_t)jsLocationPrototypeFunctionToString, DontDelete|DontEnum|Function, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSLocationPrototypeTable = { 15, JSLocationPrototypeTableValues, 0 };

const ClassInfo JSLocationPrototype::s_info = { "LocationPrototype", 0, &JSLocationPrototypeTable, 0 };

JSObject* JSLocationPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSLocation.prototype]]");
    return KJS::cacheGlobalObject<JSLocationPrototype>(exec, prototypeIdentifier);
}

bool JSLocationPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSLocationPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSLocation::s_info = { "Location", 0, &JSLocationTable , 0 };

JSLocation::JSLocation(JSObject* prototype, Location* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSLocation::~JSLocation()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSLocation::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    if (customGetOwnPropertySlot(exec, propertyName, slot))
        return true;
    return getStaticValueSlot<JSLocation, Base>(exec, &JSLocationTable, this, propertyName, slot);
}

JSValue* JSLocation::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case HrefAttrNum: {
        Location* imp = static_cast<Location*>(impl());
        return jsString(exec, imp->href());
    }
    case ProtocolAttrNum: {
        Location* imp = static_cast<Location*>(impl());
        return jsString(exec, imp->protocol());
    }
    case HostAttrNum: {
        Location* imp = static_cast<Location*>(impl());
        return jsString(exec, imp->host());
    }
    case HostnameAttrNum: {
        Location* imp = static_cast<Location*>(impl());
        return jsString(exec, imp->hostname());
    }
    case PortAttrNum: {
        Location* imp = static_cast<Location*>(impl());
        return jsString(exec, imp->port());
    }
    case PathnameAttrNum: {
        Location* imp = static_cast<Location*>(impl());
        return jsString(exec, imp->pathname());
    }
    case SearchAttrNum: {
        Location* imp = static_cast<Location*>(impl());
        return jsString(exec, imp->search());
    }
    case HashAttrNum: {
        Location* imp = static_cast<Location*>(impl());
        return jsString(exec, imp->hash());
    }
    }
    return 0;
}

void JSLocation::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    if (customPut(exec, propertyName, value))
        return;
    lookupPut<JSLocation, Base>(exec, propertyName, value, &JSLocationTable, this);
}

void JSLocation::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case HrefAttrNum: {
        setHref(exec, value);
        break;
    }
    case ProtocolAttrNum: {
        setProtocol(exec, value);
        break;
    }
    case HostAttrNum: {
        setHost(exec, value);
        break;
    }
    case HostnameAttrNum: {
        setHostname(exec, value);
        break;
    }
    case PortAttrNum: {
        setPort(exec, value);
        break;
    }
    case PathnameAttrNum: {
        setPathname(exec, value);
        break;
    }
    case SearchAttrNum: {
        setSearch(exec, value);
        break;
    }
    case HashAttrNum: {
        setHash(exec, value);
        break;
    }
    }
}

void JSLocation::getPropertyNames(ExecState* exec, PropertyNameArray& propertyNames)
{
    if (customGetPropertyNames(exec, propertyNames))
        return;
     Base::getPropertyNames(exec, propertyNames);
}

JSValue* jsLocationPrototypeFunctionAssign(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSLocation::s_info))
        return throwError(exec, TypeError);
    JSLocation* castedThisObj = static_cast<JSLocation*>(thisValue);
    return castedThisObj->assign(exec, args);
}

JSValue* jsLocationPrototypeFunctionReplace(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSLocation::s_info))
        return throwError(exec, TypeError);
    JSLocation* castedThisObj = static_cast<JSLocation*>(thisValue);
    return castedThisObj->replace(exec, args);
}

JSValue* jsLocationPrototypeFunctionReload(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSLocation::s_info))
        return throwError(exec, TypeError);
    JSLocation* castedThisObj = static_cast<JSLocation*>(thisValue);
    return castedThisObj->reload(exec, args);
}

JSValue* jsLocationPrototypeFunctionToString(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSLocation::s_info))
        return throwError(exec, TypeError);
    JSLocation* castedThisObj = static_cast<JSLocation*>(thisValue);
    return castedThisObj->toString(exec, args);
}

KJS::JSValue* toJS(KJS::ExecState* exec, Location* obj)
{
    return cacheDOMObject<Location, JSLocation, JSLocationPrototype>(exec, obj);
}
Location* toLocation(KJS::JSValue* val)
{
    return val->isObject(&JSLocation::s_info) ? static_cast<JSLocation*>(val)->impl() : 0;
}

}
