/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009
*/

#include "config.h"


#if ENABLE(VIDEO)

#include "JSHTMLVideoElement.h"

#include <wtf/GetPtr.h>

#include "HTMLVideoElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLVideoElementTableValues[7] =
{
    { "width", (intptr_t)JSHTMLVideoElement::WidthAttrNum, DontDelete, 0 },
    { "height", (intptr_t)JSHTMLVideoElement::HeightAttrNum, DontDelete, 0 },
    { "videoWidth", (intptr_t)JSHTMLVideoElement::VideoWidthAttrNum, DontDelete|ReadOnly, 0 },
    { "videoHeight", (intptr_t)JSHTMLVideoElement::VideoHeightAttrNum, DontDelete|ReadOnly, 0 },
    { "poster", (intptr_t)JSHTMLVideoElement::PosterAttrNum, DontDelete, 0 },
    { "constructor", (intptr_t)JSHTMLVideoElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLVideoElementTable = { 31, JSHTMLVideoElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLVideoElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLVideoElementConstructorTable = { 0, JSHTMLVideoElementConstructorTableValues, 0 };

class JSHTMLVideoElementConstructor : public DOMObject {
public:
    JSHTMLVideoElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLVideoElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLVideoElementConstructor::s_info = { "HTMLVideoElementConstructor", 0, &JSHTMLVideoElementConstructorTable, 0 };

bool JSHTMLVideoElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLVideoElementConstructor, DOMObject>(exec, &JSHTMLVideoElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLVideoElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLVideoElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLVideoElementPrototypeTable = { 0, JSHTMLVideoElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLVideoElementPrototype::s_info = { "HTMLVideoElementPrototype", 0, &JSHTMLVideoElementPrototypeTable, 0 };

JSObject* JSHTMLVideoElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLVideoElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLVideoElementPrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSHTMLVideoElement::s_info = { "HTMLVideoElement", &JSHTMLMediaElement::s_info, &JSHTMLVideoElementTable , 0 };

JSHTMLVideoElement::JSHTMLVideoElement(JSObject* prototype, HTMLVideoElement* impl)
    : JSHTMLMediaElement(prototype, impl)
{
}

bool JSHTMLVideoElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLVideoElement, Base>(exec, &JSHTMLVideoElementTable, this, propertyName, slot);
}

JSValue* JSHTMLVideoElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case WidthAttrNum: {
        HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(impl());
        return jsNumber(exec, imp->width());
    }
    case HeightAttrNum: {
        HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(impl());
        return jsNumber(exec, imp->height());
    }
    case VideoWidthAttrNum: {
        HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(impl());
        return jsNumber(exec, imp->videoWidth());
    }
    case VideoHeightAttrNum: {
        HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(impl());
        return jsNumber(exec, imp->videoHeight());
    }
    case PosterAttrNum: {
        HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(impl());
        return jsString(exec, imp->poster());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLVideoElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLVideoElement, Base>(exec, propertyName, value, &JSHTMLVideoElementTable, this);
}

void JSHTMLVideoElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case WidthAttrNum: {
        HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(impl());
        imp->setWidth(value->toInt32(exec));
        break;
    }
    case HeightAttrNum: {
        HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(impl());
        imp->setHeight(value->toInt32(exec));
        break;
    }
    case PosterAttrNum: {
        HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(impl());
        imp->setPoster(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLVideoElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLVideoElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLVideoElementConstructor>(exec, constructorIdentifier);
}


}

#endif // ENABLE(VIDEO)
