/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLTableElement.h"

#include <wtf/GetPtr.h>

#include "HTMLCollection.h"
#include "HTMLElement.h"
#include "HTMLTableCaptionElement.h"
#include "HTMLTableElement.h"
#include "HTMLTableSectionElement.h"
#include "JSHTMLCollection.h"
#include "JSHTMLElement.h"
#include "JSHTMLTableCaptionElement.h"
#include "JSHTMLTableSectionElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLTableElementTableValues[16] =
{
    { "caption", (intptr_t)JSHTMLTableElement::CaptionAttrNum, DontDelete, 0 },
    { "tHead", (intptr_t)JSHTMLTableElement::THeadAttrNum, DontDelete, 0 },
    { "tFoot", (intptr_t)JSHTMLTableElement::TFootAttrNum, DontDelete, 0 },
    { "rows", (intptr_t)JSHTMLTableElement::RowsAttrNum, DontDelete|ReadOnly, 0 },
    { "tBodies", (intptr_t)JSHTMLTableElement::TBodiesAttrNum, DontDelete|ReadOnly, 0 },
    { "align", (intptr_t)JSHTMLTableElement::AlignAttrNum, DontDelete, 0 },
    { "bgColor", (intptr_t)JSHTMLTableElement::BgColorAttrNum, DontDelete, 0 },
    { "border", (intptr_t)JSHTMLTableElement::BorderAttrNum, DontDelete, 0 },
    { "cellPadding", (intptr_t)JSHTMLTableElement::CellPaddingAttrNum, DontDelete, 0 },
    { "cellSpacing", (intptr_t)JSHTMLTableElement::CellSpacingAttrNum, DontDelete, 0 },
    { "frame", (intptr_t)JSHTMLTableElement::FrameAttrNum, DontDelete, 0 },
    { "rules", (intptr_t)JSHTMLTableElement::RulesAttrNum, DontDelete, 0 },
    { "summary", (intptr_t)JSHTMLTableElement::SummaryAttrNum, DontDelete, 0 },
    { "width", (intptr_t)JSHTMLTableElement::WidthAttrNum, DontDelete, 0 },
    { "constructor", (intptr_t)JSHTMLTableElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLTableElementTable = { 127, JSHTMLTableElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLTableElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLTableElementConstructorTable = { 0, JSHTMLTableElementConstructorTableValues, 0 };

class JSHTMLTableElementConstructor : public DOMObject {
public:
    JSHTMLTableElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLTableElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLTableElementConstructor::s_info = { "HTMLTableElementConstructor", 0, &JSHTMLTableElementConstructorTable, 0 };

bool JSHTMLTableElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTableElementConstructor, DOMObject>(exec, &JSHTMLTableElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLTableElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLTableElementPrototypeTableValues[9] =
{
    { "createTHead", (intptr_t)jsHTMLTableElementPrototypeFunctionCreateTHead, DontDelete|Function, 0 },
    { "deleteTHead", (intptr_t)jsHTMLTableElementPrototypeFunctionDeleteTHead, DontDelete|Function, 0 },
    { "createTFoot", (intptr_t)jsHTMLTableElementPrototypeFunctionCreateTFoot, DontDelete|Function, 0 },
    { "deleteTFoot", (intptr_t)jsHTMLTableElementPrototypeFunctionDeleteTFoot, DontDelete|Function, 0 },
    { "createCaption", (intptr_t)jsHTMLTableElementPrototypeFunctionCreateCaption, DontDelete|Function, 0 },
    { "deleteCaption", (intptr_t)jsHTMLTableElementPrototypeFunctionDeleteCaption, DontDelete|Function, 0 },
    { "insertRow", (intptr_t)jsHTMLTableElementPrototypeFunctionInsertRow, DontDelete|Function, 1 },
    { "deleteRow", (intptr_t)jsHTMLTableElementPrototypeFunctionDeleteRow, DontDelete|Function, 1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLTableElementPrototypeTable = { 127, JSHTMLTableElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLTableElementPrototype::s_info = { "HTMLTableElementPrototype", 0, &JSHTMLTableElementPrototypeTable, 0 };

JSObject* JSHTMLTableElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLTableElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLTableElementPrototype>(exec, prototypeIdentifier);
}

bool JSHTMLTableElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLTableElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLTableElement::s_info = { "HTMLTableElement", &JSHTMLElement::s_info, &JSHTMLTableElementTable , 0 };

JSHTMLTableElement::JSHTMLTableElement(JSObject* prototype, HTMLTableElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLTableElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTableElement, Base>(exec, &JSHTMLTableElementTable, this, propertyName, slot);
}

JSValue* JSHTMLTableElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CaptionAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        return toJS(exec, WTF::getPtr(imp->caption()));
    }
    case THeadAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        return toJS(exec, WTF::getPtr(imp->tHead()));
    }
    case TFootAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        return toJS(exec, WTF::getPtr(imp->tFoot()));
    }
    case RowsAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        return toJS(exec, WTF::getPtr(imp->rows()));
    }
    case TBodiesAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        return toJS(exec, WTF::getPtr(imp->tBodies()));
    }
    case AlignAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        return jsString(exec, imp->align());
    }
    case BgColorAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        return jsString(exec, imp->bgColor());
    }
    case BorderAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        return jsString(exec, imp->border());
    }
    case CellPaddingAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        return jsString(exec, imp->cellPadding());
    }
    case CellSpacingAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        return jsString(exec, imp->cellSpacing());
    }
    case FrameAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        return jsString(exec, imp->frame());
    }
    case RulesAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        return jsString(exec, imp->rules());
    }
    case SummaryAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        return jsString(exec, imp->summary());
    }
    case WidthAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        return jsString(exec, imp->width());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLTableElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLTableElement, Base>(exec, propertyName, value, &JSHTMLTableElementTable, this);
}

void JSHTMLTableElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case CaptionAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        ExceptionCode ec = 0;
        imp->setCaption(toHTMLTableCaptionElement(value), ec);
        setDOMException(exec, ec);
        break;
    }
    case THeadAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        ExceptionCode ec = 0;
        imp->setTHead(toHTMLTableSectionElement(value), ec);
        setDOMException(exec, ec);
        break;
    }
    case TFootAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        ExceptionCode ec = 0;
        imp->setTFoot(toHTMLTableSectionElement(value), ec);
        setDOMException(exec, ec);
        break;
    }
    case AlignAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        imp->setAlign(valueToStringWithNullCheck(exec, value));
        break;
    }
    case BgColorAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        imp->setBgColor(valueToStringWithNullCheck(exec, value));
        break;
    }
    case BorderAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        imp->setBorder(valueToStringWithNullCheck(exec, value));
        break;
    }
    case CellPaddingAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        imp->setCellPadding(valueToStringWithNullCheck(exec, value));
        break;
    }
    case CellSpacingAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        imp->setCellSpacing(valueToStringWithNullCheck(exec, value));
        break;
    }
    case FrameAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        imp->setFrame(valueToStringWithNullCheck(exec, value));
        break;
    }
    case RulesAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        imp->setRules(valueToStringWithNullCheck(exec, value));
        break;
    }
    case SummaryAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        imp->setSummary(valueToStringWithNullCheck(exec, value));
        break;
    }
    case WidthAttrNum: {
        HTMLTableElement* imp = static_cast<HTMLTableElement*>(impl());
        imp->setWidth(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLTableElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLTableElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLTableElementConstructor>(exec, constructorIdentifier);
}

JSValue* jsHTMLTableElementPrototypeFunctionCreateTHead(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLTableElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLTableElement* castedThisObj = static_cast<JSHTMLTableElement*>(thisValue);
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(castedThisObj->impl());


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createTHead()));
    return result;
}

JSValue* jsHTMLTableElementPrototypeFunctionDeleteTHead(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLTableElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLTableElement* castedThisObj = static_cast<JSHTMLTableElement*>(thisValue);
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(castedThisObj->impl());

    imp->deleteTHead();
    return jsUndefined();
}

JSValue* jsHTMLTableElementPrototypeFunctionCreateTFoot(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLTableElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLTableElement* castedThisObj = static_cast<JSHTMLTableElement*>(thisValue);
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(castedThisObj->impl());


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createTFoot()));
    return result;
}

JSValue* jsHTMLTableElementPrototypeFunctionDeleteTFoot(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLTableElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLTableElement* castedThisObj = static_cast<JSHTMLTableElement*>(thisValue);
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(castedThisObj->impl());

    imp->deleteTFoot();
    return jsUndefined();
}

JSValue* jsHTMLTableElementPrototypeFunctionCreateCaption(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLTableElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLTableElement* castedThisObj = static_cast<JSHTMLTableElement*>(thisValue);
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(castedThisObj->impl());


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createCaption()));
    return result;
}

JSValue* jsHTMLTableElementPrototypeFunctionDeleteCaption(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLTableElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLTableElement* castedThisObj = static_cast<JSHTMLTableElement*>(thisValue);
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(castedThisObj->impl());

    imp->deleteCaption();
    return jsUndefined();
}

JSValue* jsHTMLTableElementPrototypeFunctionInsertRow(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLTableElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLTableElement* castedThisObj = static_cast<JSHTMLTableElement*>(thisValue);
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    int index = args[0]->toInt32(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->insertRow(index, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsHTMLTableElementPrototypeFunctionDeleteRow(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLTableElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLTableElement* castedThisObj = static_cast<JSHTMLTableElement*>(thisValue);
    HTMLTableElement* imp = static_cast<HTMLTableElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    int index = args[0]->toInt32(exec);

    imp->deleteRow(index, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}


}
