/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLStyleElement.h"

#include <wtf/GetPtr.h>

#include "HTMLStyleElement.h"
#include "JSStyleSheet.h"
#include "KURL.h"
#include "StyleSheet.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLStyleElementTableValues[6] =
{
    { "disabled", (intptr_t)JSHTMLStyleElement::DisabledAttrNum, DontDelete, 0 },
    { "media", (intptr_t)JSHTMLStyleElement::MediaAttrNum, DontDelete, 0 },
    { "type", (intptr_t)JSHTMLStyleElement::TypeAttrNum, DontDelete, 0 },
    { "sheet", (intptr_t)JSHTMLStyleElement::SheetAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSHTMLStyleElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLStyleElementTable = { 31, JSHTMLStyleElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLStyleElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLStyleElementConstructorTable = { 0, JSHTMLStyleElementConstructorTableValues, 0 };

class JSHTMLStyleElementConstructor : public DOMObject {
public:
    JSHTMLStyleElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLStyleElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLStyleElementConstructor::s_info = { "HTMLStyleElementConstructor", 0, &JSHTMLStyleElementConstructorTable, 0 };

bool JSHTMLStyleElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLStyleElementConstructor, DOMObject>(exec, &JSHTMLStyleElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLStyleElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLStyleElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLStyleElementPrototypeTable = { 0, JSHTMLStyleElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLStyleElementPrototype::s_info = { "HTMLStyleElementPrototype", 0, &JSHTMLStyleElementPrototypeTable, 0 };

JSObject* JSHTMLStyleElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLStyleElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLStyleElementPrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSHTMLStyleElement::s_info = { "HTMLStyleElement", &JSHTMLElement::s_info, &JSHTMLStyleElementTable , 0 };

JSHTMLStyleElement::JSHTMLStyleElement(JSObject* prototype, HTMLStyleElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLStyleElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLStyleElement, Base>(exec, &JSHTMLStyleElementTable, this, propertyName, slot);
}

JSValue* JSHTMLStyleElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case DisabledAttrNum: {
        HTMLStyleElement* imp = static_cast<HTMLStyleElement*>(impl());
        return jsBoolean(imp->disabled());
    }
    case MediaAttrNum: {
        HTMLStyleElement* imp = static_cast<HTMLStyleElement*>(impl());
        return jsString(exec, imp->media());
    }
    case TypeAttrNum: {
        HTMLStyleElement* imp = static_cast<HTMLStyleElement*>(impl());
        return jsString(exec, imp->type());
    }
    case SheetAttrNum: {
        HTMLStyleElement* imp = static_cast<HTMLStyleElement*>(impl());
        return toJS(exec, WTF::getPtr(imp->sheet()));
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLStyleElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLStyleElement, Base>(exec, propertyName, value, &JSHTMLStyleElementTable, this);
}

void JSHTMLStyleElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case DisabledAttrNum: {
        HTMLStyleElement* imp = static_cast<HTMLStyleElement*>(impl());
        imp->setDisabled(value->toBoolean(exec));
        break;
    }
    case MediaAttrNum: {
        HTMLStyleElement* imp = static_cast<HTMLStyleElement*>(impl());
        imp->setMedia(valueToStringWithNullCheck(exec, value));
        break;
    }
    case TypeAttrNum: {
        HTMLStyleElement* imp = static_cast<HTMLStyleElement*>(impl());
        imp->setType(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLStyleElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLStyleElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLStyleElementConstructor>(exec, constructorIdentifier);
}


}
