/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLScriptElement.h"

#include <wtf/GetPtr.h>

#include "HTMLScriptElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLScriptElementTableValues[9] =
{
    { "text", (intptr_t)JSHTMLScriptElement::TextAttrNum, DontDelete, 0 },
    { "htmlFor", (intptr_t)JSHTMLScriptElement::HtmlForAttrNum, DontDelete, 0 },
    { "event", (intptr_t)JSHTMLScriptElement::EventAttrNum, DontDelete, 0 },
    { "charset", (intptr_t)JSHTMLScriptElement::CharsetAttrNum, DontDelete, 0 },
    { "defer", (intptr_t)JSHTMLScriptElement::DeferAttrNum, DontDelete, 0 },
    { "src", (intptr_t)JSHTMLScriptElement::SrcAttrNum, DontDelete, 0 },
    { "type", (intptr_t)JSHTMLScriptElement::TypeAttrNum, DontDelete, 0 },
    { "constructor", (intptr_t)JSHTMLScriptElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLScriptElementTable = { 31, JSHTMLScriptElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLScriptElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLScriptElementConstructorTable = { 0, JSHTMLScriptElementConstructorTableValues, 0 };

class JSHTMLScriptElementConstructor : public DOMObject {
public:
    JSHTMLScriptElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLScriptElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLScriptElementConstructor::s_info = { "HTMLScriptElementConstructor", 0, &JSHTMLScriptElementConstructorTable, 0 };

bool JSHTMLScriptElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLScriptElementConstructor, DOMObject>(exec, &JSHTMLScriptElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLScriptElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLScriptElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLScriptElementPrototypeTable = { 0, JSHTMLScriptElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLScriptElementPrototype::s_info = { "HTMLScriptElementPrototype", 0, &JSHTMLScriptElementPrototypeTable, 0 };

JSObject* JSHTMLScriptElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLScriptElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLScriptElementPrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSHTMLScriptElement::s_info = { "HTMLScriptElement", &JSHTMLElement::s_info, &JSHTMLScriptElementTable , 0 };

JSHTMLScriptElement::JSHTMLScriptElement(JSObject* prototype, HTMLScriptElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLScriptElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLScriptElement, Base>(exec, &JSHTMLScriptElementTable, this, propertyName, slot);
}

JSValue* JSHTMLScriptElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case TextAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        return jsString(exec, imp->text());
    }
    case HtmlForAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        return jsString(exec, imp->htmlFor());
    }
    case EventAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        return jsString(exec, imp->event());
    }
    case CharsetAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        return jsString(exec, imp->charset());
    }
    case DeferAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        return jsBoolean(imp->defer());
    }
    case SrcAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        return jsString(exec, imp->src());
    }
    case TypeAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        return jsString(exec, imp->type());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLScriptElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLScriptElement, Base>(exec, propertyName, value, &JSHTMLScriptElementTable, this);
}

void JSHTMLScriptElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case TextAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        imp->setText(valueToStringWithNullCheck(exec, value));
        break;
    }
    case HtmlForAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        imp->setHtmlFor(valueToStringWithNullCheck(exec, value));
        break;
    }
    case EventAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        imp->setEvent(valueToStringWithNullCheck(exec, value));
        break;
    }
    case CharsetAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        imp->setCharset(valueToStringWithNullCheck(exec, value));
        break;
    }
    case DeferAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        imp->setDefer(value->toBoolean(exec));
        break;
    }
    case SrcAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        imp->setSrc(valueToStringWithNullCheck(exec, value));
        break;
    }
    case TypeAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        imp->setType(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLScriptElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLScriptElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLScriptElementConstructor>(exec, constructorIdentifier);
}


}
