/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLParagraphElement.h"

#include <wtf/GetPtr.h>

#include "HTMLParagraphElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLParagraphElementTableValues[3] =
{
    { "align", (intptr_t)JSHTMLParagraphElement::AlignAttrNum, DontDelete, 0 },
    { "constructor", (intptr_t)JSHTMLParagraphElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLParagraphElementTable = { 7, JSHTMLParagraphElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLParagraphElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLParagraphElementConstructorTable = { 0, JSHTMLParagraphElementConstructorTableValues, 0 };

class JSHTMLParagraphElementConstructor : public DOMObject {
public:
    JSHTMLParagraphElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLParagraphElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLParagraphElementConstructor::s_info = { "HTMLParagraphElementConstructor", 0, &JSHTMLParagraphElementConstructorTable, 0 };

bool JSHTMLParagraphElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLParagraphElementConstructor, DOMObject>(exec, &JSHTMLParagraphElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLParagraphElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLParagraphElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLParagraphElementPrototypeTable = { 0, JSHTMLParagraphElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLParagraphElementPrototype::s_info = { "HTMLParagraphElementPrototype", 0, &JSHTMLParagraphElementPrototypeTable, 0 };

JSObject* JSHTMLParagraphElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLParagraphElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLParagraphElementPrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSHTMLParagraphElement::s_info = { "HTMLParagraphElement", &JSHTMLElement::s_info, &JSHTMLParagraphElementTable , 0 };

JSHTMLParagraphElement::JSHTMLParagraphElement(JSObject* prototype, HTMLParagraphElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLParagraphElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLParagraphElement, Base>(exec, &JSHTMLParagraphElementTable, this, propertyName, slot);
}

JSValue* JSHTMLParagraphElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case AlignAttrNum: {
        HTMLParagraphElement* imp = static_cast<HTMLParagraphElement*>(impl());
        return jsString(exec, imp->align());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLParagraphElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLParagraphElement, Base>(exec, propertyName, value, &JSHTMLParagraphElementTable, this);
}

void JSHTMLParagraphElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case AlignAttrNum: {
        HTMLParagraphElement* imp = static_cast<HTMLParagraphElement*>(impl());
        imp->setAlign(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLParagraphElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLParagraphElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLParagraphElementConstructor>(exec, constructorIdentifier);
}


}
