/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLOptionsCollection.h"

#include <wtf/GetPtr.h>

#include "HTMLOptionsCollection.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLOptionsCollectionTableValues[3] =
{
    { "selectedIndex", (intptr_t)JSHTMLOptionsCollection::SelectedIndexAttrNum, DontDelete, 0 },
    { "length", (intptr_t)JSHTMLOptionsCollection::LengthAttrNum, DontDelete, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLOptionsCollectionTable = { 3, JSHTMLOptionsCollectionTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSHTMLOptionsCollectionPrototypeTableValues[3] =
{
    { "add", (intptr_t)jsHTMLOptionsCollectionPrototypeFunctionAdd, DontDelete|Function, 2 },
    { "remove", (intptr_t)jsHTMLOptionsCollectionPrototypeFunctionRemove, DontDelete|Function, 1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLOptionsCollectionPrototypeTable = { 1, JSHTMLOptionsCollectionPrototypeTableValues, 0 };

const ClassInfo JSHTMLOptionsCollectionPrototype::s_info = { "HTMLOptionsCollectionPrototype", 0, &JSHTMLOptionsCollectionPrototypeTable, 0 };

JSObject* JSHTMLOptionsCollectionPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLOptionsCollection.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLOptionsCollectionPrototype>(exec, prototypeIdentifier);
}

bool JSHTMLOptionsCollectionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLOptionsCollectionPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLOptionsCollection::s_info = { "HTMLOptionsCollection", &JSHTMLCollection::s_info, &JSHTMLOptionsCollectionTable , 0 };

JSHTMLOptionsCollection::JSHTMLOptionsCollection(JSObject* prototype, HTMLOptionsCollection* impl)
    : JSHTMLCollection(prototype, impl)
{
}

bool JSHTMLOptionsCollection::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLOptionsCollection, Base>(exec, &JSHTMLOptionsCollectionTable, this, propertyName, slot);
}

JSValue* JSHTMLOptionsCollection::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case SelectedIndexAttrNum: {
        HTMLOptionsCollection* imp = static_cast<HTMLOptionsCollection*>(impl());
        return jsNumber(exec, imp->selectedIndex());
    }
    case LengthAttrNum: {
        return length(exec);
    }
    }
    return 0;
}

void JSHTMLOptionsCollection::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok) {
        indexSetter(exec, index, value);
        return;
    }
    lookupPut<JSHTMLOptionsCollection, Base>(exec, propertyName, value, &JSHTMLOptionsCollectionTable, this);
}

void JSHTMLOptionsCollection::put(ExecState* exec, unsigned propertyName, JSValue* value)
{
    indexSetter(exec, propertyName, value);
    return;
}

void JSHTMLOptionsCollection::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case SelectedIndexAttrNum: {
        HTMLOptionsCollection* imp = static_cast<HTMLOptionsCollection*>(impl());
        imp->setSelectedIndex(value->toInt32(exec));
        break;
    }
    case LengthAttrNum: {
        setLength(exec, value);
        break;
    }
    }
}

JSValue* jsHTMLOptionsCollectionPrototypeFunctionAdd(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLOptionsCollection::s_info))
        return throwError(exec, TypeError);
    JSHTMLOptionsCollection* castedThisObj = static_cast<JSHTMLOptionsCollection*>(thisValue);
    return castedThisObj->add(exec, args);
}

JSValue* jsHTMLOptionsCollectionPrototypeFunctionRemove(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLOptionsCollection::s_info))
        return throwError(exec, TypeError);
    JSHTMLOptionsCollection* castedThisObj = static_cast<JSHTMLOptionsCollection*>(thisValue);
    return castedThisObj->remove(exec, args);
}

HTMLOptionsCollection* toHTMLOptionsCollection(KJS::JSValue* val)
{
    return val->isObject(&JSHTMLOptionsCollection::s_info) ? static_cast<JSHTMLOptionsCollection*>(val)->impl() : 0;
}

}
