/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLOptionElement.h"

#include <wtf/GetPtr.h>

#include "HTMLFormElement.h"
#include "HTMLOptionElement.h"
#include "JSHTMLFormElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLOptionElementTableValues[9] =
{
    { "form", (intptr_t)JSHTMLOptionElement::FormAttrNum, DontDelete|ReadOnly, 0 },
    { "defaultSelected", (intptr_t)JSHTMLOptionElement::DefaultSelectedAttrNum, DontDelete, 0 },
    { "text", (intptr_t)JSHTMLOptionElement::TextAttrNum, DontDelete, 0 },
    { "index", (intptr_t)JSHTMLOptionElement::IndexAttrNum, DontDelete|ReadOnly, 0 },
    { "disabled", (intptr_t)JSHTMLOptionElement::DisabledAttrNum, DontDelete, 0 },
    { "label", (intptr_t)JSHTMLOptionElement::LabelAttrNum, DontDelete, 0 },
    { "selected", (intptr_t)JSHTMLOptionElement::SelectedAttrNum, DontDelete, 0 },
    { "value", (intptr_t)JSHTMLOptionElement::ValueAttrNum, DontDelete, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLOptionElementTable = { 127, JSHTMLOptionElementTableValues, 0 };

/* Hash table for prototype */

static const HashTableValue JSHTMLOptionElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLOptionElementPrototypeTable = { 0, JSHTMLOptionElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLOptionElementPrototype::s_info = { "HTMLOptionElementPrototype", 0, &JSHTMLOptionElementPrototypeTable, 0 };

JSObject* JSHTMLOptionElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLOptionElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLOptionElementPrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSHTMLOptionElement::s_info = { "HTMLOptionElement", &JSHTMLElement::s_info, &JSHTMLOptionElementTable , 0 };

JSHTMLOptionElement::JSHTMLOptionElement(JSObject* prototype, HTMLOptionElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLOptionElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLOptionElement, Base>(exec, &JSHTMLOptionElementTable, this, propertyName, slot);
}

JSValue* JSHTMLOptionElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case FormAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());
        return toJS(exec, WTF::getPtr(imp->form()));
    }
    case DefaultSelectedAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());
        return jsBoolean(imp->defaultSelected());
    }
    case TextAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());
        return jsString(exec, imp->text());
    }
    case IndexAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());
        return jsNumber(exec, imp->index());
    }
    case DisabledAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());
        return jsBoolean(imp->disabled());
    }
    case LabelAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());
        return jsString(exec, imp->label());
    }
    case SelectedAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());
        return jsBoolean(imp->selected());
    }
    case ValueAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());
        return jsString(exec, imp->value());
    }
    }
    return 0;
}

void JSHTMLOptionElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLOptionElement, Base>(exec, propertyName, value, &JSHTMLOptionElementTable, this);
}

void JSHTMLOptionElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case DefaultSelectedAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());
        imp->setDefaultSelected(value->toBoolean(exec));
        break;
    }
    case TextAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());
        ExceptionCode ec = 0;
        imp->setText(valueToStringWithNullCheck(exec, value), ec);
        setDOMException(exec, ec);
        break;
    }
    case DisabledAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());
        imp->setDisabled(value->toBoolean(exec));
        break;
    }
    case LabelAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());
        imp->setLabel(valueToStringWithNullCheck(exec, value));
        break;
    }
    case SelectedAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());
        imp->setSelected(value->toBoolean(exec));
        break;
    }
    case ValueAttrNum: {
        HTMLOptionElement* imp = static_cast<HTMLOptionElement*>(impl());
        imp->setValue(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

HTMLOptionElement* toHTMLOptionElement(KJS::JSValue* val)
{
    return val->isObject(&JSHTMLOptionElement::s_info) ? static_cast<JSHTMLOptionElement*>(val)->impl() : 0;
}

}
