/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLOptGroupElement.h"

#include <wtf/GetPtr.h>

#include "HTMLOptGroupElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLOptGroupElementTableValues[4] =
{
    { "disabled", (intptr_t)JSHTMLOptGroupElement::DisabledAttrNum, DontDelete, 0 },
    { "label", (intptr_t)JSHTMLOptGroupElement::LabelAttrNum, DontDelete, 0 },
    { "constructor", (intptr_t)JSHTMLOptGroupElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLOptGroupElementTable = { 63, JSHTMLOptGroupElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLOptGroupElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLOptGroupElementConstructorTable = { 0, JSHTMLOptGroupElementConstructorTableValues, 0 };

class JSHTMLOptGroupElementConstructor : public DOMObject {
public:
    JSHTMLOptGroupElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLOptGroupElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLOptGroupElementConstructor::s_info = { "HTMLOptGroupElementConstructor", 0, &JSHTMLOptGroupElementConstructorTable, 0 };

bool JSHTMLOptGroupElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLOptGroupElementConstructor, DOMObject>(exec, &JSHTMLOptGroupElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLOptGroupElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLOptGroupElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLOptGroupElementPrototypeTable = { 0, JSHTMLOptGroupElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLOptGroupElementPrototype::s_info = { "HTMLOptGroupElementPrototype", 0, &JSHTMLOptGroupElementPrototypeTable, 0 };

JSObject* JSHTMLOptGroupElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLOptGroupElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLOptGroupElementPrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSHTMLOptGroupElement::s_info = { "HTMLOptGroupElement", &JSHTMLElement::s_info, &JSHTMLOptGroupElementTable , 0 };

JSHTMLOptGroupElement::JSHTMLOptGroupElement(JSObject* prototype, HTMLOptGroupElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLOptGroupElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLOptGroupElement, Base>(exec, &JSHTMLOptGroupElementTable, this, propertyName, slot);
}

JSValue* JSHTMLOptGroupElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case DisabledAttrNum: {
        HTMLOptGroupElement* imp = static_cast<HTMLOptGroupElement*>(impl());
        return jsBoolean(imp->disabled());
    }
    case LabelAttrNum: {
        HTMLOptGroupElement* imp = static_cast<HTMLOptGroupElement*>(impl());
        return jsString(exec, imp->label());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLOptGroupElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLOptGroupElement, Base>(exec, propertyName, value, &JSHTMLOptGroupElementTable, this);
}

void JSHTMLOptGroupElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case DisabledAttrNum: {
        HTMLOptGroupElement* imp = static_cast<HTMLOptGroupElement*>(impl());
        imp->setDisabled(value->toBoolean(exec));
        break;
    }
    case LabelAttrNum: {
        HTMLOptGroupElement* imp = static_cast<HTMLOptGroupElement*>(impl());
        imp->setLabel(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLOptGroupElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLOptGroupElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLOptGroupElementConstructor>(exec, constructorIdentifier);
}


}
