/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009
*/

#include "config.h"


#if ENABLE(VIDEO)

#include "JSHTMLMediaElement.h"

#include <wtf/GetPtr.h>

#include "HTMLMediaElement.h"
#include "JSMediaError.h"
#include "JSTimeRanges.h"
#include "KURL.h"
#include "MediaError.h"
#include "TimeRanges.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLMediaElementTableValues[28] =
{
    { "error", (intptr_t)JSHTMLMediaElement::ErrorAttrNum, DontDelete|ReadOnly, 0 },
    { "src", (intptr_t)JSHTMLMediaElement::SrcAttrNum, DontDelete, 0 },
    { "currentSrc", (intptr_t)JSHTMLMediaElement::CurrentSrcAttrNum, DontDelete|ReadOnly, 0 },
    { "networkState", (intptr_t)JSHTMLMediaElement::NetworkStateAttrNum, DontDelete|ReadOnly, 0 },
    { "bufferingRate", (intptr_t)JSHTMLMediaElement::BufferingRateAttrNum, DontDelete|ReadOnly, 0 },
    { "buffered", (intptr_t)JSHTMLMediaElement::BufferedAttrNum, DontDelete|ReadOnly, 0 },
    { "readyState", (intptr_t)JSHTMLMediaElement::ReadyStateAttrNum, DontDelete|ReadOnly, 0 },
    { "seeking", (intptr_t)JSHTMLMediaElement::SeekingAttrNum, DontDelete|ReadOnly, 0 },
    { "currentTime", (intptr_t)JSHTMLMediaElement::CurrentTimeAttrNum, DontDelete, 0 },
    { "duration", (intptr_t)JSHTMLMediaElement::DurationAttrNum, DontDelete|ReadOnly, 0 },
    { "paused", (intptr_t)JSHTMLMediaElement::PausedAttrNum, DontDelete|ReadOnly, 0 },
    { "defaultPlaybackRate", (intptr_t)JSHTMLMediaElement::DefaultPlaybackRateAttrNum, DontDelete, 0 },
    { "playbackRate", (intptr_t)JSHTMLMediaElement::PlaybackRateAttrNum, DontDelete, 0 },
    { "played", (intptr_t)JSHTMLMediaElement::PlayedAttrNum, DontDelete|ReadOnly, 0 },
    { "seekable", (intptr_t)JSHTMLMediaElement::SeekableAttrNum, DontDelete|ReadOnly, 0 },
    { "ended", (intptr_t)JSHTMLMediaElement::EndedAttrNum, DontDelete|ReadOnly, 0 },
    { "autoplay", (intptr_t)JSHTMLMediaElement::AutoplayAttrNum, DontDelete, 0 },
    { "start", (intptr_t)JSHTMLMediaElement::StartAttrNum, DontDelete, 0 },
    { "end", (intptr_t)JSHTMLMediaElement::EndAttrNum, DontDelete, 0 },
    { "loopStart", (intptr_t)JSHTMLMediaElement::LoopStartAttrNum, DontDelete, 0 },
    { "loopEnd", (intptr_t)JSHTMLMediaElement::LoopEndAttrNum, DontDelete, 0 },
    { "playCount", (intptr_t)JSHTMLMediaElement::PlayCountAttrNum, DontDelete, 0 },
    { "currentLoop", (intptr_t)JSHTMLMediaElement::CurrentLoopAttrNum, DontDelete, 0 },
    { "controls", (intptr_t)JSHTMLMediaElement::ControlsAttrNum, DontDelete, 0 },
    { "volume", (intptr_t)JSHTMLMediaElement::VolumeAttrNum, DontDelete, 0 },
    { "muted", (intptr_t)JSHTMLMediaElement::MutedAttrNum, DontDelete, 0 },
    { "constructor", (intptr_t)JSHTMLMediaElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLMediaElementTable = { 127, JSHTMLMediaElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLMediaElementConstructorTableValues[10] =
{
    { "EMPTY", (intptr_t)0, DontDelete|ReadOnly, 0 },
    { "LOADING", (intptr_t)1, DontDelete|ReadOnly, 0 },
    { "LOADED_METADATA", (intptr_t)2, DontDelete|ReadOnly, 0 },
    { "LOADED_FIRST_FRAME", (intptr_t)3, DontDelete|ReadOnly, 0 },
    { "LOADED", (intptr_t)4, DontDelete|ReadOnly, 0 },
    { "DATA_UNAVAILABLE", (intptr_t)0, DontDelete|ReadOnly, 0 },
    { "CAN_SHOW_CURRENT_FRAME", (intptr_t)1, DontDelete|ReadOnly, 0 },
    { "CAN_PLAY", (intptr_t)2, DontDelete|ReadOnly, 0 },
    { "CAN_PLAY_THROUGH", (intptr_t)3, DontDelete|ReadOnly, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLMediaElementConstructorTable = { 63, JSHTMLMediaElementConstructorTableValues, 0 };

class JSHTMLMediaElementConstructor : public DOMObject {
public:
    JSHTMLMediaElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLMediaElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLMediaElementConstructor::s_info = { "HTMLMediaElementConstructor", 0, &JSHTMLMediaElementConstructorTable, 0 };

bool JSHTMLMediaElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMediaElementConstructor, DOMObject>(exec, &JSHTMLMediaElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLMediaElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLMediaElementPrototypeTableValues[13] =
{
    { "EMPTY", (intptr_t)0, DontDelete|ReadOnly, 0 },
    { "LOADING", (intptr_t)1, DontDelete|ReadOnly, 0 },
    { "LOADED_METADATA", (intptr_t)2, DontDelete|ReadOnly, 0 },
    { "LOADED_FIRST_FRAME", (intptr_t)3, DontDelete|ReadOnly, 0 },
    { "LOADED", (intptr_t)4, DontDelete|ReadOnly, 0 },
    { "DATA_UNAVAILABLE", (intptr_t)0, DontDelete|ReadOnly, 0 },
    { "CAN_SHOW_CURRENT_FRAME", (intptr_t)1, DontDelete|ReadOnly, 0 },
    { "CAN_PLAY", (intptr_t)2, DontDelete|ReadOnly, 0 },
    { "CAN_PLAY_THROUGH", (intptr_t)3, DontDelete|ReadOnly, 0 },
    { "load", (intptr_t)jsHTMLMediaElementPrototypeFunctionLoad, DontDelete|Function, 0 },
    { "play", (intptr_t)jsHTMLMediaElementPrototypeFunctionPlay, DontDelete|Function, 0 },
    { "pause", (intptr_t)jsHTMLMediaElementPrototypeFunctionPause, DontDelete|Function, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLMediaElementPrototypeTable = { 127, JSHTMLMediaElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLMediaElementPrototype::s_info = { "HTMLMediaElementPrototype", 0, &JSHTMLMediaElementPrototypeTable, 0 };

JSObject* JSHTMLMediaElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLMediaElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLMediaElementPrototype>(exec, prototypeIdentifier);
}

bool JSHTMLMediaElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSHTMLMediaElementPrototype, JSObject>(exec, &JSHTMLMediaElementPrototypeTable, this, propertyName, slot);
}

JSValue* JSHTMLMediaElementPrototype::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

const ClassInfo JSHTMLMediaElement::s_info = { "HTMLMediaElement", &JSHTMLElement::s_info, &JSHTMLMediaElementTable , 0 };

JSHTMLMediaElement::JSHTMLMediaElement(JSObject* prototype, HTMLMediaElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLMediaElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMediaElement, Base>(exec, &JSHTMLMediaElementTable, this, propertyName, slot);
}

JSValue* JSHTMLMediaElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ErrorAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return toJS(exec, WTF::getPtr(imp->error()));
    }
    case SrcAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return jsString(exec, imp->src());
    }
    case CurrentSrcAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return jsString(exec, imp->currentSrc());
    }
    case NetworkStateAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return jsNumber(exec, imp->networkState());
    }
    case BufferingRateAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return jsNumber(exec, imp->bufferingRate());
    }
    case BufferedAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return toJS(exec, WTF::getPtr(imp->buffered()));
    }
    case ReadyStateAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return jsNumber(exec, imp->readyState());
    }
    case SeekingAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return jsBoolean(imp->seeking());
    }
    case CurrentTimeAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return jsNumber(exec, imp->currentTime());
    }
    case DurationAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return jsNumber(exec, imp->duration());
    }
    case PausedAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return jsBoolean(imp->paused());
    }
    case DefaultPlaybackRateAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return jsNumber(exec, imp->defaultPlaybackRate());
    }
    case PlaybackRateAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return jsNumber(exec, imp->playbackRate());
    }
    case PlayedAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return toJS(exec, WTF::getPtr(imp->played()));
    }
    case SeekableAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return toJS(exec, WTF::getPtr(imp->seekable()));
    }
    case EndedAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return jsBoolean(imp->ended());
    }
    case AutoplayAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return jsBoolean(imp->autoplay());
    }
    case StartAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return jsNumber(exec, imp->start());
    }
    case EndAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return jsNumber(exec, imp->end());
    }
    case LoopStartAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return jsNumber(exec, imp->loopStart());
    }
    case LoopEndAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return jsNumber(exec, imp->loopEnd());
    }
    case PlayCountAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return jsNumber(exec, imp->playCount());
    }
    case CurrentLoopAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return jsNumber(exec, imp->currentLoop());
    }
    case ControlsAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return jsBoolean(imp->controls());
    }
    case VolumeAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return jsNumber(exec, imp->volume());
    }
    case MutedAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        return jsBoolean(imp->muted());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLMediaElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLMediaElement, Base>(exec, propertyName, value, &JSHTMLMediaElementTable, this);
}

void JSHTMLMediaElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case SrcAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        imp->setSrc(value->toString(exec));
        break;
    }
    case CurrentTimeAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        ExceptionCode ec = 0;
        imp->setCurrentTime(value->toFloat(exec), ec);
        setDOMException(exec, ec);
        break;
    }
    case DefaultPlaybackRateAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        ExceptionCode ec = 0;
        imp->setDefaultPlaybackRate(value->toFloat(exec), ec);
        setDOMException(exec, ec);
        break;
    }
    case PlaybackRateAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        ExceptionCode ec = 0;
        imp->setPlaybackRate(value->toFloat(exec), ec);
        setDOMException(exec, ec);
        break;
    }
    case AutoplayAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        imp->setAutoplay(value->toBoolean(exec));
        break;
    }
    case StartAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        imp->setStart(value->toFloat(exec));
        break;
    }
    case EndAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        imp->setEnd(value->toFloat(exec));
        break;
    }
    case LoopStartAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        imp->setLoopStart(value->toFloat(exec));
        break;
    }
    case LoopEndAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        imp->setLoopEnd(value->toFloat(exec));
        break;
    }
    case PlayCountAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        ExceptionCode ec = 0;
        imp->setPlayCount(value->toInt32(exec), ec);
        setDOMException(exec, ec);
        break;
    }
    case CurrentLoopAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        imp->setCurrentLoop(value->toInt32(exec));
        break;
    }
    case ControlsAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        imp->setControls(value->toBoolean(exec));
        break;
    }
    case VolumeAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        ExceptionCode ec = 0;
        imp->setVolume(value->toFloat(exec), ec);
        setDOMException(exec, ec);
        break;
    }
    case MutedAttrNum: {
        HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(impl());
        imp->setMuted(value->toBoolean(exec));
        break;
    }
    }
}

JSValue* JSHTMLMediaElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLMediaElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLMediaElementConstructor>(exec, constructorIdentifier);
}

JSValue* jsHTMLMediaElementPrototypeFunctionLoad(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLMediaElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLMediaElement* castedThisObj = static_cast<JSHTMLMediaElement*>(thisValue);
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;

    imp->load(ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsHTMLMediaElementPrototypeFunctionPlay(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLMediaElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLMediaElement* castedThisObj = static_cast<JSHTMLMediaElement*>(thisValue);
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;

    imp->play(ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsHTMLMediaElementPrototypeFunctionPause(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLMediaElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLMediaElement* castedThisObj = static_cast<JSHTMLMediaElement*>(thisValue);
    HTMLMediaElement* imp = static_cast<HTMLMediaElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;

    imp->pause(ec);
    setDOMException(exec, ec);
    return jsUndefined();
}


}

#endif // ENABLE(VIDEO)
