/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLMarqueeElement.h"

#include <wtf/GetPtr.h>

#include "HTMLMarqueeElement.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLMarqueeElementTableValues[2] =
{
    { "constructor", (intptr_t)JSHTMLMarqueeElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLMarqueeElementTable = { 0, JSHTMLMarqueeElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLMarqueeElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLMarqueeElementConstructorTable = { 0, JSHTMLMarqueeElementConstructorTableValues, 0 };

class JSHTMLMarqueeElementConstructor : public DOMObject {
public:
    JSHTMLMarqueeElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLMarqueeElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLMarqueeElementConstructor::s_info = { "HTMLMarqueeElementConstructor", 0, &JSHTMLMarqueeElementConstructorTable, 0 };

bool JSHTMLMarqueeElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMarqueeElementConstructor, DOMObject>(exec, &JSHTMLMarqueeElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLMarqueeElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLMarqueeElementPrototypeTableValues[3] =
{
    { "start", (intptr_t)jsHTMLMarqueeElementPrototypeFunctionStart, DontDelete|Function, 0 },
    { "stop", (intptr_t)jsHTMLMarqueeElementPrototypeFunctionStop, DontDelete|Function, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLMarqueeElementPrototypeTable = { 7, JSHTMLMarqueeElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLMarqueeElementPrototype::s_info = { "HTMLMarqueeElementPrototype", 0, &JSHTMLMarqueeElementPrototypeTable, 0 };

JSObject* JSHTMLMarqueeElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLMarqueeElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLMarqueeElementPrototype>(exec, prototypeIdentifier);
}

bool JSHTMLMarqueeElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLMarqueeElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLMarqueeElement::s_info = { "HTMLMarqueeElement", &JSHTMLElement::s_info, &JSHTMLMarqueeElementTable , 0 };

JSHTMLMarqueeElement::JSHTMLMarqueeElement(JSObject* prototype, HTMLMarqueeElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLMarqueeElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMarqueeElement, Base>(exec, &JSHTMLMarqueeElementTable, this, propertyName, slot);
}

JSValue* JSHTMLMarqueeElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSHTMLMarqueeElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLMarqueeElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLMarqueeElementConstructor>(exec, constructorIdentifier);
}

JSValue* jsHTMLMarqueeElementPrototypeFunctionStart(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLMarqueeElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLMarqueeElement* castedThisObj = static_cast<JSHTMLMarqueeElement*>(thisValue);
    HTMLMarqueeElement* imp = static_cast<HTMLMarqueeElement*>(castedThisObj->impl());

    imp->start();
    return jsUndefined();
}

JSValue* jsHTMLMarqueeElementPrototypeFunctionStop(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLMarqueeElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLMarqueeElement* castedThisObj = static_cast<JSHTMLMarqueeElement*>(thisValue);
    HTMLMarqueeElement* imp = static_cast<HTMLMarqueeElement*>(castedThisObj->impl());

    imp->stop();
    return jsUndefined();
}


}
