/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLLegendElement.h"

#include <wtf/GetPtr.h>

#include "HTMLFormElement.h"
#include "HTMLLegendElement.h"
#include "JSHTMLFormElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLLegendElementTableValues[5] =
{
    { "form", (intptr_t)JSHTMLLegendElement::FormAttrNum, DontDelete|ReadOnly, 0 },
    { "accessKey", (intptr_t)JSHTMLLegendElement::AccessKeyAttrNum, DontDelete, 0 },
    { "align", (intptr_t)JSHTMLLegendElement::AlignAttrNum, DontDelete, 0 },
    { "constructor", (intptr_t)JSHTMLLegendElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLLegendElementTable = { 31, JSHTMLLegendElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLLegendElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLLegendElementConstructorTable = { 0, JSHTMLLegendElementConstructorTableValues, 0 };

class JSHTMLLegendElementConstructor : public DOMObject {
public:
    JSHTMLLegendElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLLegendElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLLegendElementConstructor::s_info = { "HTMLLegendElementConstructor", 0, &JSHTMLLegendElementConstructorTable, 0 };

bool JSHTMLLegendElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLLegendElementConstructor, DOMObject>(exec, &JSHTMLLegendElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLLegendElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLLegendElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLLegendElementPrototypeTable = { 0, JSHTMLLegendElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLLegendElementPrototype::s_info = { "HTMLLegendElementPrototype", 0, &JSHTMLLegendElementPrototypeTable, 0 };

JSObject* JSHTMLLegendElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLLegendElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLLegendElementPrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSHTMLLegendElement::s_info = { "HTMLLegendElement", &JSHTMLElement::s_info, &JSHTMLLegendElementTable , 0 };

JSHTMLLegendElement::JSHTMLLegendElement(JSObject* prototype, HTMLLegendElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLLegendElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLLegendElement, Base>(exec, &JSHTMLLegendElementTable, this, propertyName, slot);
}

JSValue* JSHTMLLegendElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case FormAttrNum: {
        HTMLLegendElement* imp = static_cast<HTMLLegendElement*>(impl());
        return toJS(exec, WTF::getPtr(imp->form()));
    }
    case AccessKeyAttrNum: {
        HTMLLegendElement* imp = static_cast<HTMLLegendElement*>(impl());
        return jsString(exec, imp->accessKey());
    }
    case AlignAttrNum: {
        HTMLLegendElement* imp = static_cast<HTMLLegendElement*>(impl());
        return jsString(exec, imp->align());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLLegendElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLLegendElement, Base>(exec, propertyName, value, &JSHTMLLegendElementTable, this);
}

void JSHTMLLegendElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case AccessKeyAttrNum: {
        HTMLLegendElement* imp = static_cast<HTMLLegendElement*>(impl());
        imp->setAccessKey(valueToStringWithNullCheck(exec, value));
        break;
    }
    case AlignAttrNum: {
        HTMLLegendElement* imp = static_cast<HTMLLegendElement*>(impl());
        imp->setAlign(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLLegendElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLLegendElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLLegendElementConstructor>(exec, constructorIdentifier);
}


}
