/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLLabelElement.h"

#include <wtf/GetPtr.h>

#include "HTMLFormElement.h"
#include "HTMLLabelElement.h"
#include "JSHTMLFormElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLLabelElementTableValues[5] =
{
    { "form", (intptr_t)JSHTMLLabelElement::FormAttrNum, DontDelete|ReadOnly, 0 },
    { "accessKey", (intptr_t)JSHTMLLabelElement::AccessKeyAttrNum, DontDelete, 0 },
    { "htmlFor", (intptr_t)JSHTMLLabelElement::HtmlForAttrNum, DontDelete, 0 },
    { "constructor", (intptr_t)JSHTMLLabelElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLLabelElementTable = { 31, JSHTMLLabelElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLLabelElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLLabelElementConstructorTable = { 0, JSHTMLLabelElementConstructorTableValues, 0 };

class JSHTMLLabelElementConstructor : public DOMObject {
public:
    JSHTMLLabelElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLLabelElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLLabelElementConstructor::s_info = { "HTMLLabelElementConstructor", 0, &JSHTMLLabelElementConstructorTable, 0 };

bool JSHTMLLabelElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLLabelElementConstructor, DOMObject>(exec, &JSHTMLLabelElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLLabelElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLLabelElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLLabelElementPrototypeTable = { 0, JSHTMLLabelElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLLabelElementPrototype::s_info = { "HTMLLabelElementPrototype", 0, &JSHTMLLabelElementPrototypeTable, 0 };

JSObject* JSHTMLLabelElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLLabelElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLLabelElementPrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSHTMLLabelElement::s_info = { "HTMLLabelElement", &JSHTMLElement::s_info, &JSHTMLLabelElementTable , 0 };

JSHTMLLabelElement::JSHTMLLabelElement(JSObject* prototype, HTMLLabelElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLLabelElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLLabelElement, Base>(exec, &JSHTMLLabelElementTable, this, propertyName, slot);
}

JSValue* JSHTMLLabelElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case FormAttrNum: {
        HTMLLabelElement* imp = static_cast<HTMLLabelElement*>(impl());
        return toJS(exec, WTF::getPtr(imp->form()));
    }
    case AccessKeyAttrNum: {
        HTMLLabelElement* imp = static_cast<HTMLLabelElement*>(impl());
        return jsString(exec, imp->accessKey());
    }
    case HtmlForAttrNum: {
        HTMLLabelElement* imp = static_cast<HTMLLabelElement*>(impl());
        return jsString(exec, imp->htmlFor());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLLabelElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLLabelElement, Base>(exec, propertyName, value, &JSHTMLLabelElementTable, this);
}

void JSHTMLLabelElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case AccessKeyAttrNum: {
        HTMLLabelElement* imp = static_cast<HTMLLabelElement*>(impl());
        imp->setAccessKey(valueToStringWithNullCheck(exec, value));
        break;
    }
    case HtmlForAttrNum: {
        HTMLLabelElement* imp = static_cast<HTMLLabelElement*>(impl());
        imp->setHtmlFor(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLLabelElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLLabelElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLLabelElementConstructor>(exec, constructorIdentifier);
}


}
