/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLIsIndexElement.h"

#include <wtf/GetPtr.h>

#include "HTMLFormElement.h"
#include "HTMLIsIndexElement.h"
#include "JSHTMLFormElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLIsIndexElementTableValues[4] =
{
    { "form", (intptr_t)JSHTMLIsIndexElement::FormAttrNum, DontDelete|ReadOnly, 0 },
    { "prompt", (intptr_t)JSHTMLIsIndexElement::PromptAttrNum, DontDelete, 0 },
    { "constructor", (intptr_t)JSHTMLIsIndexElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLIsIndexElementTable = { 7, JSHTMLIsIndexElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLIsIndexElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLIsIndexElementConstructorTable = { 0, JSHTMLIsIndexElementConstructorTableValues, 0 };

class JSHTMLIsIndexElementConstructor : public DOMObject {
public:
    JSHTMLIsIndexElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLIsIndexElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLIsIndexElementConstructor::s_info = { "HTMLIsIndexElementConstructor", 0, &JSHTMLIsIndexElementConstructorTable, 0 };

bool JSHTMLIsIndexElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLIsIndexElementConstructor, DOMObject>(exec, &JSHTMLIsIndexElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLIsIndexElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLIsIndexElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLIsIndexElementPrototypeTable = { 0, JSHTMLIsIndexElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLIsIndexElementPrototype::s_info = { "HTMLIsIndexElementPrototype", 0, &JSHTMLIsIndexElementPrototypeTable, 0 };

JSObject* JSHTMLIsIndexElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLIsIndexElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLIsIndexElementPrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSHTMLIsIndexElement::s_info = { "HTMLIsIndexElement", &JSHTMLInputElement::s_info, &JSHTMLIsIndexElementTable , 0 };

JSHTMLIsIndexElement::JSHTMLIsIndexElement(JSObject* prototype, HTMLIsIndexElement* impl)
    : JSHTMLInputElement(prototype, impl)
{
}

bool JSHTMLIsIndexElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLIsIndexElement, Base>(exec, &JSHTMLIsIndexElementTable, this, propertyName, slot);
}

JSValue* JSHTMLIsIndexElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case FormAttrNum: {
        HTMLIsIndexElement* imp = static_cast<HTMLIsIndexElement*>(impl());
        return toJS(exec, WTF::getPtr(imp->form()));
    }
    case PromptAttrNum: {
        HTMLIsIndexElement* imp = static_cast<HTMLIsIndexElement*>(impl());
        return jsString(exec, imp->prompt());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLIsIndexElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLIsIndexElement, Base>(exec, propertyName, value, &JSHTMLIsIndexElementTable, this);
}

void JSHTMLIsIndexElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case PromptAttrNum: {
        HTMLIsIndexElement* imp = static_cast<HTMLIsIndexElement*>(impl());
        imp->setPrompt(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLIsIndexElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLIsIndexElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLIsIndexElementConstructor>(exec, constructorIdentifier);
}


}
