/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLInputElement.h"

#include <wtf/GetPtr.h>

#include "FileList.h"
#include "HTMLFormElement.h"
#include "HTMLInputElement.h"
#include "JSFileList.h"
#include "JSHTMLFormElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLInputElementTableValues[22] =
{
    { "defaultValue", (intptr_t)JSHTMLInputElement::DefaultValueAttrNum, DontDelete, 0 },
    { "defaultChecked", (intptr_t)JSHTMLInputElement::DefaultCheckedAttrNum, DontDelete, 0 },
    { "form", (intptr_t)JSHTMLInputElement::FormAttrNum, DontDelete|ReadOnly, 0 },
    { "accept", (intptr_t)JSHTMLInputElement::AcceptAttrNum, DontDelete, 0 },
    { "accessKey", (intptr_t)JSHTMLInputElement::AccessKeyAttrNum, DontDelete, 0 },
    { "align", (intptr_t)JSHTMLInputElement::AlignAttrNum, DontDelete, 0 },
    { "alt", (intptr_t)JSHTMLInputElement::AltAttrNum, DontDelete, 0 },
    { "checked", (intptr_t)JSHTMLInputElement::CheckedAttrNum, DontDelete, 0 },
    { "disabled", (intptr_t)JSHTMLInputElement::DisabledAttrNum, DontDelete, 0 },
    { "autofocus", (intptr_t)JSHTMLInputElement::AutofocusAttrNum, DontDelete, 0 },
    { "maxLength", (intptr_t)JSHTMLInputElement::MaxLengthAttrNum, DontDelete, 0 },
    { "name", (intptr_t)JSHTMLInputElement::NameAttrNum, DontDelete, 0 },
    { "readOnly", (intptr_t)JSHTMLInputElement::ReadOnlyAttrNum, DontDelete, 0 },
    { "size", (intptr_t)JSHTMLInputElement::SizeAttrNum, DontDelete, 0 },
    { "src", (intptr_t)JSHTMLInputElement::SrcAttrNum, DontDelete, 0 },
    { "type", (intptr_t)JSHTMLInputElement::TypeAttrNum, DontDelete, 0 },
    { "useMap", (intptr_t)JSHTMLInputElement::UseMapAttrNum, DontDelete, 0 },
    { "value", (intptr_t)JSHTMLInputElement::ValueAttrNum, DontDelete, 0 },
    { "indeterminate", (intptr_t)JSHTMLInputElement::IndeterminateAttrNum, DontDelete, 0 },
    { "files", (intptr_t)JSHTMLInputElement::FilesAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSHTMLInputElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLInputElementTable = { 255, JSHTMLInputElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLInputElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLInputElementConstructorTable = { 0, JSHTMLInputElementConstructorTableValues, 0 };

class JSHTMLInputElementConstructor : public DOMObject {
public:
    JSHTMLInputElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLInputElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLInputElementConstructor::s_info = { "HTMLInputElementConstructor", 0, &JSHTMLInputElementConstructorTable, 0 };

bool JSHTMLInputElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLInputElementConstructor, DOMObject>(exec, &JSHTMLInputElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLInputElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLInputElementPrototypeTableValues[3] =
{
    { "select", (intptr_t)jsHTMLInputElementPrototypeFunctionSelect, DontDelete|Function, 0 },
    { "click", (intptr_t)jsHTMLInputElementPrototypeFunctionClick, DontDelete|Function, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLInputElementPrototypeTable = { 3, JSHTMLInputElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLInputElementPrototype::s_info = { "HTMLInputElementPrototype", 0, &JSHTMLInputElementPrototypeTable, 0 };

JSObject* JSHTMLInputElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLInputElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLInputElementPrototype>(exec, prototypeIdentifier);
}

bool JSHTMLInputElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLInputElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLInputElement::s_info = { "HTMLInputElement", &JSHTMLInputElementBase::s_info, &JSHTMLInputElementTable , 0 };

JSHTMLInputElement::JSHTMLInputElement(JSObject* prototype, HTMLInputElement* impl)
    : JSHTMLInputElementBase(prototype, impl)
{
}

bool JSHTMLInputElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLInputElement, Base>(exec, &JSHTMLInputElementTable, this, propertyName, slot);
}

JSValue* JSHTMLInputElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case DefaultValueAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        return jsString(exec, imp->defaultValue());
    }
    case DefaultCheckedAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        return jsBoolean(imp->defaultChecked());
    }
    case FormAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        return toJS(exec, WTF::getPtr(imp->form()));
    }
    case AcceptAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        return jsString(exec, imp->accept());
    }
    case AccessKeyAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        return jsString(exec, imp->accessKey());
    }
    case AlignAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        return jsString(exec, imp->align());
    }
    case AltAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        return jsString(exec, imp->alt());
    }
    case CheckedAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        return jsBoolean(imp->checked());
    }
    case DisabledAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        return jsBoolean(imp->disabled());
    }
    case AutofocusAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        return jsBoolean(imp->autofocus());
    }
    case MaxLengthAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        return jsNumber(exec, imp->maxLength());
    }
    case NameAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        return jsString(exec, imp->name());
    }
    case ReadOnlyAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        return jsBoolean(imp->readOnly());
    }
    case SizeAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        return jsNumber(exec, imp->size());
    }
    case SrcAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        return jsString(exec, imp->src());
    }
    case TypeAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        return jsString(exec, imp->type());
    }
    case UseMapAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        return jsString(exec, imp->useMap());
    }
    case ValueAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        return jsString(exec, imp->value());
    }
    case IndeterminateAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        return jsBoolean(imp->indeterminate());
    }
    case FilesAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        return toJS(exec, WTF::getPtr(imp->files()));
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLInputElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLInputElement, Base>(exec, propertyName, value, &JSHTMLInputElementTable, this);
}

void JSHTMLInputElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case DefaultValueAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        imp->setDefaultValue(valueToStringWithNullCheck(exec, value));
        break;
    }
    case DefaultCheckedAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        imp->setDefaultChecked(value->toBoolean(exec));
        break;
    }
    case AcceptAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        imp->setAccept(valueToStringWithNullCheck(exec, value));
        break;
    }
    case AccessKeyAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        imp->setAccessKey(valueToStringWithNullCheck(exec, value));
        break;
    }
    case AlignAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        imp->setAlign(valueToStringWithNullCheck(exec, value));
        break;
    }
    case AltAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        imp->setAlt(valueToStringWithNullCheck(exec, value));
        break;
    }
    case CheckedAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        imp->setChecked(value->toBoolean(exec));
        break;
    }
    case DisabledAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        imp->setDisabled(value->toBoolean(exec));
        break;
    }
    case AutofocusAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        imp->setAutofocus(value->toBoolean(exec));
        break;
    }
    case MaxLengthAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        imp->setMaxLength(value->toInt32(exec));
        break;
    }
    case NameAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        imp->setName(valueToStringWithNullCheck(exec, value));
        break;
    }
    case ReadOnlyAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        imp->setReadOnly(value->toBoolean(exec));
        break;
    }
    case SizeAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        imp->setSize(value->toInt32(exec));
        break;
    }
    case SrcAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        imp->setSrc(valueToStringWithNullCheck(exec, value));
        break;
    }
    case TypeAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        imp->setType(valueToStringWithNullCheck(exec, value));
        break;
    }
    case UseMapAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        imp->setUseMap(valueToStringWithNullCheck(exec, value));
        break;
    }
    case ValueAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        imp->setValue(valueToStringWithNullCheck(exec, value));
        break;
    }
    case IndeterminateAttrNum: {
        HTMLInputElement* imp = static_cast<HTMLInputElement*>(impl());
        imp->setIndeterminate(value->toBoolean(exec));
        break;
    }
    }
}

JSValue* JSHTMLInputElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLInputElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLInputElementConstructor>(exec, constructorIdentifier);
}

JSValue* jsHTMLInputElementPrototypeFunctionSelect(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLInputElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLInputElement* castedThisObj = static_cast<JSHTMLInputElement*>(thisValue);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThisObj->impl());

    imp->select();
    return jsUndefined();
}

JSValue* jsHTMLInputElementPrototypeFunctionClick(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLInputElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLInputElement* castedThisObj = static_cast<JSHTMLInputElement*>(thisValue);
    HTMLInputElement* imp = static_cast<HTMLInputElement*>(castedThisObj->impl());

    imp->click();
    return jsUndefined();
}


}
