/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLImageElement.h"

#include <wtf/GetPtr.h>

#include "HTMLImageElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLImageElementTableValues[20] =
{
    { "name", (intptr_t)JSHTMLImageElement::NameAttrNum, DontDelete, 0 },
    { "align", (intptr_t)JSHTMLImageElement::AlignAttrNum, DontDelete, 0 },
    { "alt", (intptr_t)JSHTMLImageElement::AltAttrNum, DontDelete, 0 },
    { "border", (intptr_t)JSHTMLImageElement::BorderAttrNum, DontDelete, 0 },
    { "height", (intptr_t)JSHTMLImageElement::HeightAttrNum, DontDelete, 0 },
    { "hspace", (intptr_t)JSHTMLImageElement::HspaceAttrNum, DontDelete, 0 },
    { "isMap", (intptr_t)JSHTMLImageElement::IsMapAttrNum, DontDelete, 0 },
    { "longDesc", (intptr_t)JSHTMLImageElement::LongDescAttrNum, DontDelete, 0 },
    { "src", (intptr_t)JSHTMLImageElement::SrcAttrNum, DontDelete, 0 },
    { "useMap", (intptr_t)JSHTMLImageElement::UseMapAttrNum, DontDelete, 0 },
    { "vspace", (intptr_t)JSHTMLImageElement::VspaceAttrNum, DontDelete, 0 },
    { "width", (intptr_t)JSHTMLImageElement::WidthAttrNum, DontDelete, 0 },
    { "complete", (intptr_t)JSHTMLImageElement::CompleteAttrNum, DontDelete|ReadOnly, 0 },
    { "lowsrc", (intptr_t)JSHTMLImageElement::LowsrcAttrNum, DontDelete, 0 },
    { "naturalHeight", (intptr_t)JSHTMLImageElement::NaturalHeightAttrNum, DontDelete|ReadOnly, 0 },
    { "naturalWidth", (intptr_t)JSHTMLImageElement::NaturalWidthAttrNum, DontDelete|ReadOnly, 0 },
    { "x", (intptr_t)JSHTMLImageElement::XAttrNum, DontDelete|ReadOnly, 0 },
    { "y", (intptr_t)JSHTMLImageElement::YAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSHTMLImageElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLImageElementTable = { 16383, JSHTMLImageElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLImageElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLImageElementConstructorTable = { 0, JSHTMLImageElementConstructorTableValues, 0 };

class JSHTMLImageElementConstructor : public DOMObject {
public:
    JSHTMLImageElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLImageElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLImageElementConstructor::s_info = { "HTMLImageElementConstructor", 0, &JSHTMLImageElementConstructorTable, 0 };

bool JSHTMLImageElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLImageElementConstructor, DOMObject>(exec, &JSHTMLImageElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLImageElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLImageElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLImageElementPrototypeTable = { 0, JSHTMLImageElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLImageElementPrototype::s_info = { "HTMLImageElementPrototype", 0, &JSHTMLImageElementPrototypeTable, 0 };

JSObject* JSHTMLImageElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLImageElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLImageElementPrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSHTMLImageElement::s_info = { "HTMLImageElement", &JSHTMLElement::s_info, &JSHTMLImageElementTable , 0 };

JSHTMLImageElement::JSHTMLImageElement(JSObject* prototype, HTMLImageElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLImageElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLImageElement, Base>(exec, &JSHTMLImageElementTable, this, propertyName, slot);
}

JSValue* JSHTMLImageElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case NameAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsString(exec, imp->name());
    }
    case AlignAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsString(exec, imp->align());
    }
    case AltAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsString(exec, imp->alt());
    }
    case BorderAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsString(exec, imp->border());
    }
    case HeightAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsNumber(exec, imp->height());
    }
    case HspaceAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsNumber(exec, imp->hspace());
    }
    case IsMapAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsBoolean(imp->isMap());
    }
    case LongDescAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsString(exec, imp->longDesc());
    }
    case SrcAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsString(exec, imp->src());
    }
    case UseMapAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsString(exec, imp->useMap());
    }
    case VspaceAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsNumber(exec, imp->vspace());
    }
    case WidthAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsNumber(exec, imp->width());
    }
    case CompleteAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsBoolean(imp->complete());
    }
    case LowsrcAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsString(exec, imp->lowsrc());
    }
    case NaturalHeightAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsNumber(exec, imp->naturalHeight());
    }
    case NaturalWidthAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsNumber(exec, imp->naturalWidth());
    }
    case XAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsNumber(exec, imp->x());
    }
    case YAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsNumber(exec, imp->y());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLImageElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLImageElement, Base>(exec, propertyName, value, &JSHTMLImageElementTable, this);
}

void JSHTMLImageElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case NameAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setName(valueToStringWithNullCheck(exec, value));
        break;
    }
    case AlignAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setAlign(valueToStringWithNullCheck(exec, value));
        break;
    }
    case AltAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setAlt(valueToStringWithNullCheck(exec, value));
        break;
    }
    case BorderAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setBorder(valueToStringWithNullCheck(exec, value));
        break;
    }
    case HeightAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setHeight(value->toInt32(exec));
        break;
    }
    case HspaceAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setHspace(value->toInt32(exec));
        break;
    }
    case IsMapAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setIsMap(value->toBoolean(exec));
        break;
    }
    case LongDescAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setLongDesc(valueToStringWithNullCheck(exec, value));
        break;
    }
    case SrcAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setSrc(valueToStringWithNullCheck(exec, value));
        break;
    }
    case UseMapAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setUseMap(valueToStringWithNullCheck(exec, value));
        break;
    }
    case VspaceAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setVspace(value->toInt32(exec));
        break;
    }
    case WidthAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setWidth(value->toInt32(exec));
        break;
    }
    case LowsrcAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setLowsrc(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLImageElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLImageElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLImageElementConstructor>(exec, constructorIdentifier);
}


}
