/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLFormElement.h"

#include <wtf/GetPtr.h>

#include <kjs/PropertyNameArray.h>
#include "AtomicString.h"
#include "HTMLCollection.h"
#include "HTMLFormElement.h"
#include "JSHTMLCollection.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLFormElementTableValues[11] =
{
    { "elements", (intptr_t)JSHTMLFormElement::ElementsAttrNum, DontDelete|ReadOnly, 0 },
    { "length", (intptr_t)JSHTMLFormElement::LengthAttrNum, DontDelete|ReadOnly, 0 },
    { "name", (intptr_t)JSHTMLFormElement::NameAttrNum, DontDelete, 0 },
    { "acceptCharset", (intptr_t)JSHTMLFormElement::AcceptCharsetAttrNum, DontDelete, 0 },
    { "action", (intptr_t)JSHTMLFormElement::ActionAttrNum, DontDelete, 0 },
    { "encoding", (intptr_t)JSHTMLFormElement::EncodingAttrNum, DontDelete, 0 },
    { "enctype", (intptr_t)JSHTMLFormElement::EnctypeAttrNum, DontDelete, 0 },
    { "method", (intptr_t)JSHTMLFormElement::MethodAttrNum, DontDelete, 0 },
    { "target", (intptr_t)JSHTMLFormElement::TargetAttrNum, DontDelete, 0 },
    { "constructor", (intptr_t)JSHTMLFormElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLFormElementTable = { 4095, JSHTMLFormElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLFormElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLFormElementConstructorTable = { 0, JSHTMLFormElementConstructorTableValues, 0 };

class JSHTMLFormElementConstructor : public DOMObject {
public:
    JSHTMLFormElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLFormElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLFormElementConstructor::s_info = { "HTMLFormElementConstructor", 0, &JSHTMLFormElementConstructorTable, 0 };

bool JSHTMLFormElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLFormElementConstructor, DOMObject>(exec, &JSHTMLFormElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLFormElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLFormElementPrototypeTableValues[3] =
{
    { "submit", (intptr_t)jsHTMLFormElementPrototypeFunctionSubmit, DontDelete|Function, 0 },
    { "reset", (intptr_t)jsHTMLFormElementPrototypeFunctionReset, DontDelete|Function, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLFormElementPrototypeTable = { 3, JSHTMLFormElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLFormElementPrototype::s_info = { "HTMLFormElementPrototype", 0, &JSHTMLFormElementPrototypeTable, 0 };

JSObject* JSHTMLFormElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLFormElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLFormElementPrototype>(exec, prototypeIdentifier);
}

bool JSHTMLFormElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLFormElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLFormElement::s_info = { "HTMLFormElement", &JSHTMLElement::s_info, &JSHTMLFormElementTable , 0 };

JSHTMLFormElement::JSHTMLFormElement(JSObject* prototype, HTMLFormElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLFormElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    if (canGetItemsForName(exec, static_cast<HTMLFormElement*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    const HashEntry* entry = JSHTMLFormElementTable.entry(exec, propertyName);
    if (entry) {
        slot.setStaticEntry(this, entry, staticValueGetter<JSHTMLFormElement>);
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<HTMLFormElement*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSHTMLFormElement, Base>(exec, &JSHTMLFormElementTable, this, propertyName, slot);
}

JSValue* JSHTMLFormElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ElementsAttrNum: {
        HTMLFormElement* imp = static_cast<HTMLFormElement*>(impl());
        return toJS(exec, WTF::getPtr(imp->elements()));
    }
    case LengthAttrNum: {
        HTMLFormElement* imp = static_cast<HTMLFormElement*>(impl());
        return jsNumber(exec, imp->length());
    }
    case NameAttrNum: {
        HTMLFormElement* imp = static_cast<HTMLFormElement*>(impl());
        return jsString(exec, imp->name());
    }
    case AcceptCharsetAttrNum: {
        HTMLFormElement* imp = static_cast<HTMLFormElement*>(impl());
        return jsString(exec, imp->acceptCharset());
    }
    case ActionAttrNum: {
        HTMLFormElement* imp = static_cast<HTMLFormElement*>(impl());
        return jsString(exec, imp->action());
    }
    case EncodingAttrNum: {
        HTMLFormElement* imp = static_cast<HTMLFormElement*>(impl());
        return jsString(exec, imp->encoding());
    }
    case EnctypeAttrNum: {
        HTMLFormElement* imp = static_cast<HTMLFormElement*>(impl());
        return jsString(exec, imp->enctype());
    }
    case MethodAttrNum: {
        HTMLFormElement* imp = static_cast<HTMLFormElement*>(impl());
        return jsString(exec, imp->method());
    }
    case TargetAttrNum: {
        HTMLFormElement* imp = static_cast<HTMLFormElement*>(impl());
        return jsString(exec, imp->target());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLFormElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLFormElement, Base>(exec, propertyName, value, &JSHTMLFormElementTable, this);
}

void JSHTMLFormElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case NameAttrNum: {
        HTMLFormElement* imp = static_cast<HTMLFormElement*>(impl());
        imp->setName(valueToStringWithNullCheck(exec, value));
        break;
    }
    case AcceptCharsetAttrNum: {
        HTMLFormElement* imp = static_cast<HTMLFormElement*>(impl());
        imp->setAcceptCharset(valueToStringWithNullCheck(exec, value));
        break;
    }
    case ActionAttrNum: {
        HTMLFormElement* imp = static_cast<HTMLFormElement*>(impl());
        imp->setAction(valueToStringWithNullCheck(exec, value));
        break;
    }
    case EncodingAttrNum: {
        HTMLFormElement* imp = static_cast<HTMLFormElement*>(impl());
        imp->setEncoding(valueToStringWithNullCheck(exec, value));
        break;
    }
    case EnctypeAttrNum: {
        HTMLFormElement* imp = static_cast<HTMLFormElement*>(impl());
        imp->setEnctype(valueToStringWithNullCheck(exec, value));
        break;
    }
    case MethodAttrNum: {
        HTMLFormElement* imp = static_cast<HTMLFormElement*>(impl());
        imp->setMethod(valueToStringWithNullCheck(exec, value));
        break;
    }
    case TargetAttrNum: {
        HTMLFormElement* imp = static_cast<HTMLFormElement*>(impl());
        imp->setTarget(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

void JSHTMLFormElement::getPropertyNames(ExecState* exec, PropertyNameArray& propertyNames)
{
    for (unsigned i = 0; i < static_cast<HTMLFormElement*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getPropertyNames(exec, propertyNames);
}

JSValue* JSHTMLFormElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLFormElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLFormElementConstructor>(exec, constructorIdentifier);
}

JSValue* jsHTMLFormElementPrototypeFunctionSubmit(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLFormElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLFormElement* castedThisObj = static_cast<JSHTMLFormElement*>(thisValue);
    HTMLFormElement* imp = static_cast<HTMLFormElement*>(castedThisObj->impl());

    imp->submit();
    return jsUndefined();
}

JSValue* jsHTMLFormElementPrototypeFunctionReset(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLFormElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLFormElement* castedThisObj = static_cast<JSHTMLFormElement*>(thisValue);
    HTMLFormElement* imp = static_cast<HTMLFormElement*>(castedThisObj->impl());

    imp->reset();
    return jsUndefined();
}


JSValue* JSHTMLFormElement::indexGetter(ExecState* exec, const Identifier& propertyName, const PropertySlot& slot)
{
    JSHTMLFormElement* thisObj = static_cast<JSHTMLFormElement*>(slot.slotBase());
    return toJS(exec, static_cast<HTMLFormElement*>(thisObj->impl())->item(slot.index()));
}

}
