/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLEmbedElement.h"

#include <wtf/GetPtr.h>

#include "AtomicString.h"
#include "HTMLEmbedElement.h"
#include "JSHTMLEmbedElementCustom.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLEmbedElementTableValues[8] =
{
    { "align", (intptr_t)JSHTMLEmbedElement::AlignAttrNum, DontDelete, 0 },
    { "height", (intptr_t)JSHTMLEmbedElement::HeightAttrNum, DontDelete, 0 },
    { "name", (intptr_t)JSHTMLEmbedElement::NameAttrNum, DontDelete, 0 },
    { "src", (intptr_t)JSHTMLEmbedElement::SrcAttrNum, DontDelete, 0 },
    { "type", (intptr_t)JSHTMLEmbedElement::TypeAttrNum, DontDelete, 0 },
    { "width", (intptr_t)JSHTMLEmbedElement::WidthAttrNum, DontDelete, 0 },
    { "constructor", (intptr_t)JSHTMLEmbedElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLEmbedElementTable = { 16383, JSHTMLEmbedElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLEmbedElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLEmbedElementConstructorTable = { 0, JSHTMLEmbedElementConstructorTableValues, 0 };

class JSHTMLEmbedElementConstructor : public DOMObject {
public:
    JSHTMLEmbedElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLEmbedElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLEmbedElementConstructor::s_info = { "HTMLEmbedElementConstructor", 0, &JSHTMLEmbedElementConstructorTable, 0 };

bool JSHTMLEmbedElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLEmbedElementConstructor, DOMObject>(exec, &JSHTMLEmbedElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLEmbedElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLEmbedElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLEmbedElementPrototypeTable = { 0, JSHTMLEmbedElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLEmbedElementPrototype::s_info = { "HTMLEmbedElementPrototype", 0, &JSHTMLEmbedElementPrototypeTable, 0 };

JSObject* JSHTMLEmbedElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLEmbedElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLEmbedElementPrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSHTMLEmbedElement::s_info = { "HTMLEmbedElement", &JSHTMLElement::s_info, &JSHTMLEmbedElementTable , 0 };

JSHTMLEmbedElement::JSHTMLEmbedElement(JSObject* prototype, HTMLEmbedElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLEmbedElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    if (canGetItemsForName(exec, static_cast<HTMLEmbedElement*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    if (customGetOwnPropertySlot(exec, propertyName, slot))
        return true;
    return getStaticValueSlot<JSHTMLEmbedElement, Base>(exec, &JSHTMLEmbedElementTable, this, propertyName, slot);
}

JSValue* JSHTMLEmbedElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case AlignAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());
        return jsString(exec, imp->align());
    }
    case HeightAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());
        return jsString(exec, imp->height());
    }
    case NameAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());
        return jsString(exec, imp->name());
    }
    case SrcAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());
        return jsString(exec, imp->src());
    }
    case TypeAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());
        return jsString(exec, imp->type());
    }
    case WidthAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());
        return jsString(exec, imp->width());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLEmbedElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    if (customPut(exec, propertyName, value))
        return;
    lookupPut<JSHTMLEmbedElement, Base>(exec, propertyName, value, &JSHTMLEmbedElementTable, this);
}

void JSHTMLEmbedElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case AlignAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());
        imp->setAlign(valueToStringWithNullCheck(exec, value));
        break;
    }
    case HeightAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());
        imp->setHeight(valueToStringWithNullCheck(exec, value));
        break;
    }
    case NameAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());
        imp->setName(valueToStringWithNullCheck(exec, value));
        break;
    }
    case SrcAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());
        imp->setSrc(valueToStringWithNullCheck(exec, value));
        break;
    }
    case TypeAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());
        imp->setType(valueToStringWithNullCheck(exec, value));
        break;
    }
    case WidthAttrNum: {
        HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(impl());
        imp->setWidth(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLEmbedElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLEmbedElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLEmbedElementConstructor>(exec, constructorIdentifier);
}


}
