/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLDirectoryElement.h"

#include <wtf/GetPtr.h>

#include "HTMLDirectoryElement.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLDirectoryElementTableValues[3] =
{
    { "compact", (intptr_t)JSHTMLDirectoryElement::CompactAttrNum, DontDelete, 0 },
    { "constructor", (intptr_t)JSHTMLDirectoryElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLDirectoryElementTable = { 3, JSHTMLDirectoryElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLDirectoryElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLDirectoryElementConstructorTable = { 0, JSHTMLDirectoryElementConstructorTableValues, 0 };

class JSHTMLDirectoryElementConstructor : public DOMObject {
public:
    JSHTMLDirectoryElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLDirectoryElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLDirectoryElementConstructor::s_info = { "HTMLDirectoryElementConstructor", 0, &JSHTMLDirectoryElementConstructorTable, 0 };

bool JSHTMLDirectoryElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDirectoryElementConstructor, DOMObject>(exec, &JSHTMLDirectoryElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLDirectoryElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLDirectoryElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLDirectoryElementPrototypeTable = { 0, JSHTMLDirectoryElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLDirectoryElementPrototype::s_info = { "HTMLDirectoryElementPrototype", 0, &JSHTMLDirectoryElementPrototypeTable, 0 };

JSObject* JSHTMLDirectoryElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLDirectoryElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLDirectoryElementPrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSHTMLDirectoryElement::s_info = { "HTMLDirectoryElement", &JSHTMLElement::s_info, &JSHTMLDirectoryElementTable , 0 };

JSHTMLDirectoryElement::JSHTMLDirectoryElement(JSObject* prototype, HTMLDirectoryElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLDirectoryElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDirectoryElement, Base>(exec, &JSHTMLDirectoryElementTable, this, propertyName, slot);
}

JSValue* JSHTMLDirectoryElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CompactAttrNum: {
        HTMLDirectoryElement* imp = static_cast<HTMLDirectoryElement*>(impl());
        return jsBoolean(imp->compact());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLDirectoryElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLDirectoryElement, Base>(exec, propertyName, value, &JSHTMLDirectoryElementTable, this);
}

void JSHTMLDirectoryElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case CompactAttrNum: {
        HTMLDirectoryElement* imp = static_cast<HTMLDirectoryElement*>(impl());
        imp->setCompact(value->toBoolean(exec));
        break;
    }
    }
}

JSValue* JSHTMLDirectoryElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLDirectoryElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLDirectoryElementConstructor>(exec, constructorIdentifier);
}


}
