/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLDListElement.h"

#include <wtf/GetPtr.h>

#include "HTMLDListElement.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLDListElementTableValues[3] =
{
    { "compact", (intptr_t)JSHTMLDListElement::CompactAttrNum, DontDelete, 0 },
    { "constructor", (intptr_t)JSHTMLDListElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLDListElementTable = { 3, JSHTMLDListElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLDListElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLDListElementConstructorTable = { 0, JSHTMLDListElementConstructorTableValues, 0 };

class JSHTMLDListElementConstructor : public DOMObject {
public:
    JSHTMLDListElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLDListElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLDListElementConstructor::s_info = { "HTMLDListElementConstructor", 0, &JSHTMLDListElementConstructorTable, 0 };

bool JSHTMLDListElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDListElementConstructor, DOMObject>(exec, &JSHTMLDListElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLDListElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLDListElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLDListElementPrototypeTable = { 0, JSHTMLDListElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLDListElementPrototype::s_info = { "HTMLDListElementPrototype", 0, &JSHTMLDListElementPrototypeTable, 0 };

JSObject* JSHTMLDListElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLDListElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLDListElementPrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSHTMLDListElement::s_info = { "HTMLDListElement", &JSHTMLElement::s_info, &JSHTMLDListElementTable , 0 };

JSHTMLDListElement::JSHTMLDListElement(JSObject* prototype, HTMLDListElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLDListElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDListElement, Base>(exec, &JSHTMLDListElementTable, this, propertyName, slot);
}

JSValue* JSHTMLDListElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CompactAttrNum: {
        HTMLDListElement* imp = static_cast<HTMLDListElement*>(impl());
        return jsBoolean(imp->compact());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLDListElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLDListElement, Base>(exec, propertyName, value, &JSHTMLDListElementTable, this);
}

void JSHTMLDListElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case CompactAttrNum: {
        HTMLDListElement* imp = static_cast<HTMLDListElement*>(impl());
        imp->setCompact(value->toBoolean(exec));
        break;
    }
    }
}

JSValue* JSHTMLDListElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLDListElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLDListElementConstructor>(exec, constructorIdentifier);
}


}
