/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLCollection.h"

#include <wtf/GetPtr.h>

#include <kjs/PropertyNameArray.h>
#include "AtomicString.h"
#include "HTMLCollection.h"
#include "JSNode.h"
#include "JSNodeList.h"
#include "NameNodeList.h"
#include "Node.h"
#include "NodeList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLCollectionTableValues[3] =
{
    { "length", (intptr_t)JSHTMLCollection::LengthAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSHTMLCollection::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLCollectionTable = { 15, JSHTMLCollectionTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLCollectionConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLCollectionConstructorTable = { 0, JSHTMLCollectionConstructorTableValues, 0 };

class JSHTMLCollectionConstructor : public DOMObject {
public:
    JSHTMLCollectionConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLCollectionPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLCollectionConstructor::s_info = { "HTMLCollectionConstructor", 0, &JSHTMLCollectionConstructorTable, 0 };

bool JSHTMLCollectionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLCollectionConstructor, DOMObject>(exec, &JSHTMLCollectionConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLCollectionConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLCollectionPrototypeTableValues[4] =
{
    { "item", (intptr_t)jsHTMLCollectionPrototypeFunctionItem, DontDelete|Function, 1 },
    { "namedItem", (intptr_t)jsHTMLCollectionPrototypeFunctionNamedItem, DontDelete|Function, 1 },
    { "tags", (intptr_t)jsHTMLCollectionPrototypeFunctionTags, DontDelete|Function, 1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLCollectionPrototypeTable = { 7, JSHTMLCollectionPrototypeTableValues, 0 };

const ClassInfo JSHTMLCollectionPrototype::s_info = { "HTMLCollectionPrototype", 0, &JSHTMLCollectionPrototypeTable, 0 };

JSObject* JSHTMLCollectionPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLCollection.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLCollectionPrototype>(exec, prototypeIdentifier);
}

bool JSHTMLCollectionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLCollectionPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLCollection::s_info = { "HTMLCollection", 0, &JSHTMLCollectionTable , 0 };

JSHTMLCollection::JSHTMLCollection(JSObject* prototype, HTMLCollection* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSHTMLCollection::~JSHTMLCollection()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSHTMLCollection::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    JSValue* proto = prototype();
    if (proto->isObject() && static_cast<JSObject*>(proto)->hasProperty(exec, propertyName))
        return false;

    const HashEntry* entry = JSHTMLCollectionTable.entry(exec, propertyName);
    if (entry) {
        slot.setStaticEntry(this, entry, staticValueGetter<JSHTMLCollection>);
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<HTMLCollection*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<HTMLCollection*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    return getStaticValueSlot<JSHTMLCollection, Base>(exec, &JSHTMLCollectionTable, this, propertyName, slot);
}

bool JSHTMLCollection::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<HTMLCollection*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue* JSHTMLCollection::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case LengthAttrNum: {
        HTMLCollection* imp = static_cast<HTMLCollection*>(impl());
        return jsNumber(exec, imp->length());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLCollection::getPropertyNames(ExecState* exec, PropertyNameArray& propertyNames)
{
    for (unsigned i = 0; i < static_cast<HTMLCollection*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getPropertyNames(exec, propertyNames);
}

JSValue* JSHTMLCollection::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLCollection.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLCollectionConstructor>(exec, constructorIdentifier);
}

JSValue* jsHTMLCollectionPrototypeFunctionItem(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLCollection::s_info))
        return throwError(exec, TypeError);
    JSHTMLCollection* castedThisObj = static_cast<JSHTMLCollection*>(thisValue);
    return castedThisObj->item(exec, args);
}

JSValue* jsHTMLCollectionPrototypeFunctionNamedItem(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLCollection::s_info))
        return throwError(exec, TypeError);
    JSHTMLCollection* castedThisObj = static_cast<JSHTMLCollection*>(thisValue);
    return castedThisObj->namedItem(exec, args);
}

JSValue* jsHTMLCollectionPrototypeFunctionTags(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLCollection::s_info))
        return throwError(exec, TypeError);
    JSHTMLCollection* castedThisObj = static_cast<JSHTMLCollection*>(thisValue);
    HTMLCollection* imp = static_cast<HTMLCollection*>(castedThisObj->impl());
    const UString& name = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->tags(name)));
    return result;
}


JSValue* JSHTMLCollection::indexGetter(ExecState* exec, const Identifier& propertyName, const PropertySlot& slot)
{
    JSHTMLCollection* thisObj = static_cast<JSHTMLCollection*>(slot.slotBase());
    return toJS(exec, static_cast<HTMLCollection*>(thisObj->impl())->item(slot.index()));
}
HTMLCollection* toHTMLCollection(KJS::JSValue* val)
{
    return val->isObject(&JSHTMLCollection::s_info) ? static_cast<JSHTMLCollection*>(val)->impl() : 0;
}

}
