/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLCanvasElement.h"

#include <wtf/GetPtr.h>

#include "HTMLCanvasElement.h"
#include "JSCanvasRenderingContext2D.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLCanvasElementTableValues[4] =
{
    { "width", (intptr_t)JSHTMLCanvasElement::WidthAttrNum, DontDelete, 0 },
    { "height", (intptr_t)JSHTMLCanvasElement::HeightAttrNum, DontDelete, 0 },
    { "constructor", (intptr_t)JSHTMLCanvasElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLCanvasElementTable = { 31, JSHTMLCanvasElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLCanvasElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLCanvasElementConstructorTable = { 0, JSHTMLCanvasElementConstructorTableValues, 0 };

class JSHTMLCanvasElementConstructor : public DOMObject {
public:
    JSHTMLCanvasElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLCanvasElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLCanvasElementConstructor::s_info = { "HTMLCanvasElementConstructor", 0, &JSHTMLCanvasElementConstructorTable, 0 };

bool JSHTMLCanvasElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLCanvasElementConstructor, DOMObject>(exec, &JSHTMLCanvasElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLCanvasElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLCanvasElementPrototypeTableValues[3] =
{
    { "toDataURL", (intptr_t)jsHTMLCanvasElementPrototypeFunctionToDataURL, DontDelete|Function, 1 },
    { "getContext", (intptr_t)jsHTMLCanvasElementPrototypeFunctionGetContext, DontDelete|Function, 1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLCanvasElementPrototypeTable = { 3, JSHTMLCanvasElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLCanvasElementPrototype::s_info = { "HTMLCanvasElementPrototype", 0, &JSHTMLCanvasElementPrototypeTable, 0 };

JSObject* JSHTMLCanvasElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLCanvasElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLCanvasElementPrototype>(exec, prototypeIdentifier);
}

bool JSHTMLCanvasElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLCanvasElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLCanvasElement::s_info = { "HTMLCanvasElement", &JSHTMLElement::s_info, &JSHTMLCanvasElementTable , 0 };

JSHTMLCanvasElement::JSHTMLCanvasElement(JSObject* prototype, HTMLCanvasElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLCanvasElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLCanvasElement, Base>(exec, &JSHTMLCanvasElementTable, this, propertyName, slot);
}

JSValue* JSHTMLCanvasElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case WidthAttrNum: {
        HTMLCanvasElement* imp = static_cast<HTMLCanvasElement*>(impl());
        return jsNumber(exec, imp->width());
    }
    case HeightAttrNum: {
        HTMLCanvasElement* imp = static_cast<HTMLCanvasElement*>(impl());
        return jsNumber(exec, imp->height());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLCanvasElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLCanvasElement, Base>(exec, propertyName, value, &JSHTMLCanvasElementTable, this);
}

void JSHTMLCanvasElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case WidthAttrNum: {
        HTMLCanvasElement* imp = static_cast<HTMLCanvasElement*>(impl());
        imp->setWidth(value->toInt32(exec));
        break;
    }
    case HeightAttrNum: {
        HTMLCanvasElement* imp = static_cast<HTMLCanvasElement*>(impl());
        imp->setHeight(value->toInt32(exec));
        break;
    }
    }
}

JSValue* JSHTMLCanvasElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLCanvasElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLCanvasElementConstructor>(exec, constructorIdentifier);
}

JSValue* jsHTMLCanvasElementPrototypeFunctionToDataURL(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLCanvasElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLCanvasElement* castedThisObj = static_cast<JSHTMLCanvasElement*>(thisValue);
    HTMLCanvasElement* imp = static_cast<HTMLCanvasElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& type = valueToStringWithUndefinedOrNullCheck(exec, args[0]);


    KJS::JSValue* result = jsString(exec, imp->toDataURL(type, ec));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsHTMLCanvasElementPrototypeFunctionGetContext(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLCanvasElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLCanvasElement* castedThisObj = static_cast<JSHTMLCanvasElement*>(thisValue);
    HTMLCanvasElement* imp = static_cast<HTMLCanvasElement*>(castedThisObj->impl());
    const UString& contextId = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getContext(contextId)));
    return result;
}


}
