/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLButtonElement.h"

#include <wtf/GetPtr.h>

#include "HTMLButtonElement.h"
#include "HTMLFormElement.h"
#include "JSHTMLFormElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLButtonElementTableValues[9] =
{
    { "form", (intptr_t)JSHTMLButtonElement::FormAttrNum, DontDelete|ReadOnly, 0 },
    { "accessKey", (intptr_t)JSHTMLButtonElement::AccessKeyAttrNum, DontDelete, 0 },
    { "disabled", (intptr_t)JSHTMLButtonElement::DisabledAttrNum, DontDelete, 0 },
    { "autofocus", (intptr_t)JSHTMLButtonElement::AutofocusAttrNum, DontDelete, 0 },
    { "name", (intptr_t)JSHTMLButtonElement::NameAttrNum, DontDelete, 0 },
    { "type", (intptr_t)JSHTMLButtonElement::TypeAttrNum, DontDelete|ReadOnly, 0 },
    { "value", (intptr_t)JSHTMLButtonElement::ValueAttrNum, DontDelete, 0 },
    { "constructor", (intptr_t)JSHTMLButtonElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLButtonElementTable = { 127, JSHTMLButtonElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLButtonElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLButtonElementConstructorTable = { 0, JSHTMLButtonElementConstructorTableValues, 0 };

class JSHTMLButtonElementConstructor : public DOMObject {
public:
    JSHTMLButtonElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLButtonElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLButtonElementConstructor::s_info = { "HTMLButtonElementConstructor", 0, &JSHTMLButtonElementConstructorTable, 0 };

bool JSHTMLButtonElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLButtonElementConstructor, DOMObject>(exec, &JSHTMLButtonElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLButtonElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLButtonElementPrototypeTableValues[2] =
{
    { "click", (intptr_t)jsHTMLButtonElementPrototypeFunctionClick, DontDelete|Function, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLButtonElementPrototypeTable = { 0, JSHTMLButtonElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLButtonElementPrototype::s_info = { "HTMLButtonElementPrototype", 0, &JSHTMLButtonElementPrototypeTable, 0 };

JSObject* JSHTMLButtonElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLButtonElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLButtonElementPrototype>(exec, prototypeIdentifier);
}

bool JSHTMLButtonElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLButtonElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLButtonElement::s_info = { "HTMLButtonElement", &JSHTMLElement::s_info, &JSHTMLButtonElementTable , 0 };

JSHTMLButtonElement::JSHTMLButtonElement(JSObject* prototype, HTMLButtonElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLButtonElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLButtonElement, Base>(exec, &JSHTMLButtonElementTable, this, propertyName, slot);
}

JSValue* JSHTMLButtonElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case FormAttrNum: {
        HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(impl());
        return toJS(exec, WTF::getPtr(imp->form()));
    }
    case AccessKeyAttrNum: {
        HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(impl());
        return jsString(exec, imp->accessKey());
    }
    case DisabledAttrNum: {
        HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(impl());
        return jsBoolean(imp->disabled());
    }
    case AutofocusAttrNum: {
        HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(impl());
        return jsBoolean(imp->autofocus());
    }
    case NameAttrNum: {
        HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(impl());
        return jsString(exec, imp->name());
    }
    case TypeAttrNum: {
        HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(impl());
        return jsString(exec, imp->type());
    }
    case ValueAttrNum: {
        HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(impl());
        return jsString(exec, imp->value());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLButtonElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLButtonElement, Base>(exec, propertyName, value, &JSHTMLButtonElementTable, this);
}

void JSHTMLButtonElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case AccessKeyAttrNum: {
        HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(impl());
        imp->setAccessKey(valueToStringWithNullCheck(exec, value));
        break;
    }
    case DisabledAttrNum: {
        HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(impl());
        imp->setDisabled(value->toBoolean(exec));
        break;
    }
    case AutofocusAttrNum: {
        HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(impl());
        imp->setAutofocus(value->toBoolean(exec));
        break;
    }
    case NameAttrNum: {
        HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(impl());
        imp->setName(valueToStringWithNullCheck(exec, value));
        break;
    }
    case ValueAttrNum: {
        HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(impl());
        imp->setValue(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLButtonElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLButtonElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLButtonElementConstructor>(exec, constructorIdentifier);
}

JSValue* jsHTMLButtonElementPrototypeFunctionClick(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLButtonElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLButtonElement* castedThisObj = static_cast<JSHTMLButtonElement*>(thisValue);
    HTMLButtonElement* imp = static_cast<HTMLButtonElement*>(castedThisObj->impl());

    imp->click();
    return jsUndefined();
}


}
