/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLBodyElement.h"

#include <wtf/GetPtr.h>

#include "HTMLBodyElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLBodyElementTableValues[12] =
{
    { "aLink", (intptr_t)JSHTMLBodyElement::ALinkAttrNum, DontDelete, 0 },
    { "background", (intptr_t)JSHTMLBodyElement::BackgroundAttrNum, DontDelete, 0 },
    { "bgColor", (intptr_t)JSHTMLBodyElement::BgColorAttrNum, DontDelete, 0 },
    { "link", (intptr_t)JSHTMLBodyElement::LinkAttrNum, DontDelete, 0 },
    { "text", (intptr_t)JSHTMLBodyElement::TextAttrNum, DontDelete, 0 },
    { "vLink", (intptr_t)JSHTMLBodyElement::VLinkAttrNum, DontDelete, 0 },
    { "scrollLeft", (intptr_t)JSHTMLBodyElement::ScrollLeftAttrNum, DontDelete, 0 },
    { "scrollTop", (intptr_t)JSHTMLBodyElement::ScrollTopAttrNum, DontDelete, 0 },
    { "scrollWidth", (intptr_t)JSHTMLBodyElement::ScrollWidthAttrNum, DontDelete|ReadOnly, 0 },
    { "scrollHeight", (intptr_t)JSHTMLBodyElement::ScrollHeightAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSHTMLBodyElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLBodyElementTable = { 63, JSHTMLBodyElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLBodyElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLBodyElementConstructorTable = { 0, JSHTMLBodyElementConstructorTableValues, 0 };

class JSHTMLBodyElementConstructor : public DOMObject {
public:
    JSHTMLBodyElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLBodyElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLBodyElementConstructor::s_info = { "HTMLBodyElementConstructor", 0, &JSHTMLBodyElementConstructorTable, 0 };

bool JSHTMLBodyElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBodyElementConstructor, DOMObject>(exec, &JSHTMLBodyElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLBodyElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLBodyElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLBodyElementPrototypeTable = { 0, JSHTMLBodyElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLBodyElementPrototype::s_info = { "HTMLBodyElementPrototype", 0, &JSHTMLBodyElementPrototypeTable, 0 };

JSObject* JSHTMLBodyElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLBodyElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLBodyElementPrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSHTMLBodyElement::s_info = { "HTMLBodyElement", &JSHTMLElement::s_info, &JSHTMLBodyElementTable , 0 };

JSHTMLBodyElement::JSHTMLBodyElement(JSObject* prototype, HTMLBodyElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLBodyElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBodyElement, Base>(exec, &JSHTMLBodyElementTable, this, propertyName, slot);
}

JSValue* JSHTMLBodyElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ALinkAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        return jsString(exec, imp->aLink());
    }
    case BackgroundAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        return jsString(exec, imp->background());
    }
    case BgColorAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        return jsString(exec, imp->bgColor());
    }
    case LinkAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        return jsString(exec, imp->link());
    }
    case TextAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        return jsString(exec, imp->text());
    }
    case VLinkAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        return jsString(exec, imp->vLink());
    }
    case ScrollLeftAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        return jsNumber(exec, imp->scrollLeft());
    }
    case ScrollTopAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        return jsNumber(exec, imp->scrollTop());
    }
    case ScrollWidthAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        return jsNumber(exec, imp->scrollWidth());
    }
    case ScrollHeightAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        return jsNumber(exec, imp->scrollHeight());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLBodyElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLBodyElement, Base>(exec, propertyName, value, &JSHTMLBodyElementTable, this);
}

void JSHTMLBodyElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case ALinkAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        imp->setALink(valueToStringWithNullCheck(exec, value));
        break;
    }
    case BackgroundAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        imp->setBackground(valueToStringWithNullCheck(exec, value));
        break;
    }
    case BgColorAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        imp->setBgColor(valueToStringWithNullCheck(exec, value));
        break;
    }
    case LinkAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        imp->setLink(valueToStringWithNullCheck(exec, value));
        break;
    }
    case TextAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        imp->setText(valueToStringWithNullCheck(exec, value));
        break;
    }
    case VLinkAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        imp->setVLink(valueToStringWithNullCheck(exec, value));
        break;
    }
    case ScrollLeftAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        imp->setScrollLeft(value->toInt32(exec));
        break;
    }
    case ScrollTopAttrNum: {
        HTMLBodyElement* imp = static_cast<HTMLBodyElement*>(impl());
        imp->setScrollTop(value->toInt32(exec));
        break;
    }
    }
}

JSValue* JSHTMLBodyElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLBodyElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLBodyElementConstructor>(exec, constructorIdentifier);
}


}
