/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLBaseElement.h"

#include <wtf/GetPtr.h>

#include "HTMLBaseElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLBaseElementTableValues[4] =
{
    { "href", (intptr_t)JSHTMLBaseElement::HrefAttrNum, DontDelete, 0 },
    { "target", (intptr_t)JSHTMLBaseElement::TargetAttrNum, DontDelete, 0 },
    { "constructor", (intptr_t)JSHTMLBaseElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLBaseElementTable = { 3, JSHTMLBaseElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLBaseElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLBaseElementConstructorTable = { 0, JSHTMLBaseElementConstructorTableValues, 0 };

class JSHTMLBaseElementConstructor : public DOMObject {
public:
    JSHTMLBaseElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLBaseElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLBaseElementConstructor::s_info = { "HTMLBaseElementConstructor", 0, &JSHTMLBaseElementConstructorTable, 0 };

bool JSHTMLBaseElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBaseElementConstructor, DOMObject>(exec, &JSHTMLBaseElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLBaseElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLBaseElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLBaseElementPrototypeTable = { 0, JSHTMLBaseElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLBaseElementPrototype::s_info = { "HTMLBaseElementPrototype", 0, &JSHTMLBaseElementPrototypeTable, 0 };

JSObject* JSHTMLBaseElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLBaseElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLBaseElementPrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSHTMLBaseElement::s_info = { "HTMLBaseElement", &JSHTMLElement::s_info, &JSHTMLBaseElementTable , 0 };

JSHTMLBaseElement::JSHTMLBaseElement(JSObject* prototype, HTMLBaseElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLBaseElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLBaseElement, Base>(exec, &JSHTMLBaseElementTable, this, propertyName, slot);
}

JSValue* JSHTMLBaseElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case HrefAttrNum: {
        HTMLBaseElement* imp = static_cast<HTMLBaseElement*>(impl());
        return jsString(exec, imp->href());
    }
    case TargetAttrNum: {
        HTMLBaseElement* imp = static_cast<HTMLBaseElement*>(impl());
        return jsString(exec, imp->target());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLBaseElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLBaseElement, Base>(exec, propertyName, value, &JSHTMLBaseElementTable, this);
}

void JSHTMLBaseElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case HrefAttrNum: {
        HTMLBaseElement* imp = static_cast<HTMLBaseElement*>(impl());
        imp->setHref(valueToStringWithNullCheck(exec, value));
        break;
    }
    case TargetAttrNum: {
        HTMLBaseElement* imp = static_cast<HTMLBaseElement*>(impl());
        imp->setTarget(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLBaseElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLBaseElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLBaseElementConstructor>(exec, constructorIdentifier);
}


}
