/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009
*/

#include "config.h"


#if ENABLE(VIDEO)

#include "JSHTMLAudioElement.h"

#include <wtf/GetPtr.h>

#include "HTMLAudioElement.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLAudioElementTableValues[2] =
{
    { "constructor", (intptr_t)JSHTMLAudioElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLAudioElementTable = { 0, JSHTMLAudioElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLAudioElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLAudioElementConstructorTable = { 0, JSHTMLAudioElementConstructorTableValues, 0 };

class JSHTMLAudioElementConstructor : public DOMObject {
public:
    JSHTMLAudioElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLAudioElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLAudioElementConstructor::s_info = { "HTMLAudioElementConstructor", 0, &JSHTMLAudioElementConstructorTable, 0 };

bool JSHTMLAudioElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLAudioElementConstructor, DOMObject>(exec, &JSHTMLAudioElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLAudioElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLAudioElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLAudioElementPrototypeTable = { 0, JSHTMLAudioElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLAudioElementPrototype::s_info = { "HTMLAudioElementPrototype", 0, &JSHTMLAudioElementPrototypeTable, 0 };

JSObject* JSHTMLAudioElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLAudioElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLAudioElementPrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSHTMLAudioElement::s_info = { "HTMLAudioElement", &JSHTMLMediaElement::s_info, &JSHTMLAudioElementTable , 0 };

JSHTMLAudioElement::JSHTMLAudioElement(JSObject* prototype, HTMLAudioElement* impl)
    : JSHTMLMediaElement(prototype, impl)
{
}

bool JSHTMLAudioElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLAudioElement, Base>(exec, &JSHTMLAudioElementTable, this, propertyName, slot);
}

JSValue* JSHTMLAudioElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSHTMLAudioElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLAudioElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLAudioElementConstructor>(exec, constructorIdentifier);
}


}

#endif // ENABLE(VIDEO)
