/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLAppletElement.h"

#include <wtf/GetPtr.h>

#include "AtomicString.h"
#include "HTMLAppletElement.h"
#include "JSHTMLAppletElementCustom.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLAppletElementTableValues[13] =
{
    { "align", (intptr_t)JSHTMLAppletElement::AlignAttrNum, DontDelete, 0 },
    { "alt", (intptr_t)JSHTMLAppletElement::AltAttrNum, DontDelete, 0 },
    { "archive", (intptr_t)JSHTMLAppletElement::ArchiveAttrNum, DontDelete, 0 },
    { "code", (intptr_t)JSHTMLAppletElement::CodeAttrNum, DontDelete, 0 },
    { "codeBase", (intptr_t)JSHTMLAppletElement::CodeBaseAttrNum, DontDelete, 0 },
    { "height", (intptr_t)JSHTMLAppletElement::HeightAttrNum, DontDelete, 0 },
    { "hspace", (intptr_t)JSHTMLAppletElement::HspaceAttrNum, DontDelete, 0 },
    { "name", (intptr_t)JSHTMLAppletElement::NameAttrNum, DontDelete, 0 },
    { "object", (intptr_t)JSHTMLAppletElement::ObjectAttrNum, DontDelete, 0 },
    { "vspace", (intptr_t)JSHTMLAppletElement::VspaceAttrNum, DontDelete, 0 },
    { "width", (intptr_t)JSHTMLAppletElement::WidthAttrNum, DontDelete, 0 },
    { "constructor", (intptr_t)JSHTMLAppletElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLAppletElementTable = { 127, JSHTMLAppletElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLAppletElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLAppletElementConstructorTable = { 0, JSHTMLAppletElementConstructorTableValues, 0 };

class JSHTMLAppletElementConstructor : public DOMObject {
public:
    JSHTMLAppletElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLAppletElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLAppletElementConstructor::s_info = { "HTMLAppletElementConstructor", 0, &JSHTMLAppletElementConstructorTable, 0 };

bool JSHTMLAppletElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLAppletElementConstructor, DOMObject>(exec, &JSHTMLAppletElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLAppletElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLAppletElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLAppletElementPrototypeTable = { 0, JSHTMLAppletElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLAppletElementPrototype::s_info = { "HTMLAppletElementPrototype", 0, &JSHTMLAppletElementPrototypeTable, 0 };

JSObject* JSHTMLAppletElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLAppletElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLAppletElementPrototype>(exec, prototypeIdentifier);
}

const ClassInfo JSHTMLAppletElement::s_info = { "HTMLAppletElement", &JSHTMLElement::s_info, &JSHTMLAppletElementTable , 0 };

JSHTMLAppletElement::JSHTMLAppletElement(JSObject* prototype, HTMLAppletElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLAppletElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    if (canGetItemsForName(exec, static_cast<HTMLAppletElement*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    if (customGetOwnPropertySlot(exec, propertyName, slot))
        return true;
    return getStaticValueSlot<JSHTMLAppletElement, Base>(exec, &JSHTMLAppletElementTable, this, propertyName, slot);
}

JSValue* JSHTMLAppletElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case AlignAttrNum: {
        HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(impl());
        return jsString(exec, imp->align());
    }
    case AltAttrNum: {
        HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(impl());
        return jsString(exec, imp->alt());
    }
    case ArchiveAttrNum: {
        HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(impl());
        return jsString(exec, imp->archive());
    }
    case CodeAttrNum: {
        HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(impl());
        return jsString(exec, imp->code());
    }
    case CodeBaseAttrNum: {
        HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(impl());
        return jsString(exec, imp->codeBase());
    }
    case HeightAttrNum: {
        HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(impl());
        return jsString(exec, imp->height());
    }
    case HspaceAttrNum: {
        HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(impl());
        return jsString(exec, imp->hspace());
    }
    case NameAttrNum: {
        HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(impl());
        return jsString(exec, imp->name());
    }
    case ObjectAttrNum: {
        HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(impl());
        return jsString(exec, imp->object());
    }
    case VspaceAttrNum: {
        HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(impl());
        return jsString(exec, imp->vspace());
    }
    case WidthAttrNum: {
        HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(impl());
        return jsString(exec, imp->width());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLAppletElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    if (customPut(exec, propertyName, value))
        return;
    lookupPut<JSHTMLAppletElement, Base>(exec, propertyName, value, &JSHTMLAppletElementTable, this);
}

void JSHTMLAppletElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case AlignAttrNum: {
        HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(impl());
        imp->setAlign(valueToStringWithNullCheck(exec, value));
        break;
    }
    case AltAttrNum: {
        HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(impl());
        imp->setAlt(valueToStringWithNullCheck(exec, value));
        break;
    }
    case ArchiveAttrNum: {
        HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(impl());
        imp->setArchive(valueToStringWithNullCheck(exec, value));
        break;
    }
    case CodeAttrNum: {
        HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(impl());
        imp->setCode(valueToStringWithNullCheck(exec, value));
        break;
    }
    case CodeBaseAttrNum: {
        HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(impl());
        imp->setCodeBase(valueToStringWithNullCheck(exec, value));
        break;
    }
    case HeightAttrNum: {
        HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(impl());
        imp->setHeight(valueToStringWithNullCheck(exec, value));
        break;
    }
    case HspaceAttrNum: {
        HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(impl());
        imp->setHspace(valueToStringWithNullCheck(exec, value));
        break;
    }
    case NameAttrNum: {
        HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(impl());
        imp->setName(valueToStringWithNullCheck(exec, value));
        break;
    }
    case ObjectAttrNum: {
        HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(impl());
        imp->setObject(valueToStringWithNullCheck(exec, value));
        break;
    }
    case VspaceAttrNum: {
        HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(impl());
        imp->setVspace(valueToStringWithNullCheck(exec, value));
        break;
    }
    case WidthAttrNum: {
        HTMLAppletElement* imp = static_cast<HTMLAppletElement*>(impl());
        imp->setWidth(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLAppletElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLAppletElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLAppletElementConstructor>(exec, constructorIdentifier);
}


}
