/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSHTMLAnchorElement.h"

#include <wtf/GetPtr.h>

#include "HTMLAnchorElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLAnchorElementTableValues[21] =
{
    { "accessKey", (intptr_t)JSHTMLAnchorElement::AccessKeyAttrNum, DontDelete, 0 },
    { "charset", (intptr_t)JSHTMLAnchorElement::CharsetAttrNum, DontDelete, 0 },
    { "coords", (intptr_t)JSHTMLAnchorElement::CoordsAttrNum, DontDelete, 0 },
    { "href", (intptr_t)JSHTMLAnchorElement::HrefAttrNum, DontDelete, 0 },
    { "hreflang", (intptr_t)JSHTMLAnchorElement::HreflangAttrNum, DontDelete, 0 },
    { "name", (intptr_t)JSHTMLAnchorElement::NameAttrNum, DontDelete, 0 },
    { "rel", (intptr_t)JSHTMLAnchorElement::RelAttrNum, DontDelete, 0 },
    { "rev", (intptr_t)JSHTMLAnchorElement::RevAttrNum, DontDelete, 0 },
    { "shape", (intptr_t)JSHTMLAnchorElement::ShapeAttrNum, DontDelete, 0 },
    { "target", (intptr_t)JSHTMLAnchorElement::TargetAttrNum, DontDelete, 0 },
    { "type", (intptr_t)JSHTMLAnchorElement::TypeAttrNum, DontDelete, 0 },
    { "hash", (intptr_t)JSHTMLAnchorElement::HashAttrNum, DontDelete|ReadOnly, 0 },
    { "host", (intptr_t)JSHTMLAnchorElement::HostAttrNum, DontDelete|ReadOnly, 0 },
    { "hostname", (intptr_t)JSHTMLAnchorElement::HostnameAttrNum, DontDelete|ReadOnly, 0 },
    { "pathname", (intptr_t)JSHTMLAnchorElement::PathnameAttrNum, DontDelete|ReadOnly, 0 },
    { "port", (intptr_t)JSHTMLAnchorElement::PortAttrNum, DontDelete|ReadOnly, 0 },
    { "protocol", (intptr_t)JSHTMLAnchorElement::ProtocolAttrNum, DontDelete|ReadOnly, 0 },
    { "search", (intptr_t)JSHTMLAnchorElement::SearchAttrNum, DontDelete|ReadOnly, 0 },
    { "text", (intptr_t)JSHTMLAnchorElement::TextAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSHTMLAnchorElement::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLAnchorElementTable = { 511, JSHTMLAnchorElementTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSHTMLAnchorElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLAnchorElementConstructorTable = { 0, JSHTMLAnchorElementConstructorTableValues, 0 };

class JSHTMLAnchorElementConstructor : public DOMObject {
public:
    JSHTMLAnchorElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLAnchorElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLAnchorElementConstructor::s_info = { "HTMLAnchorElementConstructor", 0, &JSHTMLAnchorElementConstructorTable, 0 };

bool JSHTMLAnchorElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLAnchorElementConstructor, DOMObject>(exec, &JSHTMLAnchorElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLAnchorElementConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLAnchorElementPrototypeTableValues[2] =
{
    { "toString", (intptr_t)jsHTMLAnchorElementPrototypeFunctionToString, DontDelete|DontEnum|Function, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLAnchorElementPrototypeTable = { 0, JSHTMLAnchorElementPrototypeTableValues, 0 };

const ClassInfo JSHTMLAnchorElementPrototype::s_info = { "HTMLAnchorElementPrototype", 0, &JSHTMLAnchorElementPrototypeTable, 0 };

JSObject* JSHTMLAnchorElementPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSHTMLAnchorElement.prototype]]");
    return KJS::cacheGlobalObject<JSHTMLAnchorElementPrototype>(exec, prototypeIdentifier);
}

bool JSHTMLAnchorElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLAnchorElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLAnchorElement::s_info = { "HTMLAnchorElement", &JSHTMLElement::s_info, &JSHTMLAnchorElementTable , 0 };

JSHTMLAnchorElement::JSHTMLAnchorElement(JSObject* prototype, HTMLAnchorElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLAnchorElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLAnchorElement, Base>(exec, &JSHTMLAnchorElementTable, this, propertyName, slot);
}

JSValue* JSHTMLAnchorElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case AccessKeyAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        return jsString(exec, imp->accessKey());
    }
    case CharsetAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        return jsString(exec, imp->charset());
    }
    case CoordsAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        return jsString(exec, imp->coords());
    }
    case HrefAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        return jsString(exec, imp->href());
    }
    case HreflangAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        return jsString(exec, imp->hreflang());
    }
    case NameAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        return jsString(exec, imp->name());
    }
    case RelAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        return jsString(exec, imp->rel());
    }
    case RevAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        return jsString(exec, imp->rev());
    }
    case ShapeAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        return jsString(exec, imp->shape());
    }
    case TargetAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        return jsString(exec, imp->target());
    }
    case TypeAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        return jsString(exec, imp->type());
    }
    case HashAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        return jsString(exec, imp->hash());
    }
    case HostAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        return jsString(exec, imp->host());
    }
    case HostnameAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        return jsString(exec, imp->hostname());
    }
    case PathnameAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        return jsString(exec, imp->pathname());
    }
    case PortAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        return jsString(exec, imp->port());
    }
    case ProtocolAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        return jsString(exec, imp->protocol());
    }
    case SearchAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        return jsString(exec, imp->search());
    }
    case TextAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        return jsString(exec, imp->text());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLAnchorElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLAnchorElement, Base>(exec, propertyName, value, &JSHTMLAnchorElementTable, this);
}

void JSHTMLAnchorElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case AccessKeyAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        imp->setAccessKey(valueToStringWithNullCheck(exec, value));
        break;
    }
    case CharsetAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        imp->setCharset(valueToStringWithNullCheck(exec, value));
        break;
    }
    case CoordsAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        imp->setCoords(valueToStringWithNullCheck(exec, value));
        break;
    }
    case HrefAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        imp->setHref(valueToStringWithNullCheck(exec, value));
        break;
    }
    case HreflangAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        imp->setHreflang(valueToStringWithNullCheck(exec, value));
        break;
    }
    case NameAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        imp->setName(valueToStringWithNullCheck(exec, value));
        break;
    }
    case RelAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        imp->setRel(valueToStringWithNullCheck(exec, value));
        break;
    }
    case RevAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        imp->setRev(valueToStringWithNullCheck(exec, value));
        break;
    }
    case ShapeAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        imp->setShape(valueToStringWithNullCheck(exec, value));
        break;
    }
    case TargetAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        imp->setTarget(valueToStringWithNullCheck(exec, value));
        break;
    }
    case TypeAttrNum: {
        HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(impl());
        imp->setType(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLAnchorElement::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[HTMLAnchorElement.constructor]]");
    return KJS::cacheGlobalObject<JSHTMLAnchorElementConstructor>(exec, constructorIdentifier);
}

JSValue* jsHTMLAnchorElementPrototypeFunctionToString(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLAnchorElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLAnchorElement* castedThisObj = static_cast<JSHTMLAnchorElement*>(thisValue);
    HTMLAnchorElement* imp = static_cast<HTMLAnchorElement*>(castedThisObj->impl());


    KJS::JSValue* result = jsString(exec, imp->toString());
    return result;
}


}
