/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSEventException.h"

#include <wtf/GetPtr.h>

#include "EventException.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSEventExceptionTableValues[5] =
{
    { "code", (intptr_t)JSEventException::CodeAttrNum, DontDelete|ReadOnly, 0 },
    { "name", (intptr_t)JSEventException::NameAttrNum, DontDelete|ReadOnly, 0 },
    { "message", (intptr_t)JSEventException::MessageAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSEventException::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSEventExceptionTable = { 127, JSEventExceptionTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSEventExceptionConstructorTableValues[2] =
{
    { "UNSPECIFIED_EVENT_TYPE_ERR", (intptr_t)0, DontDelete|ReadOnly, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSEventExceptionConstructorTable = { 0, JSEventExceptionConstructorTableValues, 0 };

class JSEventExceptionConstructor : public DOMObject {
public:
    JSEventExceptionConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSEventExceptionPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSEventExceptionConstructor::s_info = { "EventExceptionConstructor", 0, &JSEventExceptionConstructorTable, 0 };

bool JSEventExceptionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEventExceptionConstructor, DOMObject>(exec, &JSEventExceptionConstructorTable, this, propertyName, slot);
}

JSValue* JSEventExceptionConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSEventExceptionPrototypeTableValues[3] =
{
    { "UNSPECIFIED_EVENT_TYPE_ERR", (intptr_t)0, DontDelete|ReadOnly, 0 },
    { "toString", (intptr_t)jsEventExceptionPrototypeFunctionToString, DontDelete|DontEnum|Function, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSEventExceptionPrototypeTable = { 7, JSEventExceptionPrototypeTableValues, 0 };

const ClassInfo JSEventExceptionPrototype::s_info = { "EventExceptionPrototype", 0, &JSEventExceptionPrototypeTable, 0 };

JSObject* JSEventExceptionPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSEventException.prototype]]");
    return KJS::cacheGlobalObject<JSEventExceptionPrototype>(exec, prototypeIdentifier);
}

bool JSEventExceptionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSEventExceptionPrototype, JSObject>(exec, &JSEventExceptionPrototypeTable, this, propertyName, slot);
}

JSValue* JSEventExceptionPrototype::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

const ClassInfo JSEventException::s_info = { "EventException", 0, &JSEventExceptionTable , 0 };

JSEventException::JSEventException(JSObject* prototype, EventException* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSEventException::~JSEventException()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSEventException::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEventException, Base>(exec, &JSEventExceptionTable, this, propertyName, slot);
}

JSValue* JSEventException::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CodeAttrNum: {
        EventException* imp = static_cast<EventException*>(impl());
        return jsNumber(exec, imp->code());
    }
    case NameAttrNum: {
        EventException* imp = static_cast<EventException*>(impl());
        return jsString(exec, imp->name());
    }
    case MessageAttrNum: {
        EventException* imp = static_cast<EventException*>(impl());
        return jsString(exec, imp->message());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSEventException::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[EventException.constructor]]");
    return KJS::cacheGlobalObject<JSEventExceptionConstructor>(exec, constructorIdentifier);
}

JSValue* jsEventExceptionPrototypeFunctionToString(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSEventException::s_info))
        return throwError(exec, TypeError);
    JSEventException* castedThisObj = static_cast<JSEventException*>(thisValue);
    EventException* imp = static_cast<EventException*>(castedThisObj->impl());


    KJS::JSValue* result = jsString(exec, imp->toString());
    return result;
}

KJS::JSValue* toJS(KJS::ExecState* exec, EventException* obj)
{
    return cacheDOMObject<EventException, JSEventException, JSEventExceptionPrototype>(exec, obj);
}
EventException* toEventException(KJS::JSValue* val)
{
    return val->isObject(&JSEventException::s_info) ? static_cast<JSEventException*>(val)->impl() : 0;
}

}
