/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
* This file was modified by Electronic Arts Inc Copyright  2009-2010
*/

#include "config.h"

#include "JSEvent.h"

#include <wtf/GetPtr.h>

#include "Event.h"
#include "EventTargetNode.h"
#include "JSEventTargetNode.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashTableValue JSEventTableValues[13] =
{
    { "type", (intptr_t)JSEvent::TypeAttrNum, DontDelete|ReadOnly, 0 },
    { "target", (intptr_t)JSEvent::TargetAttrNum, DontDelete|ReadOnly, 0 },
    { "currentTarget", (intptr_t)JSEvent::CurrentTargetAttrNum, DontDelete|ReadOnly, 0 },
    { "eventPhase", (intptr_t)JSEvent::EventPhaseAttrNum, DontDelete|ReadOnly, 0 },
    { "bubbles", (intptr_t)JSEvent::BubblesAttrNum, DontDelete|ReadOnly, 0 },
    { "cancelable", (intptr_t)JSEvent::CancelableAttrNum, DontDelete|ReadOnly, 0 },
    { "timeStamp", (intptr_t)JSEvent::TimeStampAttrNum, DontDelete|ReadOnly, 0 },
    { "srcElement", (intptr_t)JSEvent::SrcElementAttrNum, DontDelete|ReadOnly, 0 },
    { "returnValue", (intptr_t)JSEvent::ReturnValueAttrNum, DontDelete, 0 },
    { "cancelBubble", (intptr_t)JSEvent::CancelBubbleAttrNum, DontDelete, 0 },
    { "clipboardData", (intptr_t)JSEvent::ClipboardDataAttrNum, DontDelete|ReadOnly, 0 },
    { "constructor", (intptr_t)JSEvent::ConstructorAttrNum, DontEnum, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSEventTable = { 127, JSEventTableValues, 0 };

/* Hash table for constructor */

static const HashTableValue JSEventConstructorTableValues[20] =
{
    { "CAPTURING_PHASE", (intptr_t)1, DontDelete|ReadOnly, 0 },
    { "AT_TARGET", (intptr_t)2, DontDelete|ReadOnly, 0 },
    { "BUBBLING_PHASE", (intptr_t)3, DontDelete|ReadOnly, 0 },
    { "MOUSEDOWN", (intptr_t)1, DontDelete|ReadOnly, 0 },
    { "MOUSEUP", (intptr_t)2, DontDelete|ReadOnly, 0 },
    { "MOUSEOVER", (intptr_t)4, DontDelete|ReadOnly, 0 },
    { "MOUSEOUT", (intptr_t)8, DontDelete|ReadOnly, 0 },
    { "MOUSEMOVE", (intptr_t)16, DontDelete|ReadOnly, 0 },
    { "MOUSEDRAG", (intptr_t)32, DontDelete|ReadOnly, 0 },
    { "CLICK", (intptr_t)64, DontDelete|ReadOnly, 0 },
    { "DBLCLICK", (intptr_t)128, DontDelete|ReadOnly, 0 },
    { "KEYDOWN", (intptr_t)256, DontDelete|ReadOnly, 0 },
    { "KEYUP", (intptr_t)512, DontDelete|ReadOnly, 0 },
    { "KEYPRESS", (intptr_t)1024, DontDelete|ReadOnly, 0 },
    { "DRAGDROP", (intptr_t)2048, DontDelete|ReadOnly, 0 },
    { "FOCUS", (intptr_t)4096, DontDelete|ReadOnly, 0 },
    { "BLUR", (intptr_t)8192, DontDelete|ReadOnly, 0 },
    { "SELECT", (intptr_t)16384, DontDelete|ReadOnly, 0 },
    { "CHANGE", (intptr_t)32768, DontDelete|ReadOnly, 0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSEventConstructorTable = { 8191, JSEventConstructorTableValues, 0 };

class JSEventConstructor : public DOMObject {
public:
    JSEventConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSEventPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSEventConstructor::s_info = { "EventConstructor", 0, &JSEventConstructorTable, 0 };

bool JSEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEventConstructor, DOMObject>(exec, &JSEventConstructorTable, this, propertyName, slot);
}

JSValue* JSEventConstructor::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

/* Hash table for prototype */

static const HashTableValue JSEventPrototypeTableValues[23] =
{
    { "CAPTURING_PHASE", (intptr_t)1, DontDelete|ReadOnly, 0 },
    { "AT_TARGET", (intptr_t)2, DontDelete|ReadOnly, 0 },
    { "BUBBLING_PHASE", (intptr_t)3, DontDelete|ReadOnly, 0 },
    { "MOUSEDOWN", (intptr_t)1, DontDelete|ReadOnly, 0 },
    { "MOUSEUP", (intptr_t)2, DontDelete|ReadOnly, 0 },
    { "MOUSEOVER", (intptr_t)4, DontDelete|ReadOnly, 0 },
    { "MOUSEOUT", (intptr_t)8, DontDelete|ReadOnly, 0 },
    { "MOUSEMOVE", (intptr_t)16, DontDelete|ReadOnly, 0 },
    { "MOUSEDRAG", (intptr_t)32, DontDelete|ReadOnly, 0 },
    { "CLICK", (intptr_t)64, DontDelete|ReadOnly, 0 },
    { "DBLCLICK", (intptr_t)128, DontDelete|ReadOnly, 0 },
    { "KEYDOWN", (intptr_t)256, DontDelete|ReadOnly, 0 },
    { "KEYUP", (intptr_t)512, DontDelete|ReadOnly, 0 },
    { "KEYPRESS", (intptr_t)1024, DontDelete|ReadOnly, 0 },
    { "DRAGDROP", (intptr_t)2048, DontDelete|ReadOnly, 0 },
    { "FOCUS", (intptr_t)4096, DontDelete|ReadOnly, 0 },
    { "BLUR", (intptr_t)8192, DontDelete|ReadOnly, 0 },
    { "SELECT", (intptr_t)16384, DontDelete|ReadOnly, 0 },
    { "CHANGE", (intptr_t)32768, DontDelete|ReadOnly, 0 },
    { "stopPropagation", (intptr_t)jsEventPrototypeFunctionStopPropagation, DontDelete|Function, 0 },
    { "preventDefault", (intptr_t)jsEventPrototypeFunctionPreventDefault, DontDelete|Function, 0 },
    { "initEvent", (intptr_t)jsEventPrototypeFunctionInitEvent, DontDelete|Function, 3 },
    { 0, 0, 0, 0 }
};

static const HashTable JSEventPrototypeTable = { 8191, JSEventPrototypeTableValues, 0 };

const ClassInfo JSEventPrototype::s_info = { "EventPrototype", 0, &JSEventPrototypeTable, 0 };

JSObject* JSEventPrototype::self(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier prototypeIdentifier(exec, "[[JSEvent.prototype]]");
    return KJS::cacheGlobalObject<JSEventPrototype>(exec, prototypeIdentifier);
}

bool JSEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSEventPrototype, JSObject>(exec, &JSEventPrototypeTable, this, propertyName, slot);
}

JSValue* JSEventPrototype::getValueProperty(ExecState* exec, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(exec, token);
}

const ClassInfo JSEvent::s_info = { "Event", 0, &JSEventTable , 0 };

JSEvent::JSEvent(JSObject* prototype, Event* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSEvent::~JSEvent()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEvent, Base>(exec, &JSEventTable, this, propertyName, slot);
}

JSValue* JSEvent::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case TypeAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        return jsString(exec, imp->type());
    }
    case TargetAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        return toJS(exec, WTF::getPtr(imp->target()));
    }
    case CurrentTargetAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        return toJS(exec, WTF::getPtr(imp->currentTarget()));
    }
    case EventPhaseAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        return jsNumber(exec, imp->eventPhase());
    }
    case BubblesAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        return jsBoolean(imp->bubbles());
    }
    case CancelableAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        return jsBoolean(imp->cancelable());
    }
    case TimeStampAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        return jsNumber(exec, imp->timeStamp());
    }
    case SrcElementAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        return toJS(exec, WTF::getPtr(imp->srcElement()));
    }
    case ReturnValueAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        return jsBoolean(imp->returnValue());
    }
    case CancelBubbleAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        return jsBoolean(imp->cancelBubble());
    }
    case ClipboardDataAttrNum: {
        return clipboardData(exec);
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSEvent::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSEvent, Base>(exec, propertyName, value, &JSEventTable, this);
}

void JSEvent::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case ReturnValueAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        imp->setReturnValue(value->toBoolean(exec));
        break;
    }
    case CancelBubbleAttrNum: {
        Event* imp = static_cast<Event*>(impl());
        imp->setCancelBubble(value->toBoolean(exec));
        break;
    }
    }
}

JSValue* JSEvent::getConstructor(ExecState* exec)
{
    // Changed by Paul Pedriana (1/2009), as the static new was creating a memory leak. If this gets called a lot then we can consider making it a static pointer that's freed on shutdown.
    const Identifier constructorIdentifier(exec, "[[Event.constructor]]");
    return KJS::cacheGlobalObject<JSEventConstructor>(exec, constructorIdentifier);
}

JSValue* jsEventPrototypeFunctionStopPropagation(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSEvent::s_info))
        return throwError(exec, TypeError);
    JSEvent* castedThisObj = static_cast<JSEvent*>(thisValue);
    Event* imp = static_cast<Event*>(castedThisObj->impl());

    imp->stopPropagation();
    return jsUndefined();
}

JSValue* jsEventPrototypeFunctionPreventDefault(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSEvent::s_info))
        return throwError(exec, TypeError);
    JSEvent* castedThisObj = static_cast<JSEvent*>(thisValue);
    Event* imp = static_cast<Event*>(castedThisObj->impl());

    imp->preventDefault();
    return jsUndefined();
}

JSValue* jsEventPrototypeFunctionInitEvent(ExecState* exec, JSObject*, JSValue* thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSEvent::s_info))
        return throwError(exec, TypeError);
    JSEvent* castedThisObj = static_cast<JSEvent*>(thisValue);
    Event* imp = static_cast<Event*>(castedThisObj->impl());
    const UString& eventTypeArg = args[0]->toString(exec);
    bool canBubbleArg = args[1]->toBoolean(exec);
    bool cancelableArg = args[2]->toBoolean(exec);

    imp->initEvent(eventTypeArg, canBubbleArg, cancelableArg);
    return jsUndefined();
}

Event* toEvent(KJS::JSValue* val)
{
    return val->isObject(&JSEvent::s_info) ? static_cast<JSEvent*>(val)->impl() : 0;
}

}
